from django.shortcuts import render
from pandas._libs.properties import cache_readonly

from APIs.models import *
from APIs.views.views import *

from .models import *
from datetime import *
from django.http import HttpResponse, HttpResponseNotFound
from django.shortcuts import redirect
from django.contrib.auth.decorators import login_required
from django.views.decorators.csrf import csrf_exempt
from rest_framework.decorators import api_view
from django.contrib.auth import authenticate
from django.db.models import Q, Max, Min
import jdatetime
import re
import requests
import string
# import secrets
import pandas
import numpy as np

from django.contrib.auth.models import User as DjangoUser
from django.contrib.auth.models import Group


def RequsetChecker(data, foramt):
    # Sampeleforamt=[
    #     {
    #         "name":"field name", # required
    #         "format":"regex",    # required
    #         "required": True,    # optional default is true
    #         "errorMessage":"field be required!" # optional
    #     }
    # ]

    for field in foramt:
        if field.get('required') is None or field.get('required') is True:
            if data.get(field['name']) is None:
                raise ValueError('the '+field['name']+' is required')
            elif not re.compile(field['format']).match(data.get(field['name'])):
                raise ValueError(field.get('errorMessage') or 'invalid input format on '+field['name'])
    return


def getList(strList):
    S = strList.split("&")
    last = len(S) - 1
    F = []
    for i in range(1, last):
        if not S[i] == "":
            F.append(float(S[i]))
    return F


def index(request):
    """View function for home page of site."""
    return HttpResponseNotFound()
    context = {
    }
    # Render the HTML template index.html with the data in the context variable
    return render(request, 'home/index.html', context=context)

@api_view(["GET"])
@login_required(login_url='/site/accounts/login/')
def patient(request):
    django_user = request.user
    if django_user is None:
        return redirect('login')
    else:
        if not django_user.groups.filter(name='Patient').exists():
            return redirect('have-not-access')
    user = User.objects.get(django_user=django_user)

    if user is None:
        return myResponse.Error("this part is not active for u")

    durations = 30
    dt = date.today() - timedelta(days=durations)
    date_array = []
    drug_logs_list = []
    feeling_logs_list = []
    eating_logs_list = []
    points_list = []
    sumation_list = []
    average_sugar_befor_food = []
    average_sugar_after_food = []
    sum_of_insulin_usage = []
    total_hypo = 0
    total_hyper = 0
    carbo_need = []
    carbo_used = []

    for i in range(durations + 1):
        try:
            sumation = 0
            temp = Points.objects.filter(user=user, date=dt)
            if temp.count() > 0:
                record = temp[0]
                points_list.append(record.total_points)

                carbo_used.append(sum(getList(record.this_day_Carbohydrates_g)))

            else:
                points_list.append(0)
                carbo_used.append(0)

            carbo_need.append(user.profile.Carbohydrates_g)

            temp = SugarMeasurement.objects.filter(time__year=dt.year,
                                               time__month=dt.month,
                                               time__day=dt.day, user=user)

            sugar_befor_food = temp.filter(Q(meal=0) | Q(meal=2) | Q(meal=4))
            sum_befor = 0

            for item in sugar_befor_food:
                sum_befor += item.amount
            if sum_befor == 0:
                average_sugar_befor_food.append(0)
            else:
                average_sugar_befor_food.append(sum_befor/sugar_befor_food.count())

            sugar_after_food = temp.filter(Q(meal=1) | Q(meal=3) | Q(meal=5))
            sum_after = 0
            for item in sugar_after_food:
                sum_after += item.amount
            if sum_after == 0:
                average_sugar_after_food.append(0)
            else:
                average_sugar_after_food.append(sum_after/sugar_after_food.count())

            total_hypo += temp.filter(hypo=True).count()

            total_hyper += temp.filter(hyper=True).count()

            temp = InsulinUsage.objects.filter(time__year=dt.year,
                                               time__month=dt.month,
                                               time__day=dt.day, user=user)
            sum_i = 0
            for item in temp:
                sum_i += item.amount
            sum_of_insulin_usage.append(sum_i)



            temp = DrugUsage.objects.filter(time__year=dt.year,
                                            time__month=dt.month,
                                            time__day=dt.day).count()
            sumation += temp
            drug_logs_list.append(temp)

            temp = Feeling.objects.filter(time__year=dt.year,
                                          time__month=dt.month,
                                          time__day=dt.day).count()
            sumation += temp
            feeling_logs_list.append(temp)

            temp = Eating.objects.filter(date_time__year=dt.year,
                                         date_time__month=dt.month,
                                         date_time__day=dt.day).count()
            sumation += temp
            sumation_list.append(sumation)

            eating_logs_list.append(temp)

            date_array.append(str(jdatetime.date.fromgregorian(date=dt)))

            dt = dt + timedelta(days=1)
            dt_end = dt + timedelta(days=1)
        except:
            pass

    temp = Points.objects.filter(user=user, date=date.today())
    if temp.exists():
        p = temp[0]
        totalCarboControlPoint = p.totalCarboControlPoint
        totalSugarControlPoint = p.totalSugarControlPoint
        totalHypoHyperControlPoint = p.totalHypoHyperControlPoint
        total_Calories_Point = p.total_Calories_Point
        total_Activity_Point = p.total_Activity_Point
        totalCooperationPoints = p.totalCooperationPoints
    else:
        totalCarboControlPoint = 0
        totalSugarControlPoint = 0
        totalHypoHyperControlPoint = 0
        total_Calories_Point = 0
        totalCooperationPoints = 0
        total_Activity_Point = 0

    type_of_treatment = ""
    t = str(user.profile.type_of_treatment)
    if t.count("0") > 0:
        type_of_treatment = "دارو"
    if t.count("1") > 0:
        if type_of_treatment == "":
            type_of_treatment += "انسولین"
        else:
            type_of_treatment += "، انسولین"
    if t.count("2") > 0:
        if type_of_treatment == "":
            type_of_treatment += "دارو های از پیش ترکیب GLP1"
        else:
            type_of_treatment += "، دارو های از پیش ترکیب GLP1"

    context = {
        "date": date_array,
        "points_list": points_list,
        "total_hypo": total_hypo,
        "total_hyper": total_hyper,
        "type_of_treatment": type_of_treatment,
        "totalCarboControlPoint": totalCarboControlPoint * 100,
        "totalSugarControlPoint": totalSugarControlPoint * 100,
        "totalHypoHyperControlPoint": totalHypoHyperControlPoint * 100,
        "total_Calories_Point": total_Calories_Point * 100,
        "totalCooperationPoints": totalCooperationPoints * 100,
        "total_Activity_Point": total_Activity_Point * 100,


        "sumation_logs_list": sumation_list,
        "user": user,
        "average_sugar_befor_food": average_sugar_befor_food,
        "average_sugar_after_food": average_sugar_after_food,
        "sum_of_insulin_usage": sum_of_insulin_usage,
        "this_day_point": points_list[len(points_list) - 1],
        "carbo_need": carbo_need,
        "carbo_used": carbo_used,

    }

    return render(request, 'patient/patient.html', context=context)


@api_view(["GET", "POST"])
# @login_required(login_url='/site/accounts/login/')
def patient_image_crop(request):
    if request.method == "POST":
        return myResponse.OK("ok", str(request.FILES))
    else:
        django_user = request.user
        if django_user is None:
            return redirect('login')
        else:
            if not django_user.groups.filter(name='Patient').exists():
                return redirect('have-not-access')
        user = User.objects.get(django_user=django_user)

        if user is None:
            return myResponse.Error("this part is not active for u")

        context = {
            "user": user,
        }
        return render(request, 'patient/image-cropper.html', context=context)


@login_required(login_url='/site/accounts/login/')
def doctor(request):
    try:
        django_user = request.user
        if django_user is None:
            return redirect('login')
        else:
            if not django_user.groups.filter(name='Doctor').exists():
                return redirect('have-not-access')
        doctor = Doctor.objects.get(django_user=django_user)

        if doctor is None:
            return myResponse.Error("this part is not active for u")

        # update number of panel_visit for doctor
        if doctor.last_view_datetime < (datetime.now() - timedelta(hours=1)):
            doctor.panel_visits += 1
            doctor.last_view_datetime = datetime.now()
            doctor.save()

        patient_names = []
        patient_profile_id = []
        new_messages_number = []
        profiles = Profile.objects.filter(doctor=doctor)
        for p in profiles:
            patient_names.append(p.first_name + " " + p.last_name)
            patient_profile_id.append(p.id)
            patient = User.objects.filter(profile=p)[0]

            new_messages_number.append(Message.objects.filter(user=patient,
                                                              employee=django_user, employee_seen=False,
                                                              direction=False).count())

        context = {
            "patient_names": patient_names,
            "patient_number": len(patient_names),
            "patient_profile_id": patient_profile_id,
            "patient_range": range(len(patient_profile_id)),
            "new_messages_number": new_messages_number,
            "doctor": doctor,

            "message_sum": sum(new_messages_number),
        }

        return render(request, 'doctor/doctor.html', context=context)
    except Exception as e:
        print(e.args)
        return redirect('login')

@api_view(["GET"])
@login_required(login_url='/site/accounts/login/')
def show_patient_for_doctor(request, profile_id):
    django_user = request.user
    if django_user is None:
        return redirect('login')
    else:
        if not django_user.groups.filter(name='Doctor').exists():
            return redirect('have-not-access')
    doctor = Doctor.objects.get(django_user=django_user)

    if doctor is None:
        return myResponse.Error("this part is not active for u", [])

    temp = Profile.objects.filter(id=profile_id)
    if not temp.exists():
        return myResponse.Error("dose not exists any profile with this id!", [])
    profile = temp[0]
    if not(profile.doctor == doctor):
        return myResponse.Error("You do not have access to this patient. This patient's doctor is another person", [])

    temp = User.objects.filter(profile=profile)
    if not temp.exists():
        return myResponse.Error("dose not exists any User with this profile!", [])
    patient = temp[0]

    durations = 30
    dt = date.today() - timedelta(days=durations)
    date_array = []
    drug_logs_list = []
    feeling_logs_list = []
    eating_logs_list = []
    points_list = []
    sumation_list = []
    average_sugar_befor_food = []
    average_sugar_after_food = []
    sum_of_insulin_usage = []
    total_hypo = 0
    total_hyper = 0
    carbo_need = []
    carbo_used = []
    MinMaxSugar = []
    MinMaxSugarDate = []


    for i in range(durations + 1):
        try:
            sumation = 0
            temp = Points.objects.filter(user=patient, date=dt)
            if temp.count() > 0:
                record = temp[0]
                points_list.append(record.total_points)

                carbo_used.append(sum(getList(record.this_day_Carbohydrates_g)))

            else:
                points_list.append(0)
                carbo_used.append(0)

            carbo_need.append(patient.profile.Carbohydrates_g)

            # SugarMeasurement
            temp = SugarMeasurement.objects.filter(time__year=dt.year,
                                               time__month=dt.month,
                                               time__day=dt.day, user=patient)

            sugar_befor_food = temp.filter(Q(meal=0) | Q(meal=2) | Q(meal=4))
            sum_befor = 0

            for item in sugar_befor_food:
                sum_befor += item.amount
            if sum_befor == 0:
                average_sugar_befor_food.append(0)
            else:
                average_sugar_befor_food.append(sum_befor/sugar_befor_food.count())

            sugar_after_food = temp.filter(Q(meal=1) | Q(meal=3) | Q(meal=5))
            sum_after = 0
            for item in sugar_after_food:
                sum_after += item.amount
            if sum_after == 0:
                average_sugar_after_food.append(0)
            else:
                average_sugar_after_food.append(sum_after/sugar_after_food.count())

            total_hypo += temp.filter(hypo=True).count()

            total_hyper += temp.filter(hyper=True).count()

            # max/min Glocus
            if temp.exists():
                MinMaxSugarDate.append(str(jdatetime.date.fromgregorian(date=dt)))
                min = temp.order_by("amount")[0].amount
                max = temp.order_by("-amount")[0].amount
                MinMaxSugar.append([min, max])



            temp = InsulinUsage.objects.filter(time__year=dt.year,
                                               time__month=dt.month,
                                               time__day=dt.day, user=patient)
            sum_i = 0
            for item in temp:
                sum_i += item.amount
            sum_of_insulin_usage.append(sum_i)



            temp = DrugUsage.objects.filter(time__year=dt.year,
                                            time__month=dt.month,
                                            time__day=dt.day).count()
            sumation += temp
            drug_logs_list.append(temp)

            temp = Feeling.objects.filter(time__year=dt.year,
                                          time__month=dt.month,
                                          time__day=dt.day).count()
            sumation += temp
            feeling_logs_list.append(temp)

            temp = Eating.objects.filter(date_time__year=dt.year,
                                         date_time__month=dt.month,
                                         date_time__day=dt.day).count()
            sumation += temp
            sumation_list.append(sumation)

            eating_logs_list.append(temp)

            date_array.append(str(jdatetime.date.fromgregorian(date=dt)))

            dt = dt + timedelta(days=1)
            dt_end = dt + timedelta(days=1)
        except:
            pass

    type_of_treatment = ""
    t = str(patient.profile.type_of_treatment)
    if t.count("0") > 0:
        type_of_treatment = "دارو"
    if t.count("1") > 0:
        if type_of_treatment == "":
            type_of_treatment += "انسولین"
        else:
            type_of_treatment += "، انسولین"
    if t.count("2") > 0:
        if type_of_treatment == "":
            type_of_treatment += "دارو های از پیش ترکیب GLP1"
        else:
            type_of_treatment += "، دارو های از پیش ترکیب GLP1"


    # HEI_Table saved in view file of APIs app

    calorie = round(profile.CR / 100) * 100
    if calorie > 3500:
        calorie = 3500
    elif calorie < 1100:
        calorie = 1100
    GoalHEI = HEI_Table[calorie]


    points = Points.objects.filter(user=patient, date=date.today())
    if points.exists():
        p = points[0]
        totalCarboControlPoint = p.totalCarboControlPoint
        totalSugarControlPoint = p.totalSugarControlPoint
        totalHypoHyperControlPoint = p.totalHypoHyperControlPoint
        total_Calories_Point = p.total_Calories_Point
        total_Activity_Point = p.total_Activity_Point
        totalCooperationPoints = p.totalCooperationPoints

        User_HEI = getList(str(p.HEI_elements_list))

        HEI_Grain = round((User_HEI[14] / GoalHEI[0]), 5) * 100
        HEI_Protein = round((User_HEI[15] / GoalHEI[1]), 5) * 100
        HEI_Dairy = round((User_HEI[16] / GoalHEI[2]), 5) * 100
        HEI_Fruit = round((User_HEI[17] / GoalHEI[3]), 5) * 100
        HEI_Vegetables = round((User_HEI[18] / GoalHEI[4]), 5) * 100
        HEI_Fat = round((User_HEI[19] / GoalHEI[5]), 5) * 100

    else:
        totalCarboControlPoint = 0
        totalSugarControlPoint = 0
        totalHypoHyperControlPoint = 0
        total_Calories_Point = 0
        total_Activity_Point = 0
        totalCooperationPoints = 0

        HEI_Grain = 0
        HEI_Protein = 0
        HEI_Dairy = 0
        HEI_Fruit = 0
        HEI_Vegetables = 0
        HEI_Fat = 0


    # make seen chats
    chats = Message.objects.filter(user=patient, employee=django_user, employee_seen=False)
    for ch in chats:
        ch.employee_seen = True
        ch.save()


    # recent chats
    chats = Message.objects.filter(user=patient, employee=django_user).order_by("time")
    if chats.count() > 8:
        messages = chats[chats.count() - 8: chats.count()]
    else:
        messages = chats

    pills_code = getList(profile.pills)
    pills = ""
    for code in pills_code:
        t = Drug.objects.filter(DataBaseNumber=code)
        if t.exists():
            pills += t[0].name + "، "

    context = {
        "doctor": doctor,
        "patient": patient,
        "profile": profile,
        "birth_date": str(jdatetime.date.fromgregorian(date=profile.birth_date.date())),
        "age": datetime.now().year - profile.birth_date.year,
        "pills": pills,
        "type_of_treatment": type_of_treatment,
        "totalCarboControlPoint": totalCarboControlPoint * 100,
        "totalSugarControlPoint": totalSugarControlPoint * 100,
        "totalHypoHyperControlPoint": totalHypoHyperControlPoint * 100,
        "total_Calories_Point": total_Calories_Point * 100,
        "total_Activity_Point": total_Activity_Point * 100,
        "totalCooperationPoints": totalCooperationPoints * 100,

        "date": date_array,
        "points_list": points_list,
        "total_hypo": total_hypo,
        "total_hyper": total_hyper,
        "sumation_logs_list": sumation_list,
        "average_sugar_befor_food": average_sugar_befor_food,
        "average_sugar_after_food": average_sugar_after_food,
        "MinMaxSugarDate": MinMaxSugarDate,
        "MinMaxSugar": MinMaxSugar,
        "sum_of_insulin_usage": sum_of_insulin_usage,
        "this_day_point": points_list[len(points_list) - 1],
        "carbo_need": carbo_need,
        "carbo_used": carbo_used,
        # HEI:
        "HEI_Vegetables": HEI_Vegetables,
        "HEI_Dairy": HEI_Dairy,
        "HEI_Fruit": HEI_Fruit,
        "HEI_Grain": HEI_Grain,
        "HEI_Fat": HEI_Fat,
        "HEI_Protein": HEI_Protein,

        # Message:
        "messages": messages,

    }

    return render(request, 'doctor/show_patient.html', context=context)


@api_view(["GET", "POST"])
@login_required(login_url='/site/accounts/login/')
def message_to_patient(request, patient_id):
    try:
        django_user = request.user
        if django_user is None:
            return redirect('login')
        else:
            if not django_user.groups.filter(name='Doctor').exists():
                return redirect('have-not-access')
        doctor = Doctor.objects.get(django_user=django_user)

        if doctor is None:
            return myResponse.Error("this part is not active for u", [])

        temp = User.objects.filter(id=patient_id)
        if not temp.exists():
            return myResponse.Error("dose not exists any profile with this id!", [])
        patient = temp[0]
        if not(patient.profile.doctor == doctor):
            return myResponse.Error("You do not have access to this patient. This patient's doctor is another person", [])

        text = str(request.POST.get("message_text"))
        if len(text) > 0:
            message = Message(user=patient, employee=doctor.django_user, request_text=text, title="doctor", direction=True)
            message.save()


        return redirect('https://i-dia.ir/site/accounts/doctor/see/patient/' + str(patient.profile.id) + '/')

    except Exception as e:
        return myResponse.Error(str(e.args), -1)


@api_view(["POST", "GET"])
def activation_code(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "phone_number",
                    "format": "^09[0-9]{9}$"
                }
            ])

            phone = str(request.POST["phone_number"])

            xx = DoctorSMS.objects.filter(phone=phone)

            digits = string.digits
            code = generateRandomString(digits, 4)

            if xx.exists():
                tt = xx[0]
                tt.number_of_sms_sent += 1
                tt.code = code

            else:
                tt = DoctorSMS(phone=phone, code=code)
                tt.number_of_sms_sent += 1

            tt.save()

            # send with kavenegar
            url = "https://api.kavenegar.com/v1/776643766A357671537637453675434446764F4A57336A783831512F423163685465576B2B6D78366331593D/verify/lookup.json"
            querystring = {"receptor": phone, "template": "verify1", "token": code}
            response = requests.request("POST", url, params=querystring)
            jresp = response.json()
            if not jresp.get("return").get("status") == 200:
                return myResponse.Error("sms not sent", -1)

            # send activationCode AS SMS to phone number with old sms panle
            # url = "https://37.130.202.188/class/sms/webservice/send_url.php"
            # message = "با سلام" + "\n" + "کد فعال سازی شما: " + str(code) + "\n" + "آیدیا"
            # querystring = {"from": "0985000189", "to": phone, "msg": message, "uname": "pwssajodi",
            #                "pass": "pws741852", "op": "send"}
            # response = requests.request("GET", url, params=querystring)
            #
            # if not response.status_code == 200:
            #     return myResponse.Error(Errors.ErrorInSMS.message, Errors.ErrorInSMS.code)

            data = {
                # "activation_code": code,
                # "response": str(response)
            }
            return render(request, 'registration/register.html', data)
        except ValueError as e:
            return myResponse.Error(e.args[0], -1)
    else:
        render(requests, 'registration/verification.html', context={})


@api_view(["POST", "GET"])
def register_doctor(request):
    if request.method == "POST":
        try:
            first_name = request.POST.get("first_name")
            last_name = request.POST.get("last_name")
            username = request.POST.get("username")
            password = request.POST.get("password")
            code = request.POST.get("code")
            phone = str(request.POST.get("phone_number"))
            activation_code = str(request.POST.get("activation_code"))

            temp = DjangoUser.objects.filter(username=username)
            error = ""


            if temp.exists():
                error = "این نام کاربری قبلا استفاده شده است"
                context = {
                    "error": error,
                }
                return render(request, 'registration/register.html', context=context)
            else:
                doctor = Doctor()
                doctor.first_name = first_name
                doctor.last_name = last_name
                doctor.phone = phone
                doctor.code = code
                doctor.isActive = False  # todo: To prevent subversive acts :)

                du = DjangoUser()
                du.username = username
                du.set_password(password)
                du.save()
                my_group = Group.objects.get(name='Doctor')
                my_group.user_set.add(du)

                doctor.django_user = du
                doctor.save()

            return render(request, 'registration/login.html', {})
        except Exception as e:
            return myResponse.Error(str(e.args), -1)
    else:
        try:
            return render(request, 'registration/verification.html', context={})
        except Exception as e:
            return myResponse.Error(str(e.args), -1)


@login_required(login_url='/site/accounts/login/')
def support(request):
    temp = Message.objects.filter(Q(is_answered=False) & (~Q(title="doctor"))).order_by("-time")
    title = []
    request_text = []
    time_list = []
    message = []
    names = []
    for i in range(temp.count()):
        if not(temp[i].user is None):
            if not(temp[i].user.profile is None):
                if (not(temp[i].user.profile.first_name is None)) and (not(temp[i].user.profile.last_name is None)):
                    title.append(temp[i].title)
                    request_text.append(temp[i].request_text)
                    time_list.append(str(jdatetime.datetime.fromtimestamp(temp[i].time.timestamp())))
                    message.append(temp[i].id)
                    name = str(temp[i].user.profile.first_name) + " " + str(temp[i].user.profile.last_name)
                    names.append(name)

    context = {
        "title": title,
        "request_text": request_text,
        "time": time_list,
        "message": message,
        "names": names,
        "range": range(len(message))
    }

    return render(request, 'Support/answer.html', context=context)


@login_required(login_url='/site/accounts/login/')
def data_analysis(request):
    women = Profile.objects.filter(gender=1, weight__gt=1).count()
    men = Profile.objects.filter(gender=0, weight__gt=1).count()
    unknown_gender = Profile.objects.all().count() - women - men


    type1 = Profile.objects.filter(diabetes_type=1, weight__gt=1).count()
    type2 = Profile.objects.filter(diabetes_type=2, weight__gt=1).count()
    pregnancy = Profile.objects.filter(diabetes_type=0, weight__gt=1).count()
    unknown_type = Profile.objects.all().count() - type1 - type2 - pregnancy

    age_distribution = []
    now = datetime.now()
    for i in range(8):
        number = Profile.objects.filter(weight__gt=1, birth_date__range=(now - timedelta(days=(i + 1) * 10 * 365),
                                                           now - timedelta(days=i * 10 * 365))).count()
        age_distribution.append(number)

    a1c_distribution = []
    for i in range(7):
        number = Profile.objects.filter(weight__gt=1, a1c__range=(i * 2, i * 2 + 2)).count()
        a1c_distribution.append(number)

    # BLOOD SUGAR Analysis
    users = User.objects.filter(isRegistered=True)
    a1c_improvement_list = []
    a1c_improvement_list_user_age = []
    a1c_improvement_list_number_of_days = []
    a1c_improvement_list_user_average_time_per_day = []
    for user in users:
        SM = SugarMeasurement.objects.filter(user=user).order_by('time')
        sm_sum = 0
        sm_num = SM.count()
        first_a1c = user.profile.a1c  # default

        if sm_num > 4:  # so can be examine and analyze
            for sm in SM:
                sm_sum += sm.amount
            sm_average = sm_sum / sm_num
            new_a1c = round((sm_average + 46.7) / 28.7, 2)
            if new_a1c < first_a1c and (new_a1c > first_a1c - 6):  # So it has improved
                improve = first_a1c - new_a1c
                a1c_improvement_list.append(round(improve, 2))
                age = round((datetime.now() - user.profile.birth_date).days / 365, 1)
                if age < 0:
                    continue
                a1c_improvement_list_user_age.append(age)

                t = 0
                t += Eating.objects.filter(user=user).count()
                t += Activities_log.objects.filter(user=user).count()
                t += SugarMeasurement.objects.filter(user=user).count()
                t += Feeling.objects.filter(user=user).count()
                t += InsulinUsage.objects.filter(user=user).count()
                t += BloodPressure.objects.filter(user=user).count()
                t += DrugUsage.objects.filter(user=user).count()
                t += Weights.objects.filter(user=user).count()
                t += Walking.objects.filter(user=user).count()
                t += AOneC.objects.filter(user=user).count()
                points = Points.objects.filter(user=user).order_by('date')
                days = points.count()
                average = 2 * t / days

                # a1c_improvement_list_number_of_days.append(days)
                length = (SM[len(SM) - 1].time - SM[0].time).days
                a1c_improvement_list_number_of_days.append(length)
                a1c_improvement_list_user_average_time_per_day.append(average)


    # user activity by age
    activity_by_age = []
    for i in range(10):
        a = i * 10 * 365
        b = a + 10 * 365
        number = Points.objects.filter(user__profile__birth_date__lte=datetime.now() - timedelta(days=a),
                                       user__profile__birth_date__gte=datetime.now() - timedelta(days=b)).count()
        activity_by_age.append(number)

    # user activity by time
    activity_by_time = []
    for i in range(24):
        number = 0
        number += Eating.objects.filter(date_time__hour=i).count()
        number += Activities_log.objects.filter(start_date_time__hour=i).count()
        number += SugarMeasurement.objects.filter(time__hour=i).count()
        number += Feeling.objects.filter(time__hour=i).count()
        number += InsulinUsage.objects.filter(time__hour=i).count()
        number += BloodPressure.objects.filter(time__hour=i).count()
        number += DrugUsage.objects.filter(time__hour=i).count()
        number += Weights.objects.filter(time__hour=i).count()
        number += AOneC.objects.filter(time__hour=i).count()
        activity_by_time.append(number)

    # users per month
    users_per_month = []
    users_per_month_names = []
    for i in range(4 * 12, -1, -1):  # 4 years
        lte = now - timedelta(days=i * 30)
        temp = User.objects.filter(created_at__lte=lte)
        users_per_month.append(temp.count())
        users_per_month_names.append("{}-{}".format(lte.year, lte.month))

    data = {
        'women': women,
        'men': men,
        'unknown_gender': unknown_gender,
        'type1': type1,
        'type2': type2,
        'pregnancy': pregnancy,
        'unknown_type': unknown_type,
        'age_distribution': age_distribution,
        'a1c_distribution': a1c_distribution,
        'a1c_improvement_list': a1c_improvement_list,
        'a1c_improvement_list_user_age': a1c_improvement_list_user_age,
        'a1c_improvement_list_number_of_days': a1c_improvement_list_number_of_days,
        'a1c_improvement_list_user_average_time_per_day': a1c_improvement_list_user_average_time_per_day,
        'activity_by_age': activity_by_age,
        'activity_by_time': activity_by_time,
        'a1c_improvement_list_length': len(a1c_improvement_list),
        'max_a1c_improve': max(a1c_improvement_list),
        'min_a1c_improve': min(a1c_improvement_list),
        'users_per_month': users_per_month,
        'users_per_month_names': users_per_month_names,
    }

    return render(request, 'Support/data_analysis.html', context=data)


@api_view(["GET", "POST"])
def food_recognition(request):
    if request.method == "GET":
        try:
            fimg = None
            time = None
            status = 1

            temp = FoodImage.objects.filter(is_processed=False)
            if temp.count() > 0:
                fimg = temp[0]
                time = str(jdatetime.datetime.fromgregorian(datetime=fimg.time))
            else:
                status = -1

            foods = Food.objects.all()
            food_names = []
            foods_number = foods.count()

            for i in range(foods_number):
                food_names.append(str(foods[i].FA_Name))


            context = {
                "foods_range": range(foods.count()),
                "foods": foods,
                "food_image": fimg,
                "time": time,
                "status": status,
                "amounts_range": range(10, 200, 10)
            }
            return render(request, 'Support/food_recognition.html', context=context)

        except Exception as e:
            return myResponse.Error(e.args,-1)


@login_required(login_url='/site/accounts/login/')
def answer(request, request_id):
    temp = Message.objects.filter(id=request_id)
    response_text = str(request.POST.get("answer"))

    if temp.count() > 0:
        message = temp[0]
    else:
        return myResponse.Error("this is answerd !!", -1)
    if len(response_text) > 5:
        message.response_text = response_text + "\n\n" + "پشتیبانی از شما وظیفه ماست، آیدیا"
        message.is_answered = True
        message.response_time = datetime.now()
        message.save()

    return redirect('support')


@login_required(login_url='/site/accounts/login/')
def show_user_profile(request, phone_number):
    if request.method == "GET":
        temp = User.objects.filter(phone_number=str(phone_number))
        if not temp.exists():
            context = {
                "message": "چنین کاربری وجود ندارد"
            }
            return render(request, "Support/show_profile.html", context=context)
        else:
            user = temp[0]
            profile = user.profile
            pills_list = getList(profile.pills)
            pills = []
            for dbn in pills_list:
                t = Drug.objects.filter(DataBaseNumber=int(dbn))
                if t.exists():
                    pills.append(t[0].name)

            short_act_ins = "-"
            long_act_ins = "-"
            glp1 = "-"
            if not (profile.insulin_short_effect is None):
                short_act_ins = profile.insulin_short_effect.name
            if not (profile.insulin_long_effect is None):
                long_act_ins = profile.insulin_long_effect.name
            if not (profile.glp1 is None):
                glp1 = profile.glp1.name

            context = {
                "message": "",
                "user": user,
                "profile": profile,
                "pills": pills,
                "short_act_ins": short_act_ins,
                "long_act_ins": long_act_ins,
                "glp1": glp1,
            }
            return render(request, "Support/show_profile.html", context=context)
    else:
        return redirect("support")


# @login_required(login_url='/site/accounts/login/')
@api_view(["GET"])
def sendSMS(request):
    return render(request, 'Support/send _sms.html')

@api_view(["GET"])
def server_state(request):
    f = open(STATIC_ROOT + "/logs/server_last_state.txt", "r")
    state = str(f.readline())
    result = False
    result = (state == "yes\n")

    message = f.readline()
    f.close()
    context = {
        "result": result,
        "message": message,
    }
    return render(request, 'Support/server_state.html', context=context)


# @login_required(login_url='/site/accounts/login/')
@api_view(["GET", "POST"])
def sending(request):
    if request.method == "GET":
        return render(request, 'Support/send _sms.html')
    else:
        try:
            user_name = str(request.POST.get("user_name"))
            password = str(request.POST.get("password"))

            if (not (user_name == "SMS_TO_USERS")) or (not (password == "#$%&*x*$%&&3#di&3")):
                return render(request, 'Support/send _sms.html',
                              context={"error": "نام کاربری یا رمز عبور صحیح نمی باشد"})
            # return myResponse.OK("ok", [str(request.POST), str(request.FILES), user_name, password])
            if request.FILES["file"] == None:
                return render(request, 'Support/send _sms.html',
                              context={"error": "فایلی با فرمت .xlsx را انتخاب کنید"})

            f = request.FILES["file"]
            name = str(request.FILES["file"]).split('.')
            if not(name[len(name) - 1] == "xlsx"):
                return render(request, 'Support/send _sms.html',
                              context={"error": "حتما باید فرمت فایل xlsx باشد"})

            message = str(request.POST.get("message"))
            if len(message) < 15:
                return render(request, 'Support/send _sms.html',
                              context={"error": "ظاهرا متن پیام اشتباه است! طول آن بسیار کوتاه است!"})



            path = '/assets/sms/sms_' + str(datetime.now())
            newExcelFile = STATIC_ROOT + path + '.xlsx'
            with open(newExcelFile, 'wb+') as destination:
                for chunk in f.chunks():
                    destination.write(chunk)
            destination.close()


            newTxtFile = STATIC_ROOT + path + '.txt'
            with open(newTxtFile, 'wb+') as textFile:
                textFile.write(message.encode('utf8'))
                textFile.write("\n".encode('utf8'))


            df = pandas.read_excel(newExcelFile)
            number_of_sent = 0
            Total_number = df.count()

            # textFile.write(("Total number: " + str(Total_number)).encode('utf8'))
            textFile.close()

            url = "https://api.kavenegar.com/v1/776643766A357671537637453675434446764F4A57336A783831512F423163685465576B2B6D78366331593D/sms/send.json"

            for value in df.get_values():
                try:
                    if not str(value[0]) == "nan":
                        # send message to admin ...
                        try:
                            number_of_sent += 1
                            url = "https://api.kavenegar.com/v1/776643766A357671537637453675434446764F4A57336A783831512F423163685465576B2B6D78366331593D/sms/send.json"
                            receptor = str(value[0])
                            if len(receptor) < 11:
                                receptor = "0" + receptor
                            querystring = {"receptor": receptor,
                                           "message": message}
                            response = requests.request("POST", url, params=querystring)
                            jresp = response.json()
                            if not jresp.get("return").get("status") == 200:
                                return render(request, 'Support/sms_result.html',
                                              context={"error": "خطا در ارسال پیام برای فرد : " + str(number_of_sent)})
                        except Exception as e:
                                return myResponse.Error(str(e), [])
                    else:
                        return render(request, 'Support/sms_result.html',
                                      context={"error": "خطا در ارسال پیام برای فرد : " + str(number_of_sent + 1)})

                except ValueError as e:
                    return render(request, 'Support/sms_result.html',
                                  context={str(e.args) + "\n" + "error": "خطا در ارسال پیام برای فرد : " + str(number_of_sent)})

            querystring = {"receptor": "09217761645",
                           "message": "پیام کنترلی" + "\n" + message}
            response = requests.request("POST", url, params=querystring)

            return render(request, 'Support/sms_result.html',
                          context={"message": "پیام ها با موفقیت ارسال شدند. ممکن است برخی پیام ها کمی با تاخیر ارسال شوند (در صف ارسال هستند)"})

        except Exception as e:
            return myResponse.Error(str(e.args), -1)


@api_view(["GET", "POST"])
def return_report(request, report_code):
    temp = Report.objects.filter(code=report_code)
    if temp.exists():
        try:
            report = temp[0]
            user = report.user

            st = report.start_time
            et = report.end_time
            # return myResponse.OK("ok", SugarMeasurement.objects.filter(user=user, time__range=(st, et)).count())

            # Activity
            ACTIVITY = timedelta(0)
            activities = Activities_log.objects.filter(user=user, start_date_time__gte=datetime.combine(date=st, time=time(0, 0, 0)), end_date_time__lte=report.created_at)
            for act in activities:
                ACTIVITY += timedelta(minutes=act.amount)



            # BLOOD SUGAR Calculations
            SM = SugarMeasurement.objects.filter(user=user, time__range=(st, et))
            sm_average = 0
            sm_sum = 0
            sm_num = SM.count()
            a1c_state = False
            a1c = user.profile.a1c  # default
            sm_list = []
            BLOOD_SUGAR_DEVIATION = 0
            hyper_num = 0
            hypo_num = 0
            max_num = 0
            min_num = 0
            in_normal_range = 0


            if sm_num > 2:
                for sm in SM:
                    sm_sum += sm.amount
                    sm_list.append(sm.amount)
                    am = sm.amount
                    if am <= user.profile.hypo:
                        hypo_num += 1
                    elif am < user.profile.minimum_sugar:
                        min_num += 1
                    elif am < user.profile.maximum_sugar:
                        in_normal_range += 1
                        p = True
                    elif am < user.profile.hyper:
                        max_num += 1
                    elif am >= user.profile.hyper:
                        hyper_num += 1
                sm_average = sm_sum / sm_num
                a1c_state = True
                a1c = round((sm_average + 46.7) / 28.7, 1)
                BLOOD_SUGAR_DEVIATION = round(np.std(sm_list), 1)

            table_data = {}
            # table_data["1399-02-02"] = {
            #         "Blood Sugar": [1,199,3,4,289,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24],
            #         "Act.": [17,"",13,14,15,16,7,8,9,12,13,14,15,16,17,18,19,20,21,22,23,24]
            # }
            # table_data["1399-02-01"] = {
            #         "Blood Sugar": [1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19],
            #         "Act.": [11,12,13,14,15,16,7,8,9,12,13,14,15,16,17,18,19]
            # }

            records = Points.objects.filter(date__gte=st, date__lte=et, user=user).order_by("date")
            temprory_list = []
            for i in range(24):
                temprory_list.append("")

            for rec in records:
                d = rec.date
                d_s = datetime.combine(date=d, time=time(0, 0, 0))
                d_e = datetime.combine(date=d, time=time(23, 59, 59))
                element = {}


                # Insulin:
                insulins = InsulinUsage.objects.filter(time__range=(d_s, d_e), user=user)
                if insulins.exists():
                    insulin_list = []
                    Basal_list = []
                    Bolus_list = []
                    for hour in range(24):
                        l = datetime.combine(date=d, time=time(hour, 0, 0))
                        r = datetime.combine(date=d, time=time(hour, 59, 59))

                        # all insulin
                        temp = insulins.filter(time__range=(l, r)).order_by("time")
                        if temp.exists():
                            if temp.count() == 1:
                                insulin_list.append(temp[0].amount)
                            else:
                                s = str(temp[0].amount)
                                for i in range(len(temp) - 1):
                                    s += " >>> " + str(temp[i+1].amount)
                                insulin_list.append(s)
                        else:
                            insulin_list.append("")

                        # Bolus --> short
                        temp = insulins.filter(time__range=(l, r), Insulin__EffectType=1).order_by("time")
                        if temp.exists():
                            if temp.count() == 1:
                                Bolus_list.append(temp[0].amount)
                            else:
                                s = str(temp[0].amount)
                                for i in range(len(temp) - 1):
                                    s += " >>> " + str(temp[i + 1].amount)
                                Bolus_list.append(s)
                        else:
                            Bolus_list.append("")

                        # Basal --> long
                        temp = insulins.filter(time__range=(l, r), Insulin__EffectType=2).order_by("time")
                        if temp.exists():
                            if temp.count() == 1:
                                Basal_list.append(temp[0].amount)
                            else:
                                s = str(temp[0].amount)
                                for i in range(len(temp) - 1):
                                    s += " >>> " + str(temp[i + 1].amount)
                                Basal_list.append(s)
                        else:
                            Basal_list.append("")

                    # element["Insulin"] = insulin_list
                    element["Bolus"] = Bolus_list
                    element["Basal"] = Basal_list
                else:
                    # element["Insulin"] = temprory_list
                    element["Bolus"] = temprory_list
                    element["Basal"] = temprory_list

                # Sugar Measurements:
                sugar_measurements = SugarMeasurement.objects.filter(time__range=(d_s, d_e), user=user)
                if sugar_measurements.exists():
                    sugar_list = []
                    for hour in range(24):
                        l = datetime.combine(date=d, time=time(hour, 0, 0))
                        r = datetime.combine(date=d, time=time(hour, 59, 59))
                        temp = sugar_measurements.filter(time__range=(l, r)).order_by("time")
                        if temp.exists():
                            if temp.count() == 1:
                                sugar_list.append(temp[0].amount)
                            else:
                                s = str(temp[0].amount)
                                for i in range(len(temp) - 1):
                                    s += " >>> " + str(temp[i+1].amount)
                                sugar_list.append(s)
                        else:
                            sugar_list.append("")
                    element["Blood Sugar"] = sugar_list
                else:
                    element["Blood Sugar"] = temprory_list

                # Carb:
                eatings = Eating.objects.filter(date_time__range=(d_s, d_e), user=user)
                if eatings.exists():
                    carb_list = []
                    for hour in range(24):
                        l = datetime.combine(date=d, time=time(hour, 0, 0))
                        r = datetime.combine(date=d, time=time(hour, 59, 59))
                        temp = eatings.filter(date_time__range=(l, r))
                        if temp.exists():
                            s = 0
                            for item in temp:
                                s += item.amount * item.food.Carbohydrates_g / 100
                            carb_list.append(round(s))
                        else:
                            carb_list.append("")
                    element["Carb"] = carb_list
                else:
                    element["Carb"] = temprory_list

                # Blood pressure Measurements:
                blood_pressure_measurements = BloodPressure.objects.filter(time__range=(d_s, d_e), user=user)
                if blood_pressure_measurements.exists():
                    blood_pressure_list = []
                    for hour in range(24):
                        l = datetime.combine(date=d, time=time(hour, 0, 0))
                        r = datetime.combine(date=d, time=time(hour, 59, 59))
                        temp = blood_pressure_measurements.filter(time__range=(l, r)).order_by("time")
                        if temp.exists():
                            if temp.count() == 1:
                                blood_pressure_list.append(str(temp[0].amount) + "/" + str(temp[0].over))
                            else:
                                s = str(temp[0].amount) + "/" + str(temp[0].over)
                                for i in range(len(temp) - 1):
                                    s += " >>> " + str(str(temp[i+1].amount) + "/" + str(temp[i+1].over))
                                blood_pressure_list.append(s)
                        else:
                            blood_pressure_list.append("")
                    element["Blood Pressure"] = blood_pressure_list
                else:
                    element["Blood Pressure"] = temprory_list

                # todo Act and ...:

                table_data[str(jdatetime.date.fromgregorian(date=d))] = element



            context = {
                "FROM": str(jdatetime.date.fromgregorian(date=report.start_time)),
                "UNTIL": str(jdatetime.date.fromgregorian(date=report.end_time)),
                "Created_at": str(jdatetime.datetime.fromgregorian(datetime=report.created_at)),
                "a1c": a1c,
                "a1c_state": a1c_state,
                "BLOOD_SUGAR_AVERAGE": round(sm_average),
                "BLOOD_SUGAR_DEVIATION": BLOOD_SUGAR_DEVIATION,
                "ACTIVITY": ACTIVITY,
                "HYPOS": hypo_num,
                "HYPERS": hyper_num,
                "user": user,
                "table_data": table_data,
                "profile": user.profile,
                "hours": range(1, 25),
            }
            return render(request, 'reports/report.html', context=context)
        except Exception as e:
            return myResponse.Error(e.args, -1)
    else:
        return HttpResponseNotFound()

@api_view(["GET"])
@login_required(login_url='/site/accounts/login/')
def login_success(request):
    if request.user.groups.filter(name='developer').exists():
        return redirect('admin-dashboard')
    elif request.user.groups.all().count() > 0:
        return redirect("choose-user-type")
    # if request.user.groups.filter(name="Doctor").exists():
    #     return redirect("doctor")
    # if request.user.groups.filter(name="patient").exists():
    #     return redirect("patient")
    # elif request.user.groups.filter(name="support").exists():
    #     return redirect("support")
    else:
        return redirect('have-not-access')
    # todo other else ...


@api_view(["GET"])
def have_not_access(request):
    return render(request, 'registration/have_not_access.html', context={})


@api_view(["GET"])
@login_required(login_url='/site/accounts/login/')
def choose_user_type(request):
    return render(request, 'registration/choose_user_type.html', context={})



@login_required(login_url='/site/accounts/login/')
@api_view(["POST", "GET"])
def recognize(request, food_image_id):
    if request.method == "POST":
        try:
            amounts = [int(request.POST["amount"])]
            food_codes = [int(request.POST["food"])]
            id = int(food_image_id)
            temp = FoodImage.objects.filter(id=id)
            if temp.exists():
                food_image = temp[0]
            else:
                return myResponse.Error("image not found!!", -1)
            meal = int(request.POST.get("meal"))
            user = food_image.user
            date_time = food_image.time
            # return myResponse.OK(str(request.POST) +" "+ str(amounts)+" "+str(food_codes)+" "+str(meal)+" "+str(id)+" ",[])
            if meal > 5:
                return myResponse.Error(Errors.InvalidMealId.message, Errors.InvalidMealId.code)

            data = user.calculate_cr_macro_nutrients_distribution()

            user.profile.CR = data["CR"]
            user.profile.Carbohydrates_g = data["macro_nutrients"]["carbohydrates_g"]
            user.profile.Carbohydrates_unit = data["macro_nutrients"]["carbohydrates_unit"]
            user.profile.Protein_g = data["macro_nutrients"]["protein_g"]
            user.profile.Protein_unit = data["macro_nutrients"]["protein_unit"]
            user.profile.Fat_g = data["macro_nutrients"]["fat_g"]
            user.profile.Fat_unit = data["macro_nutrients"]["fat_unit"]

            Carbohydrates_distribution_str = listToStr(data["carbohydrate_distribution_g"])

            user.profile.Carbohydrates_distribution_list_g = Carbohydrates_distribution_str
            user.profile.Protein_distribution_g = data["protein_distribution_g"]
            user.profile.Fat_distribution_g = data["fat_distribution_g"]
            user.profile.save()

            Carbohydrates_list_to_use = getList(user.profile.Carbohydrates_distribution_list_g)
            Fat_to_use = user.profile.Fat_distribution_g
            Protein_to_use = user.profile.Protein_distribution_g

            record_date = date_time.date()
            p = Points.objects.filter(user=user, date=record_date)
            if p.exists():
                record = p[0]
            else:
                record = Points(user=user, date=record_date)
            # this meal used:
            HEI_elements_sum = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]

            Carbohydrates_used = 0
            Protein_used = 0
            Fat_used = 0
            Calorie_used = 0

            for i in range(min(len(amounts), len(food_codes))):
                f = Food.objects.filter(Data_Base_Number=str(int(food_codes[i])))
                if not f.exists():
                    return myResponse.Error(Errors.InvalidFoodId.message, Errors.InvalidFoodId.code)
                food = f[0]
                food_image.food = food
                food_image.save()
                Carbohydrates_used += (amounts[i]/100)*food.Carbohydrates_g
                Protein_used += (amounts[i]/100)*food.Protein_g
                Fat_used += (amounts[i]/100)*food.Fat_g
                Calorie_used += (amounts[i]/100)*food.Calories
                HEI_elements_i = getHEI_List(food, amounts[i])
                HEI_elements_sum = myListAdder(HEI_elements_sum, HEI_elements_i)
                # save eating log in it's table..
                new_log = Eating(user=user,
                                 food=food,
                                 date_time=date_time,
                                 amount=amounts[i],
                                 meal=meal)
                new_log.save()

            food_image.is_processed = True
            food_image.amount = amounts[0]
            food_image.meal = meal
            food_image.save()

            # Carbohydrates calculations
            this_day_Carbohydrates_point = getList(record.this_day_Carbohydrates_point)
            this_day_Carbohydrates_g = getList(record.this_day_Carbohydrates_g)
            this_day_Carbohydrates_g[meal] += Carbohydrates_used
            record.this_day_Carbohydrates_g = listToStr(this_day_Carbohydrates_g)
            this_day_Carbohydrates_point[meal] = normalize(this_day_Carbohydrates_g[meal]/Carbohydrates_list_to_use[meal])
            record.this_day_Carbohydrates_point = listToStr(this_day_Carbohydrates_point)
            totalCarboControl = myListSum(this_day_Carbohydrates_point)/len(this_day_Carbohydrates_point)
            record.totalCarboControlPoint = totalCarboControl


            # Fat calculations
            this_day_Fat_g = getList(record.this_day_Fat_list_g)
            this_day_Fat_g[meal] += Fat_used
            record.this_day_Fat_list_g = listToStr(this_day_Fat_g)
            this_day_Fat_list_point = getList(record.this_day_Fat_list_point)
            this_day_Fat_list_point[meal] = normalize(this_day_Fat_g[meal]/Fat_to_use)
            record.this_day_Fat_list_point = listToStr(this_day_Fat_list_point)


            # Protein calculations
            this_day_Protein_list_g = getList(record.this_day_Protein_list_g)
            this_day_Protein_list_g[meal] += Protein_used
            record.this_day_Protein_list_g = listToStr(this_day_Protein_list_g)
            this_day_Protein_list_point = getList(record.this_day_Protein_list_point)
            this_day_Protein_list_point[meal] = normalize(this_day_Protein_list_g[meal]/Protein_to_use)
            record.this_day_Protein_list_point = listToStr(this_day_Protein_list_point)


            # Calorie Calculations
            total_Calories_used = Calorie_used + record.total_Calories_used
            record.total_Calories_used = total_Calories_used
            record.total_Calories_Point = normalize(total_Calories_used/user.profile.CR)
            record.save()

            # HEI elements used and calculations ...
            # HEI_elements_used = getHEI_List(food, amounts[0])  #
            Last_HEI_elements = getList(record.HEI_elements_list)
            sum_Of_HEI_elements = myListAdder(Last_HEI_elements, HEI_elements_sum)
            total_HEI_Point = HEI_Point_Calculator(sum_Of_HEI_elements,
                                                   record.total_Calories_used)
            record.HEI_elements_list = listToStr(sum_Of_HEI_elements)
            record.total_HEI_Point = total_HEI_Point


            # update and save changes
            record.save()
            u = updateTotalPointDay(user, record)
            totalPoint = u["DayPoint"]
            record.total_points = totalPoint
            record.totalCooperationPoints = u["totalCooperate"]
            record.save()

            return redirect('food-recognition')

        except Exception as e:
            return myResponse.Error(str(e), -1)
    else:
        try:
            return myResponse.Error("POST", [])
        except Exception as e:
            return myResponse.Error(e.args, -1)

@api_view(["GET", "POST"])
def toDayInfo(request):
    newUser = User.objects.filter(created_at=date.today()).count()
    registered_user = User.objects.filter(created_at=date.today(), isRegistered=True).count()
    active_users = Points.objects.filter(date=date.today()).count()
    context = {
        "newUser": newUser,
        "registered_user": registered_user,
        "active_users": active_users,
        "correct_register_rate": round(100 * (registered_user / newUser))

    }
    return render(request, "Support/toDayInfo.html", context=context)


@api_view(["GET", "POST"])
def annually_reports(request):
    start = request.POST.get("start")
    end = request.POST.get("end")
    if end == None or start == None:
        end = datetime.today()
        start = end - timedelta(days=365)

    analysis = Analysis.objects.filter(date__range=(start, end))

    context = {
        'analysis': analysis
    }
    return render(request, "Support/annually_reports.html", context=context)