from django.urls import path, include
from django.urls import path
from . import views, tests

urlpatterns = [
    path('', views.index, name='index'),
    path('accounts/', include('django.contrib.auth.urls'), name='accounts'),
    path('accounts/login_success/', views.login_success, name='login_success'),
    path('accounts/have/not/access/', views.have_not_access, name='have-not-access'),
    path('accounts/choose/user/type/', views.choose_user_type, name='choose-user-type'),
    path('accounts/patient/', views.patient, name='patient'),
    path('accounts/patient/crop/image/', views.patient_image_crop, name='patient-image-crop'),
    path('accounts/doctor/', views.doctor, name='doctor'),
    path('accounts/doctor/see/patient/<int:profile_id>/', views.show_patient_for_doctor, name='patient-of-doctor'),
    path('accounts/doctor/message/to/<int:patient_id>/', views.message_to_patient, name='message_to_patient'),
    path('accounts/register/doctor/', views.register_doctor, name='register-doctor'),
    path('accounts/activation/code/doctor/', views.activation_code, name='activation-code-doctor'),
    path('support/', views.support, name='support'),
    path('support/data/analysis/', views.data_analysis, name='data-analysis'),
    path('support/toDayInfo/', views.toDayInfo, name='toDayInfo'),
    path('support/food/recognition/', views.food_recognition, name='food-recognition'),
    path('support/food/recognition/<int:food_image_id>/', views.recognize, name='food-recognize'),
    path('support/answer/message/<int:request_id>/', views.answer, name='answer'),
    path('support/show/user/profile/<str:phone_number>/', views.show_user_profile, name='show-user-profile'),
    path('support/send/sms/', views.sendSMS, name='send-sms'),
    path('support/server/last/state/', views.server_state, name='server-last-state'),
    path('support/send/sms/sending/', views.sending, name='sending'),
    path('support/annually/reports/', views.annually_reports, name='annually-reports'),
    path('report/<str:report_code>/', views.return_report, name='report'),
]
