"""iDia_project URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/2.1/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
# from django.urls import re_path as url
from django.urls import path, include
from django.views.generic import TemplateView

from APIs.views import AdminDashboard, DBAccess
from APIs.views import views
from ziluck_site import views as site_view
from django.conf import settings
from django.conf.urls.static import static


urlpatterns = [
    path('run/scripts/', DBAccess.runScripts),
    path('testing3/', views.TestingApi3),

    
    path('measure/body/analysis/', views.process_body_composition_image_api),

    path('', site_view.index, name='index'),
    path('site/', include('ziluck_site.urls')),
    path('api/v1/', include('APIs.urls')),
    path('api/v2/', include('APIs.views.v2.url')),
    path('hypo/dashboard/', AdminDashboard.home,  name='admin-dashboard'),
    path('hypo/dashboard/charts/', AdminDashboard.charts, name='online-charts'),
    path('hypo/dashboard/charts/offline/', AdminDashboard.home_ofline, name='offline-charts'),
    path('hypo/dashboard/update/foods/list/', AdminDashboard.AddingFoodFromExcel, name='update-foods-list'),
    path('hypo/dashboard/update/cards/tags/amin/', AdminDashboard.update_food_cards_from_excel, name='update-foods-tags'),
    path('hypo/dashboard/update/foods/tags/', AdminDashboard.UpdateFoodTagsFromExcel, name='update-foods-tags'),
    path('hypo/dashboard/update/cards/list/', AdminDashboard.add_food_cards_from_excel, name='update-cards-list'),
    path('hypo/dashboard/update/cards/list/amin', AdminDashboard.amin_import_food_cards_from_excel, name='update-cards-list'),
    path('hypo/dashboard/update/cards/list/tag/amin', AdminDashboard.UpdateCardTagAmin, name='update-cards-list'),
    path('hypo/dashboard/update/cards/list/disease/tag/amin', AdminDashboard.UpdateCardDiseaseTagsAmin, name='update-cards-list'),
    path('hypo/dashboard/update/food/cards/excel/', AdminDashboard.UpdateFoodCardsFromExcel, name='update-food-cards-excel'),
    path('hypo/dashboard/add/databaseexcel/cards/', AdminDashboard.addFoodCardsFromExcel, name='add-database-food-cards-excel'),
    path('hypo/dashboard/add/databaseexcel/updateTagggggg/', AdminDashboard.updateTagggggg, name='add-database-food-cards-excel'),
    path('hypo/dashboard/update/food/cards/excel/with/specific/rules/', AdminDashboard.update_food_cards_from_excel_with_specific_rules, name='update-food-cards-excel-with-specific-rules'),
    path('hypo/dashboard/update/food/cards/excel/with/specific/rules/tag/20250101', AdminDashboard.update_food_cards_from_excel_with_specific_rules_tag_20250101, name='update-food-cards-excel-with-specific-rules-tag-20250101-0'), 
    path('hypo/dashboard/update/food/cards/excel/with/specific/rules/tag/20250101_20250201', AdminDashboard.update_food_cards_from_excel_with_specific_rules_tag_20250101_20250201, name='update-food-cards-excel-with-specific-rules-tag-20250101_20250201-1'), 
    path('hypo/dashboard/update/food/cards/excel/with/specific/rules/tag/20250201_20250301', AdminDashboard.update_food_cards_from_excel_with_specific_rules_tag_20250201_20250301, name='update-food-cards-excel-with-specific-rules-tag-20250201_20250301-2'), 
    path('hypo/dashboard/update/food/cards/excel/with/specific/rules/tag/20250301_20250401', AdminDashboard.update_food_cards_from_excel_with_specific_rules_tag_20250301_20250401, name='update-food-cards-excel-with-specific-rules-tag-20250301_20250401-3'), 
    path('hypo/dashboard/update/food/cards/excel/with/specific/rules/tag/20250401_20250504', AdminDashboard.update_food_cards_from_excel_with_specific_rules_tag_20250401_20250504, name='update-food-cards-excel-with-specific-rules-tag-20250401_20250504-4'), 
    

    
    path('hypo/dashboard/add/diet/template/excel/', AdminDashboard.AddDietTemplatesFromExcel, name='add-diet-template-excel'),
    path('hypo/dashboard/update/food/cards/allergy/tags/', AdminDashboard.UpdateFoodCardAllergyTagsFromExcelWithSportBreadRiceSaladTag, name='update-food-cards-allergy-tags'),
    path('hypo/dashboard/add/card/', AdminDashboard.StaticAddFoodCardsFromExcel, name='static-add-food-cards'),
    path('hypo/', admin.site.urls, name='django-admin'),
    path('generate/recent/profiles/data/', AdminDashboard.recent_data, name='recent-profiles-data'),


    path('robots.txt', TemplateView.as_view(template_name="home/robots.txt", content_type='text/plain')),
    path('sitemap.xml', TemplateView.as_view(template_name="home/sitemap.xml", content_type='text/plain')),
    path('709878.txt', TemplateView.as_view(template_name="home/709878.txt", content_type='text/plain')),

    path('panel/', include('panel.urls')),

    path('payment/', include('payment.urls')),
]


if settings.DEBUG or 1:
    urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
    



