"""
Django settings for iDia_project project.

Generated by 'django-admin startproject' using Django 2.1.4.

For more information on this file, see
https://docs.djangoproject.com/en/2.1/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/2.1/ref/settings/
"""

import os

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
from django.conf.global_settings import SESSION_ENGINE, DEFAULT_CHARSET

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/2.1/howto/deployment/checklist/


# SECURITY WARNING: don't run with debug turned on in production!

import platform

server = platform.version()

SECRET_KEY = 'hello'

DEBUG = True

DATABASES = {
    'default': {
        # with sqlite3 (local test) +++++++++++++++++++++++
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
        'OPTIONS': {
            'timeout': 30,  # in seconds
        }
        # +++++++++++++++++++++++++++++++++++++++++++++++++
    }
}

ALLOWED_HOSTS = ['i-dia.ir', 'api.i-dia.ir', 'idiapro.app', "172.20.10.4:8000", " 10.230.97.123:8000"
                 'www.i-dia.ir', '127.0.0.1', '172.19.0.1', 'localhost', '10.230.97.123']

# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'corsheaders',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'rest_framework',
    'APIs.apps.ApisConfig',
    'ziluck_site',
    'panel',
    'payment',
    'django_cron',

]

CRON_CLASSES = [
    "APIs.CronJobs.DailyReport",

    "APIs.notification.weight.WeightCronJob1",
    "APIs.notification.weight.WeightCronJob2",
    "APIs.notification.height.HeightCronJob1",
    "APIs.notification.insulin.InsulinCronJob1",
    "APIs.notification.insulin.InsulinCronJob2",
    "APIs.notification.drug.DrugCronJob1",
    "APIs.notification.drug.DrugCronJob2",
    "APIs.notification.calorie.CalorieCronJob1",
    "APIs.notification.calorie.CalorieCronJob2",
    "APIs.notification.carbohydrate.CarbohydrateCronJob1",
    "APIs.notification.carbohydrate.CarbohydrateCronJob2",
    "APIs.notification.activity.ActivityCronJob1",
    "panel.notifications.waiting_users_handler.WaitingUsers",

]

# Cache configuration for better performance
CACHES = {
    'default': {
        'BACKEND': 'django.core.cache.backends.locmem.LocMemCache',
        'LOCATION': 'unique-snowflake',
        'TIMEOUT': 300,  # 5 minutes default
        'OPTIONS': {
            'MAX_ENTRIES': 1000,
            'CULL_FREQUENCY': 3,
        }
    }
}

# Cache middleware for better performance
MIDDLEWARE = [
    'django.middleware.cache.UpdateCacheMiddleware',  # Add this at the top
    'django.middleware.security.SecurityMiddleware',
    'whitenoise.middleware.WhiteNoiseMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.locale.LocaleMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'corsheaders.middleware.CorsMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.cache.FetchFromCacheMiddleware',  # Add this at the bottom
]

# CORS_ORIGIN_ALLOW_ALL = True
CORS_ORIGIN_ALLOW_ALL = False

CORS_ORIGIN_WHITELIST = [
    'https://i-dia.ir:80',
    'https://i-dia.ir:8000',
    'https://www.i-dia.ir:80',

    'https://idiapro.app:80',
    'https://www.idiapro.app:80',

    'https://apptest.ziluck.info',

    'https://probiofit.net:80',
    'https://www.probiofit.net:80',
]

CORS_ALLOWED_ORIGINS = [
    "http://localhost:3000",
    "http://172.19.0.1:3000",
]

CORS_ALLOW_ALL_ORIGINS = True


CORS_ALLOW_METHODS = [
    'DELETE',
    'GET',
    'OPTIONS',
    'PATCH',
    'POST',
    'PUT',
]

ROOT_URLCONF = 'ziluck_project.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [os.path.join(BASE_DIR, 'APIs/template'),
                 os.path.join(BASE_DIR, 'panel/templates'),
                 os.path.join(BASE_DIR, 'payment/templates'),
                 os.path.join(BASE_DIR, 'ziluck_site/templates')],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.template.context_processors.static',
                'django.template.context_processors.media',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

SESSION_ENGINE = "django.contrib.sessions.backends.signed_cookies"

WSGI_APPLICATION = 'ziluck_project.wsgi.application'

# Database
# https://docs.djangoproject.com/en/2.1/ref/settings/#databases


# Password validation
# https://docs.djangoproject.com/en/2.1/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]

# Internationalization
# https://docs.djangoproject.com/en/2.1/topics/i18n/

DEFAULT_AUTO_FIELD = 'django.db.models.AutoField'

LANGUAGES = [
    ('en', 'English'),
    ('fa', 'Persian'),
    ('ar', 'Arabic')
]

LOCALE_PATHS = [
    os.path.join(BASE_DIR, 'locale'),
]

TIME_ZONE = "Asia/Tehran"

USE_I18N = True

USE_L10N = True

USE_TZ = False

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/2.1/howto/static-files/

# STATIC_URL = '/static/'


# STATICFILES_DIRS = [
#     os.path.join(BASE_DIR, "static"),
#     # '/var/www/static/',
# ]

STATIC_URL = '/static/'
STATIC_ROOT = os.path.join(BASE_DIR,
                           'static')  # after collect static is run all the static files will be put in this folder
# STATICFILES_DIRS = ( #is where Django will additionally look for static files
# )

MEDIA_URL = '/media/'
MEDIA_ROOT = os.path.join(BASE_DIR, 'media')

# STATICFILES_DIRS = [
#     STATIC_ROOT,
#     # '/var/www/static/',
# ]


# Redirect to home URL after login (Default redirects to /accounts/profile/)
LOGIN_REDIRECT_URL = '/site/accounts/login_success/'

BOT_TOKEN = ""