$(document).ready(function($) {
    var audioElement = document.createElement('audio');
    audioElement.setAttribute('src', 'https://www.soundjay.com/button/button-16.mp3');
    $("#chat-list").animate({ scrollTop: $("#chat-list")[0].scrollHeight}, 3000);
    var delay_to_call = 5 * 1000;
    class Message{
        constructor(text, type){
            this.text = text;
            var h = new Date().getHours();
            if (h < 10) {
                h = "0" + h;
            }
            h = h.toString();
            var m = new Date().getMinutes();
            if (m < 10) {
                m = "0" + m;
            }
            m = m.toString();
            this.time = h + ":" + m;
            this.type = type;
        }


        generateHTML(){
            var html;
            if(this.type == "text"){
                html = '<div class="chat chat-right">\n' +
                       '    <div class="chat-body">\n' +
                       '        <div class="chat-bubble">\n' +
                       '            <div class="chat-content">\n' +
                       '                <p class="text-right" style="direction: rtl;">' + this.text + '</p>\n' +
                       '                <span class="chat-time">' + this.time + '</span>\n' +
                       '            </div>\n' +
                       '        </div>\n' +
                       '    </div>\n' +
                       '</div>';
            }
            return html;
        }
    }
    class ChatWithAttachment{
        constructor(chat) {
            this.text = chat['text'];
            this.time = chat['time'];
            this.type = 'text';
            if (chat['sender'] === 'you'){
                this.side = 'right';
            }
            else {
                this.side = 'left';
            }
            if (chat['attachment'] != null){
                this.type = chat['attachment']['content_type']
                this.attachment_url = chat['attachment']['path']
                this.attachment_name = chat['attachment']['name']
                this.attachment_size = chat['attachment']['size']
            }
        }

        generateHTML(){
            console.log(this.type);
            var html;
            if(this.type === "text"){
                html = '<div class="chat chat-' + this.side + '">\n' +
                       '    <div class="chat-body">\n' +
                       '        <div class="chat-bubble">\n' +
                       '            <div class="chat-content">\n' +
                       '                <p class="text-right" style="direction: rtl;">' + this.text + '</p>\n' +
                       '                <span class="chat-time">' + this.time + '</span>\n' +
                       '            </div>\n' +
                       '        </div>\n' +
                       '    </div>\n' +
                       '</div>';
            }
            if ((this.type === 'jpg') || (this.type === 'jpeg') || (this.type === 'png')){
                html = '<div class="chat chat-' + this.side + '">\n' +
                    '       <div class="chat-avatar">\n' +
                    '           <a href="profile.html" class="avatar">\n' +
                    '               <img alt="Jennifer Robinson" src="" class="img-fluid rounded-circle">\n' +
                    '           </a>\n' +
                    '       </div>\n' +
                    '       <div class="chat-body">\n' +
                    '           <div class="chat-bubble">\n' +
                    '               <div class="chat-content img-content">\n' +
                    '                   <div class="chat-img-group clearfix">\n' +
                    '                       <a class="chat-img-attach" target="_blank" href="' + this.attachment_url + '">\n' +
                    '                           <img width="182" height="137" alt="" src="' + this.attachment_url + '">\n' +
                    '                           <div class="chat-placeholder">\n' +
                    '                               <div class="chat-img-name">' + this.attachment_name + '</div>\n' +
                    '                               <div class="chat-file-desc">' + this.attachment_size + '</div>\n' +
                    '                           </div>\n' +
                    '                       </a>\n' +
                    '                       <p class="text-right" style="direction: rtl;">' + this.text + '</p>\n' +
                    '                   </div>\n' +
                    '                   <span class="chat-time">' + this.time + '</span>\n' +
                    '               </div>\n' +
                    '           </div>\n' +
                    '       </div>\n' +
                    '   </div>'
            }
            return html;
        }
    }
    function sendMessage(message) {
        $.post("/panel/doctor/send/message/to/" + patient_id + "/",
        {
            text: message,
            csrfmiddlewaretoken: window.CSRF_TOKEN,
        },
        function(data, status){
            //alert("Data: " + data + "\nStatus: " + status);
            if (status == 'success'){
                audioElement.play();
                $("#chats").append(new Message(message, "text").generateHTML());
                $("#chat-list").animate({ scrollTop: $("#chat-list")[0].scrollHeight}, 2000);
            }
        });
    }


    $("#send_message").click(function (e) {
        var text_area = $("#text_to_send");
        if(text_area.val().length > 0){
            sendMessage(text_area.val());
            console.log(text_area.val());
            text_area.val("");
        }
    });

    function checkForNewChat() {
      $.post("/panel/doctor/check/new/message/from/" + patient_id + "/",
        {
            csrfmiddlewaretoken: window.CSRF_TOKEN,
        },
        function(data, status){
            //alert("Data: " + data + "\nStatus: " + status);
            console.log('call');
            if (status == 'success'){
                console.log("success");
                let n = data['data'][0]['number_of_new_messages'];
                let new_chats = data['data'][0]['new_chats'];
                if (n > 0){
                    new_chats.forEach(function (chat, index, arr) {
                        $("#chats").append(new ChatWithAttachment(chat).generateHTML());
                        // update delay_to_call
                        delay_to_call = 5 * 1000;
                    });
                    $("#chat-list").animate({ scrollTop: $("#chat-list")[0].scrollHeight}, 2000);
                }else {
                    if (delay_to_call < 60000){
                        delay_to_call += 5000;
                    }
                }
                setTimeout(checkForNewChat, delay_to_call);
                // audioElement.play();
                // $("#chats").append(new Message(data.toString(), "text").generateHTML());
                // $("#chat-list").animate({ scrollTop: $("#chat-list")[0].scrollHeight}, 2000);
            } else {

            }
        });
        // console.log('call');
        // setTimeout(myPeriodicMethod, 5000);
    }

    // schedule the first invocation:
    setTimeout(checkForNewChat, delay_to_call);
});