/**
* Theme: Notika Template
* Author: Kalam
* Chat application 
*/

!function($) {
    "use strict";

    var ChatApp = function() {
        this.$body = $("body"),
        this.$chatInput = $('.chat-input'),
        this.$chatList = $('.conversation-list'),
        this.$chatSendBtn = $('.chat-send .btn')
    };

    //saves chat entry - You should send ajax call to server in order to save chat enrty
    ChatApp.prototype.save = function() {
        var chatText = this.$chatInput.val();
        var chatTime = moment().format("h:mm");
        if (chatText == "") {
            sweetAlert("Oops...", "You forgot to enter your chat message", "error");
            this.$chatInput.focus();
        } else {
            if (chatText.length < 2){
                alert("empty message!!!");
            }else {
                var $crf_token = $('[name="csrfmiddlewaretoken"]').attr('value');
                var data = {"message_text":chatText};
                const url = "../../../message/to/"+ patient_id.toString() + "/";
                $.ajax({
                    type: "POST",
                    url: url,
                    data: data,
                    headers:{"X-CSRFToken": $crf_token},
                    success: function(data){
                            $('<li class="clearfix odd"><div class="chat-avatar"><img src='+ doctor_image_url+'><i>' + chatTime + '</i></div><div class="conversation-text"><div class="ctext-wrap chat-widgets-cn"><i class="text-right">شما</i><p>' + chatText + '</p></div></div></li>').appendTo('ul.conversation-list');
                            $('.chat-input').val('');
                            $('.chat-input').focus();
                            // $('.conversation-list').scrollTo('100%', '100%', {
                            //     easing: 'swing'
                            // });
                            // $('.widgets-chat-scrollbar').scrollTo('100%', '100%', {
                            //     easing: 'swing'
                            // });
                        },
                    error: function(error){
                        console.log(error);
                    }
                });

            }

        }
    },
    ChatApp.prototype.init = function () {
        var $this = this;
        //binding keypress event on chat input box - on enter we are adding the chat into chat list - 
        $this.$chatInput.keypress(function (ev) {
            var p = ev.which;
            if (p == 13) {
                $this.save();
                return false;
            }
        });


        //binding send button click
        $this.$chatSendBtn.click(function (ev) {
           $this.save();
           return false;
        });
    },
    //init ChatApp
    $.ChatApp = new ChatApp, $.ChatApp.Constructor = ChatApp
    
}(window.jQuery),

//initializing main application module
function($) {
    "use strict";
    $.ChatApp.init();
}(window.jQuery);