import platform

def init():
    server = platform.version()
    print("running in", server)

    if "#52-Ubuntu" in server:
        import os
        import django
        os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'ziluck_project.settings')
        django.setup()
    else:
        import os
        import sys
        import django
        sys.path.append('/home/idiair/.ziluck310')
        os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'ziluck_project.settings')
        django.setup()

init()


from APIs.models import FoodCard


def set_main_dish_codes_for_chesse_peanut_butter_oatmeal():
    try:
        # Get all food cards containing "پنیر" in FA_Name and main_dish_code = -1
        food_cards = FoodCard.objects.filter(FA_Name__contains="پنیر", main_dish_code=-1, is_breakfast=True)
        
        
        for card in food_cards:
            # Check if food parameter exists and contains food_code=1042
            card_foods = card.foods
            # Check if card_foods is a list
            if isinstance(card_foods, list):
                # Look for food_code=1042 in any of the food objects
                for food in card_foods:
                    if isinstance(food, dict) and food.get('food_code') == 1042:
                        # Update main_dish_code to 1042 for this food card
                        food_cards.update(main_dish_code=1042)
                        break
                        
        
        oatmeal_food_cards = FoodCard.objects.filter(FA_Name__contains="اوتمیل", main_dish_code=-1, is_breakfast=True)
        
        for card in oatmeal_food_cards:
            # Check if food parameter exists and contains food_code=20038
            card_foods = card.foods
            # Check if card_foods is a list
            if isinstance(card_foods, list):
            # Look for food_code=20038 in any of the food objects
                for food in card_foods:
                    if isinstance(food, dict) and food.get('food_code') == 20038:
                        # Update main_dish_code to 20038 for this food card
                        oatmeal_food_cards.update(main_dish_code=20038)
                        break            
            
        peanut_butter_food_cards = FoodCard.objects.filter(FA_Name__contains="کره بادام زمینی", main_dish_code=-1, is_breakfast=True)
        
        for card in peanut_butter_food_cards:
            # Check if food parameter exists and contains food_code=16150
            card_foods = card.foods
            # Check if card_foods is a list
            if isinstance(card_foods, list):
            # Look for food_code=16150 in any of the food objects
                for food in card_foods:
                    if isinstance(food, dict) and food.get('food_code') == 16150:
                        # Update main_dish_code to 16150 for this food card
                        peanut_butter_food_cards.update(main_dish_code=16150)
                        break            
        
        tahini_food_cards = FoodCard.objects.filter(FA_Name__contains="ارده", main_dish_code=-1, is_breakfast=True)
        
        for card in tahini_food_cards:
            # Check if food parameter exists and contains food_code=12166
            card_foods = card.foods
            # Check if card_foods is a list
            if isinstance(card_foods, list):
                # Look for food_code=12166 in any of the food objects
                for food in card_foods:
                    if isinstance(food, dict) and food.get('food_code') == 12166:
                        # Update main_dish_code to 12166 for this food card
                        tahini_food_cards.update(main_dish_code=12166)
                        break
        
        tahini_food_cards = FoodCard.objects.filter(FA_Name__contains="ارده", main_dish_code=-1, is_breakfast=True)
        
        for card in tahini_food_cards:
            # Check if food parameter exists and contains food_code=12166
            card_foods = card.foods
            # Check if card_foods is a list
            if isinstance(card_foods, list):
                # Look for food_code=12166 in any of the food objects
                for food in card_foods:
                    if isinstance(food, dict) and food.get('food_code') == 12166:
                        # Update main_dish_code to 12166 for this food card
                        tahini_food_cards.update(main_dish_code=12166)
                        break
                        
        khagineh_food_cards = FoodCard.objects.filter(FA_Name__contains="خاگینه", main_dish_code=-1)
        
        for card in khagineh_food_cards:
            # Check if food parameter exists and contains food_code=9980080
            card_foods = card.foods
            # Check if card_foods is a list
            if isinstance(card_foods, list):
                # Look for food_code=9980080 in any of the food objects
                for food in card_foods:
                    if isinstance(food, dict) and food.get('food_code') == 9980080:
                        # Update main_dish_code to 9980080 for this food card
                        khagineh_food_cards.update(main_dish_code=9980080)
                        break
                        
                    
        # Serialize the food cards
        cards_data = []
        for card in food_cards:
            card_data = {
                'id': card.id,
                'FA_Name': card.FA_Name,
                'EN_Name': card.EN_Name,
                'main_dish_code': card.main_dish_code,
                'foods': card.foods
            }
            cards_data.append(card_data)

        return cards_data

    except Exception as e:
        return "error " + str(e)
    
set_main_dish_codes_for_chesse_peanut_butter_oatmeal()

