from APIs.models import User
from APIs.views.views import myResponse
from panel.PushNotification import PushNotification
from panel.models import Assistant, Message, FirebaseNotification
from datetime import datetime

def test_bacteria_message_script(target_group):
    assistants = Assistant.objects.all()
    data = [{'id': 2121, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2124, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2110, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2119, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2126, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2128, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 0, 'bacteria': "-", 'coach': 'Mahdiye'}, {'id': 2133, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2132, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2113, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2117, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2139, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2141, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2137, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2142, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2146, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2147, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2150, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2151, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2154, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2159, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2158, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2157, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2160, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2162, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2166, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2168, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2170, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2169, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2175, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2176, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2173, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2177, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2184, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2187, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 0, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 0, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2191, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2193, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2194, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2195, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2197, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2208, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2201, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2202, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2205, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2204, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2207, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2216, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2212, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2213, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2217, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2221, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2228, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2223, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2227, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2182, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2233, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 0, 'bacteria': "-", 'coach': 'Mahdiye'}, {'id': 2236, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2238, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2240, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2242, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2244, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2245, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2112, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2253, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2247, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2249, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2116, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 0, 'bacteria': "-", 'coach': 'Mahdiye'}, {'id': 2256, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2258, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2259, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2265, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2270, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2273, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2277, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2269, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2268, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2276, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2279, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2272, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2283, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2284, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2287, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2286, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2289, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2293, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2237, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2109, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2296, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2299, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2300, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2302, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2305, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2308, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2310, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2311, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2315, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2317, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2319, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2322, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2321, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2325, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2326, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2329, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2330, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2331, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2178, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2336, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2335, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2337, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2341, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2340, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2344, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2346, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2349, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2351, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2353, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2355, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 0, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2360, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2364, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2365, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2369, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2370, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2372, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2219, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2378, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2380, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2383, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2384, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2385, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2376, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2111, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2390, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2394, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2397, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2403, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2405, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2409, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2411, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2413, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2415, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2417, 'bacteria': 'Bifidobacterium', 'coach': 'Mahdiye'}, {'id': 2419, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}, {'id': 2420, 'bacteria': 'Fecalibacterium', 'coach': 'Mahdiye'}, {'id': 2423, 'bacteria': 'Lactobacilus', 'coach': 'Mahdiye'}, {'id': 2426, 'bacteria': 'Akkremansia', 'coach': 'Mahdiye'}, {'id': 2430, 'bacteria': 'Bacteroidet', 'coach': 'Mahdiye'}]

    bacteroidet_messages = [
        "باکتری که این دو هفته میخواهیم باهم راجع بهش صحبت بکنیم کسی نیست جز باکتروییدت!",
        """باکتروئیدت ها یک نوع باکتری مفید هستند که در خاک، آب دریا، روده و پوست انسان و حیوانات زندگی می کنند. این باکتری ها می توانند با دستگاه گوارش انسان همزیستی کنند و در روده انسان بسیار فراوان هستند.
باکتروئیدت ها در روده افرادی که در دوران نوزادی با شیر مادر تغذیه شده اند بیشتر هستند و به عنوان یکی از پایدارترین بخش های میکرو فلور دستگاه گوارش محسوب می شوند.
کاهش فراوانی برخی از گونه های باکتروئیدت ها ممکن است با چاقی همراه باشد. این باکتری ها در بیماران مبتلا به سندرم روده تحریک پذیر بیشتر هستند و در دیابت نوع 1 و 2 نقش دارند. این باکتری ها تا زمانی که در دستگاه گوارش هستند عموما مفید هستند، اما اگر از دستگاه گوارش خارج شوند، می توانند مضر باشند."""
        '''"حالا این باکتری برای رشدش به چه منابع غذایی علاقه دارد؟
نان خمیر ترش، زیتون و دوغ کفیر "''',
        ''''خیلی خوبه اگر این منابع رو به برنامه غذایی این دو هفته ات اضافه کنی و به رشد باکتری مفید باکتروییدت کمک کنی'''
    ]

    akkermansia_messages = [
        """باکتری که این دو هفته میخواهیم باهم راجع بهش صحبت بکنیم کسی نیست جز آکرمانسیا!""",
        """"آکرمانسیا یکی از باکتری های مفیدی هست در دستگاه گوارش ما زندگی می کنه. این باکتری می تواند بر وزن ما تاثیر بگذارد و اگر در بدنمان کم شود، ممکن است وزنمان افزایش یابد یا وزنی که کاهش داده ایم، دوباره برگردد. همچنین، کاهش این باکتری ممکن است خطر بروز بیماری تنبلی تخمدان را افزایش دهد.
یکی از انواع این باکتری، آکرمانسیا موسینیفیلا، می تواند به کنترل بهتر قند خون و حساسیت به انسولین کمک کند. همچنین، این باکتری می تواند احتمال ابتلا به کبد چرب غیر الکلی که مرتبط با رژیم غذایی پرچرب است را کاهش دهد.""",

        """"حالا این باکتری برای رشدش به چه منابع غذایی علاقه دارد؟
جو، جو دوسر، غلات کامل، هویج، سیب، گروه خانواده کلم ها و عرق کاسنی""",

        """خیلی خوبه اگر این منابع رو به برنامه غذایی این دو هفته ات اضافه کنی و به رشد باکتری مفید آکرمانسیا کمک کنی""",
    ]

    bifidobacterium_messages = [
        """باکتری که این دو هفته میخواهیم باهم راجع بهش صحبت بکنیم کسی نیست جز بیفیدوباکتریوم!""",
        """"بیفیدوباکتریوم یک نوع باکتری مفید است که در دستگاه گوارش پستانداران زندگی می کند. این باکتری ها می توانند به عنوان پروبیوتیک استفاده شوند.
 بیفیدوباکتریوم ها می توانند اثرات مفید بسیاری بر سلامت داشته باشند، از جمله تنظیم میکروبیوتای روده، مهار باکتری های مضر، تعدیل پاسخ های ایمنی و تولید ویتامین ها.
 این باکتری ها همچنین می توانند به بهبود سد مخاطی روده و کاهش سطح لیپوپلی ساکارید در روده کمک کنند.""",
        """"حالا این باکتری برای رشدش به چه منابع غذایی علاقه دارد؟
این باکتری ها علاقه زیادی به امگا-3 و اینولین دارند. منابع گیاهی امگا-3 شامل دانه چیا، تخم شربتی، شاهدانه، گردو، بزرک و منابع حیوانی آن ماهی های چرب می باشند. منابع غذایی اینولین شامل سیر، پیاز و جو هستند.""",
        """خیلی خوبه اگر این منابع رو به برنامه غذایی این دو هفته ات اضافه کنی و به رشد باکتری مفید بیفیدوباکتریوم کمک کنی"""
    ]

    fecalibacterium_messages = [
        """باکتری که این دو هفته میخواهیم باهم راجع بهش صحبت بکنیم کسی نیست جز فکالی باکتریوم!""",
        """"این باکتری نقش بسیار مهمی در سلامت انسان دارد و به تولید اسید بوتیریک کمک می‌کنند که این اسید به کاهش التهابات و بهبود سلامت گوارشی کمک می‌کند.
فکالی باکتریوم در حدود 5 تا 15 درصد از باکتری‌های روده انسان را تشکیل می‌دهد. این باکتری‌ها نقش مهمی در تجزیه و جذب مواد غذایی دارند و به مقاومت در برابر عفونت‌های گوارشی کمک می‌کنند.
با توجه به تحقیقات، کاهش سطح فکالی باکتریوم در روده باعث افزایش خطر بروز بیماری‌های مختلفی همچون سندرم روده تحریک‌پذیر میشه.""",
        """"حالا این باکتری برای رشدش به چه منابع غذایی علاقه دارد؟
این باکتری ها علاقه زیادی به امگا-3 و اینولین دارند. منابع گیاهی امگا-3 شامل دانه چیا، تخم شربتی، شاهدانه، گردو، بزرک و منابع حیوانی آن ماهی های چرب می باشند. منابع غذایی اینولین شامل سیر، پیاز و جو هستند.""",
        """خیلی خوبه اگر این منابع رو به برنامه غذایی این دو هفته ات اضافه کنی و به رشد باکتری مفید فکالی باکتریوم کمک کنی""",
    ]

    lactobacilus_messages = [
        """باکتری که این دو هفته میخواهیم باهم راجع بهش صحبت بکنیم کسی نیست جز لاکتوباسیلوس!""", """"لاکتوباسیلوس یک نوع باکتری خوبه که توی روده ما زندگی می‌کنه. این باکتری‌ها می‌تونن به سلامتی ما کمک کنن. مثلا، اونها می‌تونن باکتری‌های بد رو از بدنمون دور کنن و به ما کمک کنن که انرژی لازم رو از غذا بگیریم.
لاکتوباسیلوس همچنین می‌تونه به درمان برخی از بیماری‌ها مثل IBS و درمان عفونت‌های ناشی از باکتری هلیکوباکتر پیلوری کمک کنن. اگه این باکتری‌ها رو به عنوان یک پروبیوتیک همراه با درمان استفاده کنیم، می‌تونه اثربخشی درمان رو افزایش بده و عوارض جانبی رو کاهش بده.""",
                             """"حالا این باکتری برای رشدش به چه منابع غذایی علاقه دارد؟
گوشت پرندگان، لبنیات و مواد غذایی حاوی فیبر مثل سیر، پیاز، جو، موز و عرق کاسنی""", """خیلی خوبه اگر این منابع رو به برنامه غذایی این دو هفته ات اضافه کنی و به رشد باکتری مفید لاکتوباسیلوس کمک کنی"""
    ]

    alistipes_messages = [
        """باکتری که این دو هفته میخواهیم باهم راجع بهش صحبت بکنیم کسی نیست جز آلستیپس!""",
        """"آلستیپس یک باکتری مفید و کلیدی در میکروبیوم روده انسان است که در تنظیم سیستم ایمنی، متابولیسم و سلامت روانی نقش دارد. این باکتری‌ها می‌توانند در بازیابی میکروبیوم روده پس از مصرف آنتی‌بیوتیک‌ها مؤثر باشند.
مطالعات اخیر نشان می‌دهند که تغییرات در سطح آلستیپس ممکن است با افسردگی و اضطراب مرتبط باشد. به طور مثال، کاهش آلستیپس در افرادی با رفتارهای مشابه افسردگی مشاهده شده است، که نشان می‌دهد ممکن است آلستیپس نقش محافظتی در برابر مشکلات روانی داشته باشد. این باکتری با تولید اسیدهای چرب کوتاه زنجیره (SCFA) که در سلامت روده و کاهش التهاب نقش دارد می‌تواند به بهبود شرایط روانی مانند افسردگی کمک کند.""",
        """"
حالا این باکتری برای رشدش به چه منابع غذایی علاقه دارد؟
- غلات کامل: مانند جوی دو سر و غلات کامل مانند برنج قهوه‌ای، نان تست جو دو سر، نان خمیرترش، نان پروتئینه و ...
- عدس، نخود، و لوبیا
- سیب‌زمینی شیرین و هویج
- موز و سیب
- سیر و پیاز""",
"""خیلی خوبه اگر این منابع رو به برنامه غذایی این دو هفته ات اضافه کنی و به رشد باکتری مفید آلستیپس کمک کنی""",
    ]

    therapists = Assistant.objects.all()
    mghods = Assistant.objects.filter(first_name="مریم", last_name="قدس")[0]
    mtabesh = Assistant.objects.filter(first_name="مهدیه", last_name="تابش")[0]

    # user = User.objects.filter(django_user_id=8)[0]

    listtt = []

    for d in data:
        print(f"processing user with id of {d["id"]}")

        message = ""

        selectedList = []

        if (d['bacteria'] == "Akkremansia"):
            selectedList = akkermansia_messages
        elif (d['bacteria'] == "Alistipes"):
            selectedList = akkermansia_messages
        elif (d['bacteria'] == "Bacteroidet"):
            selectedList = bacteroidet_messages
        elif (d['bacteria'] == "Bifidobacterium"):
            selectedList = bifidobacterium_messages
        elif (d['bacteria'] == "Lactobacilus"):
            selectedList = lactobacilus_messages
        elif (d['bacteria'] == "Fecalibacterium"):
            selectedList = fecalibacterium_messages

        # if (d["coach"] == "Maryam"):
        #     sender = mghods
        # elif (d["coach"] == "Mahdiye"):
        sender = mtabesh

        user = User.objects.filter(django_user_id=8)[0]
        # user = User.objects.filter(django_user_id=d["id"])[0]

        user_groups = user.django_user.groups.all()

        group = []
        for user_group in user_groups:
            group.append(user_group.name)


        if (group.__contains__(target_group)):

            listtt.append(
                {
                    "full_name" : user.profile.first_name + " " + user.profile.last_name,
                    "user_groups" : group
                }
            )

            for text in selectedList:

                m = Message(sender=sender.django_user, receiver=user.django_user, text=text)
                m.save()
                notification = FirebaseNotification(
                    title="پیام جدید از مربی",
                    body=text,
                    datetime=datetime.now(),
                    user=user
                )
                notification.save()

                try:
                    result = PushNotification(user).push_service.notify(fcm_token=user.profile.firebase_token,
                                                      notification_title="رژیم شما آماده است!",
                                                      notification_body=text)
                except Exception as e:
                    print("error occured while sending notification")
                    print(f"This is the error code: {e}")

    return myResponse.OK("data", {"list" : listtt})





