from django.urls import path
from . import views


urlpatterns = [
    path('get/link/', views.get_payment_link, name='payment-link'),
    path('get/link/coin/', views.get_payment_link_coin, name='payment-link-coin'),
    path('check/discount/', views.check_for_discount, name='check-discount'),
    path('verify/zarinpal/', views.verify, name='verify'),
    path('check/subscription/', views.check_subscription, name='check-subscription'),
    path('verify/digipay/payment/', views.verify_digipay, name='verify-digipay-payment'),
    path('digipay/payment/', views.get_digipay_payment_link, name='digipay-payment'),
    
    # Timeslot payment verification endpoints
    path('verify/timeslot/zarinpal/', views.verify_timeslot_zarinpal, name='verify-timeslot-zarinpal'),
    path('verify/timeslot/digipay/', views.verify_timeslot_digipay, name='verify-timeslot-digipay'),
    
    # Hospital integration endpoint
    path('hospital/check/discount/', views.check_for_discount_hospital, name='check-hospital-discount'),
    path('hospital/successful-payment/', views.successful_payment_from_hospital, name='simulate-successful-payment'),
    path('hospital/statistics/', views.get_hospital_upgrade_statistics, name='hospital-upgrade-statistics'),
]