from django.shortcuts import render, redirect
from django.views.decorators.csrf import csrf_exempt
from rest_framework.decorators import api_view
from django.contrib.auth.decorators import login_required
from django.contrib.auth.models import Group
from django.contrib.auth import logout, authenticate
from django.contrib.auth import login as django_login
from django.http import HttpResponse
import datetime

from APIs.models import ZiLuckGroup
from APIs.views.Errors import Errors
from APIs.views.views import myResponse
from panel.models import *
from django.db.models import Q
from collections import Counter
from django.utils import translation
from django.conf import settings


# from iDia_project.settings import STATIC_ROOT
import os

STATIC_PATH = 'static/panel/'
import os


def current_datetime():
    now = datetime.datetime.now()
    html = "<html><body>It is now %s.</body></html>" % now
    return HttpResponse(html)


def create_image_name(id):
    name = str(id * 177 + 10000000)  # hash function
    return name


def generate_error_page(request, message):
    context = {
        'message': message,
    }
    return render(request=request, template_name='manager/error.html', context=context)


@api_view(["GET"])
def test(request):
    return render(request, template_name='general/test.html', context={})


@csrf_exempt
@api_view(["GET", "POST"])
def echo(request):
    return HttpResponse("POST:%s\nGET:%s\nFILES%s\nDjango user:%s" % (
        str(request.POST), str(request.GET), str(request.FILES), str(request.user)))


@api_view(["GET"])
def login(request):
    language = request.session.get(settings.LANGUAGE_COOKIE_NAME, 'en')  # Default to 'en' if not set
    logout(request)
    request.session[settings.LANGUAGE_COOKIE_NAME] = language
    translation.activate(language)
    return render(request, template_name='general/login.html', context={})


@api_view(["POST"])
def coach_login(request):
    try:
        username = request.POST.get('username')
        password = request.POST.get('password')
        user = authenticate(username=username, password=password)

        if user is not None:
            django_login(request=request, user=user)
            context = {}
            if user.groups.filter(name='HR').exists():
                role = 'hr'
                # HR users access the HR lab tests panel
                return myResponse.OK("Logged in as HR", {'redirect': '/panel/hr/employee-lab-tests/'})
            elif user.groups.filter(name='Manager').exists():
                role = 'manager'
                context['user'] = Manager.objects.get(django_user=user)
            elif user.groups.filter(name='Doctor').exists():
                role = 'doctor'
                context['user'] = Doctor.objects.get(django_user=user)
                return redirect('panel-doctor-patients')
            elif user.groups.filter(name='Assistant').exists():
                role = 'assistant'
                context['user'] = Assistant.objects.get(django_user=user)
            elif user.groups.filter(name='Hospital').exists():
                role = 'hospital'
                try:
                    context['hospital'] = Hospital.objects.get(django_user=user)
                    return redirect('panel-hospital-dashboard')
                except Hospital.DoesNotExist:
                    return myResponse.Error("Hospital account not found", Errors.InvalidUser.code)
            elif user.is_superuser:
                role = 'manager'
            else:
                role = 'none'
                return myResponse.Error("login with a valid user", Errors.InvalidUser.code)

            try:
                context['user'].telegram_chat_id = request.POST.get('telegram_chat_id')
            except Exception as e:
                return myResponse.Error("There was an error parsing the telegram", e.args[0])

            return myResponse.OK("Logged in √", {})

        else:
            return myResponse.Error("Either username or password is not correct please check again",
                                    Errors.InvalidUser.code)

    except Exception as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


# @login_required(login_url='/panel/login/')
@csrf_exempt
@api_view(["GET", "POST"])
def index(request):
    if request.method == "POST":
        username = request.POST.get('username')
        password = request.POST.get('password')
        language = request.POST.get('language')
        user = authenticate(username=username, password=password)

        # return generate_error_page(request, str(user.first_name))
        if user is not None:
            django_login(request=request, user=user)
            # Handle language preference
            if language and language in dict(settings.LANGUAGES):
                # Store language preference in session
                request.session[settings.LANGUAGE_COOKIE_NAME] = language
                translation.activate(language)
            else:
                # Default to English if language not found
                request.session[settings.LANGUAGE_COOKIE_NAME] = 'en'
                translation.activate('en')
            context = {}
            if user.groups.filter(name='HR').exists():
                role = 'hr'
                # HR users don't need a Manager/Doctor/Assistant instance
                # They access the HR lab tests panel directly
                return redirect('panel-hr-employee-lab-tests')
            elif user.groups.filter(name='Manager').exists():
                role = 'manager'
                context['user'] = Manager.objects.get(django_user=user)
            elif user.groups.filter(name='Doctor').exists():
                role = 'doctor'
                context['user'] = Doctor.objects.get(django_user=user)
                return redirect('panel-doctor-patients')
            elif user.groups.filter(name='Assistant').exists():
                role = 'assistant'
                context['user'] = Assistant.objects.get(django_user=user)
                time = datetime.now()
                assistant = Assistant.objects.get(django_user=user)
                assistant.last_login = time
                assistant.save()
                return redirect('panel-assistant-patients')
            elif user.groups.filter(name='Hospital').exists():
                role = 'hospital'
                try:
                    context['hospital'] = Hospital.objects.get(django_user=user)
                    return redirect('panel-hospital-dashboard')
                except Hospital.DoesNotExist:
                    return generate_error_page(request, "Hospital account not found")
            elif user.is_superuser:
                role = 'manager'
            else:
                role = 'none'
                return generate_error_page(request, "login with a valid user")
            return render(request, template_name=role + '/index.html', context=context)
        else:
            return redirect('panel-login')
    elif request.method == "GET":
        # Retrieve language preference from session
        language = request.session.get(settings.LANGUAGE_COOKIE_NAME, 'en')
        translation.activate(language)
        if not request.user.is_authenticated:
            # return generate_error_page(request, str(request.POST) + " " + str(request.GET))
            return redirect('panel-login')
        else:
            user = request.user

            context = dict()
            if user.groups.filter(name='HR').exists():
                role = 'hr'
                # HR users access the HR lab tests panel
                return redirect('panel-hr-employee-lab-tests')
            elif user.groups.filter(name='Manager').exists():
                role = 'manager'
                context['user'] = Manager.objects.get(django_user=user)
            elif user.groups.filter(name='Hospital').exists():
                role = 'hospital'
                try:
                    context['hospital'] = Hospital.objects.get(django_user=user)
                    return redirect('panel-hospital-dashboard')
                except Hospital.DoesNotExist:
                    return generate_error_page(request, "Hospital account not found")
            elif user.groups.filter(name='Doctor').exists():
                role = 'doctor'
                doctor = Doctor.objects.get(django_user=user)

                seven_days_ago = (datetime.now() - timedelta(days=7)).date()
                new_sub = []
                patients_list = AppUser.objects.all()
                patients_list = list(patients_list)
                disease_counts = Counter()
                for p in patients_list:
                    app_user = p
                    diseases = p.profile.diseases
                    for disease in diseases:
                        disease_counts[disease] += 1
                    django_user = app_user.django_user
                    temp2 = TherapistSelection.objects.filter(user=django_user)
                    try:
                        if temp2.last().created_at.date() >= seven_days_ago:
                            new_sub.append(True)
                        else:
                            new_sub.append(False)
                    except Exception as e:
                        new_sub.append(False)
                total_patients = len(patients_list)
                disease_percentages = {disease: round((count / total_patients) * 100, 2) for disease, count in disease_counts.items()}

                context['disease_percentages'] = disease_percentages
                context['patients_list'] = zip(patients_list, new_sub)
                context['user'] = Doctor.objects.get(django_user=user)
                context['patients'] = AppUser.objects.filter(profile__therapist=user)
                context['number_of_patients'] = context['patients'].count()
                context['assistant'] = Assistant.objects.filter(doctor=doctor)
            elif user.groups.filter(name='Assistant').exists():
                role = 'assistant'
                context['user'] = Assistant.objects.get(django_user=user)
                context['patients-assistant'] = AppUser.objects.filter(profile__therapist=user)
                context['number_of_patients'] = context['patients-assistant'].count()

                django_groups = request.user.groups.filter(~Q(name='Assistant'))
                user_groups = ZiLuckGroup.objects.filter(group_ptr__in=django_groups)
                django_users = []
                group_names = []
                context['groups'] = user_groups
                for group in user_groups:
                    users_group = group.user_set.all()
                    for c in users_group:
                        django_users.append(c)

                result_set = AppUser.objects.filter(Q(profile__therapist=user) & ~Q(django_user__in=django_users))
                all_set = AppUser.objects.filter(Q(profile__therapist=user) & Q(django_user__in=django_users))
                for g in all_set:
                    group_names.append(g.django_user.groups.exclude(name__in=["Patient", "Doctor", "Assistant"])[0].name)
                days_joined = []
                days_joined2 = []
                users = []
                for user in result_set:
                    try:
                        if user.profile.register_time:
                            days_joined.append((datetime.now() - user.profile.register_time).days)
                        else:
                            days_joined.append(0)  # or some default/fallback
                    except Exception as e:
                        days_joined.append(0)  # fallback
                for user in all_set:
                    try:
                        if user.profile.register_time:
                            days_joined2.append((datetime.now() - user.profile.register_time).days)
                        else:
                            days_joined2.append(0)  # or some default/fallback
                    except Exception as e:
                        days_joined2.append(0)  # fallback
                context['out_groups'] = zip(result_set, days_joined)
                context['out_groups_2'] = zip(result_set, days_joined)
                context['in_groups'] = zip(all_set, group_names, days_joined2)
                context['in_groups_2'] = zip(all_set, group_names, days_joined2)
            elif user.is_superuser:
                role = 'manager'
            else:
                role = 'none'
                return generate_error_page(request, "login with a valid user")

            return render(request, template_name=role + '/index.html', context=context)


@api_view(["POST", "GET"])
def logout_user(request):
    language = request.session.get(settings.LANGUAGE_COOKIE_NAME, 'en')  # Default to 'en' if not set
    logout(request)
    request.session[settings.LANGUAGE_COOKIE_NAME] = language
    translation.activate(language)
    return redirect('panel-login')



@api_view(["GET"])
def doctors_page(request):
    if not request.user.is_authenticated:
        return redirect('panel-login')
    temp = Manager.objects.filter(django_user=request.user)
    if not temp.exists():
        return redirect('panel-login')
    manager = temp[0]
    doctors = Doctor.objects.filter(manager=manager)
    context = {
        "doctors": doctors,
        "user": manager
    }
    return render(request, 'manager/doctors.html', context=context)


@api_view(["GET"])
def assistants_page(request):
    if not request.user.is_authenticated:
        return redirect('panel-login')
    manager = Manager.objects.filter(django_user=request.user)[0]
    assistants = Assistant.objects.filter(manager=manager)
    context = {
        "assistants": assistants,
        'user': manager
    }
    return render(request, 'manager/assistants.html', context=context)


@api_view(["GET"])
def add_doctor_page(request):
    if not request.user.is_authenticated:
        return redirect('panel-login')
    fields = Field.objects.all()
    manager = Manager.objects.filter(django_user=request.user)[0]
    context = {
        'fields': fields,
        'user': manager
    }
    return render(request, 'manager/add-doctor.html', context=context)


@api_view(["POST"])
def create_doctor(request):
    # return generate_error_page(request,str(request.POST))
    if not request.user.is_authenticated:
        return redirect('panel-login')
    django_user = request.user
    if not django_user.groups.filter(name='Manager').exists():
        return generate_error_page(request, "you have not access")
    manager = Manager.objects.filter(django_user=django_user)[0]
    # return generate_error_page(request, str(request.POST) + "\n\n<br><br>" + str(request.FILES))

    field = Field.objects.get(name=request.POST.get("field"))
    if field is None:
        return generate_error_page(request, "field not selected!")
    first_name = request.POST.get("first_name")
    last_name = request.POST.get("last_name")
    if len(first_name) < 3 or len(last_name) < 3:
        return generate_error_page(request, "نام یا نام خانوادگی اشتباه است")
    password = request.POST.get("password")
    confirm = request.POST.get("confirm")
    if len(password) < 6 or len(confirm) < 5:
        return generate_error_page(request, "رمز (های) عبور کوتاه هستند، حداقل باید 6 رقم وارد کنید")
    if confirm != password:
        return generate_error_page(request, "password not equal to confirmation")
    username = request.POST.get("username")
    if DjangoUser.objects.filter(username=username).exists():
        return generate_error_page(request, "این نام کاربری قبلا انتخاب شده است")

    gender = str(request.POST.get("gender"))
    if gender == "Female":
        gender = 0
    elif gender == "Male":
        gender = 1
    else:
        gender = None

    is_active = str(request.POST.get("is_active"))
    if is_active == "false":
        is_active = False
    elif is_active == "true":
        is_active = True

    phone = str(request.POST.get("phone"))
    if len(phone) != 11:
        return generate_error_page(request, "شماره تلفن اشتباه است")

    image = request.FILES.get("image")
    if not (image == None):
        with open(STATIC_PATH + 'profiles/doctors/name.png', 'wb+') as destination:
            for chunk in image.chunks():
                destination.write(chunk)
        destination.close()
    du = DjangoUser(username=username, first_name=first_name, last_name=last_name)
    du.set_password(password)
    du.save()
    gr = Group.objects.get(name='Doctor')
    gr.user_set.add(du)
    doctor = Doctor(manager=manager, field=field, first_name=first_name, last_name=last_name,
                    gender=gender, django_user=du, is_active=is_active, phone=phone)
    doctor.save()
    if not (request.FILES.get("image") == None):
        new_image_name = create_image_name(doctor.django_user.id) + ".png"
        new_image_path = STATIC_PATH + 'profiles/doctors/' + new_image_name
        os.rename(STATIC_PATH + 'profiles/doctors/name.png',
                  new_image_path)
        doctor.image = new_image_name
        doctor.save()
    return redirect('panel-manager-doctors')


@api_view(["GET"])
def delete_doctor(request, doctor_id):
    if not request.user.is_authenticated:
        return redirect('panel-login')
    django_user = request.user
    if not django_user.groups.filter(name='Manager').exists():
        return generate_error_page(request, "you have not access")
    manager = Manager.objects.filter(django_user=django_user)[0]
    doctor = Doctor.objects.get(id=doctor_id)
    if doctor is not None:
        if doctor.manager == manager:
            doctor.django_user.delete()
            doctor.delete()
        else:
            return generate_error_page(request, "you have not access!")
    return redirect('panel-manager-doctors')


@api_view(["GET"])
def add_assistant_page(request):
    if not request.user.is_authenticated:
        return redirect('panel-login')
    django_user = request.user
    manager = Manager.objects.get(django_user=django_user)
    if manager is None:
        return generate_error_page(request, "manager not found!")
    doctors = Doctor.objects.filter(manager=manager)
    context = {
        'doctors': doctors,
    }
    return render(request, 'manager/add-assistant.html', context=context)


@api_view(["POST"])
def create_assistant(request):
    if not request.user.is_authenticated:
        return redirect('panel-login')
    django_user = request.user
    if not django_user.groups.filter(name='Manager').exists():
        return generate_error_page(request, "you have not access")
    manager = Manager.objects.filter(django_user=django_user)[0]

    doctor = Doctor.objects.get(id=request.POST.get("doctor_id"))
    if doctor is None:
        return generate_error_page(request, "doctor not selected!")
    first_name = request.POST.get("first_name")
    last_name = request.POST.get("last_name")
    if len(first_name) < 3 or len(last_name) < 3:
        return generate_error_page(request, "نام یا نام خانوادگی اشتباه است")
    password = request.POST.get("password")
    confirm = request.POST.get("confirm")
    if len(password) < 6 or len(confirm) < 5:
        return generate_error_page(request, "رمز (های) عبور کوتاه هستند، حداقل باید 6 رقم وارد کنید")
    if confirm != password:
        return generate_error_page(request, "password not equal to confirmation")
    username = request.POST.get("username")
    if DjangoUser.objects.filter(username=username).exists():
        return generate_error_page(request, "این نام کاربری قبلا انتخاب شده است")

    gender = str(request.POST.get("gender"))
    if gender == "Female":
        gender = 0
    elif gender == "Male":
        gender = 1
    else:
        gender = None

    image = request.FILES.get("image")
    if not (image == None):
        with open(STATIC_PATH + 'profiles/assistants/name.png', 'wb+') as destination:
            for chunk in image.chunks():
                destination.write(chunk)
        destination.close()

    du = DjangoUser(username=username, first_name=first_name, last_name=last_name)
    du.set_password(password)
    du.save()
    gr = Group.objects.get(name='Assistant')
    gr.user_set.add(du)
    doctor = Assistant(manager=manager, doctor=doctor, first_name=first_name, last_name=last_name, gender=gender,
                       django_user=du)
    doctor.save()

    if not (request.FILES.get("image") == None):
        new_image_name = create_image_name(doctor.django_user.id) + ".png"
        new_image_path = STATIC_PATH + 'profiles/assistants/' + new_image_name
        os.rename(STATIC_PATH + 'profiles/assistants/name.png',
                  new_image_path)
        doctor.image = new_image_name
        doctor.save()

    return redirect('panel-manager-assistants')


@api_view(["GET"])
def delete_assistant(request, assistant_id):
    if not request.user.is_authenticated:
        return redirect('panel-login')
    django_user = request.user
    if not django_user.groups.filter(name='Manager').exists():
        return generate_error_page(request, "you have not access")
    manager = Manager.objects.filter(django_user=django_user)[0]
    assistant = Assistant.objects.get(id=assistant_id)
    if assistant is not None:
        if assistant.manager == manager:
            assistant.django_user.delete()
            assistant.delete()
        else:
            return generate_error_page(request, "you have not access!")
    return redirect('panel-manager-assistants')
