import json
from datetime import datetime
import numpy as np
from django.http import HttpResponse, JsonResponse
import re
from pandas import read_excel
from APIs.models import Food
from APIs.views.list import getHomeUnitElements
from pprint import pprint

class myResponse():
    @staticmethod
    def Error(message, error_code):
        return JsonResponse({
            "status": "Error",
            "message": message,
            "error_code": str(error_code),
            "data": []
        }, safe=False)

    @staticmethod
    def OK(message, data):
        return JsonResponse({
            "status": "OK",
            "message": message,
            "error_code": "1000",
            "data": [data]
        }, safe=False)


def generateRandomString(seq_set="abcdefghijklmnopqrst123456789", size=20):
    """Choose a random element from a non-empty sequence."""
    try:
        ret = ""
        for i in range(size):
            j = np.random.randint(len(seq_set))
            ret += seq_set[j]
    except ValueError:
        raise IndexError('Cannot choose from an empty sequence') from None
    return ret


def getIntList(string):
    if string is None:
        return []
    temp = string.split("&")
    array = []
    for i in range(len(temp)):
        if temp[i] != '':
            array.append(int(temp[i]))
    return array


def create_image_name(id):
    randomString = generateRandomString()
    name = str(id * 177 + 10000000) + randomString  # hash function
    return name


def generate_file_name(extension):
    t = str(int(datetime.now().timestamp()))
    name = t + generateRandomString() + "." + extension
    return name


def convert_excel_to_diet(path):
    data = {
        # the last one is for -1 model --> [[], [], [], [], [], [], [], ["-1 model"]]
        "week1": {
            "breakfast": [[], [], [], [], [], [], [], []],
            "lunch": [[], [], [], [], [], [], [], []],
            "dinner": [[], [], [], [], [], [], [], []],
            "snack1": [[], [], [], [], [], [], [], []],
            "snack2": [[], [], [], [], [], [], [], []]
        },
        # "week2": {
        #     "breakfast": [[], [], [], [], [], [], []],
        #     "lunch": [[], [], [], [], [], [], []],
        #     "dinner": [[], [], [], [], [], [], []],
        #     "snack1": [[], [], [], [], [], [], []],
        #     "snack2": [[], [], [], [], [], [], []],
        # },
        # "week3": {
        #     "breakfast": [[], [], [], [], [], [], []],
        #     "lunch": [[], [], [], [], [], [], []],
        #     "dinner": [[], [], [], [], [], [], []],
        #     "snack1": [[], [], [], [], [], [], []],
        #     "snack2": [[], [], [], [], [], [], []],
        # }
    }

    MEAL = {
        "breakfast" : "breakfast",
        "lunch" : "lunch",
        "dinner" : "dinner",
        "snack1" : "snack1",
        "snack2" : "snack2",
        "صبحانه" : "breakfast",
        "نهار" : "lunch",
        "شام" : "dinner",
        "اسنک 1" : "snack1",
        "اسنک 2" : "snack2",
        "اسنک 3" : "snack2",
        "میان وعده" : "snack1",
        "میان وعده اول" : "snack1",
        "میان وعده دوم" : "snack2",
        np.NAN : "snack1",
        "سحری" : "breakfast",
        "افطاری" : "dinner",
    }
    df = read_excel(path, sheet_name='Sheet1').iloc[1:]

    diet_type = df.iloc[0, 0]

    data['type'] = diet_type


    for x in range(len(df.values)):
        record = df.iloc[x]
        if str(record.loc['item']) == 'nan':
            break
        if ('#N/A' in str(record.loc['amount']) or
                '#DIV/0!' in str(record.loc['amount']) or
                'nan' in str(str(record.loc['amount'])).lower()):
            continue
        if record.loc['week'] != 1:
            week = "week1"
        # week = f"week{record.loc['week']}"
        week = "week1"
        meal = MEAL[record.loc['meal']]
        title = record.loc['food']
        day = record.loc['day']

        item = {
            'name': record.loc['name'],
            'home_unit': record.loc['home_unit'],
            'amount_in_home_unit': record.loc['amount'],
            'amount_g': round(record.loc['weight_g'], 1),
            'protein': round(record.loc['protein'], 1),
            'energy': round(record.loc['energy'], 1),
            'carbohydrate': round(record.loc['carbohydrate'], 1),
            'fat': round(record.loc['fat'], 1),
            'food_code': record.loc['code']
        }
        if  len(data[week][meal][day-1]) == 0:
            data[week][meal][day - 1].append({
                "title": title,
                "ingredient": []
            })

        data[week][meal][day - 1][0]["ingredient"].append(item)

    # else:
    #     print("B")


    # for key in data:
    #
    #     for i in range(0, 21, 3):
    #         all_items = []git
    #         for j in range(1, len(df.values)):
    #             if str(df.values[j][i]) == 'nan' or str(df.values[j][i]) == 'nan':
    #                 continue
    #             amount = int(df.values[j][i + 2])
    #             item = {
    #                 "food_code": int(df.values[j][i]),
    #                 "amount": amount,
    #                 "food_name": "غذای اشتباه",
    #                 "Calorie": 0,
    #                 "Fat": 0,
    #                 "Carbohydrates": 0,
    #                 "Protein": 0,
    #                 "name_of_home_units": [],
    #                 "weight_of_home_units": [],
    #                 "amount_per_home_units": [],
    #                 "index_of_home_units": []
    #             }
    #             try:
    #                 temp = Food.objects.filter(Data_Base_Number=int(df.values[j][i]))
    #                 if temp.exists():
    #                     food = temp[0]
    #                     item["food_name"] = food.FA_Name
    #                     item["Calorie"] = (amount / 100) * food.Calories
    #                     item["Fat"] = (amount / 100) * food.Fat_g
    #                     item["Carbohydrates"] = (amount / 100) * food.Carbohydrates_g
    #                     item["Protein"] = (amount / 100) * food.Protein_g
    #                     item["name_of_home_units"] = getHomeUnitElements(food.Name_of_home_units)
    #                     str_weight_of_home_units = getHomeUnitElements(food.Weight_of_home_units)
    #                     for weight in str_weight_of_home_units:
    #                         item["amount_per_home_units"].append(round(amount / float(weight), 1))
    #                         item["weight_of_home_units"].append(float(weight))
    #                     item["index_of_home_units"] = getHomeUnitElements(food.Index_of_home_units)
    #
    #             except Exception as e:
    #                 print(e)
    #             all_items.append(item)
    #         data[key].append(all_items)

    return data