from django.urls import path
from panel import view, doctor, api, assistant, manager, manager_dashboard, hospital, hr_lab_tests

urlpatterns = [
    path('echo/', view.echo, name='echo'),
    path('test/', view.test, name='panel-test'),

    path('index/', view.index, name='panel-index'),
    path('login/', view.login, name='panel-login'),
    path('logout/', view.logout_user, name='panel-logout'),

    path('manager/doctors/', view.doctors_page, name='panel-manager-doctors'),
    path('manager/', view.index, name='panel-manager'),
    path('manager/patients/', manager.patients, name='panel-manager-patients'),
    path('manager/assistants/', view.assistants_page, name='panel-manager-assistants'),
    path('manager/add/doctor/', view.add_doctor_page, name='panel-manager-add-doctor'),
    path('manager/add/assistant/', view.add_assistant_page, name='panel-add-assistant'),
    path('manager/create/doctor/', view.create_doctor, name='panel-manager-create-doctor'),
    path('manager/create/assistant/', view.create_assistant, name='panel-manager-create-assistant'),
    path('manager/delete/doctor/<int:doctor_id>/', view.delete_doctor, name='panel-manager-delete-doctor'),
    path('manager/delete/assistant/<int:assistant_id>/', view.delete_assistant, name='panel-manager-delete-assistant'),

    # Category Management URLs
    path('manager/categories/', manager.categories, name='panel-manager-categories'),
    path('manager/categories/create/', manager.create_category, name='panel-manager-create-category'),
    path('manager/categories/<int:category_id>/edit/', manager.edit_category, name='panel-manager-edit-category'),
    path('manager/categories/<int:category_id>/delete/', manager.delete_category, name='panel-manager-delete-category'),

    # Resource Management URLs
    path('manager/resources/', manager.resources, name='panel-manager-resources'),
    path('manager/resources/create/', manager.create_resource, name='panel-manager-create-resource'),
    
    # Manager Dashboard URLs - New B2B Management System
    path('manager/dashboard/', manager_dashboard.dashboard_overview, name='panel-manager-dashboard'),
    path('manager/users/', manager_dashboard.user_management, name='panel-manager-users'),
    path('manager/users/<int:user_id>/', manager_dashboard.user_profile_view, name='panel-manager-user-profile'),
    path('manager/companies/', manager_dashboard.company_management, name='panel-manager-companies'),
    path('manager/companies/<int:company_id>/', manager_dashboard.company_profile_view, name='panel-manager-company-profile'),
    path('manager/sales/', manager_dashboard.sales_pipeline, name='panel-manager-sales'),
    path('manager/segmentation/', manager_dashboard.user_segmentation, name='panel-manager-segmentation'),
    path('manager/notifications/', manager_dashboard.notification_conditions, name='panel-manager-notifications'),
    path('manager/acquisition/', manager_dashboard.acquisition_analytics, name='panel-manager-acquisition'),
    
    # HR Lab Test Management URLs
    path('hr/employee-lab-tests/', hr_lab_tests.employee_lab_tests_dashboard, name='panel-hr-employee-lab-tests'),
    path('hr/employee/<int:employee_id>/lab-tests/', hr_lab_tests.employee_lab_test_detail, name='panel-hr-employee-lab-test-detail'),
    path('hr/employee-eating-habits/', hr_lab_tests.employee_eating_habits, name='panel-hr-employee-eating-habits'),
    path('hr/critical-cases/', hr_lab_tests.critical_cases, name='panel-hr-critical-cases'),
    path('hr/green-employees/', hr_lab_tests.green_employees, name='panel-hr-green-employees'),
    path('hr/company-risks/', hr_lab_tests.company_risks, name='panel-hr-company-risks'),
    
    # AJAX endpoints for manager dashboard
    path('manager/ajax/create-company/', manager_dashboard.create_company_ajax, name='panel-manager-create-company-ajax'),
    path('manager/ajax/create-hr-account/', manager_dashboard.create_hr_account_ajax, name='panel-manager-create-hr-account-ajax'),
    path('manager/ajax/create-lead/', manager_dashboard.create_lead_ajax, name='panel-manager-create-lead-ajax'),
    path('manager/ajax/update-lead-status/', manager_dashboard.update_lead_status_ajax, name='panel-manager-update-lead-status-ajax'),
    
    path('manager/resources/<int:resource_id>/edit/', manager.edit_resource, name='panel-manager-edit-resource'),
    path('manager/resources/<int:resource_id>/delete/', manager.delete_resource, name='panel-manager-delete-resource'),

    # Payment Plans Management URLs
    path('manager/payment-plans/', manager.payment_plans, name='panel-manager-payment-plans'),
    path('manager/payment-plans/create/', manager.create_payment_plan, name='panel-manager-create-payment-plan'),
    path('manager/payment-plans/<int:plan_id>/edit/', manager.edit_payment_plan, name='panel-manager-edit-payment-plan'),
    path('manager/payment-plans/<int:plan_id>/delete/', manager.delete_payment_plan, name='panel-manager-delete-payment-plan'),
    path('manager/payment-plans/<int:plan_id>/toggle/', manager.toggle_payment_plan, name='panel-manager-toggle-payment-plan'),
    
    # Hospital Management URLs (for Manager)
    path('manager/hospitals/', manager.hospitals, name='panel-manager-hospitals'),
    path('manager/hospitals/create/', manager.create_hospital, name='panel-manager-create-hospital'),
    path('manager/hospitals/<int:hospital_id>/edit/', manager.edit_hospital, name='panel-manager-edit-hospital'),
    path('manager/hospitals/<int:hospital_id>/delete/', manager.delete_hospital, name='panel-manager-delete-hospital'),
    path('manager/hospitals/<int:hospital_id>/regenerate/', manager.regenerate_hospital_credentials, name='panel-manager-regenerate-hospital-credentials'),

    # Hospital Panel URLs (for Hospital Users)
    path('hospital/', hospital.dashboard, name='panel-hospital-dashboard'),
    path('hospital/credentials/', hospital.credentials, name='panel-hospital-credentials'),
    path('hospital/credentials/regenerate/', hospital.regenerate_credentials, name='panel-hospital-regenerate-credentials'),
    path('hospital/users/', hospital.users, name='panel-hospital-users'),
    path('hospital/show/patient/<int:patient_id>/', hospital.show_patient, name='panel-hospital-show-patient'),
    path('hospital/upgrades/', hospital.upgrades, name='panel-hospital-upgrades'),

    path('doctor/', view.index, name='panel-doctor'),
    path('doctor/patients/', doctor.patients, name='panel-doctor-patients'),
    path('doctor/patients/archive', doctor.patients_archive, name='panel-doctor-patients-archive'),
    path('doctor/appointments/', doctor.appointments, name='panel-doctor-appointments'),
    path('doctor/shop/', doctor.shop, name='panel-doctor-shop'),
    path('doctor/analyze/', doctor.analyze, name='panel-doctor-analyze'),
    path('doctor/add/item/', doctor.add_item, name='panel-doctor-add-item'),
    path('doctor/delete/item/<int:item_id>/', doctor.delete_item, name='panel-doctor-delete-item'),
    path('doctor/get/existing/tags/', doctor.get_existing_tags, name='panel-doctor-get-existing-tags'),
    path('doctor/assign/<int:patient_id>/to/<int:assistant_id>/', doctor.assign_patient, name='panel-doctor-assign'),
    path('doctor/assistants/', doctor.assistants_page, name='panel-doctor-assistants'),
    path('doctor/add/assistant/', doctor.add_assistant_page, name='panel-doctor-add-assistant-page'),
    path('doctor/create/assistant/', doctor.create_assistant, name='panel-doctor-create-assistant'),
    path('doctor/delete/assistant/<int:assistant_id>/', doctor.delete_assistant, name='panel-doctor-delete-assistant'),
    path('doctor/show/patient/<int:patient_id>/', doctor.show_patient, name='panel-doctor-show-patient'),
    path('doctor/add/food/', doctor.add_food, name='panel-doctor-add-food'),
    path('doctor/add/note/for/<int:patient_id>/', doctor.add_note, name='panel-doctor-add-note'),
    path('doctor/edit/note/<int:note_id>/', doctor.edit_note, name='panel-doctor-edit_note'),
    path('doctor/delete/note/<int:note_id>/', doctor.delete_note, name='panel-doctor-delete_note'),
    path('doctor/chat/with/<int:patient_id>/', doctor.chat_with, name='panel-doctor-chat-with'),
    path('doctor/chat/inbox/', doctor.chat_inbox, name='panel-doctor-chat-inbox'),
    path('doctor/send/message/to/<int:patient_id>/', doctor.send_message, name='panel-doctor-send-message'),
    path('doctor/delete/message/', doctor.delete_message, name='panel-doctor-delete-message'),
    path('doctor/edit/message/', doctor.edit_message, name='panel-doctor-edit-message'),
    # path('doctor/reply/message/', doctor.reply_message, name='panel-doctor-reply-message'),
    path('doctor/send/file/to/<int:patient_id>/', doctor.send_file, name='panel-doctor-send-file'),
    path('doctor/add/excel/diet/to/<int:patient_id>/', doctor.add_diet_with_excel,
         name='panel-doctor-add-diet-with-excel'),
    path('doctor/delete/diet/<int:diet_id>/', doctor.delete_diet, name='panel-doctor-delete-diet'),
    path('doctor/add/daily/note/to/<int:patient_id>/', doctor.add_daily_note, name='panel-doctor-add-daily-note'),
    path('doctor/check/new/message/from/<int:patient_id>/', doctor.check_new_message_from,
         name='panel-doctor-check-new-message-from'),
    path('doctor/send/message/to/all/', doctor.send_message_to_all_patients,
         name='panel-doctor-send-message-to-all-patients'),
    path('doctor/send/notification/to/all/', doctor.send_notification_to_all_patients,
         name='panel-doctor-send-notification-to-all-patients'),
    path('doctor/challenge/', doctor.challenge, name='panel-doctor-challenge'),
    path('doctor/add/challenge/', doctor.add_challenge, name='panel-doctor-add-challenge'),
    path('doctor/delete/challenge/<int:challenge_id>/', doctor.delete_challenge, name='panel-doctor-delete-challenge'),
    path('doctor/submit/free/time/', doctor.submit_free_time, name='panel-doctor-submit-free-time'),
    path('doctor/add/meeting/link/<int:session_id>/', doctor.add_meeting_link,
         name='panel-doctor-add-meeting-link'),
    path('doctor/delete/appointment/<int:appointment_id>/', doctor.delete_appointment,
         name='panel-doctor-delete-appointment'),
    path('doctor/get/assistant/activity/', doctor.get_assistant_activity, name='panel-doctor-assistant-activity'),
    path('doctor/get/assistant/weight/changes/', doctor.get_assistant_weight_changes, name='panel-doctor-get-assistant-weight-changes'),
    path('doctor/get/diet/activity/', doctor.get_diet_activity, name='panel-doctor-diet-activity'),
    path('doctor/get/assistant/points/data/', doctor.get_assistants_points_data, name='panel-doctor-assistant-points-data'),
    path('doctor/get/assistant/messages/', doctor.get_assistant_messages, name='panel-doctor-get-assistant-messages'),
    path('doctor/requested/foods/', doctor.requested_foods, name='panel-doctor-requested-foods'),
    path('doctor/recent/points/view/', doctor.recent_points_view, name='panel-doctor-recent-points-view'),
    path('doctor/upload/file/', doctor.file_upload_page, name='panel-doctor-file-upload'),
    
    # Doctor timeslot management
    path('doctor/timeslot/management/', doctor.timeslot_management, name='panel-doctor-timeslot-management'),
    path('doctor/timeslot/create/', doctor.create_timeslot_for_purchase, name='panel-doctor-create-timeslot'),
    path('doctor/timeslot/submit/', doctor.submit_timeslot_for_purchase, name='panel-doctor-submit-timeslot'),
    path('doctor/timeslot/assign/', doctor.assign_timeslot_to_therapist_panel, name='panel-doctor-assign-timeslot'),
    path('doctor/timeslot/change-assignment/', doctor.change_timeslot_assignment, name='panel-doctor-change-assignment'),

    path('assistant/', view.index, name='panel-assistant'),
    path('assistant/patients/', assistant.patients, name='panel-assistant-patients'),
    path('assistant/patients/archive', assistant.patients_archive, name='panel-assistant-patients-archive'),
    path('assistant/patients/favorites', assistant.patients_favorites, name='panel-assistant-patients-favorites'),
    path('assistant/toggle/favorite/<int:user_id>/', assistant.toggle_favorite_user, name='panel-assistant-toggle-favorite-user'),
    path('assistant/appointments/', assistant.appointments, name='panel-assistant-appointments'),
    path('assistant/diet/management/', assistant.diet_management, name='panel-assistant-diet-management'),
    path('assistant/diets/<int:patient_id>/', assistant.diets, name='panel-assistant-diets'),
    path('assistant/diets2/<int:patient_id>/', assistant.diets2, name='panel-assistant-diets2'),
    path('assistant/get/user/diet/tags/', assistant.get_user_diet_tags, name='panel-assistant-get-user-diet-tags'),
    path('assistant/column/refresh/', assistant.refresh_column_cards, name='panel-assistant-refresh-column-cards'),
    path('assistant/cells/card/', assistant.generate_cells_card, name='panel-assistant-generate-cells-card'),
    path('assistant/diet/cards/ajax/', assistant.diet_cards_ajax, name='panel-assistant-diet-cards-ajax'),
    path('assistant/diet/cards/<int:card_id>/nutrients/', assistant.get_card_nutrients, name='panel-assistant-card-nutrients'),
    path('assistant/diet/foods/ajax/', assistant.diet_foods_ajax, name='panel-assistant-diet-foods-ajax'),
    path('assistant/diet/templates/', assistant.diet_templates, name='panel-assistant-diet-templates'),
    path('assistant/show/patient/<int:patient_id>/', assistant.show_patient, name='panel-assistant-show-patient'),
    path('assistant/update/cr/coach/<int:patient_id>/', assistant.update_cr_coach, name='panel-assistant-update-cr-coach'),
    path('assistant/show/patient/additional/information/<int:patient_id>/', assistant.show_patient_additional_information, name='panel-assistant-show-patient-additional-information'),
    path('assistant/add/note/for/<int:patient_id>/', assistant.add_note, name='panel-assistant-add-note'),
    # Body Analysis Report URLs
    path('assistant/upload/body-analysis/<int:patient_id>/', assistant.upload_body_analysis, name='panel-assistant-upload-body-analysis'),
    path('assistant/share/body-analysis/<int:report_id>/', assistant.share_body_analysis_report, name='panel-assistant-share-body-analysis'),
    path('assistant/body-analysis-report/<int:report_id>/', assistant.view_body_analysis_report, name='panel-assistant-view-body-analysis-report'),
    path('assistant/edit/body-analysis/<int:report_id>/', assistant.edit_body_analysis_report, name='panel-assistant-edit-body-analysis'),
    # Public BIA Report URL (no authentication required)
    path('bia-report/<str:share_token>/', assistant.public_bia_report, name='panel-public-bia-report'),
    path('assistant/edit/note/<int:note_id>/', assistant.edit_note, name='panel-assistant-edit_note'),
    path('assistant/delete/note/<int:note_id>/', assistant.delete_note, name='panel-assistant-delete_note'),
    path('assistant/chat/with/<int:patient_id>/', assistant.chat_with, name='panel-assistant-chat-with'),
    path('assistant/chat/inbox/', assistant.chat_inbox, name='panel-assistant-chat-inbox'),
    path('assistant/send/message/to/<int:patient_id>/', assistant.send_message, name='panel-assistant-send-message'),
    path('assistant/delete/message/', assistant.delete_message, name='panel-assistant-delete-message'),
    path('assistant/edit/message/', assistant.edit_message, name='panel-assistant-edit-message'),
    path('assistant/send/file/to/<int:patient_id>/', assistant.send_file, name='panel-assistant-send-file'),
    path('assistant/add/excel/diet/to/<int:patient_id>/', assistant.add_diet_with_excel,
         name='panel-assistant-add-diet-with-excel'),
    path('assistant/upload/last/diet/<int:patient_id>/', assistant.upload_last_diet, name='upload_last_diet'),
    path('assistant/add/table/diet/to/<int:patient_id>/', assistant.add_diet_from_table,
         name='panel-assistant-add-diet-from-table'),
    path('assistant/save/diet/template/', assistant.save_diet_template, name='panel-assistant-save-diet-template'),
    # path('assistant/get/diet/templates/', assistant.get_diet_templates, name='panel-assistant-get-diet-template'),
    path('assistant/edit/diet/template/<int:template_id>/', assistant.edit_diet_template, name='panel-assistant-edit_diet_template'),
    path('assistant/delete/diet/template/<int:template_id>/', assistant.delete_diet_template, name='panel-assistant-delete_diet_template'),
    path('assistant/get/diet/template/<int:template_id>/', assistant.get_diet_template,
         name='panel-assistant-get-diet-template-detail'),
    path('assistant/delete/diet/<int:diet_id>/', assistant.delete_diet, name='panel-assistant-delete-diet'),
    path('assistant/diets/<int:patient_id>/<int:diet_id>/', assistant.edit_diet, name='panel-assistant-diets-edit'),
    path('assistant/add/daily/note/to/<int:patient_id>/', assistant.add_daily_note,
         name='panel-assistant-add-daily-note'),
    path('assistant/check/new/message/from/<int:patient_id>/', assistant.check_new_message_from,
         name='panel-assistant-check-new-message-from'),
    path('assistant/send/message/to/my/', assistant.send_message_to_my_patients,
         name='panel-assistant-send-message-to-my-patients'),
    path('assistant/send/notification/to/my/', assistant.send_notification_to_my_patients,
         name='panel-assistant-send-notification-to-my-patients'),
    path('assistant/submit/free/time/', assistant.submit_free_time, name='panel-assistant-submit-free-time'),
    path('assistant/add/meeting/link/<int:session_id>/', assistant.add_meeting_link,
         name='panel-assistant-add-meeting-link'),
    path('assistant/delete/appointment/<int:appointment_id>/', assistant.delete_appointment,
         name='panel-assistant-delete-appointment'),
    path('assistant/requested/foods/', assistant.requested_foods, name='panel-assistant-requested-foods'),
    path('assistant/check/food/<int:food_id>/', assistant.check_food, name='panel-assistant-check-food'),
    path('assistant/delete/food/<int:food_id>/', assistant.delete_food, name='panel-assistant-delete-food'),
    path('assistant/challenge/', assistant.challenge, name='panel-assistant-challenge'),
    path('assistant/cards/', assistant.cards, name='panel-assistant-cards'),
    path('assistant/cards/ajax/', assistant.cards_ajax, name='panel-assistant-cards-ajax'),
    path('assistant/foods/ajax/', assistant.foods_ajax, name='panel-assistant-foods-ajax'),
    path('assistant/get/card/<int:card_id>/', assistant.get_card_data, name='panel-assistant-get-card-data'),
    path('assistant/get/food/allergies/<str:food_code>/', assistant.get_food_allergies, name='panel-assistant-get-food-allergies'),
    path('assistant/save/cards/', assistant.save_card, name='panel-assistant-save-cards'),
    path('assistant/delete/card/', assistant.delete_card, name='panel-assistant-delete-card'),
    path('assistant/delete/multiple/cards/', assistant.delete_multiple_cards, name='panel-assistant-delete-multiple-cards'),
    path('assistant/manage/card/tags/', assistant.manage_card_tags, name='panel-assistant-manage-card-tags'),
    path('assistant/manage/card/tags/data/', assistant.manage_card_tags_data, name='panel-assistant-manage-card-tags-data'),
    path('assistant/update/card/<int:card_id>/', assistant.update_card, name='panel-assistant-update-card'),
    path('assistant/add/challenge/', assistant.add_challenge, name='panel-assistant-add-challenge'),
    path('assistant/delete/challenge/<int:challenge_id>/', assistant.delete_challenge, name='panel-assistant-delete-challenge'),
    path('assistant/food/auto/complete/', assistant.food_autocomplete, name='panel-assistant-food-auto-complete'),
    path('assistant/foods/', assistant.food_list, name='panel-assistant-food-list'),
    path('assistant/foods/new/', assistant.food_create, name='panel-assistant-food-create'),
    path('assistant/foods/<int:pk>/edit/', assistant.food_edit, name='panel-assistant-food-edit'),
    path('assistant/foods/<int:pk>/duplicate/', assistant.food_duplicate, name='panel-assistant-food-duplicate'),
    path('assistant/foods/delete/<int:pk>/', assistant.food_delete, name='panel-assistant-food-delete'),
    path('assistant/activities/', assistant.activity_list, name='panel-assistant-activity-list'),
    path('assistant/activities/create/', assistant.activity_create, name='panel-assistant-activity-create'),
    path('assistant/activities/<int:pk>/edit/', assistant.activity_edit, name='panel-assistant-activity-edit'),
    path('assistant/activities/<int:pk>/delete/', assistant.activity_delete, name='panel-assistant-activity-delete'),
    path('assistant/recent/points/view/', assistant.recent_points_view, name='panel-assistant-recent-points-view'),
    
    # Assistant purchased sessions
    path('assistant/purchased/sessions/', assistant.purchased_sessions, name='panel-assistant-purchased-sessions'),
    path('assistant/complete/session/<int:session_id>/', assistant.complete_session, name='panel-assistant-complete-session'),
    path('assistant/set/call/link/', assistant.set_call_link, name='panel-assistant-set-call-link'),

    path('api/v1/check/account/', api.check_account, name='check-account'),
    path('api/v1/get/chats/', api.get_chats, name='panel-api-get-chats'),
    path('api/v1/get/media/', api.get_media, name='panel-api-get-media'),
    path('api/v1/post/chat/', api.post_chat, name='panel-api-post-chat'),
    path('api/v1/edit/chat/', api.edit_chat, name='panel-api-edit_chat'),
    path('api/v1/delete/chat/', api.delete_chat, name='panel-api-delete_chat'),
    path('api/v1/star/message/', api.star_message, name='panel-api-star-message'),
    path('api/v1/un/star/message/', api.un_star_message, name='panel-api-un-star-message'),
    path('api/v1/get/starred/messages/', api.get_starred_messages, name='panel-api-get-starred-messages'),
    path('api/v1/get/diets/', api.get_diets, name='panel-api-get-diets'),
    path('api/v1/get/daily/notes/', api.get_daily_notes, name='panel-api-get-daily-notes'),
    path('api/v1/post/attachment/', api.post_attachment, name='panel-api-post-attachment'),
    path('api/v1/get/challenges/', api.get_challenges, name='panel-api-get-challenges'),
    path('api/v1/assign/user/to/challenge/', api.assign_user_to_challenge,
         name='assign-user-to-challenge'),
    path('api/v1/get/items/', api.get_items, name='panel-api-get-items'),
    path('api/v1/buy/item/', api.buy_item, name='panel-api-buy-item'),
    path('api/v1/get/user/items/', api.get_user_items, name='panel-api-get-user-items'),
    path('api/v1/get/user/challenges/', api.get_user_challenges, name='get-user-challenges'),
    path('api/v1/get/assistant/free/times/', api.get_assistant_free_times, name='get-assistant-free-times'),
    path('api/v1/get/user/appointment/', api.get_user_appointment, name='get-user-appointment'),
    path('api/v1/book/appointment/', api.book_appointment, name='book-appointment'),
    path('api/v1/cancel/appointment/', api.cancel_appointment, name='cancel-appointment'),
    path('api/v1/add/new/food/', api.add_new_food, name='add-new-food'),
    path('api/v1/add/microbiome/analysis/', api.add_microbiome_analysis, name='add-microbiome-analysis'),
    path('api/v1/get/microbiome/analysis/', api.get_microbiome_analysis, name='get-microbiome-analysis'),
    path('api/v1/add/coin/price/', api.add_coin_price, name='add-coin-price'),
    path('api/v1/get/coin/price/', api.get_coin_price, name='get-coin-price'),
    path('api/v1/show/user/daily/points/', api.show_user_daily_points, name='show-user-daily-points'),
    path('api/v1/post/ai/chat/', api.ai_chat, name='panel-api-post-ai-chat'),
    path('api/v1/get/ai/chats/', api.get_ai_chats, name='panel-api-get-ai-chats'),

    path('api/v1/doctors/list/', api.get_list_of_doctors, name='panel-api-get-list-of-doctors'),

    path('api/v1/diet/eating/', api.eating, name='panel-api-eating'),
    path('api/v1/get/firebase/notifications/', api.firebase_notifications),

    # path('api/v1/get/payment/link/', api.get_payment_link, name='panel-api-get-payment-link'),
    # path('api/v1/payment/<int:id>/', api.payment, name='panel-api-payment'),

]
