from django import template
from datetime import timedelta

register = template.Library()

@register.filter
def add_minutes(value, minutes):
    """Add minutes to a datetime object"""
    if value:
        return value + timedelta(minutes=int(minutes))
    return value 