import requests
from panel.models import *

class TelegramNotification:

    def __init__(self):
        print("Initializing TelegramNotification")
        self.admin_chat_id = "93465629"
        self.mohammad_chat_id = "76335794"
        self.nadia_chat_id = "93465629"  # Add Nadia's chat ID
        self.bot_token = "bot7165401474:AAFXLMG5e5DJX-d7mv9BnfC-2ZQLKEeKS9M"
        self.send_message_url = "https://api.telegram.org/" + self.bot_token + "/sendMessage?text={text}&chat_id={chat_id}"
        
    def send_message(self, temp, text: str):
        try: 
            user = temp[0].profile.therapist

            telegram_id = "00000"

            if user.groups.filter(name='Manager').exists():
                role = 'manager'
                manager = Manager.objects.get(django_user=user)
                telegram_id = manager.telegram_chat_id
                print("This users therapist is manager")
            elif user.groups.filter(name='Doctor').exists():
                role = 'doctor'
                print("This users therapist is doctor")
                doctor = Doctor.objects.get(django_user=user)
                telegram_id = doctor.telegram_chat_id
                # return redirect('panel-doctor-patients')
            elif user.groups.filter(name='Assistant').exists():
                role = 'assistant'
                print("This users therapist is assistant")
                assistant = Assistant.objects.get(django_user=user)
                telegram_id = assistant.telegram_chat_id
                
            print(f"This the telegram post api: {self.send_message_url.format(text=text, chat_id=telegram_id)}")

            requests.get(self.send_message_url.format(text=text, chat_id=telegram_id))

            print("This is assistant: ", assistant)
        except Exception as e:
            print("This is the exception: ", e)


    def send_purchase_notif(self, user, plan=None, discount_code=None):
        """
        Send purchase notification with plan and discount information
        
        Args:
            user: User object or username string
            plan: Plan number (1-8)
            discount_code: Discount code object or string if applicable
        """
        try:
            # Get username from user object or string
            if hasattr(user, 'profile'):
                username = f"{user.profile.first_name} {user.profile.last_name}".strip()
                if not username:
                    username = "کاربر"
            else:
                username = str(user)
            
            # Map plan numbers to Persian names
            plan_names = {
                1: "نقره‌ای سه ماهه",
                2: "ظلایی سه ماهه", 
                3: "---------------",
                4: "نقره‌ای  یک ماهه",
                5: "طلایی یک ماهه",
                6: "برنزی یک ماهه",
                7: "برنزی سه ماهه",
                8: "پلن آیدی ۸"
            }
            
            # Build the message
            text = f"🎉 خرید جدید!\n\n👤 کاربر: {username}\n"
            
            if plan:
                plan_name = plan_names.get(plan, f"پلن {plan}")
                text += f"📦 پلن: {plan_name}\n"
            else:
                text += "📦 پلن: نامشخص\n"
            
            # Add discount info if available
            if discount_code:
                # Check if it's a Discount object or string
                if hasattr(discount_code, 'code'):
                    text += f"🎁 کد تخفیف: {discount_code.code} ({discount_code.percentage}%)\n"
                else:
                    text += f"🎁 کد تخفیف: {discount_code}\n"
            
            text += "\nلطفا نسبت به اقدامات بعدی اقدام کنید."

            requests.get(self.send_message_url.format(text=text, chat_id=self.mohammad_chat_id))
            requests.get(self.send_message_url.format(text=text, chat_id=self.nadia_chat_id))
            self.send_notif_to_admin(text)

        except Exception as e:
            print("This is the exception: ", e)

    def send_timeslot_purchase_notif(self, text: str):
        try:
            requests.get(self.send_message_url.format(text=text, chat_id=self.mohammad_chat_id))
            requests.get(self.send_message_url.format(text=text, chat_id=self.nadia_chat_id))
            self.send_notif_to_admin(text)

            # print("This is assistant: ", assistant)
        except Exception as e:
            print("This is the exception: ", e)

    def send_assign_patient_notif(self, username: str, chat_id: str):
        try:
            text = f"کاربر جدید به نام {username} به شما assign شد"

            requests.get(self.send_message_url.format(text=text, chat_id=chat_id))
            self.send_notif_to_admin(text)

            # print("This is assistant: ", assistant)
        except Exception as e:
            print("This is the exception: ", e)

    def send_timeslot_assignment_notif(self, therapist_name: str, patient_name: str, session_time: str, chat_id: str):
        try:
            text = f"🔔 جلسه جدید به شما تخصیص داده شد\n\n👤 بیمار: {patient_name}\n⏰ زمان: {session_time}\n\nلطفا برای آماده‌سازی جلسه اقدام کنید."

            requests.get(self.send_message_url.format(text=text, chat_id=chat_id))
            self.send_notif_to_admin(f"جلسه جدید به {therapist_name} تخصیص داده شد - بیمار: {patient_name}")

        except Exception as e:
            print("This is the timeslot assignment telegram exception: ", e)

    def send_notif_to_admin(self, message: str):
        try:
            requests.get(self.send_message_url.format(text=message, chat_id=self.admin_chat_id))
        except Exception as e:
            print("sent notification to admin exception:", e)
    
    def send_debug_log(self, message: str):
        """
        Send debug log message to Mohammad's Telegram for monitoring diet generation
        """
        try:
            # Truncate message if too long (Telegram has 4096 char limit)
            if len(message) > 4000:
                message = message[:4000] + "... (truncated)"
            
            requests.get(
                self.send_message_url.format(text=message, chat_id=self.mohammad_chat_id),
                timeout=5
            )
        except Exception as e:
            # Silently fail - don't break the main flow
            print(f"Failed to send debug log to Telegram: {e}")