$(document).ready(function() {
    function standard_deviation(arr)
    {
        var len = 0;
        var sum=0;
        for(var i=0;i<arr.length;i++)
        {
            if (arr[i] == null){}
            else
            {
                len = len + 1;
                sum = sum + parseFloat(arr[i]);
            }
        }
        var v = 0;
        if (len > 1)
        {
            var mean = sum / len;
            for(var i=0;i<arr.length;i++)
            {
                if (arr[i] == null){}
                else { v = v + (arr[i] - mean) * (arr[i] - mean); }
            }
            return Math.sqrt(v / len);
        }
        else { return 0; }
    }

    function calculation(arr){
        var summation = 0;
        var number_of_tests = 0;
        var min = 1000;
        var max = -1000;

        for (var i = 0; i < arr.length; i++){
            if(arr[i] != null){
                summation += arr[i];
                number_of_tests++;
                if (arr[i] > max){
                    max = arr[i];
                }
                if (arr[i] < min){
                    min = arr[i];
                }
            }
        }
        var average = "null";
        if (number_of_tests > 0){
            average = Math.round(summation / number_of_tests);
        }
        var data = {
            'average':average,
            'number_of_tests':number_of_tests,
            'min':min,
            'max':max,
            'standard_deviation': standard_deviation(arr)
        };
        return data;

    }

    // fasting
    var summation = 0;
    var number_of_fasting_tests = 0;
    var min = 1000;
    var max = -1000;
    for (var i = 0; i < fasting_sugar_list.length; i++){
        if(fasting_sugar_list[i] != null){
            summation += fasting_sugar_list[i];
            number_of_fasting_tests++;
            if (fasting_sugar_list[i] > max){
                max = fasting_sugar_list[i];
            }
            if (fasting_sugar_list[i] < min){
                min = fasting_sugar_list[i];
            }
        }
    }
    var fasting_average = "null";
    if (number_of_fasting_tests > 0){
        fasting_average = Math.round(summation / number_of_fasting_tests);
    }

    var meals = ['fasting', 'after_breakfast', 'after_lunch', 'after_dinner'];
    var durations = [100, 30, 14];
    var duration_names = ['100day', '1month', '2week'];
    meals.forEach(function (meal, index) {
        var id = null;
        switch (meal){
            case 'fasting':
            {
                durations.forEach(function (du, i) {
                    var arr = fasting_sugar_list.slice(-du, fasting_sugar_list.length);
                    var temp = calculation(arr);
                    id = '#' + meal + '_' + duration_names[i] + '_' + 'blood_sugar_';
                    console.log(id);
                    $(id + "average").text(temp['average'] + " از میان " + temp['number_of_tests'] + " تست");
                    $(id + "variant").text(Math.round(temp['standard_deviation']) + " از میان " + temp['number_of_tests'] + " تست");
                    $(id + "max").text(temp['max']);
                    $(id + "min").text(temp['min']);
                });
                break;
            }
            case 'after_breakfast':
            {
                durations.forEach(function (du, i) {
                    var arr = after_breakfast_sugar_list.slice(-du, after_breakfast_sugar_list.length);
                    var temp = calculation(arr);
                    id = '#' + meal + '_' + duration_names[i] + '_' + 'blood_sugar_';
                    console.log(id);
                    $(id + "average").text(temp['average'] + " از میان " + temp['number_of_tests'] + " تست");
                    $(id + "variant").text(Math.round(temp['standard_deviation']) + " از میان " + temp['number_of_tests'] + " تست");
                    $(id + "max").text(temp['max']);
                    $(id + "min").text(temp['min']);
                });
                break;
            }
            case 'after_lunch':
            {
                durations.forEach(function (du, i) {
                    var arr = after_lunch_sugar_list.slice(-du, after_lunch_sugar_list.length);
                    var temp = calculation(arr);
                    id = '#' + meal + '_' + duration_names[i] + '_' + 'blood_sugar_';
                    console.log(id);
                    $(id + "average").text(temp['average'] + " از میان " + temp['number_of_tests'] + " تست");
                    $(id + "variant").text(Math.round(temp['standard_deviation']) + " از میان " + temp['number_of_tests'] + " تست");
                    $(id + "max").text(temp['max']);
                    $(id + "min").text(temp['min']);
                });
                break;
            }
            case 'after_dinner':
            {
                durations.forEach(function (du, i) {
                    var arr = after_dinner_sugar_list.slice(-du, after_dinner_sugar_list.length);
                    var temp = calculation(arr);
                    id = '#' + meal + '_' + duration_names[i] + '_' + 'blood_sugar_';
                    console.log(id);
                    $(id + "average").text(temp['average'] + " از میان " + temp['number_of_tests'] + " تست");
                    $(id + "variant").text(Math.round(temp['standard_deviation']) + " از میان " + temp['number_of_tests'] + " تست");
                    $(id + "max").text(temp['max']);
                    $(id + "min").text(temp['min']);
                });
                break;
            }
        }

    });


    google.charts.load('current', {'packages':['corechart']});
    google.charts.setOnLoadCallback(drawThreeMonthChart);
    google.charts.setOnLoadCallback(drawTwoWeeksChart);
    google.charts.setOnLoadCallback(drawTwoWeeksChart);

    var all_data = [];
    var one_month_data = [];
    var two_weeks_data = [];
    var duration = fasting_sugar_list.length;


    for(var j=0; j < fasting_sugar_list.length; j++){
      if(fasting_sugar_list[j] != null){
          var item = [j+1, fasting_sugar_list[j], null, null, null, null, null, null];
          all_data.push(item);
          if (j >= (duration - 30)){
              var x = item.slice();
              x[0] = j - (duration - 30) + 1;
              one_month_data.push(x);
          }
          if (j >= (duration - 14)){
              var x = item.slice();
              x[0] = j - (duration - 14) + 1;
              two_weeks_data.push(x);
          }
      }

    }
    for(var j=0; j < after_breakfast_sugar_list.length; j++){
      if(after_breakfast_sugar_list[j] != null){
          var item = [j+1, null, after_breakfast_sugar_list[j], null, null, null, null, null];
          all_data.push(item);
          if (j >= (duration - 30)){
              var x = item.slice();
              x[0] = j - (duration - 30) + 1;
              one_month_data.push(x);
          }
          if (j >= (duration - 14)){
              var x = item.slice();
              x[0] = j - (duration - 14) + 1;
              two_weeks_data.push(x);
          }
      }
    }
    for(var j=0; j < after_lunch_sugar_list.length; j++){
      if(after_lunch_sugar_list[j] != null){
          var item = [j+1, null, null, after_lunch_sugar_list[j], null, null, null, null];
          all_data.push(item);
          if (j >= (duration - 30)){
              var x = item.slice();
              x[0] = j - (duration - 30) + 1;
              one_month_data.push(x);
          }
          if (j >= (duration - 14)){
              var x = item.slice();
              x[0] = j - (duration - 14) + 1;
              two_weeks_data.push(x);
          }
      }
    }
    for(var j=0; j < after_dinner_sugar_list.length; j++){
      if(after_dinner_sugar_list[j] != null){
          var item = [j+1, null, null, null, after_dinner_sugar_list[j], null, null, null];
          all_data.push(item);
          if (j >= (duration - 30)){
              var x = item.slice();
              x[0] = j - (duration - 30) + 1;
              one_month_data.push(x);
          }
          if (j >= (duration - 14)){
              var x = item.slice();
              x[0] = j - (duration - 14) + 1;
              two_weeks_data.push(x);
          }
      }
    }

    function drawThreeMonthChart() {

        var data = new google.visualization.DataTable();
        data.addColumn('number', 'روز');
        data.addColumn('number', 'ناشتا');
        data.addColumn('number', 'بعد صبحانه');
        data.addColumn('number', 'بعد ناهار');
        data.addColumn('number', 'بعد شام');
        data.addColumn('number', 'هایپو');
        data.addColumn('number', 'بازه نرمال');
        data.addColumn('number', 'هایپر');
        //data.addColumn({type: 'string', role: 'tooltip'}); // certainty col.

        data.addRows(all_data);
        data.addRows([
            // [1,10,  null,null,null,null,null,null],
            // [2,null,10,  null,null,null,null,null],
            // [2,null,null,30,  null,null,null,null],
            // [2,null,20,  null,null,null,null,null],
            // [3,null,null,10,  null,null,null,null],
            // [4,null,null,null,10,  null,null,null],
            [0,null,null,null,null,0   ,null,null],
            [0,null,null,null,null,hypo ,null,null],
            [100,null,null,null,null,hypo ,null,null],
            [100,null,null,null,null,0   ,null,null],
            [0,null,null,null,null,null,hypo ,null],
            [0,null,null,null,null,null,hyper ,null],
            [100,null,null,null,null,null,hyper ,null],
            [100,null,null,null,null,null,hypo ,null],
            [0,null,null,null,null,null,null,hyper ],
            [0,null,null,null,null,null,null,400 ],
            [100,null,null,null,null,null,null,400 ],
            [100,null,null,null,null,null,null,hyper ],
        ]);

        var options = {
          title: '',
          chartArea: {
              width: '90%',
              height: '75%',
              right:0,
              top:10
          },
          series: {
            0: {
                type: 'line'
            },
            2: {
                type: 'line'
            },
            3: {
                type: 'line'
            },
            4: {
                // area series
                type: 'area',
                enableInteractivity: false,
                lineWidth: 0,
                isStacked: true,
                pointSize: 0,
            },
            5: {
                // area series
                type: 'area',
                enableInteractivity: false,
                lineWidth: 0,
                isStacked: true,
                pointSize: 0,
            },
            6: {
                // area series
                type: 'area',
                enableInteractivity: false,
                lineWidth: 0,
                isStacked: true,
                pointSize: 0,
            },
          },
          hAxis: {
                title: 'روز از صد روز اخیر',
                titleFontSize:20,
                minValue: 1,
                maxValue: 7,
                textStyle : {
                    fontSize: 14 // or the number you want
                }
          },
          vAxis: {
              title: 'میزان قند خون',
              titleFontSize:20,
              minValue: 30,
              maxValue: 400,
              textStyle : {
                    fontSize: 14 // or the number you want
                }
          },
          legend: {position: 'bottom', textStyle: {fontSize: 20}},
          fontName: 'Nazanin',
          height:470,
          isStacked: true,
        };

        var chart = new google.visualization.ScatterChart(document.getElementById('three_month_sugar_chart_div'));
        chart.draw(data, options);
    };

    function drawOneMonthChart() {
        var data = new google.visualization.DataTable();
        data.addColumn('number', 'روز');
        data.addColumn('number', 'ناشتا');
        data.addColumn('number', 'بعد صبحانه');
        data.addColumn('number', 'بعد ناهار');
        data.addColumn('number', 'بعد شام');
        data.addColumn('number', 'هایپو');
        data.addColumn('number', 'بازه نرمال');
        data.addColumn('number', 'هایپر');
        //data.addColumn({type: 'string', role: 'tooltip'}); // certainty col.

        data.addRows(one_month_data);
        data.addRows([
            [0,null,null,null,null,0   ,null,null],
            [0,null,null,null,null,hypo ,null,null],
            [30,null,null,null,null,hypo ,null,null],
            [30,null,null,null,null,0   ,null,null],
            [0,null,null,null,null,null,hypo ,null],
            [0,null,null,null,null,null,hyper ,null],
            [30,null,null,null,null,null,hyper ,null],
            [30,null,null,null,null,null,hypo ,null],
            [0,null,null,null,null,null,null,hyper ],
            [0,null,null,null,null,null,null,400 ],
            [30,null,null,null,null,null,null,400 ],
            [30,null,null,null,null,null,null,hyper ],
        ]);

        var options = {
          title: '',
          chartArea: {width: '90%', height: '75%', right:0, top:10},
            series: {
            0: {
                type: 'line'
            },
            2: {
                type: 'line'
            },
            3: {
                type: 'line'
            },
            4: {
                // area series
                type: 'area',
                enableInteractivity: false,
                lineWidth: 0,
                isStacked: true,
                pointSize: 0,
            },
            5: {
                // area series
                type: 'area',
                enableInteractivity: false,
                lineWidth: 0,
                isStacked: true,
                pointSize: 0,
            },
            6: {
                // area series
                type: 'area',
                enableInteractivity: false,
                lineWidth: 0,
                isStacked: true,
                pointSize: 0,
            },
          },
          hAxis: {
                title: 'روز از ماه اخیر',
                titleFontSize:20,
                minValue: 1,
                maxValue: 7,
                textStyle : {
                    fontSize: 14 // or the number you want
                }
          },
          vAxis: {
              title: 'میزان قند خون',
              titleFontSize:20,
              minValue: 30,
              maxValue: 400,
              textStyle : {
                    fontSize: 14 // or the number you want
                }
          },
          legend: {position: 'bottom', textStyle: {fontSize: 20}},
          fontName: 'Nazanin',
          height:470,
        };

        var chart = new google.visualization.ScatterChart(document.getElementById('one_month_sugar_chart_div'));

        chart.draw(data, options);
    };

    function drawTwoWeeksChart() {
        var data = new google.visualization.DataTable();
        data.addColumn('number', 'روز');
        data.addColumn('number', 'ناشتا');
        data.addColumn('number', 'بعد صبحانه');
        data.addColumn('number', 'بعد ناهار');
        data.addColumn('number', 'بعد شام');
        data.addColumn('number', 'هایپو');
        data.addColumn('number', 'بازه نرمال');
        data.addColumn('number', 'هایپر');
        // data.addColumn({type: 'string', role: 'tooltip'}); // certainty col.

        data.addRows(two_weeks_data);
        data.addRows([
            [0,null,null,null,null,0   ,null,null],
            [0,null,null,null,null,hypo ,null,null],
            [14,null,null,null,null,hypo ,null,null],
            [14,null,null,null,null,0   ,null,null],
            [0,null,null,null,null,null,hypo ,null],
            [0,null,null,null,null,null,hyper ,null],
            [14,null,null,null,null,null,hyper ,null],
            [14,null,null,null,null,null,hypo ,null],
            [0,null,null,null,null,null,null,hyper ],
            [0,null,null,null,null,null,null,400 ],
            [14,null,null,null,null,null,null,400 ],
            [14,null,null,null,null,null,null,hyper ],
        ]);

        var options = {
          title: '',
          chartArea: {width: '90%', height: '75%', right: 0, top: 10},
            series: {
            0: {
                type: 'line'
            },
            2: {
                type: 'line'
            },
            3: {
                type: 'line'
            },
            4: {
                // area series
                type: 'area',
                enableInteractivity: false,
                lineWidth: 0,
                isStacked: true,
                pointSize: 0,
            },
            5: {
                // area series
                type: 'area',
                enableInteractivity: false,
                lineWidth: 0,
                isStacked: true,
                pointSize: 0,
            },
            6: {
                // area series
                type: 'area',
                enableInteractivity: false,
                lineWidth: 0,
                isStacked: true,
                pointSize: 0,
            },
          },
          hAxis: {
                title: 'روز از دو هفته اخیر',
                titleFontSize: 20,
                minValue: 1,
                maxValue: 7,
                textStyle : {
                    fontSize: 14 // or the number you want
                }
          },
          vAxis: {
              title: 'میزان قند خون',
              titleFontSize: 20,
              minValue: 30,
              maxValue: 400,
              textStyle : {
                fontSize: 14 // or the number you want
              }
          },
          legend: {
              position: 'bottom',
              textStyle: {
                      fontSize: 20
                  }
              },
          fontName: 'Nazanin',
          height:470,
        };

        var chart = new google.visualization.ScatterChart(document.getElementById('two_weeks_sugar_chart_div'));

        chart.draw(data, options);
    };

    $(window).resize(function(){
        setTimeout(drawThreeMonthChart, 100);
        setTimeout(drawOneMonthChart, 200);
        setTimeout(drawTwoWeeksChart, 300);
    });

    $("#sugar_chart_three_month_button").click(function(){
        setTimeout(drawThreeMonthChart, 50);
    });

    $("#sugar_chart_one_month_button").click(function(){
        setTimeout(drawOneMonthChart, 50);
    });

    $("#sugar_chart_two_weeks_button").click(function(){
        setTimeout(drawTwoWeeksChart, 50);
    });

});
