// Global arrays to store selected items for each section
let selectedMessageItems = [];
let selectedNotificationItems = [];

/* --------------------------------------------------
   Event Listeners for Checkbox Changes
----------------------------------------------------- */
// For Message Table Checkboxes
$(document).on('change', '.select-item', function() {
    let value = $(this).val(); // e.g. "123" (group or user ID)
    if ($(this).prop('checked')) {
        if (!selectedMessageItems.includes(value)) {
            selectedMessageItems.push(value);
            console.log("Message item added:", value);
        }
    } else {
        selectedMessageItems = selectedMessageItems.filter(v => v !== value);
        console.log("Message item removed:", value);
    }
    console.log("Current Message Items:", selectedMessageItems);
});

// For Notification Table Checkboxes
$(document).on('change', '.select-item-notif', function() {
    let value = $(this).val(); // e.g. "123" (group or user ID)
    if ($(this).prop('checked')) {
        if (!selectedNotificationItems.includes(value)) {
            selectedNotificationItems.push(value);
            console.log("Notification item added:", value);
        }
    } else {
        selectedNotificationItems = selectedNotificationItems.filter(v => v !== value);
        console.log("Notification item removed:", value);
    }
    console.log("Current Notification Items:", selectedNotificationItems);
});

/* --------------------------------------------------
   Class for Sending Messages
----------------------------------------------------- */
class SendToAll {
    constructor(div_id, btn_id, text_id, table_id) {
        this.div_id = div_id;
        this.btn_id = btn_id;
        this.text_id = text_id;
        this.table_id = table_id;
        this.div = $('#' + div_id);
        this.text = $('#' + text_id);
        this.table = $('#' + table_id);
        let self = this;
        this.send = true;
        $('#' + this.btn_id).click(function () {
            self.notify();
        });
    }

    notify() {
        console.log("Sending message...");
        if (this.text.val().length === 0) {
            alert('Write a message!');
            return;
        }
        this.send = false;  // Prevent multiple clicks
        $('#send_loader').show();  // Show spinner
        $('#send_to_all_text').hide(); // Hide button text

        let self = this;
        if (selectedMessageItems.length === 0) {
            console.log("No message items selected!");
            alert("No users or groups selected for messages!");
            this.send = true;
            $('#send_loader').hide();
            $('#send_to_all_text').show();
            return;
        }
        console.log("Selected Message Items:", selectedMessageItems);

        $.post("/panel/assistant/send/message/to/my/", {
            message: JSON.stringify(this.text.val()),
            checked_items: JSON.stringify(selectedMessageItems),
            csrfmiddlewaretoken: window.CSRF_TOKEN,
        },
        function (data, status) {
            console.log("Response Data:", data);
            console.log("Request Status:", status);
            if (status === 'success') {
                if (data.status === 'login') {
                    window.location.replace("/panel/login/");
                    return;
                } else if (data.status === 'ok') {
                    alert('Message sent successfully');
                } else if (data.status === 'no') {
                    alert('Error sending message');
                    console.error("Server returned no. Response:", data);
                } else if (data.status === 'error') {
                    console.error("Server error:", data.error);
                    alert('Error sending message: ' + data.error);
                } else {
                    console.warn("Unexpected response:", data);
                }
            } else {
                console.error("Error occurred, status=", status, "data=", data);
            }
            self.send = true;
            $('#send_loader').hide();
            $('#send_to_all_text').show();
        })
        .fail(function (jqXHR, x, error) {
            console.error("AJAX request failed:", error, jqXHR.responseText);
            if (jqXHR.status === 429) {
                alert("You are out of service. You can use this service again from tomorrow!");
            }
            self.send = true;
            $('#send_loader').hide();
            $('#send_to_all_text').show();
        });
    }
}

let send_to_all = new SendToAll("send_to_all_div", "send_to_all_btn", "send_to_all_text", "message_table");

/* --------------------------------------------------
   Class for Sending Notifications
----------------------------------------------------- */
class SendToAllNotif {
    constructor(div_id, btn_id, text_id, table_id) {
        this.div_id = div_id;
        this.btn_id = btn_id;
        this.text_id = text_id;
        this.table_id = table_id;
        this.div = $('#' + div_id);
        this.text = $('#' + text_id);
        this.table = $('#' + table_id);
        let self = this;
        this.send = true;
        $('#' + this.btn_id).click(function () {
            self.notify();
        });
    }

    notify() {
        console.log("Sending notification...");
        if (this.text.val().length === 0) {
            alert('Write a notification!');
            return;
        }
        this.send = false;
        $('#send_loader_notif').show();
        $('#send_to_all_text_notif').hide();

        let self = this;
        if (selectedNotificationItems.length === 0) {
            console.log("No notification items selected!");
            alert("No users or groups selected for notifications!");
            this.send = true;
            $('#send_loader_notif').hide();
            $('#send_to_all_text_notif').show();
            return;
        }
        console.log("Selected Notification Items:", selectedNotificationItems);

        $.post("/panel/assistant/send/notification/to/my/", {
            message: JSON.stringify(this.text.val()),
            checked_items_notif: JSON.stringify(selectedNotificationItems),
            csrfmiddlewaretoken: window.CSRF_TOKEN,
        },
        function (data, status) {
            console.log("Response Data:", data);
            console.log("Request Status:", status);
            if (status === 'success') {
                if (data.status === 'login') {
                    window.location.replace("/panel/login/");
                    return;
                } else if (data.status === 'ok') {
                    alert('Notification sent successfully');
                } else if (data.status === 'no') {
                    alert('Error sending notification');
                    console.error("Server returned no. Response:", data);
                } else if (data.status === 'error') {
                    console.error("Server error:", data.error);
                    alert('Error sending notification: ' + data.error);
                } else {
                    console.warn("Unexpected response:", data);
                }
            } else {
                console.error("Error occurred, status=", status, "data=", data);
            }
            self.send = true;
            $('#send_loader_notif').hide();
            $('#send_to_all_text_notif').show();
        })
        .fail(function (jqXHR, x, error) {
            console.error("AJAX request failed:", error, jqXHR.responseText);
            if (jqXHR.status === 429) {
                alert("You are out of service. You can use this service again from tomorrow!");
            }
            self.send = true;
            $('#send_loader_notif').hide();
            $('#send_to_all_text_notif').show();
        });
    }
}

let send_to_all_notif = new SendToAllNotif("send_to_all_div_notif", "send_to_all_btn_notif", "send_to_all_text_notif", "notif_table");

$(document).ready(function() {
    console.log("Document loaded. Ready!");
});
