from django_cron import CronJobBase, Schedule
from .utils import CRONTIMES
from panel.models import Doctor, Message
from panel.SMSNotification import SMS
from APIs.models import User as AppUser


class WaitingUsers(CronJobBase):
    '''
    send notification of users who are waiting for doctor
    '''
    RUN_AT_TIMES = CRONTIMES["PanelCronJobWaitingUsers"]
    schedule = Schedule(run_at_times=RUN_AT_TIMES)
    code = 'cron.panel.waiting_users'  # a unique code

    def do(self):
        # print(self.code)
        try:
            sms_data = []
            active_doctors = Doctor.objects.filter(is_active=True)
            for doctor in active_doctors:
                doctor_user_set = set()
                temp = AppUser.objects.filter(profile__therapist=doctor.django_user)
                for t in temp:
                    doctor_user_set.add(t.django_user)

                number_of_unread_messages = 0
                waiting_user_set = set()
                unread_messages = Message.objects.filter(receiver=doctor.django_user, has_been_seen=False)
                for message in unread_messages:
                    if message.sender in doctor_user_set:
                        number_of_unread_messages += 1
                        waiting_user_set.add(message.sender)

                if number_of_unread_messages > 0:
                    m = "باسلام\n" + "شما " + str(number_of_unread_messages) + " پیام خوانده نشده از طرف " + str(
                        len(waiting_user_set)) + " کاربر مختلف دارید.\nآیدیا"
                    sms_data.append({
                        "phone": doctor.phone,
                        "message": m
                    })
            SMS().send_to_list(sms_data)
            print("sms data:\n", sms_data)
        except Exception as e:
            print(e)

