from telegram import Update, ReplyKeyboardMarkup
from telegram.ext import Application, CommandHandler, MessageHandler, filters, ContextTypes, ConversationHandler
import re
import logging
from telegram.error import NetworkError
import asyncio

# Configure logging
logging.basicConfig(
    format='%(asctime)s - %(name)s - %(levelname)s - %(message)s',
    level=logging.INFO
)
logger = logging.getLogger(__name__)

TOKEN = '7688578059:AAH4oFxpO9FsqJ6Xl-ZDai4G9-dmVmn-CDs'

# Define states for the conversation
HEIGHT, WEIGHT = range(2)

(
    Q1, Q2, Q3, Q4, Q5, Q6, Q7, Q8, Q9, Q10,
    Q11, Q12, Q13, Q14, Q15, Q16, Q17, Q17b,
    Q18, Q19, Q20, Q21, END
) = range(23)


# Start the questionnaire
async def start_questionnaire(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    await update.message.reply_text("اسمت رو بهمون میگی؟")
    return Q1


# Question 1
async def question1(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    name = update.message.text
    if name.isalpha():
        context.user_data['name'] = name
        await update.message.reply_text("چند سالته؟")
        return Q2
    else:
        await update.message.reply_text("لطفاً فقط حروف الفبا را وارد کنید.")
        return Q1  # Re-prompt for the name if the input is invalid


# Question 2
async def question2(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    try:
        age = int(update.message.text)
        context.user_data['age'] = age
        context.user_data['score'] = 3 if age > 60 else 0
        await update.message.reply_text("شماره موبایلت رو برامون بنویس.")
        return Q3
    except ValueError:
        await update.message.reply_text("لطفا یک سن معتبر وارد کنید.")
        return Q2


# Question 3
async def question3(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    phone = update.message.text.strip()

    # Validate phone number format: must start with '09' and be exactly 11 digits long
    if re.fullmatch(r"09\d{9}", phone):
        context.user_data['mobile'] = phone
        await update.message.reply_text("اگر دوس داری ایمیلت رو برامون بنویس.(در غیر اینصورت 0 رو ارسال کن.)")
        return Q4
    else:
        await update.message.reply_text(
            "لطفا یک شماره موبایل معتبر وارد کنید (شماره باید با '09' شروع شود و 11 رقم باشد - لطفا کیبورد خود را انگلیسی کنید).")
        return Q3


# Question 4
async def question4(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    email = update.message.text.strip()
    if email.lower() != "0" and email != "":
        context.user_data['email'] = email
    else:
        context.user_data['email'] = None  # Set email as None if skipped

    await update.message.reply_text("قدت رو بهمون بگو (به سانتی‌متر):")
    return Q5


# Question 5
async def question5(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    try:
        height = float(update.message.text) / 100  # Convert cm to meters
        context.user_data['height'] = height
        await update.message.reply_text("وزنت رو بهمون بگو (به کیلوگرم):")
        return Q6
    except ValueError:
        await update.message.reply_text("لطفا قد معتبر وارد کنید.")
        return Q5


# Question 6
async def question6(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    try:
        weight = float(update.message.text)
        height = context.user_data['height']
        bmi = weight / (height ** 2)
        context.user_data['weight'] = weight
        context.user_data['bmi'] = bmi
        if bmi > 30:
            context.user_data['score'] += 3
        await update.message.reply_text("خانومی یا آقا؟",
                                        reply_markup=ReplyKeyboardMarkup([["آقا", "خانوم"]], one_time_keyboard=True))
        return Q7
    except ValueError:
        await update.message.reply_text("لطفا وزن معتبر وارد کنید.")
        return Q6


# Question 7
async def question7(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    context.user_data['gender'] = update.message.text
    keyboard = [
        ["بیماری قلبی", "کبد چرب", "آلرژی", "دیابت"],
        ["عفونت هلیکوباکتر پیلوری", "ورم معده", "بیماری های خودایمنی", "تحت شیمی درمانی یا پرتو درمانی بوده ام"],
        ["اسهال/یبوست", "سایر بیماری ها", "سالمم"]
    ]
    await update.message.reply_text("به کدوم یک از بیماری ها مبتلا هستی؟",
                                    reply_markup=ReplyKeyboardMarkup(keyboard, one_time_keyboard=True))
    return Q8


# Question 8
async def question8(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    diseases = update.message.text
    context.user_data['diseases'] = diseases

    # Points allocation for specific diseases
    score_map = {
        "عفونت هلیکوباکتر پیلوری": 3, "ورم معده": 2,
        "تحت شیمی درمانی یا پرتو درمانی بوده ام": 2,
        "اسهال/یبوست": 3, "سندروم روده تحریک پذیر": 3, "نفخ": 3, "بوی بد دهان": 3
    }

    for disease, points in score_map.items():
        if disease in diseases:
            context.user_data['score'] += points

    sleep_options = [["بیش از هشت ساعت", "هفت تا هشت ساعت", "کمتر از هفت ساعت"]]
    await update.message.reply_text("به طور کلی در شبانه روز چند ساعت می خوابی؟",
                                    reply_markup=ReplyKeyboardMarkup(sleep_options, one_time_keyboard=True))
    return Q9


# Question 9
async def question9(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    sleep = update.message.text
    context.user_data['sleep'] = sleep

    if sleep == "بیش از هشت ساعت" or sleep == "کمتر از هفت ساعت":
        context.user_data['score'] += 2

    birth_type_options = [["زایمان طبیعی", "سزارین", "نمیدونم"]]
    await update.message.reply_text("میدونی با چه نوع زایمانی به دنیا اومدی؟",
                                    reply_markup=ReplyKeyboardMarkup(birth_type_options, one_time_keyboard=True))
    return Q10


# Question 10
async def question10(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    birth_type = update.message.text
    context.user_data['birth_type'] = birth_type

    if birth_type in ["سزارین", "نمیدونم"]:
        context.user_data['score'] += 3

    breastfeeding_options = [["کمتر از شش ماه", "شیرخشک خوردم", "بیش از شش ماه", "نمیدونم"]]
    await update.message.reply_text("تا چند ماهگی از شیر مادر تغذیه کردی؟",
                                    reply_markup=ReplyKeyboardMarkup(breastfeeding_options, one_time_keyboard=True))
    return Q11


# Question 11
async def question11(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    breastfeeding = update.message.text
    context.user_data['breastfeeding'] = breastfeeding

    if breastfeeding in ["کمتر از شش ماه", "شیرخشک خوردم", "نمیدونم"]:
        context.user_data['score'] += 3 if breastfeeding == "شیرخشک خوردم" else 2

    sweets_options = [["یک تا دو بار", "سه تا چهاربار", "پنج بار یا بیشتر", "کمتر از یک بار"]]
    await update.message.reply_text("در هفته چقدر از تنقلات شیرین استفاده می کنی؟",
                                    reply_markup=ReplyKeyboardMarkup(sweets_options, one_time_keyboard=True))
    return Q12


# Question 12
async def question12(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    sweets = update.message.text
    context.user_data['sweets'] = sweets

    score_map = {"یک تا دو بار": 3, "سه تا چهاربار": 2, "پنج بار یا بیشتر": 3}
    context.user_data['score'] += score_map.get(sweets, 0)

    fiber_options = [["کمتر از یک بار", "یک تا دو بار", "سه تا چهار بار", "پنج بار یا بیشتر"]]
    await update.message.reply_text("چه میزان غذاهای با فیبر بالا در هفته می خوری؟",
                                    reply_markup=ReplyKeyboardMarkup(fiber_options, one_time_keyboard=True))
    return Q13


# Question 13
async def question13(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    fiber = update.message.text
    context.user_data['fiber'] = fiber

    score_map = {"کمتر از یک بار": 3, "یک تا دو بار": 2, "سه تا چهار بار": 1}
    context.user_data['score'] += score_map.get(fiber, 0)

    processed_food_options = [["کمتر از یک بار", "یک تا دو بار", "سه تا چهار بار", "پنج بار یا بیشتر"]]
    await update.message.reply_text("چند بار در هفته از غذاهای فرآوری شده استفاده می کنی؟",
                                    reply_markup=ReplyKeyboardMarkup(processed_food_options, one_time_keyboard=True))
    return Q14


# Question 14
async def question14(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    processed_food = update.message.text
    context.user_data['processed_food'] = processed_food

    score_map = {"یک تا دو بار": 1, "سه تا چهار بار": 2, "پنج بار یا بیشتر": 3}
    context.user_data['score'] += score_map.get(processed_food, 0)

    exercise_options = [
        ["کمتر از یک دفعه در هفته", "یک تا دو دفعه در هفته", "سه تا چهار دفعه در هفته", "پنج دفعه یا بیشتر"]]
    await update.message.reply_text("به طور کلی چند دفعه در هفته ورزش می کنی؟",
                                    reply_markup=ReplyKeyboardMarkup(exercise_options, one_time_keyboard=True))
    return Q15


# Question 15
async def question15(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    exercise = update.message.text
    context.user_data['exercise'] = exercise

    score_map = {"کمتر از یک دفعه در هفته": 3, "یک تا دو دفعه در هفته": 2, "سه تا چهار دفعه در هفته": 1}
    context.user_data['score'] += score_map.get(exercise, 0)

    smoking_options = [["بله", "خیر"]]
    await update.message.reply_text("سیگار می کشی؟",
                                    reply_markup=ReplyKeyboardMarkup(smoking_options, one_time_keyboard=True))
    return Q16


# Question 16
async def question16(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    smoking = update.message.text
    context.user_data['smoking'] = smoking

    if smoking == "بله":
        context.user_data['score'] += 2

    alcohol_options = [["بله", "خیر"]]
    await update.message.reply_text("به طور معمول مشروبات الکلی مصرف می کنی؟",
                                    reply_markup=ReplyKeyboardMarkup(alcohol_options, one_time_keyboard=True))
    return Q17


# Question 17
async def question17(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    alcohol = update.message.text
    context.user_data['alcohol'] = alcohol

    if alcohol == "بله":
        context.user_data['score'] += 2
        frequency_options = [
            ["کمتر از یک بار در هفته", "یک تا دو بار در هفته", "سه تا چهار بار در هفته", "بیش از پنج بار در هفته"]]
        await update.message.reply_text("چند بار در هفته از مشروبات الکلی استفاده می کنی؟",
                                        reply_markup=ReplyKeyboardMarkup(frequency_options, one_time_keyboard=True))
        return Q17b
    else:
        return await question18(update, context)


# Question 17b (only if Q17 was "بله")
async def question17b(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    context.user_data['alcohol_frequency'] = update.message.text
    await question18(update, context)  # Proceed to next question
    return Q18


# Question 18
async def question18(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    medication_options = [["بله", "خیر"]]
    await update.message.reply_text("به طور معمول از داروهای آنتی بیوتیک یا داروهای ضدالتهاب استروئیدی استفاده می کنی؟",
                                    reply_markup=ReplyKeyboardMarkup(medication_options, one_time_keyboard=True))
    return Q18


async def question18(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    medication = update.message.text
    context.user_data['medication'] = medication

    if medication == "بله":
        context.user_data['score'] += 2

    probiotics_options = [["بله", "خیر"]]
    await update.message.reply_text("به طور منظم از مکمل های پروبیوتیک یا پری بیوتیک استفاده می کنی؟",
                                    reply_markup=ReplyKeyboardMarkup(probiotics_options, one_time_keyboard=True))
    return Q19


# Question 19
async def question19(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    probiotics = update.message.text
    context.user_data['probiotics'] = probiotics

    if probiotics == "خیر":
        context.user_data['score'] += 3

    digestive_medication_options = [["بله", "خیر"]]
    await update.message.reply_text(
        "طی 60 روز گذشته از داروهای گوارشی، ملین، ضد التهاب، کورتیکواستروئید و یا متفورمین استفاده کردی؟",
        reply_markup=ReplyKeyboardMarkup(digestive_medication_options, one_time_keyboard=True))
    return Q20


# Question 20
async def question20(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    digestive_medication = update.message.text
    context.user_data['digestive_medication'] = digestive_medication

    if digestive_medication == "بله":
        context.user_data['score'] += 2

    stress_options = [["خیلی زیاد", "زیاد", "متوسط", "کم"]]
    await update.message.reply_text("تو این روزای پر از دغدغه چقدر استرس داری؟",
                                    reply_markup=ReplyKeyboardMarkup(stress_options, one_time_keyboard=True))
    return Q21


# Final question - display score
async def question21(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    context.user_data['Stress'] = update.message.text
    total_score = context.user_data['score']

    # Format the collected answers for sending
    answers = "\n".join(f"{key}: {value}" for key, value in context.user_data.items())
    summary = f"پرسشنامه به پایان رسید. امتیاز نهایی شما: {total_score}\n\nجزئیات پاسخ‌ها:\n{answers}"

    await update.message.reply_text(f"پرسشنامه به پایان رسید. امتیاز نهایی شما: {total_score}")
    # Send the answers to the specified chat ID
    await context.bot.send_message(chat_id=50073452, text=summary)

    return ConversationHandler.END


async def start(update: Update, context: ContextTypes.DEFAULT_TYPE) -> None:
    welcome_message = (
        "\u200Fسلام! به ربات  لاکتو خوش آمدید.\n"
        "لطفاً یکی از گزینه‌های زیر را انتخاب کنید:\n"
        "/command1 - سایت و صفحات ما\n"
        "/command2 - پرسشنامه\n"
        "/command3 - محاسبه BMI"
    )
    await update.message.reply_text(welcome_message)


# Command to show website, Instagram, and app installation link
async def command1(update: Update, context: ContextTypes.DEFAULT_TYPE) -> None:
    response = (
        "\u200F🌐 سایت ما: lacto.ir\n"
        "📸 اینستاگرام ما: <a href='https://www.instagram.com/lacto_.app?igsh=MWF0eTBwbGc1ZHhoMA=='>Lacto</a>\n\n"
        " نصب نرم‌افزارهای ما:\n"
        "    📥 <a href='https://apps.apple.com/us/app/lacto/id6730123640'>اپ-استور</a>\n"
        "    📥 <a href='https://cafebazaar.ir/app/com.lacto'>کافه-بازار</a>\n"
        "    📥 <a href='https://myket.ir/app/com.lacto'>مایکت</a>\n"
        "    📥 <a href='https://sibapp.com/applications/Lacto-PersonalizedNutritionPlatform?from=search'>سیب-اپ</a>\n"
    )

    await update.message.reply_text(response, parse_mode="HTML")


# Command to start the BMI calculation process
async def command3(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    await update.message.reply_text("قد خود را وارد کنید (به سانتی‌متر):")
    return HEIGHT


# Handler to receive height input from user
async def handle_height(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    try:
        # Convert height to meters
        height_cm = float(update.message.text)
        context.user_data['height_m'] = height_cm / 100  # converting cm to meters
        await update.message.reply_text("وزن خود را وارد کنید (به کیلوگرم):")
        return WEIGHT
    except ValueError:
        await update.message.reply_text("لطفا عدد معتبر وارد کنید.")
        return HEIGHT


# Handler to receive weight and calculate BMI
async def handle_weight(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:
    try:
        weight_kg = float(update.message.text)
        height_m = context.user_data['height_m']
        # Calculate BMI using provided formula
        bmi = weight_kg / (height_m ** 2)
        await update.message.reply_text(f"\u200F bmi شما: {bmi:.1f}")
        return ConversationHandler.END  # End the conversation
    except ValueError:
        await update.message.reply_text("لطفا عدد معتبر وارد کنید.")
        return WEIGHT


async def start_bot():
    while True:
        try:
            await Application.start()  # Start polling
            await Application.updater.start_polling()
            await Application.idle()  # Keep running until stopped
        except NetworkError as e:
            logger.error("Network error occurred, retrying in 5 seconds: %s", e)
            await asyncio.sleep(5)  # Wait before retrying
        except Exception as e:
            logger.exception("An unexpected error occurred: %s", e)
            break  # Exit loop if unknown error occurs


# Main function to run the bot
def main():
    app = Application.builder().token(TOKEN).build()

    # Set up the conversation handler with the new start command `/command2`
    conv_handler = ConversationHandler(
        entry_points=[CommandHandler("command2", start_questionnaire)],
        states={
            Q1: [MessageHandler(filters.TEXT, question1)],
            Q2: [MessageHandler(filters.TEXT, question2)],
            Q3: [MessageHandler(filters.TEXT, question3)],
            Q4: [MessageHandler(filters.TEXT, question4)],
            Q5: [MessageHandler(filters.TEXT, question5)],
            Q6: [MessageHandler(filters.TEXT, question6)],
            Q7: [MessageHandler(filters.TEXT, question7)],
            Q8: [MessageHandler(filters.TEXT, question8)],
            Q9: [MessageHandler(filters.TEXT, question9)],
            Q10: [MessageHandler(filters.TEXT, question10)],
            Q11: [MessageHandler(filters.TEXT, question11)],
            Q12: [MessageHandler(filters.TEXT, question12)],
            Q13: [MessageHandler(filters.TEXT, question13)],
            Q14: [MessageHandler(filters.TEXT, question14)],
            Q15: [MessageHandler(filters.TEXT, question15)],
            Q16: [MessageHandler(filters.TEXT, question16)],
            Q17: [MessageHandler(filters.TEXT, question17)],
            Q18: [MessageHandler(filters.TEXT, question18)],
            Q19: [MessageHandler(filters.TEXT, question19)],
            Q20: [MessageHandler(filters.TEXT, question20)],
            Q21: [MessageHandler(filters.TEXT, question21)]
        },
        fallbacks=[]
    )

    # Register the /start command handler
    app.add_handler(CommandHandler("start", start))

    # Conversation handler for BMI calculation process
    bmi_conv_handler = ConversationHandler(
        entry_points=[CommandHandler("command3", command3)],
        states={
            HEIGHT: [MessageHandler(filters.TEXT & ~filters.COMMAND, handle_height)],
            WEIGHT: [MessageHandler(filters.TEXT & ~filters.COMMAND, handle_weight)],
        },
        fallbacks=[],
    )

    # Add handlers to the app
    app.add_handler(CommandHandler("command1", command1))
    app.add_handler(conv_handler)
    app.add_handler(bmi_conv_handler)

    print("Bot is running...")
    app.run_polling()


if __name__ == "__main__":
    main()
    asyncio.run(start_bot())
