from profile import Profile
from rest_framework.decorators import api_view
from APIs.views.views import RequsetChecker
from .telegram_notification import TelegramNotification
from .utility import *
from APIs.views.Errors import Errors
from APIs.models import Activities_log, Sleep, User as AppUser, Shop, RequestedFoods, CoinValue, ContentService, Video, PDF, Purchase, \
    DietSubscription, AppointmentCredit, Water
from APIs.models import Diet, Points, Eating, AIChatMessage
from APIs.views.report import get_key_factor
from panel.models import *
from payment.models import ZarinPalPayment
from django.db.models import Q, Sum, F
from ziluck_project.settings import STATIC_ROOT
import os
from APIs.views.report import (getList, getIntegerList, listToStr, getFloatList,
                               getHEI_List, myListAdder, normalize, myListSum,
                               HEI_Point_Calculator, updateTotalPointDay)
from APIs.views.views import notif_cal
import requests
import jdatetime
from panel.SMSNotification import SMS
from django.shortcuts import get_object_or_404
import traceback
from django.db import transaction
from openai import OpenAI


@api_view(["POST"])
def check_account(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",  # required
                "format": "^(\S)+$",  # required
                "required": True,  # optional default is true
            },
        ], request)
        token = request.POST.get("token")
        if token == None:
            return myResponse.Error(Errors.InvalidArgument.message, Errors.InvalidArgument.code)

        temp = AppUser.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        app_user = temp[0]

        patient = app_user.django_user
        temp = TherapistSelection.objects.filter(user=patient)
        if not temp.exists():
            return myResponse.Error(Errors.UnselectedTherapist.message, Errors.UnselectedTherapist.code)
        ts = temp.last()
        if ts.credit_left():
            credit = 'اعتبار حساب شما منقضی شده است'
            code = -1
        else:
            credit = str(ts.remaining_credit()) + ' روز از اعتبار حساب شما باقیمانده است'
            code = 1

        data = {
            "credit": credit,
            "code": code
        }
        return myResponse.OK("chats", data)
    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def get_chats(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",  # required
                "format": "^(\S)+$",  # required
                "required": True,  # optional default is true
            },
            {
                "name": "tags",  # required
                "format": ".",  # required
                "required": False,  # optional default is true
            }
        ], request)
        token = request.POST.get("token")
        if token is None:
            return myResponse.Error(Errors.InvalidArgument.message, Errors.InvalidArgument.code)

        temp = AppUser.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        app_user = temp[0]
        patient = app_user.django_user
        if request.POST.get("tags") is None or request.POST.get("tags") == "":
            # Use sender_id and receiver_id directly for more reliable querying
            # Also add order_by and select_related for consistency and performance
            chats = Message.objects.filter(
                Q(sender_id=patient.id) | Q(receiver_id=patient.id)
            ).select_related('sender', 'receiver', 'reply_message', 'attachment').order_by('time')
            filter_flag = False
        else:
            # Use sender_id and receiver_id directly for more reliable querying
            # Also add order_by and select_related for consistency and performance
            chats = Message.objects.filter(
                Q(sender_id=patient.id) | Q(receiver_id=patient.id)
            ).select_related('sender', 'receiver', 'reply_message', 'attachment').order_by('time')
            filter_flag = True
            tags = set(str(request.POST.get("tags")).split("&"))
            tags.discard("")

        chats_list = []
        for chat in chats:
            if filter_flag:
                if len(set(chat.tags["tags"]).intersection(tags)) == 0:
                    continue
            item = {
                'time': int(chat.time.timestamp()),
                'text': chat.text,
                'attachment': None,
                'sender': 'other',
                'id': chat.id,
                'is_star': chat.is_stared,
            }

            if chat.reply_message is not None:
                item['reply_message'] = {
                    'time': int(chat.reply_message.time.timestamp()),
                    'text': chat.reply_message.text,
                    'sender': 'other',
                }

                if chat.reply_message.sender == patient:
                    item["reply_message"]['sender'] = 'you'
                else:
                    item["reply_message"]['sender'] = 'other'
                    chat.save()

            if chat.sender == patient:
                item['sender'] = 'you'
            else:
                item['sender'] = 'other'
                chat.has_been_seen = True
                chat.save()

            if chat.attachment is not None:
                item['attachment'] = {
                    'name': chat.attachment.name,
                    'time': int(chat.attachment.time.timestamp()),
                    'content_type': chat.attachment.content_type,
                    'is_diet': chat.attachment.is_diet,
                    'path': 'https://ziluck.probiofit.net/static/' + chat.attachment.path,
                    'size': chat.attachment.get_size(),
                    'owner': None,
                }
                if chat.attachment.owner is not None:
                    item["owner"] = chat.attachment.owner.id

            chats_list.append(item)
        data = {
            'chats': chats_list,
        }
        return myResponse.OK("chats", data)
    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def get_media(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",  # required
                "format": "^(\S)+$",  # required
                "required": True,  # optional default is true
            },
            {
                "name": "tags",  # required
                "format": ".",  # required
                "required": False,  # optional default is true
            }
        ], request)
        token = request.POST.get("token")
        if token is None:
            return myResponse.Error(Errors.InvalidArgument.message, Errors.InvalidArgument.code)

        temp = AppUser.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        app_user = temp[0]
        patient = app_user.django_user
        if request.POST.get("tags") is None or request.POST.get("tags") == "":
            # Use sender_id and receiver_id directly for more reliable querying
            # Also add order_by and select_related for consistency and performance
            chats = Message.objects.filter(
                Q(sender_id=patient.id) | Q(receiver_id=patient.id)
            ).select_related('sender', 'receiver', 'reply_message', 'attachment').order_by('time')
            filter_flag = False
        else:
            # Use sender_id and receiver_id directly for more reliable querying
            # Also add order_by and select_related for consistency and performance
            chats = Message.objects.filter(
                Q(sender_id=patient.id) | Q(receiver_id=patient.id)
            ).select_related('sender', 'receiver', 'reply_message', 'attachment').order_by('time')
            filter_flag = True
            tags = set(str(request.POST.get("tags")).split("&"))
            tags.discard("")

        chats_list = []
        for chat in chats:
            # Check if the message has an attachment or if the text is a .mp4 URL
            if chat.attachment is not None or (chat.text.startswith("https://") and chat.text.endswith(".mp4")):
                if filter_flag:
                    if len(set(chat.tags["tags"]).intersection(tags)) == 0:
                        continue

                item = {
                    'time': int(chat.time.timestamp()),
                    'text': chat.text,
                    'attachment': None,
                    'sender': 'other',
                    'id': chat.id,
                }

                if chat.reply_message is not None:
                    item['reply_message'] = {
                        'time': int(chat.reply_message.time.timestamp()),
                        'text': chat.reply_message.text,
                        'sender': 'other',
                    }

                    if chat.reply_message.sender == patient:
                        item["reply_message"]['sender'] = 'you'
                    else:
                        item["reply_message"]['sender'] = 'other'

                if chat.sender == patient:
                    item['sender'] = 'you'
                else:
                    item['sender'] = 'other'
                    chat.has_been_seen = True
                    chat.save()

                # Build the attachment data
                if chat.attachment is not None:
                    item['attachment'] = {
                        'name': chat.attachment.name,
                        'time': int(chat.attachment.time.timestamp()),
                        'content_type': chat.attachment.content_type,
                        'is_diet': chat.attachment.is_diet,
                        'path': 'https://ziluck.probiofit.net/static/' + chat.attachment.path,
                        'size': chat.attachment.get_size(),
                        'owner': None,
                    }
                    if chat.attachment.owner is not None:
                        item["attachment"]['owner'] = chat.attachment.owner.id
                else:
                    # Treat the text as an attachment
                    item['attachment'] = {
                        'name': chat.text.split('/')[-1],  # Extract the file name from the URL
                        'time': int(chat.time.timestamp()),
                        'content_type': 'mp4',
                        'is_diet': False,  # Set this based on your requirements
                        'path': chat.text,
                        'size': None,  # Size may not be available
                        'owner': None,
                    }

                chats_list.append(item)
        data = {
            'chats': chats_list,
        }
        return myResponse.OK("chats", data)
    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def post_chat(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",  # required
                "format": "^(\S)+$",  # required
                "required": True,  # optional default is true
            },
            {
                "name": "text",  # required
                "format": ".",  # required
                "required": True,  # optional default is true
            },
            {
                "name": "message_id",  # required
                "format": ".",  # required
                "required": False,  # optional default is true
            },
        ], request)
        token = request.POST.get("token")
        if token == None:
            return myResponse.Error(Errors.InvalidArgument.message, Errors.InvalidArgument.code)

        temp = AppUser.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        app_user = temp[0]
        patient = app_user.django_user
        text = request.POST.get("text")
        replied_message_id = request.POST.get("message_id")

        record_date = datetime.now().date()
        p = Points.objects.filter(user=app_user, date=record_date)
        if p.exists():
            record = p[0]
        else:
            record = Points(user=app_user, date=record_date)

        user_name = app_user.profile.first_name + " " + app_user.profile.last_name
        telegram_message = f"{user_name} پیام جدید برای شما ارسال کرده است"

        # First check if user has therapist and credit
        temp = TherapistSelection.objects.filter(user=app_user.django_user)
        if not temp.exists():
            return myResponse.Error(Errors.UnselectedTherapist.message, Errors.UnselectedTherapist.code)
            
        ts = temp.last()
        zp = ZarinPalPayment.objects.filter(user=app_user).order_by("created_at").last()

        # Check if user has valid subscription
        if not ts.has_credit():
            return myResponse.Error(Errors.CreditLeft.message, Errors.CreditLeft.code)

        # After credit validation, check plan restrictions
        if zp and (zp.plan == 7 or zp.plan == 8):
            return myResponse.Error(Errors.FeatureNotAvailable.message, Errors.FeatureNotAvailable.code)
        
        

        if replied_message_id is None:
            if text is not None:
                if app_user.profile.therapist is None:
                    return myResponse.Error(Errors.UnselectedTherapist.message, Errors.UnselectedTherapist.code)

                # check the credit of account
                ts = TherapistSelection.objects.filter(user=app_user.django_user).order_by("id").last()
                if ts.credit_left():
                    return myResponse.Error(Errors.CreditLeft.message, Errors.CreditLeft.code)

                # everything is ok, so save the message
                message = Message(sender=patient, receiver=app_user.profile.therapist, text=text)
                message.tags['tags'] = ["text"]
                message.save()

                u = updateTotalPointDay(app_user, record, is_Message=True)
                totalPoint = u["DayPoint"]
                record.total_points = totalPoint
                record.totalCooperationPoints = u["totalCooperate"]
                record.save()
                
                TelegramNotification().send_message(temp=[app_user], text=telegram_message)
                
                # SMS().notify_doctor(user=app_user)
                return myResponse.OK("sent!", [])
        else:
            past_message = get_object_or_404(Message, id=replied_message_id)
            if text is not None:
                # Creating a reply message directly in the same Message model
                message = Message(sender=patient,
                                  receiver=app_user.profile.therapist,
                                  text=text,
                                  reply_message=past_message  # Assigning the replied message
                                  )
                message.tags['tags'] = ["text"]
                message.save()

                u = updateTotalPointDay(app_user, record, is_Message=True)
                totalPoint = u["DayPoint"]
                record.total_points = totalPoint
                record.totalCooperationPoints = u["totalCooperate"]
                record.save()

                # SMS().notify_user(user=patient)
                TelegramNotification().send_message(temp=[app_user], text=telegram_message)

                return myResponse.OK("sent", [])

    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def edit_chat(request):
    try:
        # Validate request parameters
        RequsetChecker(request.POST, [
            {
                "name": "token",  # required
                "format": "^(\S)+$",  # required
                "required": True,
            },
            {
                "name": "message_id",  # required
                "format": "^\d+$",  # Must be a number
                "required": True,
            },
            {
                "name": "text",  # required
                "format": ".",  # Any text
                "required": True,
            },
        ], request)

        # Get and validate token
        token = request.POST.get("token")
        if token is None:
            return myResponse.Error(Errors.InvalidArgument.message, Errors.InvalidArgument.code)

        temp = AppUser.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        app_user = temp[0]
        patient = app_user.django_user

        # Get the message to edit
        message_id = request.POST.get("message_id")
        new_text = request.POST.get("text")

        # Fetch the message and check ownership
        message = get_object_or_404(Message, id=message_id)
        if message.sender != patient:
            return myResponse.Error("شما فقط می‌توانید پیام‌های خودتان را ویرایش کنید", Errors.Unauthorized.code)
        if (datetime.now() - message.time).total_seconds() > 7200:  # 2 hour limit
            return myResponse.Error("مهلت ویرایش پیام به پایان رسیده است", Errors.Unauthorized.code)

        # Update the message
        message.text = new_text
        message.is_edited = True  # Mark as edited
        message.edited_time = datetime.now()  # Update edit timestamp
        message.save()

        # Optional: Notify the receiver (e.g., therapist) about the edit
        user_name = app_user.profile.first_name + " " + app_user.profile.last_name
        notification_text = f"پیام از {user_name} ویرایش شده‌است."
        TelegramNotification().send_message(temp=app_user.profile.therapist, text=notification_text)

        return myResponse.OK("پیام با موفقیت ویرایش شد", [])

    except ValueError as e:
        return myResponse.Error(str(e), Errors.InvalidArgument.code)
    except Exception as e:
        return myResponse.Error(f"خطا در ویرایش پیام: {str(e)}", Errors.InternalError.code)


@api_view(["POST"])
def delete_chat(request):
    try:
        # Validate request parameters
        RequsetChecker(request.POST, [
            {
                "name": "token",  # required
                "format": "^(\S)+$",  # required
                "required": True,
            },
            {
                "name": "message_id",  # required
                "format": "^\d+$",  # Must be a number
                "required": True,
            },
        ], request)

        # Get and validate token
        token = request.POST.get("token")
        if token is None:
            return myResponse.Error(Errors.InvalidArgument.message, Errors.InvalidArgument.code)

        temp = AppUser.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        app_user = temp[0]
        patient = app_user.django_user

        # Get the message to delete
        message_id = request.POST.get("message_id")

        # Fetch the message and check ownership
        message = get_object_or_404(Message, id=message_id)
        if message.sender != patient:
            return myResponse.Error("شما فقط می‌توانید پیام‌های خودتان را حذف کنید", Errors.Unauthorized.code)
        if (datetime.now() - message.time).total_seconds() > 1800:  # 30 minute limit
            return myResponse.Error("مهلت حذف پیام به پایان رسیده است", Errors.Unauthorized.code)

        # Delete the message
        message.delete()

        return myResponse.OK("پیام با موفقیت حذف شد", [])

    except ValueError as e:
        return myResponse.Error(str(e), Errors.InvalidArgument.code)
    except Exception as e:
        return myResponse.Error(f"خطا در حذف پیام: {str(e)}", Errors.InternalError.code)


@api_view(["POST"])
def star_message(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S)+$",
                "required": True,
            },
            {
                "name": "message_id",
                "format": "^\d+$",  # message_id should be an integer
                "required": True,
            },
        ], request)

        token = request.POST.get("token")
        message_id = request.POST.get("message_id")

        # Validate token
        temp = AppUser.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        # Fetch the message by ID
        message = get_object_or_404(Message, id=message_id)

        # Star the message
        message.is_stared = True
        message.save()

        return myResponse.OK("This message is starred now.", [])

    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def un_star_message(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S)+$",
                "required": True,
            },
            {
                "name": "message_id",
                "format": "^\d+$",  # message_id should be an integer
                "required": True,
            },
        ], request)

        token = request.POST.get("token")
        message_id = request.POST.get("message_id")

        # Validate token
        temp = AppUser.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        # Fetch the message by ID
        message = get_object_or_404(Message, id=message_id)

        # Star the message
        message.is_stared = False
        message.save()

        return myResponse.OK("This message is un_starred now.", [])

    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def get_starred_messages(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",  # required
                "format": "^(\S)+$",  # required
                "required": True,  # optional default is true
            },
        ], request)
        token = request.POST.get("token")
        if token is None:
            return myResponse.Error(Errors.InvalidArgument.message, Errors.InvalidArgument.code)

        temp = AppUser.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
        app_user = temp[0]
        patient = app_user.django_user

        # Fetch all starred messages for the user
        starred_messages = Message.objects.filter(receiver=patient, is_stared=True) | Message.objects.filter(
            sender=patient, is_stared=True)

        # Serialize the data
        messages_data = []
        for message in starred_messages:
            messages_data.append({
                "id": message.id,
                "sender": 'you' if message.sender == patient else 'other',
                "text": message.text,
                "time": message.time,
                "has_been_seen": message.has_been_seen,
                "is_stared": message.is_stared,
                "tags": message.tags,
                "reply_message": message.reply_message.id if message.reply_message else None,
            })
        return myResponse.OK("Starred messages retrieved successfully!", messages_data)

    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def post_attachment(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",  # required
                "format": "^(\S)+$",  # required
                "required": True,  # optional default is true
            },
            {
                "name": "text",  # required
                "format": ".",  # required
                "required": False,  # optional default is true
            },
        ], request)

        token = request.POST.get("token")
        if token == None:
            return myResponse.Error(Errors.InvalidArgument.message, Errors.InvalidArgument.code)

        temp = AppUser.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        app_user = temp[0]
        patient = app_user.django_user
        text = request.POST.get("text")
        if text == None:
            text = ""
        file = request.FILES.get("file")
        if file is None:
            return myResponse.Error(Errors.UnselectedAttachment.message, Errors.UnselectedAttachment.code)
        extension = file.name.split(".")[-1]
        hashed_name = generate_file_name(extension)
        path_from_static_root = "panel/attachments/" + hashed_name

        if app_user.profile.therapist != None:
            # check the credit of account
            ts = TherapistSelection.objects.filter(user=app_user.django_user).order_by("id").last()
            if ts.credit_left():
                return myResponse.Error(Errors.CreditLeft.message, Errors.CreditLeft.code)

            # now try to save the attachment
            try:
                with open(STATIC_ROOT + "/" + path_from_static_root, 'wb+') as destination:
                    for chunk in file.chunks():
                        destination.write(chunk)
                    destination.close()

                print("wrote to", STATIC_ROOT + "/" + path_from_static_root)

                file_size = os.path.getsize(STATIC_ROOT + "/" + path_from_static_root)
                attachment = Attachment(owner=patient, name=file.name, path=path_from_static_root, size=file_size,
                                        content_type=extension)

                attachment.save()
                message = Message(sender=patient, receiver=app_user.profile.therapist,
                                  text=text, attachment=attachment)
                message.tags["tags"] = [extension]
                message.save()
                info = {
                    "url_uploaded": "https://ziluck.probiofit.net/static/" + path_from_static_root,
                    "content_type": extension,
                    "name": file.name,
                    "time": "%s:%s" % (message.time.hour, message.time.minute),
                    'size': attachment.get_size(),  # changing byte to KB
                }
                data = {
                    "attachment": info
                }
                # SMS().notify_doctor(app_user)
                return myResponse.OK("sent", data)
            except Exception as e:
                return myResponse.Error("error on saving the message")

    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def get_list_of_doctors(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",  # required
                "format": "^(\S)+$",  # required
                "required": True,  # optional default is true
            },
        ], request)

        token = request.POST.get("token")
        if token == None:
            return myResponse.Error(Errors.InvalidArgument.message, Errors.InvalidArgument.code)

        temp = AppUser.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        # app_user = temp[0]
        # patient = app_user.django_user
        doctors = Doctor.objects.filter(is_active=True)
        doctors_data = []
        for doctor in doctors:
            doctors_data.append({
                "name": doctor.first_name + " " + doctor.last_name,
                "id": doctor.id
            })
        return myResponse.OK("list of doctors", data=doctors_data)

    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def get_diets(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",  # required
                "format": "^(\S)+$",  # required
                "required": True,  # optional default is true
            },
        ], request)
        token = request.POST.get("token")
        if token == None:
            return myResponse.Error(Errors.InvalidArgument.message, Errors.InvalidArgument.code)

        temp = AppUser.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        app_user = temp[0]
        patient = app_user.django_user
        diets = Diet.objects.filter(user=app_user).order_by('-created_at')
        diets_list = []
        for diet in diets:
            if diet.from_date <= date.today():
                diets_list.append(diet.to_json)

        data = {
            'diets': diets_list,
        }
        return myResponse.OK("diets", data)
    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def eating(request):
    if request.method == "POST":
        # try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "errorMessage": "توکن را درست وارد کنید"
            },
            {
                "name": "date_time",
                "format": "^[-+]?[0-9]{10}$",  # timestamp
                # ex:  "1546270161",
                "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند"
            },
            {
                "name": "amount",
                "format": "^(\S)+$",

            },
            {
                "name": "food_code",
                "format": "^(\S)+$",
                "errorMessage": "نوع غذا باید به صورت یک عدد طبیعی باشد و در طرفین اعداد & باشد"
            },
            {
                "name": "home_unit_index",
                "format": "^(\S)+$",
                "errorMessage": "نوع واحد خانگی باید به صورت یک عدد طبیعی باشد و در طرفین اعداد & باشد",
                "required": False
            },
            {
                "name": "meal",
                "format": "^[\d]+$",
                "errorMessage": "وعده غذایی باید به صورت یک عدد طبیعی باشد، 1 صبحانه، 2 ناهار، 3 شام و 0 برای میان وعده"
            },
            {
                "name": "model",
                "format": "^-?[\d]+$",
                "errorMessage": "یک مدل از شماره -1 تا 7 را انتخاب نمایید"
            }
        ], request)

        token = str(request.POST["token"])
        # phone = str(request.POST["phone_number"])
        # temp = User.objects.filter(token=token, phone_number=phone)
        temp = AppUser.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        user = temp[0]
        meal = int(request.POST["meal"])
        model = int(request.POST["model"])



        app_user = temp[0]
        patient = app_user.django_user
        diets = Diet.objects.filter(user=app_user).order_by('-created_at')
        dietss = []
        for diet in diets:
            if diet.from_date <= date.today():
                dietss.append(diet.to_json)

        mealStr = ""

        if meal == 0:
            mealStr = "breakfast"
        elif meal == 1:
            mealStr = "lunch"
        elif meal == 2:
            mealStr = "dinner"
        elif meal == 3:
            mealStr = "snack1"
        elif meal == 4:
            mealStr = "snack2"

        calculated_score = -1

        if model != -1 and dietss:
            try:
                cardIngredientList = dietss[0]["diet"]["week1"][mealStr][model][0]["ingredient"]
            except (IndexError, KeyError):
                return myResponse.Error("Diet data is invalid or missing.", {})

            ingredientsCode = []
            ingredientsAmount = []

            for a in cardIngredientList:
                ingredientsCode.append(a["food_code"])
                ingredientsAmount.append(a["amount_g"])

            eaten_amounts = getList(request.POST["amount"])
            eaten_food_codes = getList(request.POST["food_code"])

            # Expected ingredients from the diet plan (card)
            expected_ingredients = {}  # key: food_code, value: amount
            for code, amount in zip(ingredientsCode, ingredientsAmount):
                expected_ingredients[code] = amount

            # Eaten ingredients
            eaten_ingredients = {}  # key: food_code, value: amount
            for code, amount in zip(eaten_food_codes, eaten_amounts):
                eaten_ingredients[code] = amount

            # Score Calculation

            high_score = 0
            score = 10
            # Initialize score
            if meal == 0 or meal == 1 or meal == 2:
                score = 10
                high_score = 1
            elif meal == 3 or meal == 4:
                score = 5
                high_score = 2

            # Threshold for amount comparison (grams)
            threshold = 30

            # Penalty per mismatch
            # penalty_per_mismatch = 1  # Adjust as needed
            penalty_per_amount_conflict = 0.5
            penalty_per_foodcode_mismatch = 2
            total_penalty = 0

            # Compare expected ingredients with eaten ingredients
            for food_code, expected_amount in expected_ingredients.items():
                if food_code in eaten_ingredients:
                    eaten_amount = eaten_ingredients[food_code]
                    amount_difference = abs(expected_amount - eaten_amount)
                    if amount_difference > threshold:
                        # Amount differs beyond the threshold
                        total_penalty += penalty_per_amount_conflict
                else:
                    # Ingredient missing in eaten ingredients
                    total_penalty += penalty_per_foodcode_mismatch

            # Check for extra ingredients in eaten ingredients
            for food_code in eaten_ingredients:
                if food_code not in expected_ingredients:
                    # Extra ingredient not expected
                    total_penalty += 1

            # Calculate final score
            score -= total_penalty

            score = max(score, 0)

            if high_score == 1:
                score = min(score, 10)
            elif high_score == 2:
                score = min(score, 5)

            calculated_score = score

        dt = int(request.POST["date_time"])
        date_time = datetime.fromtimestamp(dt)

        now = datetime.now().date()
        today = date.today()
        today_start = datetime(year=today.year, month=today.month, day=today.day, hour=0, minute=0, second=0)
        today_end = datetime(year=today.year, month=today.month, day=today.day, hour=23, minute=59, second=59)

        if meal > 5:
            return myResponse.Error(Errors.InvalidMealId.message, Errors.InvalidMealId.code)

        amounts = getList(request.POST["amount"])
        food_codes = getList(request.POST["food_code"])
        if request.POST.get("home_unit_index") is None:
            home_unit_index = []
            for i in range(len(food_codes)):
                home_unit_index.append(0)
        else:
            home_unit_index = getIntegerList(request.POST["home_unit_index"])

        data = user.calculate_cr_macro_nutrients_distribution()

        user.profile.CR = data["CR"]
        user.profile.Carbohydrates_g = data["macro_nutrients"]["carbohydrates_g"]
        user.profile.Carbohydrates_unit = data["macro_nutrients"]["carbohydrates_unit"]
        user.profile.Protein_g = data["macro_nutrients"]["protein_g"]
        user.profile.Protein_unit = data["macro_nutrients"]["protein_unit"]
        user.profile.Fat_g = data["macro_nutrients"]["fat_g"]
        user.profile.Fat_unit = data["macro_nutrients"]["fat_unit"]

        Carbohydrates_distribution_str = listToStr(data["carbohydrate_distribution_g"])

        user.profile.Carbohydrates_distribution_list_g = Carbohydrates_distribution_str
        user.profile.Protein_distribution_g = data["protein_distribution_g"]
        user.profile.Fat_distribution_g = data["fat_distribution_g"]
        user.profile.save()

        Carbohydrates_list_to_use = getList(user.profile.Carbohydrates_distribution_list_g)
        Fat_to_use = user.profile.Fat_distribution_g
        Protein_to_use = user.profile.Protein_distribution_g

        record_date = date_time.date()
        p = Points.objects.filter(user=user, date=record_date)
        if p.exists():
            record = p[0]
        else:
            record = Points(user=user, date=record_date)
        # this meal used:
        HEI_elements_sum = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]

        Carbohydrates_used = 0
        Protein_used = 0
        Fat_used = 0
        Calorie_used = 0
        diet_amounts_g = []
        diet_home_unit = []
        diet_amount_in_home_unit = []
        diet_carbohydrates_g = []
        diet_protein_g = []
        diet_fat_g = []
        diet_calories = []
        diet_food_names = []

        for i in range(min(len(amounts), len(food_codes))):
            f = Food.objects.filter(Data_Base_Number=str(int(food_codes[i])))
            if not f.exists():
                return myResponse.Error(Errors.InvalidFoodId.message, Errors.InvalidFoodId.code)
            food = f[0]
            HUIi = home_unit_index[i]
            real_amount_g = amounts[i] * getFloatList(food.Weight_of_home_units)[HUIi]
            Carbohydrates_used += (real_amount_g / 100) * food.Carbohydrates_g
            Protein_used += (real_amount_g / 100) * food.Protein_g
            Fat_used += (real_amount_g / 100) * food.Fat_g
            Calorie_used += (real_amount_g / 100) * food.Calories
            HEI_elements_i = getHEI_List(food, real_amount_g)
            HEI_elements_sum = myListAdder(HEI_elements_sum, HEI_elements_i)
            # save eating log in it's table...
            new_log = Eating(user=user,
                             food=food,
                             date_time=date_time,
                             amount=real_amount_g,
                             meal=meal)
            new_log.save()

            diet_amounts_g.append(real_amount_g)
            diet_carbohydrates_g.append((real_amount_g / 100) * food.Carbohydrates_g)
            diet_protein_g.append((real_amount_g / 100) * food.Protein_g)
            diet_fat_g.append((real_amount_g / 100) * food.Fat_g)
            diet_calories.append((real_amount_g / 100) * food.Calories)
            diet_food_names.append(food.FA_Name)
            diet_home_unit.append(food.Name_of_home_units.split("&")[2])
            diet_amount_in_home_unit.append(real_amount_g / float(food.Weight_of_home_units.split("&")[2]))

        # if model != -1 and dietss:
        if dietss:
            # Save changes to diet
            diets = Diet.objects.filter(user=user).order_by('from_date')
            last_diet = diets.last()

            # Check to make sure user has a diet
            if last_diet.from_date <= date_time.date() <= (last_diet.from_date + timedelta(days=30)):
                day = (date_time.date() - last_diet.from_date).days
                if day >= 31:
                    day = 30  # Cap the day to 30 (31st day, zero-indexed)fff

                last_diet.eating(
                    day, meal, model, diet_amounts_g, food_codes, diet_food_names,
                    diet_carbohydrates_g, diet_protein_g, diet_fat_g, diet_calories,
                    diet_home_unit, diet_amount_in_home_unit
                )
            else:
                # Handle the diet before the last diet
                # Retrieve the second last diet (previous diet)
                diets_ordered = diets.order_by('-from_date')  # Order descendingly
                try:
                    previous_diet = diets_ordered[1]  # Get the second item

                    # Check if current date falls within the previous diet's period
                    if previous_diet.from_date <= date_time.date() <= (previous_diet.from_date + timedelta(days=30)):
                        day = (date_time.date() - previous_diet.from_date).days

                        if day >= 31:
                            day = 30  # Cap the day to 30 (31st day, zero-indexed)

                        previous_diet.eating(
                            day, meal, model, diet_amounts_g, food_codes, diet_food_names,
                            diet_carbohydrates_g, diet_protein_g, diet_fat_g, diet_calories,
                            diet_home_unit, diet_amount_in_home_unit
                        )
                    else:
                        # Current date does not fall within any diet's period
                        print("No active diet found for the current date.")
                        # Optionally, handle this scenario (e.g., notify the user, log the event)
                except IndexError:
                    # There is no previous diet to handle
                    print("No previous diet found to handle the current date.")
                    # Optionally, handle this scenario (e.g., notify the user, log the event)

        # Carbohydrates calculations
        this_day_Carbohydrates_point = getList(record.this_day_Carbohydrates_point)
        this_day_Carbohydrates_g = getList(record.this_day_Carbohydrates_g)
        this_day_Carbohydrates_g[meal] += Carbohydrates_used
        record.this_day_Carbohydrates_g = listToStr(this_day_Carbohydrates_g)
        this_day_Carbohydrates_point[meal] = normalize(
            this_day_Carbohydrates_g[meal] / Carbohydrates_list_to_use[meal])
        record.this_day_Carbohydrates_point = listToStr(this_day_Carbohydrates_point)
        totalCarboControl = myListSum(this_day_Carbohydrates_point) / len(this_day_Carbohydrates_point)
        record.totalCarboControlPoint = totalCarboControl

        # Fat calculations
        this_day_Fat_g = getList(record.this_day_Fat_list_g)
        this_day_Fat_g[meal] += Fat_used
        record.this_day_Fat_list_g = listToStr(this_day_Fat_g)
        this_day_Fat_list_point = getList(record.this_day_Fat_list_point)
        this_day_Fat_list_point[meal] = normalize(this_day_Fat_g[meal] / Fat_to_use)
        record.this_day_Fat_list_point = listToStr(this_day_Fat_list_point)

        # Protein calculations
        this_day_Protein_list_g = getList(record.this_day_Protein_list_g)
        this_day_Protein_list_g[meal] += Protein_used
        record.this_day_Protein_list_g = listToStr(this_day_Protein_list_g)
        this_day_Protein_list_point = getList(record.this_day_Protein_list_point)
        this_day_Protein_list_point[meal] = normalize(this_day_Protein_list_g[meal] / Protein_to_use)
        record.this_day_Protein_list_point = listToStr(this_day_Protein_list_point)

        # Calorie Calculations
        total_Calories_used = Calorie_used + record.total_Calories_used
        record.total_Calories_used = total_Calories_used
        record.total_Calories_Point = normalize(total_Calories_used / user.profile.CR)
        record.save()

        # HEI elements used and calculations ...
        # HEI_elements_used = getHEI_List(food, amount)  #
        Last_HEI_elements = getList(record.HEI_elements_list)
        sum_Of_HEI_elements = myListAdder(Last_HEI_elements, HEI_elements_sum)
        total_HEI_Point = HEI_Point_Calculator(sum_Of_HEI_elements,
                                               record.total_Calories_used)
        record.HEI_elements_list = listToStr(sum_Of_HEI_elements)
        record.total_HEI_Point = total_HEI_Point

        # update and save changes
        if calculated_score == -1:
            score = -1
        else:
            score = calculated_score

        before_log_point = record.this_day_total_diet_Point
        before_fiber_point = record.total_Fiber_Point

        if meal == 0:
            record.this_day_breakfast_Point = min(max(score, int(record.this_day_breakfast_Point)), 10)
            record.this_day_breakfast_Fiber_Point = min(record.this_day_breakfast_Fiber_Point + 3, 3)
        elif meal == 1:
            record.this_day_lunch_Point = min(max(score, int(record.this_day_lunch_Point)), 10)
            record.this_day_lunch_Fiber_Point = min(record.this_day_lunch_Fiber_Point + 3, 3)
        elif meal == 2:
            record.this_day_dinner_Point = min(max(score, int(record.this_day_dinner_Point)), 10)
            record.this_day_dinner_Fiber_Point = min(record.this_day_dinner_Fiber_Point + 3, 3)
        elif meal == 3:
            record.this_day_snack1_Point = min(max(score, int(record.this_day_snack1_Point)), 10)
            record.this_day_snack1_Fiber_Point = min(record.this_day_snack1_Fiber_Point + 3, 3)
        elif meal == 4:
            record.this_day_snack2_Point = min(max(score, int(record.this_day_snack2_Point)), 10)
            record.this_day_snack2_Fiber_Point = min(record.this_day_snack2_Fiber_Point + 3, 3)
        record.total_Fiber_Point = min(record.this_day_breakfast_Fiber_Point + record.this_day_lunch_Fiber_Point +
                                       record.this_day_dinner_Fiber_Point + record.this_day_snack1_Fiber_Point +
                                       record.this_day_snack2_Fiber_Point, 15)
        record.save()

        u = updateTotalPointDay(user, record, isCall=score, is_Diet=True)

        try:
            notif = notif_cal(record.this_day_total_diet_Point - before_log_point, "غذا") if before_log_point != 10 else notif_cal(-100, "غذا")
            notif_fiber = notif_cal(record.total_Fiber_Point - before_fiber_point, "فیبر") if before_fiber_point != 15 else notif_cal(-100, "فیبر")
        except Exception as e:
            notif = ""
            notif_fiber = ""

        totalPoint = u["DayPoint"]
        record.total_points = totalPoint
        record.totalCooperationPoints = u["totalCooperate"]
        record.save()

        # todo: We need to change this section so that the valid dates for participating in the challenge
        #  are also considered...
        # if date_time.date() <= (last_diet.from_date + timedelta(days=7)):
        #     challenges = ChallengeSelection.objects.filter(user=user)
        #     for c in challenges:
        #         if c.challenge.category == 0:
        #             if c.challenge.sub_category == 5:  # cards
        #                 start_day = c.challenge.start_deadline.date()
        #                 end_day = c.challenge.end_deadline.date()
        #                 df = now - start_day
        #                 duration = df.days
        #                 if start_day <= now < end_day:
        #                     if today_start < date_time < today_end:
        #                         if model == 0 or model == 2:
        #                             c.day_status['status'][duration] = True
        #                             c.save()

        data = {
            "DayPoint": totalPoint,
            "notif_cal": notif,
            "notif_cal_fiber": notif_fiber
        }
        return myResponse.OK("Information on this meal(s) was recorded", data)

    # except ValueError as e:
    #     return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    # except Exception as e:
    #     return myResponse.Error(e.args[0], -1)
    else:
        try:
            RequsetChecker(request.GET, [
                {
                    "name": "token",
                    "format": "^(\S){30}$"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$"
                },
                {
                    "name": "start_date_time",
                    "format": "^[-+]?[0-9]{10}$",  # timestamp
                    # ex:  "1546270161"
                    "errorMessage": "تاریخ یا زمان شروع اشتباه وارد شده اند"
                },
                {
                    "name": "end_date_time",
                    "format": "^[-+]?[0-9]{10}$",  # timestamp
                    # ex:  "1546270161"
                    "errorMessage": "تاریخ یا زمان  پایان اشتباه وارد شده اند"
                },
                {
                    "name": "only_total",
                    "format": "^[0-1]$",  # 0 or 1 for true or false
                    "required": False
                }
            ], request)
            token = str(request.GET["token"])
            # phone = str(request.GET["phone_number"])
            # u = User.objects.filter(token=token, phone_number=phone)
            u = AppUser.objects.filter(token=token)
            if not u.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            user = u[0]

            sdt = int(request.GET["start_date_time"])
            edt = int(request.GET["end_date_time"])
            t1 = datetime.fromtimestamp(sdt)
            d1 = t1.date()
            t2 = datetime.fromtimestamp(edt)
            d2 = t2.date()

            if t1 > t2:
                return myResponse.Error(Errors.InvalidArgument.message,
                                        Errors.InvalidArgument.code)

            result = {
                "total_amount": 0,
                "total_calorie": 0,
                "total_fat": 0,
                "total_protein": 0,
                "total_carbohydrate": 0,
                "count": 0
            }

            # breakfast ********************************************
            temp = Eating.objects.filter(user=user, date_time__range=(t1, t2), meal=0)
            # return myResponse.OK("0",str(temp))
            breakfast = {
                "calorie": 0,
                "fat": 0,
                "protein": 0,
                "carbohydrate": 0
            }
            for i in range(temp.count()):  # meal=0 --> breakfast
                breakfast["calorie"] += round((temp[i].food.Calories * temp[i].amount) / 100, 2)
                breakfast["fat"] += round((temp[i].food.Fat_g * temp[i].amount) / 100, 2)
                breakfast["protein"] += round((temp[i].food.Protein_g * temp[i].amount) / 100, 2)
                breakfast["carbohydrate"] += round((temp[i].food.Carbohydrates_g * temp[i].amount) / 100, 2)

            # morning_snack ****************************************
            temp = Eating.objects.filter(user=user, date_time__range=(t1, t2), meal=1)
            # return myResponse.OK("1", str(temp))
            morning_snack = {
                "calorie": 0,
                "fat": 0,
                "protein": 0,
                "carbohydrate": 0
            }
            for i in range(temp.count()):  # meal=1 --> morning_snack
                morning_snack["calorie"] += round((temp[i].food.Calories * temp[i].amount) / 100, 2)
                morning_snack["fat"] += round((temp[i].food.Fat_g * temp[i].amount) / 100, 2)
                morning_snack["protein"] += round((temp[i].food.Protein_g * temp[i].amount) / 100, 2)
                morning_snack["carbohydrate"] += round((temp[i].food.Carbohydrates_g * temp[i].amount) / 100, 2)

            # lunch ************************************************
            temp = Eating.objects.filter(user=user, date_time__range=(t1, t2), meal=2)
            # return myResponse.OK("2", str(temp))
            lunch = {
                "calorie": 0,
                "fat": 0,
                "protein": 0,
                "carbohydrate": 0
            }
            for i in range(temp.count()):  # meal=2 --> lunch
                lunch["calorie"] += round((temp[i].food.Calories * temp[i].amount) / 100, 2)
                lunch["fat"] += round((temp[i].food.Fat_g * temp[i].amount) / 100, 2)
                lunch["protein"] += round((temp[i].food.Protein_g * temp[i].amount) / 100, 2)
                lunch["carbohydrate"] += round((temp[i].food.Carbohydrates_g * temp[i].amount) / 100, 2)

            # evening_snack ****************************************
            temp = Eating.objects.filter(user=user, date_time__range=(t1, t2), meal=3)
            # return myResponse.OK("3", str(temp))
            evening_snack = {
                "calorie": 0,
                "fat": 0,
                "protein": 0,
                "carbohydrate": 0
            }
            for i in range(temp.count()):  # meal=3 --> evening_snack
                evening_snack["calorie"] += round((temp[i].food.Calories * temp[i].amount) / 100, 2)
                evening_snack["fat"] += round((temp[i].food.Fat_g * temp[i].amount) / 100, 2)
                evening_snack["protein"] += round((temp[i].food.Protein_g * temp[i].amount) / 100, 2)
                evening_snack["carbohydrate"] += round((temp[i].food.Carbohydrates_g * temp[i].amount) / 100, 2)

            # dinner ***********************************************
            temp = Eating.objects.filter(user=user, date_time__range=(t1, t2), meal=4)
            # return myResponse.OK("4", str(temp))
            dinner = {
                "calorie": 0,
                "fat": 0,
                "protein": 0,
                "carbohydrate": 0
            }
            for i in range(temp.count()):  # meal=4 --> dinner
                dinner["calorie"] += round((temp[i].food.Calories * temp[i].amount) / 100, 2)
                dinner["fat"] += round((temp[i].food.Fat_g * temp[i].amount) / 100, 2)
                dinner["protein"] += round((temp[i].food.Protein_g * temp[i].amount) / 100, 2)
                dinner["carbohydrate"] += round((temp[i].food.Carbohydrates_g * temp[i].amount) / 100, 2)

            # night_snack ******************************************
            temp = Eating.objects.filter(user=user, date_time__range=(t1, t2), meal=5)
            # return myResponse.OK("5", str(temp))
            night_snack = {
                "calorie": 0,
                "fat": 0,
                "protein": 0,
                "carbohydrate": 0
            }
            for i in range(temp.count()):  # meal=5 --> night_snack
                night_snack["calorie"] += round((temp[i].food.Calories * temp[i].amount) / 100, 2)
                night_snack["fat"] += round((temp[i].food.Fat_g * temp[i].amount) / 100, 2)
                night_snack["protein"] += round((temp[i].food.Protein_g * temp[i].amount) / 100, 2)
                night_snack["carbohydrate"] += round((temp[i].food.Carbohydrates_g * temp[i].amount) / 100, 2)

            # all eating logs ******************************************
            items = []
            logs = Eating.objects.filter(user=user, date_time__range=(t1, t2))
            for i in range(logs.count()):
                item = {
                    "food_name": logs[i].food.FA_Name,
                    "id": logs[i].id,
                    "calorie": round((logs[i].food.Calories * int(logs[i].amount)) / 100, 2),
                    "fat": round((logs[i].food.Fat_g * logs[i].amount) / 100, 2),
                    "protein": round((logs[i].food.Protein_g * logs[i].amount) / 100, 2),
                    "carbohydrate": round((logs[i].food.Carbohydrates_g * logs[i].amount) / 100, 2),
                    "amount": logs[i].amount,
                    "point": logs[i].point,
                    "date_time": int(logs[i].date_time.timestamp()),
                    "meal": logs[i].meal
                }
                items.append(item)
                result["total_calorie"] += item['calorie']
                result["total_fat"] += item['fat']
                result["total_protein"] += item['protein']
                result["total_carbohydrate"] += item['carbohydrate']
                result["total_amount"] += logs[i].amount

            # target amounts:
            days = (d2 - d1).days + 1
            Carbohydrates_list_to_use = list(
                map(lambda x: days * x, getList(user.profile.Carbohydrates_distribution_list_g)))
            Fat_to_use = user.profile.Fat_distribution_g * days
            Protein_to_use = user.profile.Protein_distribution_g * days

            # set outputs ******************************************
            result["breakfast"] = breakfast
            result["morning_snack"] = morning_snack
            result["lunch"] = lunch
            result["evening_snack"] = evening_snack
            result["dinner"] = dinner
            result["night_snack"] = night_snack
            result["count"] = logs.count()
            result["days"] = days
            result["Carbohydrates_list_to_use"] = Carbohydrates_list_to_use
            result["Fat_to_use"] = Fat_to_use
            result["Protein_to_use"] = Protein_to_use

            if request.GET.get("only_total") is None or int(request.GET["only_total"]) is 0:
                result['list'] = items
            return myResponse.OK("List of foods consumed in this period along with analytical information", result)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], -1)


@api_view(["POST"])
def get_daily_notes(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",  # required
                "format": "^(\S)+$",  # required
                "required": True,  # optional default is true
            },
        ], request)
        token = request.POST.get("token")
        if token == None:
            return myResponse.Error(Errors.InvalidArgument.message, Errors.InvalidArgument.code)

        temp = AppUser.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        app_user = temp[0]
        daily_notes = DailyNote.objects.filter(patient=app_user)
        notes = []
        for note in daily_notes:
            item = {
                "message": note.text,
                "time": note.time,
                "therapist": note.writer_name,

            }
            notes.append(item)

        data = {
            'daily_notes': notes,
        }
        return myResponse.OK("daily notes", data)
    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def firebase_notifications(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "errorMessage": "Invalid token format"
            },
            {
                "name": "number",
                "format": "^[\d]+$",
                "errorMessage": "Invalid number format"
            }
        ], request)

        token = str(request.POST["token"])
        number = int(request.POST["number"])

        temp = AppUser.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
        user = temp[0]
        notifications = FirebaseNotification.objects.filter(user=user).order_by("-datetime")
        data = []
        limitation = min(notifications.count(), number)
        for i in range(limitation):
            notifications[i].seen = True
            notifications[i].save()
            data.append({
                "id": notifications[i].id,
                "title": notifications[i].title,
                "body": notifications[i].body,
                "datetime": int(notifications[i].datetime.timestamp())
            })
        return myResponse.OK("List of notifications", data)
    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST"])
def get_challenges(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S)+$",
                "required": True,
            },
        ], request)
        token = request.POST.get("token")
        if token is None:
            return myResponse.Error(Errors.InvalidArgument.message, Errors.InvalidArgument.code)

        temp = AppUser.objects.filter(token=token)
        therapist = temp[0].profile.therapist
        # print('profile.therapist')
        # print(temp[0].profile.therapist)
        # if therapist.groups.filter(name='Doctor'):
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        app_user = temp[0]

        django_user = app_user.django_user

        # Get the groups the user is a member of
        django_groups = django_user.groups.all()
        user_groups = ZiLuckGroup.objects.filter(group_ptr__in=django_groups)

        yesterday = datetime.now() - timedelta(days=1)
        challenges = Challenge.objects.filter(end_deadline__gt=yesterday, audience__in=user_groups).distinct()
        challenge_list = []
        for challenge in challenges:
            if challenge.creator.groups.filter(name='Doctor'):
                is_participate = False
                participants_data = []
                for user in challenge.participants.all():
                    profile = user.profile
                    try:
                        if (profile.image is None) or (profile.image == ''):
                            image_url = ""
                        else:
                            image_url = profile.image.url
                    except Exception as e:
                        image_url = ""
                        print("problem on image of profile {} on get challenges api call".format(profile.id))
                    if user.token == token:
                        is_participate = True
                    item2 = {
                        "name": profile.first_name,
                        "picture": image_url,
                    }
                    participants_data.append(item2)

                item = {
                    "id": challenge.id,
                    "name": challenge.name,
                    "reward": challenge.reward,
                    "fee": challenge.fee,
                    "start_deadline": int(challenge.start_deadline.timestamp()),
                    "end_deadline": int(challenge.end_deadline.timestamp()),
                    "description": challenge.description,
                    "participants_data": participants_data,
                    "category": challenge.category,
                    "sub_category": challenge.sub_category,
                    "is_participate": is_participate,
                    "key_factor": get_key_factor(challenge)
                }
                challenge_list.append(item)
            else:
                if challenge.creator == temp[0].profile.therapist:
                    is_participate = False
                    participants_data = []
                    for user in challenge.participants.all():
                        profile = user.profile
                        try:
                            if (profile.image is None) or (profile.image == ''):
                                image_url = ""
                            else:
                                image_url = profile.image.url
                        except Exception as e:
                            image_url = ""
                            print("problem on image of profile {} on get challenges api call".format(profile.id))
                        if user.token == token:
                            is_participate = True
                        item2 = {
                            "name": profile.first_name,
                            "picture": image_url,
                        }
                        participants_data.append(item2)

                    item = {
                        "id": challenge.id,
                        "name": challenge.name,
                        "reward": challenge.reward,
                        "fee": challenge.fee,
                        "start_deadline": int(challenge.start_deadline.timestamp()),
                        "end_deadline": int(challenge.end_deadline.timestamp()),
                        "description": challenge.description,
                        "participants_data": participants_data,
                        "category": challenge.category,
                        "sub_category": challenge.sub_category,
                        "is_participate": is_participate,
                        "key_factor": get_key_factor(challenge)
                    }
                    challenge_list.append(item)

        data = {
            'challenges': challenge_list,
        }
        return myResponse.OK("challenges", data)
    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(['POST'])
def assign_user_to_challenge(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "required": True
            },
            {
                "name": "challenge_id",
                "format": "^[\d]+$",
                "required": True
            }
        ], request)

        token = request.POST.get("token")
        challenge_id = int(request.POST.get("challenge_id"))
        user = AppUser.objects.filter(token=token).first()

        if user is None:
            return myResponse.Error('Invalid token', Errors.InvalidToken.code)

        challenge = Challenge.objects.filter(id=challenge_id).first()
        challenge_duration = (challenge.end_deadline.date() - challenge.start_deadline.date()).days

        if challenge is None:
            return myResponse.Error('Challenge not found', Errors.DataNotFound.code)
        if user.profile.coins >= challenge.fee:
            user.profile.coins = user.profile.coins - challenge.fee
            # Add the user to the challenge's participants
            challenge.participants.add(user)
            day_status = {
                'status': [False] * challenge_duration
            }
            challenge_selection = ChallengeSelection(challenge=challenge, user=user, day_status=day_status)
            challenge_selection.save()
            user.profile.save()
        else:
            return myResponse.Error('You dont have enough coins to challenge', {})

        return myResponse.OK('User successfully assigned to challenge', {"key_factor":
            get_key_factor(challenge)
        })


    except ValueError as e:
        return myResponse.Error(str(e), Errors.InvalidArgument.code)
    except Exception as e:
        return myResponse.Error(str(e), Errors.InternalError.code)


@api_view(['POST'])
def get_user_challenges(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "required": True
            },
        ], request)

        token = request.POST.get("token")
        if token is None:
            return myResponse.Error('Invalid token', Errors.InvalidToken.code)

        try:
            user = AppUser.objects.get(token=token)
        except not user.exists():
            return myResponse.Error({'error': 'User not found'}, Errors.NotFoundUser.code)

        user_challenges = user.participated_challenges.all()
        challenge_list = []
        for challenge in user_challenges:
            item = {
                "id": challenge.id,
                "name": challenge.name,
                "reward": challenge.reward,
                "fee": challenge.fee,
                "start_deadline": int(challenge.start_deadline.timestamp()),
                "end_deadline": int(challenge.end_deadline.timestamp()),
                "description": challenge.description,
                "key_factor": get_key_factor(challenge)
            }
            challenge_list.append(item)

        data = {
            'user_challenges': challenge_list,
        }

        return myResponse.OK("user_challenges", data)
    except Exception as e:
        return myResponse.Error({'error': str(e)}, Errors.InvalidArgument.code)


@api_view(['POST'])
def get_assistant_free_times(request):
    try:
        # Check if required parameters are present in the request
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "required": True
            },
        ], request)

        token = request.POST.get("token")
        if token == None:
            return myResponse.Error(Errors.InvalidArgument.message, Errors.InvalidArgument.code)

        temp = AppUser.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        app_user = temp[0]
        # assistant_free_times = TimeSlot.objects.filter(therapist_django_user=patient)
        assistant_free_times = TimeSlot.objects.filter(therapist_django_user=app_user.profile.therapist,
                                                       is_available=1)
        # assistant_free_times = TimeSlot.objects.filter(therapist_django_user=app_user)
        free_times = []
        for times in assistant_free_times:
            item = {
                "id": times.id,
                "days_of_week": times.days_of_week,
                "start_time": int(times.start_time.timestamp()),
                "duration": times.duration,
                "is_available": times.is_available,
                "appointment_link": times.appointment_link,
            }
            free_times.append(item)

        data = {
            'free_times': free_times,
        }

        return myResponse.OK("assistant_free_times", data)
    except Exception as e:
        return myResponse.Error({'error': str(e)}, Errors.InvalidArgument.code)


@api_view(['POST'])
def book_appointment(request):
    try:
        # Validate request parameters
        RequsetChecker(request.POST, [
            {"name": "token", "format": "^(\S){30}$", "required": True},
            {"name": "appointment_id", "format": "^[\d]+$", "required": True}
        ], request)

        token = request.POST.get("token")
        appointment_id = int(request.POST.get("appointment_id"))

        user = AppUser.objects.filter(token=token).first()
        if not user:
            return myResponse.Error('Invalid token', Errors.InvalidToken.code)

        # Fetch the time slot
        time_slot = TimeSlot.objects.filter(
            id=appointment_id,
            therapist_django_user=user.profile.therapist,
            is_available=1
        ).first()

        if not time_slot:
            return myResponse.Error('Appointment not found or not available', Errors.DataNotFound.code)

        # Check if user has available appointment credits
        appointment_credits = AppointmentCredit.objects.filter(user=user)
        total_credits = appointment_credits.aggregate(total=Sum('total_credits'))['total'] or 0
        used_credits = appointment_credits.aggregate(total=Sum('used_credits'))['total'] or 0
        available_credits = total_credits - used_credits

        if available_credits <= 0:
            return myResponse.Error('No appointment credits available.', Errors.InsufficientCoins.code)

        # Deduct an appointment credit
        # Find the earliest credit record with available credits
        credit_record = appointment_credits.filter(used_credits__lt=F('total_credits')).earliest(
            'purchase__purchase_date')
        credit_record.used_credits += 1
        credit_record.save()

        # Book the appointment
        time_slot.is_available = 0
        time_slot.patient = user
        time_slot.save()

        # Send notification (if applicable)
        name = f"{user.profile.first_name} {user.profile.last_name}"
        message = f"{name} با شما برای تاریخ {str(time_slot.start_time)} جلسه تنظیم نمود"
        TelegramNotification().send_message(temp=[user.profile.therapist], text=message)

        return myResponse.OK("Booked appointment", {})
    except Exception as e:
        print("Error booking appointment:", e)
        traceback.print_exc()
        return myResponse.Error({'error': str(e)}, Errors.InvalidArgument.code)


@api_view(['POST'])
def cancel_appointment(request):
    try:
        # Validate request parameters
        RequsetChecker(request.POST, [
            {"name": "token", "format": "^(\S){30}$", "required": True},
            {"name": "appointment_id", "format": "^[\d]+$", "required": True}
        ], request)

        token = request.POST.get("token")
        appointment_id = int(request.POST.get("appointment_id"))

        user = AppUser.objects.filter(token=token).first()
        if not user:
            return myResponse.Error('Invalid token', Errors.InvalidToken.code)

        # Fetch the time slot
        time_slot = TimeSlot.objects.filter(
            id=appointment_id,
            patient=user,
            is_available=0
        ).first()

        if not time_slot:
            return myResponse.Error('Appointment not found or not booked by user', Errors.DataNotFound.code)

        # Return the appointment credit
        # Find the latest credit record where used_credits > 0
        credit_record = AppointmentCredit.objects.filter(
            user=user,
            used_credits__gt=0
        ).latest('purchase__purchase_date')

        credit_record.used_credits -= 1
        credit_record.save()

        # Cancel the appointment
        time_slot.is_available = 1
        time_slot.patient = None
        time_slot.save()

        return myResponse.OK("Canceled appointment", {})
    except Exception as e:
        print("Error canceling appointment:", e)
        traceback.print_exc()
        return myResponse.Error({'error': str(e)}, Errors.InvalidArgument.code)


@api_view(['POST'])
def get_user_appointment(request):
    try:
        # Validate request parameters
        RequsetChecker(request.POST, [
            {"name": "token", "format": "^(\S){30}$", "required": True},
        ], request)

        token = request.POST.get("token")
        user = AppUser.objects.filter(token=token).first()
        if not user:
            return myResponse.Error('Invalid token', Errors.InvalidToken.code)

        # Get the user's booked appointments
        user_appointments = TimeSlot.objects.filter(patient=user, is_available=0)

        appointments = []
        for times in user_appointments:
            item = {
                "id": times.id,
                "days_of_week": times.days_of_week,
                "start_time": int(times.start_time.timestamp()),
                "duration": times.duration,
                "is_available": times.is_available,
                "appointment_link": times.appointment_link,
            }
            appointments.append(item)

        data = {'appointments': appointments}
        return myResponse.OK("User_appointments", data)
    except Exception as e:
        print("Error fetching user appointments:", e)
        traceback.print_exc()
        return myResponse.Error({'error': str(e)}, Errors.InvalidArgument.code)


@api_view(["POST"])
def get_items(request):
    try:
        RequsetChecker(request.POST, [{"name": "token", "format": "^(\S){30}$", "required": True}], request)
        token = request.POST.get("token")
        user = AppUser.objects.filter(token=token).first()
        if not user:
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        items_list = []
        items = Shop.objects.all()
        purchased_content_ids = Purchase.objects.filter(user=user, shop_item__service_type="content").values_list("shop_item_id", flat=True)
        active_diet_plan_ids = DietSubscription.objects.filter(user=user, end_date__gte=datetime.now().date()).values_list("diet_plan_id", flat=True)
        appointment_credits = AppointmentCredit.objects.filter(user=user)
        available_credits = (appointment_credits.aggregate(total=Sum('total_credits'))['total'] or 0) - (appointment_credits.aggregate(total=Sum('used_credits'))['total'] or 0)

        for item in items:
            is_purchased = False
            if item.service_type == "content" and item.id in purchased_content_ids:
                is_purchased = True
            elif item.service_type == "coaching":
                if item.tag == "diet" and item.id in active_diet_plan_ids:
                    is_purchased = True
                elif item.tag == "appointment" and available_credits > 0:
                    is_purchased = True
            elif item.service_type == "plan":
                ts = TherapistSelection.objects.filter(user=user.django_user).order_by('-created_at').first()
                is_purchased = ts and ts.has_credit()

            current_price = item.get_current_price()
            image_url = item.image.url if item.image else ""
            item_data = {
                "id": item.id,
                "name": item.name,
                "tag": item.tag,
                "service_type": item.service_type,
                "price": current_price,
                "original_price": item.price,
                "promotion_percentage": item.promotion_percentage,
                "promotion_end_date": item.promotion_end_date,
                "is_coin": item.is_coin,
                "description": item.description,
                "image": image_url,
                "is_purchased": is_purchased,
                "duration_months": item.duration_months if item.service_type == "plan" else None,
                "plan_type": item.get_plan_type_display() if item.service_type == "plan" else None,
            }
            items_list.append(item_data)

        return myResponse.OK("items", {"items": items_list})

    except Exception as e:
        return myResponse.Error(str(e), Errors.InternalError.code)


@api_view(['POST'])
@transaction.atomic  # Ensures all database operations succeed or roll back
def buy_item(request):
    try:
        RequsetChecker(request.POST, [
            {"name": "token", "format": "^(\S){30}$", "required": True},
            {"name": "item_id", "format": "^[\d]+$", "required": True},
            {"name": "duration", "format": "^[\d]+$", "required": False},
            {"name": "appointment_credits", "format": "^[\d]+$", "required": False},
        ], request)

        token = request.POST.get("token")
        item_id = int(request.POST.get("item_id"))
        user = AppUser.objects.filter(token=token).first()
        if not user:
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        item = Shop.objects.filter(id=item_id).first()
        if not item:
            return myResponse.Error('Item not found', Errors.DataNotFound.code)

        total_price = item.get_current_price()
        if not item.is_coin:
            return myResponse.Error('This item cannot be purchased with coins', Errors.InvalidArgument.code)

        if user.profile.coins < total_price:
            return myResponse.Error(Errors.InsufficientCoins.message, Errors.InsufficientCoins.code)

        # Perform all operations before deducting coins
        purchase = Purchase.objects.create(user=user, shop_item=item)

        if item.service_type == 'plan':
            ts = TherapistSelection.objects.filter(user=user.django_user).order_by('-created_at').first()
            if not ts:
                ts = TherapistSelection.objects.create(user=user.django_user)
            days = item.duration_months * 30
            ts.add_credit(days)
            if not ts.therapist and Doctor.objects.exists():
                doctor = Doctor.objects.first()  # Adjust as needed
                ts.therapist = doctor.django_user
                user.profile.therapist = doctor.django_user
                user.profile.save()
                ts.save()
            credits = {1: 6, 2: 8, 3: 8}.get(item.plan_type, 2)
            AppointmentCredit.objects.create(user=user, total_credits=credits)

        elif item.service_type == 'coaching' and item.tag == 'diet':
            duration_weeks = int(request.POST.get("duration", 0))
            if duration_weeks <= 0:
                return myResponse.Error('Duration must be positive', Errors.InvalidArgument.code)
            DietSubscription.objects.create(user=user, diet_plan=item, duration_weeks=duration_weeks)

        elif item.service_type == 'coaching' and item.tag == 'appointment':
            total_credits = int(request.POST.get("appointment_credits", 0))
            if total_credits <= 0:
                return myResponse.Error('Credits must be positive', Errors.InvalidArgument.code)
            AppointmentCredit.objects.create(user=user, purchase=purchase, total_credits=total_credits)

        elif item.service_type == 'content' and Purchase.objects.filter(user=user, shop_item=item).exists():
            return myResponse.Error(Errors.ItemAlreadyPurchased.message, Errors.ItemAlreadyPurchased.code)

        # Deduct coins only after all operations succeed
        user.profile.coins -= total_price
        user.profile.save()

        return myResponse.OK('User successfully bought the item', {})

    except Exception as e:
        return myResponse.Error(str(e), Errors.InternalError.code)


@api_view(['POST'])
def get_user_items(request):
    try:
        # Validate the request for token validity
        RequsetChecker(request.POST, [
            {"name": "token", "format": "^(\S){30}$", "required": True}
        ], request)

        # Retrieve user based on the token
        token = request.POST.get("token")
        user = AppUser.objects.filter(token=token).first()

        if user is None:
            return myResponse.Error('Invalid token', Errors.InvalidToken.code)

        data = {}

        # Get content items purchased
        content_purchases = Purchase.objects.filter(user=user, shop_item__service_type='content')
        content_items = []
        for purchase in content_purchases:
            shop_item = purchase.shop_item
            item_data = {
                "id": shop_item.id,
                "name": shop_item.name,
                "tag": shop_item.tag,
                "service_type": shop_item.service_type,
                "price": shop_item.price,
                "is_coin": shop_item.is_coin,
                "description": shop_item.description,
                "purchase_date": purchase.purchase_date,
            }
            try:
                content_service = ContentService.objects.get(shop_item=shop_item)
                videos = content_service.videos.all()
                pdf_files = content_service.pdf_files.all()

                item_data["videos"] = [video.file_path.url for video in videos]
                item_data["pdf_files"] = [pdf.file_path.url for pdf in pdf_files]
            except ContentService.DoesNotExist:
                pass
            content_items.append(item_data)

        data['content_items'] = content_items

        # Get active diet subscriptions
        diet_subscriptions = DietSubscription.objects.filter(user=user, end_date__gte=date.today())
        diet_items = []
        for diet in diet_subscriptions:
            item_data = {
                "diet_plan_id": diet.diet_plan.id,
                "name": diet.diet_plan.name,
                "tag": diet.diet_plan.tag,
                "service_type": diet.diet_plan.service_type,
                "description": diet.diet_plan.description,
                "start_date": diet.start_date,
                "end_date": diet.end_date,
                "duration_weeks": diet.duration_weeks,
            }
            diet_items.append(item_data)

        data['diet_subscriptions'] = diet_items

        # Get appointment credits
        appointment_credits = AppointmentCredit.objects.filter(user=user)
        # Prepare detailed credit info for each entry
        detailed_credits = []
        for credit in appointment_credits:
            detailed_credits.append({
                'id': credit.id,  # ID of the AppointmentCredit entry
                'purchase_id': credit.purchase.id if credit.purchase else None,  # ID of the Purchase entry
                'total_credits': credit.total_credits,
                'used_credits': credit.used_credits,
                'remaining_credits': credit.total_credits - credit.used_credits,
                'purchase_date': credit.purchase.purchase_date if credit.purchase else None,
                # Date of the original purchase
            })
        # total_credits = appointment_credits.aggregate(total=Sum('total_credits'))['total'] or 0
        # used_credits = appointment_credits.aggregate(total=Sum('used_credits'))['total'] or 0
        # available_credits = total_credits - used_credits

        data['appointment_credits'] = detailed_credits

        return myResponse.OK("User items retrieved successfully", data)

    except ValueError as e:
        return myResponse.Error(str(e), Errors.InvalidArgument.code)
    except Exception as e:
        return myResponse.Error(str(e), Errors.InternalError.code)


@api_view(["POST"])
def add_new_food(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن را درست وارد کنید"
                },
                {
                    "name": "time",
                    "format": "^[-+]?[0-9]{10}$",  # timestamp
                    # ex:  "1546270161",
                    "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند"
                },
                {
                    "name": "food_name",
                    "format": ".",
                    "errorMessage": "نام غذا را وارد کنید"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = AppUser.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            user = temp[0]

            food_name = str(request.POST["food_name"])
            dt = int(request.POST["time"])
            date_time = datetime.fromtimestamp(dt)

            try:
                new_food = RequestedFoods(user=user, food_name=food_name, time=date_time)
                new_food.save()
            except:
                return myResponse.Error({'error': 'Error on saving the food'}, {})

            return myResponse.OK('User successfully add new food', {})
        except ValueError as e:
            return myResponse.Error(str(e), Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(str(e), Errors.InternalError.code)


@api_view(["POST"])
def add_microbiome_analysis(request):
    if request.method == "POST":
        try:
            # Check the request parameters using the RequsetChecker function
            RequsetChecker(request.POST, [
                {"name": "token", "format": "^(\S){30}$", "errorMessage": "Invalid token format."},
                {"name": "microbiome_age", "format": "^\d+$", "errorMessage": "Invalid microbiome age."},
                {"name": "microbiome_diversity", "format": "^\d+(\.\d+)?$",
                 "errorMessage": "Invalid microbiome diversity."},
                {"name": "carbohydrate_metabolism_current", "format": "^\d+$",
                 "errorMessage": "Invalid carbohydrate metabolism current."},
                {"name": "carbohydrate_metabolism_avg", "format": "^\d+$",
                 "errorMessage": "Invalid carbohydrate metabolism average."},
                {"name": "metabolic_score_current", "format": "^\d+$",
                 "errorMessage": "Invalid metabolic score current."},
                {"name": "metabolic_score_avg", "format": "^\d+$", "errorMessage": "Invalid metabolic score average."},
                {"name": "protein_metabolism_current", "format": "^\d+$",
                 "errorMessage": "Invalid protein metabolism current."},
                {"name": "protein_metabolism_avg", "format": "^\d+$",
                 "errorMessage": "Invalid protein metabolism average."},
                {"name": "fat_metabolism_current", "format": "^\d+$",
                 "errorMessage": "Invalid fat metabolism current."},
                {"name": "fat_metabolism_avg", "format": "^\d+$", "errorMessage": "Invalid fat metabolism average."},
                {"name": "sleep_quality_current", "format": "^\d+$", "errorMessage": "Invalid sleep quality current."},
                {"name": "sleep_quality_avg", "format": "^\d+$", "errorMessage": "Invalid sleep quality average."},
                {"name": "lactose_sensitivity_current", "format": "^\d+$",
                 "errorMessage": "Invalid lactose sensitivity current."},
                {"name": "lactose_sensitivity_avg", "format": "^\d+$",
                 "errorMessage": "Invalid lactose sensitivity average."},
                {"name": "vitamin_synthesis_current", "format": "^\d+$",
                 "errorMessage": "Invalid vitamin synthesis current."},
                {"name": "vitamin_synthesis_avg", "format": "^\d+$",
                 "errorMessage": "Invalid vitamin synthesis average."},
                {"name": "processed_food_index_current", "format": "^\d+$",
                 "errorMessage": "Invalid processed food index current."},
                {"name": "processed_food_index_avg", "format": "^\d+$",
                 "errorMessage": "Invalid processed food index average."},
                {"name": "sugar_index_current", "format": "^\d+$", "errorMessage": "Invalid sugar index current."},
                {"name": "sugar_index_avg", "format": "^\d+$", "errorMessage": "Invalid sugar index average."},
                {"name": "autoimmune_index_current", "format": "^\d+$",
                 "errorMessage": "Invalid autoimmune index current."},
                {"name": "autoimmune_index_avg", "format": "^\d+$",
                 "errorMessage": "Invalid autoimmune index average."},
                {"name": "bowel_mobility_current", "format": "^\d+$",
                 "errorMessage": "Invalid bowel mobility current."},
                {"name": "bowel_mobility_avg", "format": "^\d+$", "errorMessage": "Invalid bowel mobility average."},
                {"name": "gluten_sensitivity_current", "format": "^\d+$",
                 "errorMessage": "Invalid gluten sensitivity current."},
                {"name": "gluten_sensitivity_avg", "format": "^\d+$",
                 "errorMessage": "Invalid gluten sensitivity average."},
                {"name": "antibiotic_damage_current", "format": "^\d+$",
                 "errorMessage": "Invalid antibiotic damage current."},
                {"name": "antibiotic_damage_avg", "format": "^\d+$",
                 "errorMessage": "Invalid antibiotic damage average."},
            ])

            # Retrieve and validate the token
            token = request.POST.get("token")
            user = AppUser.objects.filter(token=token).first()
            if not user:
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            # Create and save a new MicrobiomeAnalysis entry
            new_microbiome_analysis = MicrobiomeAnalysis(
                user=user,
                microbiome_age=int(request.POST.get("microbiome_age")),
                microbiome_diversity=request.POST.get("microbiome_diversity"),
                carbohydrate_metabolism_current=int(request.POST.get("carbohydrate_metabolism_current")),
                carbohydrate_metabolism_avg=int(request.POST.get("carbohydrate_metabolism_avg")),
                metabolic_score_current=int(request.POST.get("metabolic_score_current")),
                metabolic_score_avg=int(request.POST.get("metabolic_score_avg")),
                protein_metabolism_current=int(request.POST.get("protein_metabolism_current")),
                protein_metabolism_avg=int(request.POST.get("protein_metabolism_avg")),
                fat_metabolism_current=int(request.POST.get("fat_metabolism_current")),
                fat_metabolism_avg=int(request.POST.get("fat_metabolism_avg")),
                sleep_quality_current=int(request.POST.get("sleep_quality_current")),
                sleep_quality_avg=int(request.POST.get("sleep_quality_avg")),
                lactose_sensitivity_current=int(request.POST.get("lactose_sensitivity_current")),
                lactose_sensitivity_avg=int(request.POST.get("lactose_sensitivity_avg")),
                vitamin_synthesis_current=int(request.POST.get("vitamin_synthesis_current")),
                vitamin_synthesis_avg=int(request.POST.get("vitamin_synthesis_avg")),
                processed_food_index_current=int(request.POST.get("processed_food_index_current")),
                processed_food_index_avg=int(request.POST.get("processed_food_index_avg")),
                sugar_index_current=int(request.POST.get("sugar_index_current")),
                sugar_index_avg=int(request.POST.get("sugar_index_avg")),
                autoimmune_index_current=int(request.POST.get("autoimmune_index_current")),
                autoimmune_index_avg=int(request.POST.get("autoimmune_index_avg")),
                bowel_mobility_current=int(request.POST.get("bowel_mobility_current")),
                bowel_mobility_avg=int(request.POST.get("bowel_mobility_avg")),
                gluten_sensitivity_current=int(request.POST.get("gluten_sensitivity_current")),
                gluten_sensitivity_avg=int(request.POST.get("gluten_sensitivity_avg")),
                antibiotic_damage_current=int(request.POST.get("antibiotic_damage_current")),
                antibiotic_damage_avg=int(request.POST.get("antibiotic_damage_avg")),
            )

            # Save the template
            new_microbiome_analysis.save()

            return myResponse.OK('Successfully added a new microbiome analysis.', {})

        # Handle validation errors
        except ValueError as e:
            return myResponse.Error(str(e), Errors.InvalidArgument.code)

        # Catch-all for any other exceptions
        except Exception as e:
            return myResponse.Error(str(e), Errors.InternalError.code)


@api_view(["POST"])
def get_microbiome_analysis(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",  # required
                "format": "^(\S)+$",  # required
                "required": True,
            },
        ])

        # Get token from the request
        token = request.POST.get("token")
        if token is None:
            return myResponse.Error(Errors.InvalidArgument.message, Errors.InvalidArgument.code)

        # Verify if the token belongs to a valid user
        user = AppUser.objects.filter(token=token).first()
        if not user:
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        # Fetch all MicrobiomeAnalysis entries for the user
        microbiome_analyses = MicrobiomeAnalysis.objects.filter(user=user)
        analyses_data = []

        # Prepare the data to return
        for analysis in microbiome_analyses:
            item = {
                "microbiome_age": analysis.microbiome_age,
                "microbiome_diversity": analysis.microbiome_diversity,
                "carbohydrate_metabolism_current": analysis.carbohydrate_metabolism_current,
                "carbohydrate_metabolism_avg": analysis.carbohydrate_metabolism_avg,
                "metabolic_score_current": analysis.metabolic_score_current,
                "metabolic_score_avg": analysis.metabolic_score_avg,
                "protein_metabolism_current": analysis.protein_metabolism_current,
                "protein_metabolism_avg": analysis.protein_metabolism_avg,
                "fat_metabolism_current": analysis.fat_metabolism_current,
                "fat_metabolism_avg": analysis.fat_metabolism_avg,
                "sleep_quality_current": analysis.sleep_quality_current,
                "sleep_quality_avg": analysis.sleep_quality_avg,
                "lactose_sensitivity_current": analysis.lactose_sensitivity_current,
                "lactose_sensitivity_avg": analysis.lactose_sensitivity_avg,
                "vitamin_synthesis_current": analysis.vitamin_synthesis_current,
                "vitamin_synthesis_avg": analysis.vitamin_synthesis_avg,
                "processed_food_index_current": analysis.processed_food_index_current,
                "processed_food_index_avg": analysis.processed_food_index_avg,
                "sugar_index_current": analysis.sugar_index_current,
                "sugar_index_avg": analysis.sugar_index_avg,
                "autoimmune_index_current": analysis.autoimmune_index_current,
                "autoimmune_index_avg": analysis.autoimmune_index_avg,
                "bowel_mobility_current": analysis.bowel_mobility_current,
                "bowel_mobility_avg": analysis.bowel_mobility_avg,
                "gluten_sensitivity_current": analysis.gluten_sensitivity_current,
                "gluten_sensitivity_avg": analysis.gluten_sensitivity_avg,
                "antibiotic_damage_current": analysis.antibiotic_damage_current,
                "antibiotic_damage_avg": analysis.antibiotic_damage_avg,
                "created_at": analysis.created_at.strftime('%Y-%m-%d %H:%M:%S'),
            }
            analyses_data.append(item)

        data = {
            "microbiome_analyses": analyses_data,
        }
        return myResponse.OK("Microbiome analysis data", data)

    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)

    except Exception as e:
        return myResponse.Error(f"Error: {str(e)}", Errors.InternalError.code)


@api_view(["POST"])
def get_coin_price(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن را درست وارد کنید"
                }
            ])

            token = str(request.POST["token"])
            temp = AppUser.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            price_of_coin = CoinValue.objects.all().last().price_of_coin

            data = {
                'price_of_coin': price_of_coin
            }
            return myResponse.OK('successful', data)
        except ValueError as e:
            return myResponse.Error(str(e), Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(str(e), Errors.InternalError.code)


@api_view(["POST"])
def add_coin_price(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن را درست وارد کنید"
                },
                {
                    "name": "price",
                    "format": "^[0-9]+(\.[0-9]{1,2})?$",
                    "errorMessage": "قیمت را درست وارد کنید."
                }
            ])

            token = str(request.POST["token"])
            temp = AppUser.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            price = request.POST["price"]

            try:
                new_price = CoinValue(price_of_coin=price)
                new_price.save()
                return myResponse.OK('قیمت آپدیت شد.', {})
            except Exception as e:
                return myResponse.Error(str(e), Errors.InternalError.code)
        except ValueError as e:
            return myResponse.Error(str(e), Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(str(e), Errors.InternalError.code)


@api_view(["POST"])
def show_user_daily_points(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن را درست وارد کنید"
                },
                {
                    "name": "start_date_time",
                    "format": "^[-+]?[0-9]{10}$",  # timestamp
                    # ex:  "1546270161"
                    "errorMessage": "تاریخ یا زمان شروع اشتباه وارد شده اند"
                },
                {
                    "name": "end_date_time",
                    "format": "^[-+]?[0-9]{10}$",  # timestamp
                    # ex:  "1546270161"
                    "errorMessage": "تاریخ یا زمان  پایان اشتباه وارد شده اند"
                },
            ])

            token = str(request.POST["token"])
            temp = AppUser.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            user = temp[0]

            sdt = int(request.POST["start_date_time"])
            edt = int(request.POST["end_date_time"])

            t1 = datetime.fromtimestamp(sdt)
            d1 = t1.date()
            t2 = datetime.fromtimestamp(edt)
            d2 = t2.date()

            if t1 > t2:
                return myResponse.Error(Errors.InvalidArgument.message,
                                        Errors.InvalidArgument.code)

            points = Points.objects.filter(user=user, date__range=(d1, d2)).values()

            # Convert QuerySet to a list
            points_list = list(points)

            diet_point_max = 40
            sleep_point_max = 10
            exercise_point_max = 5
            water_point_max = 5

            data = {
                'points': points_list,
                'diet_point_max': diet_point_max,
                'sleep_point_max': sleep_point_max,
                'exercise_point_max': exercise_point_max,
                'water_point_max': water_point_max
            }
            return myResponse.OK('successful', data)

        except ValueError as e:
            return myResponse.Error(str(e), Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(str(e), Errors.InternalError.code)




@api_view(["POST"])
def ai_chat(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "required": True
            },
            {
                "name": "message",
                "format": ".",
                "required": True
            },
        ])
        
        user = AppUser.objects.filter(token=request.POST.get("token")).first()
        if not user:
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        user_profile = user.profile
        if not user_profile:
            return myResponse.Error(Errors.InvalidUserProfile.message, Errors.InvalidUserProfile.code)

        
        token = request.POST.get("token")
        message = request.POST.get("message")
        
        
        system_instruction = """
THE SYSTEM INSTRUCTIONS (The "Brain")

IDENTITY & ROLE You are the "Lacto AI Coach," a warm, empathetic, and expert lifestyle assistant for the Lacto mobile app. You help people with chronic conditions (like Diabetes, PCOS, Fatty Liver) manage their nutrition, exercise, and habits. You are NOT a doctor; you are a supportive companion.

TONE & PERSONALITY

Sisterly & Supportive: Use a warm, encouraging tone. Mimic a caring friend.

Language: Respond exclusively in Persian.

Persian Nuances: Use "Shoma" (formal) but maintain warmth. Use terms like "عزیزم" (Dear), "جانم" (My dear), and "خسته نباشی" (Good job/Hope you aren't tired).

No Judgment: If a user logs a "bad" food or fails a goal, never shame them. Say "فدای سرت" (Don't worry about it) and suggest a small, positive next step.

Celebrate Wins: Use emojis (💗, 😍, ✨, 🌸) to celebrate small successes.

STRICT SAFETY BOUNDARIES (CRITICAL)

No Medical Advice: You are strictly forbidden from prescribing medication, suggesting dosages (e.g., "Take 500mg of X"), or diagnosing symptoms.

Refusal Logic: If a user asks for medical advice or a diagnosis, you must say: "عزیزم، من به عنوان مربی سبک زندگی لاکتو اجازه ندارم در مورد دارو یا تشخیص بیماری‌ها نظر بدم. این موضوع خیلی حساسه و حتماً باید با پزشکت مشورت کنی. اما من می‌تونم بهت کمک کنم رژیم غذایی و عادت‌هات رو طوری تنظیم کنی که حالت بهتر بشه."

CRITICAL: Distinguish between 'Nutrition' and 'Medication'. "
    "1. If asked about PROTEIN, CARBS, or FOOD quantities for a disease, ALWAYS ANSWER using nutritional guidelines. "
    "2. If asked about PILLS, DRUGS, or DIAGNOSIS, REFUSE and refer to a doctor. 
    
Approved Topics: Focus only on food recommendations, avoidance, exercise, sleep hygiene, and stress management.

RESPONSE LOGIC

Acknowledge Data: Always look at the provided User Logs. If the user ate something specific or didn't sleep well, mention it naturally in your response.

The "Why": Explain why you are suggesting something (e.g., "Sourdough bread is better for your gut bacteria").

Small Steps: Suggest easy, 5-10 minute actions rather than overwhelming changes.

دسترسی به داده‌ها (Data Access Knowledge): تو به عنوان مربی لاکتو، به تمامی گزارش‌هایی که کاربر در اپلیکیشن ثبت می‌کند (شامل غذا، فعالیت بدنی، خواب و میزان آب مصرفی) دسترسی داری. ۱. اگر کاربر در مورد چیزی پرسید که در بخش [RECENT LOGS] وجود داشت، با جزئیات پاسخ بده. ۲. اگر کاربر پرسید "من چی خوردم؟" یا "چقدر خوابیدم؟" و اطلاعاتی در بخش Logs نبود، هرگز نگو "من دسترسی ندارم". در عوض بگو: «عزیزم، من به گزارش‌های تو دسترسی دارم، اما انگار هنوز این مورد رو در اپلیکیشن ثبت نکردی. حتماً برو توی اپ و ثبتش کن تا من بتونم دقیق‌تر راهنمایی‌ت کنم.» ۳. همیشه کاربر را تشویق کن که تمام جزئیات روزانه‌اش را در اپلیکیشن لاکتو وارد کند.

DATA-DRIVEN PERSONALIZATION (MANDATORY)

The most important rule for the Lacto Coach is to be "Data-Aware." You must bridge the gap between generic advice and the user's actual life by strictly following these guidelines:

Prioritize Logs: Always check the [RECENT LOGS] section before answering. If a user asks a general question (e.g., "Why am I tired?"), look for evidence in their logs (e.g., "I see you only slept 5 hours last night" or "You haven't logged any water intake today").

The "Yes, I See You" Principle: You must act as if you are looking at the user's dashboard in real-time. Use phrases like:

"طبق گزارش‌هایی که ثبت کردی..." (According to the logs you registered...)

"دیدم که امروز..." (I saw that today you...)

"بر اساس اطلاعاتی که در اپلیکیشن داریم..." (Based on the info we have in the app...)

Closing the Loop: If a user mentions a physical feeling (fatigue, hunger, stress), correlate it with their data. If the data is missing, tell them: "عزیزم، من برای اینکه بتونم دقیق‌تر راهنمایی‌ت کنم نیاز دارم گزارش‌های امروزت رو ببینم. حتماً [غذا/خواب/آب] رو در اپلیکیشن ثبت کن تا با هم علتش رو پیدا کنیم."

No Generic Responses: Avoid saying "It's important to eat healthy." Instead, say "Because you have [Condition] and I see you ate [Specific Food] for lunch, let's try to add some fiber to your dinner."
"""

        messages = [{"role": "system", "content": system_instruction}]
        
        refrence_prompt = f"""
## USER_PROFILE
- User Name: {user.profile.first_name}
- User Gender: {"زن" if user.profile.gender == 1 else "مرد"}
- User Age: {user.profile.age}
- User Weight: {user.profile.weight}
- User Height: {user.profile.height}
- User Diseases: {user.profile.diseases}

## RECENT_LOGS (Last 48 Hours)

"""

        recent_logs = Eating.objects.filter(user=user, date_time__gte=datetime.now() - timedelta(hours=48)).order_by('-date_time')
        
        for log in recent_logs:
            refrence_prompt += f"""
- Food: {log.food.FA_Name}
- Amount: {log.amount}
- Time: {log.date_time}
- Meal: {"Breakfast" if log.meal == 0 else "Lunch" if log.meal == 1 else "Dinner" if log.meal == 2 else "Snack"}
"""


        recent_sleep = Sleep.objects.filter(user=user, time__gte=datetime.now() - timedelta(hours=48)).order_by('-time')
        
        for sleep in recent_sleep:
            refrence_prompt += f"""
- Sleep Time (start, end): {sleep.start} , {sleep.end}
"""
    
    
        # Add the latest 10 chat messages where either the sender or receiver is the user
        recent_convos = Message.objects.filter(
            models.Q(receiver=user.django_user) | models.Q(sender=user.django_user)
        ).order_by('-time')[:10]
        refrence_prompt += "## RECENT_CONVERSATIONS (Last 10, either sent or received by user):"
        for convo in reversed(recent_convos):
            sender_name = getattr(convo.sender.profile, 'first_name', '') if hasattr(convo.sender, 'profile') else 'Unknown'
            refrence_prompt += f"- {convo.time}: {sender_name}: {convo.text}"

        recent_activities = Activities_log.objects.filter(
            user=user, 
            start_date_time__gte=datetime.now() - timedelta(hours=48)
        ).order_by('-start_date_time')
        
        for activity in recent_activities:
            activity_name = activity.activity.name if activity.activity else "Unknown"
            refrence_prompt += f"""
    - Activity: {activity_name}
    - Amount: {activity.amount}
    - Start Time: {activity.start_date_time}
    - End Time: {activity.end_date_time}
    """
    
        # Add the user's water intake logs for the last 48 hours
        recent_waters = Water.objects.filter(user=user, time__gte=datetime.now() - timedelta(hours=48)).order_by('-time')
        refrence_prompt += "## RECENT_WATER_INTAKES (Last 48 Hours)\n"
        if recent_waters.exists():
            for water in recent_waters:
                refrence_prompt += f"- Amount: {water.amount} Glass, Time: {water.time}\n"
        else:
            refrence_prompt += "- No water intake logs found in the last 48 hours.\n"
    
        refrence_prompt += f"""## User Message: 
        {message}
        """
       
        messages.append({"role": "user", "content": message})

        client = OpenAI(api_key="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")
        response = client.chat.completions.create(
            model="gpt-4o-mini",  # Best for Persian + lowest cost in 2025
            messages=messages,
            temperature=0.7,      # Keeps the tone human and warm
            max_tokens=500        # Caps response length to prevent high costs
        )    
        
        ai_response_content = response.choices[0].message.content
        
        # Save the conversation to the database
        AIChatMessage.objects.create(
            user=user,
            user_message=message,
            ai_response=ai_response_content,
            created_at=datetime.now()
        )
        
        return myResponse.OK("Success", {
            "response": ai_response_content
        })
    except ValueError as e:
        return myResponse.Error(str(e), Errors.InvalidArgument.code)
    except Exception as e:
        return myResponse.Error(str(e), Errors.InternalError.code)


@api_view(["POST"])
def get_ai_chats(request):
    """
    API endpoint to retrieve all AI chat messages for the authenticated user.
    Returns all user messages and AI responses in chronological order.
    """
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "required": True
            },
        ])
        
        user = AppUser.objects.filter(token=request.POST.get("token")).first()
        if not user:
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        # Get all AI chat messages for this user, ordered by most recent first
        chat_messages = AIChatMessage.objects.filter(user=user).order_by('-created_at')
        
        # Format the messages for response
        messages_list = []
        for msg in chat_messages:
            messages_list.append({
                "id": msg.id,
                "user_message": msg.user_message,
                "ai_response": msg.ai_response,
                "created_at": msg.created_at.strftime("%Y-%m-%d %H:%M:%S") if msg.created_at else None,
                "conversation_id": msg.conversation_id if msg.conversation_id else None
            })
        
        return myResponse.OK("Success", {
            "messages": messages_list,
            "total_count": len(messages_list)
        })
    except ValueError as e:
        return myResponse.Error(str(e), Errors.InvalidArgument.code)
    except Exception as e:
        return myResponse.Error(str(e), Errors.InternalError.code)