from panel.models import *
from django.contrib import admin


class DoctorAdmin(admin.ModelAdmin):
    list_display = ('id',
                    'phone',
                    'django_user_id',
                    'first_name',
                    'last_name')
    search_fields = ['last_name']


try:
    # admin.site.unregister(Doctor)
    admin.site.register(Doctor, DoctorAdmin)

except Exception as e:
    print(e)

admin.site.register(Assistant)
admin.site.register(Manager)

admin.site.register(Attachment)
admin.site.register(MedicalNote)
admin.site.register(Field)


class BodyAnalysisReportAdmin(admin.ModelAdmin):
    list_display = ('id', 'patient', 'created_by', 'status', 'created_at', 'shared_at')
    list_filter = ('status', 'created_at', 'shared_at')
    search_fields = ('patient__first_name', 'patient__last_name', 'patient__email',
                     'created_by__first_name', 'created_by__last_name', 'created_by__username')
    date_hierarchy = 'created_at'
    ordering = ('-created_at',)
    readonly_fields = ('created_at', 'updated_at', 'shared_at')
    
    fieldsets = (
        ('Basic Information', {
            'fields': ('patient', 'created_by', 'status')
        }),
        ('Report Data', {
            'fields': ('image', 'report_data', 'error_message')
        }),
        ('Timestamps', {
            'fields': ('created_at', 'updated_at', 'shared_at'),
            'classes': ('collapse',)
        })
    )


admin.site.register(BodyAnalysisReport, BodyAnalysisReportAdmin)


class TherapistSelectionAdmin(admin.ModelAdmin):
    list_display = ('id',
                    'user',
                    'created_at',
                    'credit',)
    search_fields = ['credit', 'user__first_name', 'user__last_name', 'user__email',
                     'therapist__first_name', 'therapist__last_name', 'therapist__email',
                     'therapist__username', 'user__username']


admin.site.register(TherapistSelection, TherapistSelectionAdmin)


class DailyNoteAdmin(admin.ModelAdmin):
    list_display = []
    for field in DailyNote._meta.get_fields():
        list_display.append(field.name)
    search_fields = list_display


admin.site.register(DailyNote, DailyNoteAdmin)


class MessageAdmin(admin.ModelAdmin):
    list_display = []
    for field in Message._meta.get_fields():  # Exclude the reply_message field
        list_display.append(field.name)
    list_display.remove('replies')
    search_fields = list_display


admin.site.register(Message, MessageAdmin)


class ChallengeAdmin(admin.ModelAdmin):
    list_display = []
    for field in Challenge._meta.get_fields():
        list_display.append(field.name)
    list_display.remove('participants')
    list_display.remove('challengeselection')
    list_display.remove('audience')
    list_display.remove('audience_users')
    search_fields = list_display


admin.site.register(Challenge, ChallengeAdmin)



class ChallengeSelectionAdmin(admin.ModelAdmin):
    list_display = []
    for field in ChallengeSelection._meta.get_fields():
        list_display.append(field.name)
    search_fields = list_display


admin.site.register(ChallengeSelection, ChallengeSelectionAdmin)


# Manager Dashboard Models Admin

# CompanyAdmin removed - using ZiLuckGroup instead


class LeadAdmin(admin.ModelAdmin):
    list_display = ('company_name', 'contact_name', 'status', 'priority', 
                    'estimated_value', 'estimated_licenses', 'assigned_to', 
                    'next_follow_up_date', 'created_at')
    list_filter = ('status', 'priority', 'industry', 'source', 'assigned_to', 'created_at')
    search_fields = ('company_name', 'contact_name', 'contact_email', 'industry')
    date_hierarchy = 'created_at'
    ordering = ('-updated_at',)
    
    fieldsets = (
        ('Company Information', {
            'fields': ('company_name', 'industry', 'source')
        }),
        ('Contact Information', {
            'fields': ('contact_name', 'contact_email', 'contact_phone')
        }),
        ('Lead Details', {
            'fields': ('status', 'priority', 'estimated_licenses', 'estimated_value')
        }),
        ('Management', {
            'fields': ('assigned_to', 'next_follow_up_date', 'next_action')
        }),
        ('Notes', {
            'fields': ('notes',),
            'classes': ('collapse',)
        }),
        ('Conversion', {
            'fields': ('converted_company', 'conversion_date'),
            'classes': ('collapse',)
        })
    )
    
    readonly_fields = ('conversion_date',)


class SavedSegmentAdmin(admin.ModelAdmin):
    list_display = ('name', 'created_by', 'is_shared', 'created_at')
    list_filter = ('is_shared', 'created_by', 'created_at')
    search_fields = ('name', 'description')
    date_hierarchy = 'created_at'
    ordering = ('-created_at',)
    
    fieldsets = (
        ('Basic Information', {
            'fields': ('name', 'description', 'created_by', 'is_shared')
        }),
        ('Filter Criteria', {
            'fields': ('filter_criteria',),
            'classes': ('collapse',)
        })
    )
    
    readonly_fields = ('created_by',)


# Company model removed - using ZiLuckGroup instead
admin.site.register(Lead, LeadAdmin)
admin.site.register(SavedSegment, SavedSegmentAdmin)


class HospitalAdmin(admin.ModelAdmin):
    list_display = ('name', 'hospital_code', 'is_active', 'contact_email', 
                    'contact_phone', 'get_users_count', 'created_at')
    list_filter = ('is_active', 'created_at', 'created_by')
    search_fields = ('name', 'hospital_code', 'contact_email', 'contact_phone', 
                     'api_key', 'contact_person')
    date_hierarchy = 'created_at'
    ordering = ('-created_at',)
    
    fieldsets = (
        ('Basic Information', {
            'fields': ('name', 'hospital_code', 'is_active')
        }),
        ('API Credentials', {
            'fields': ('api_key', 'api_secret'),
            'classes': ('collapse',)
        }),
        ('Contact Information', {
            'fields': ('contact_email', 'contact_phone', 'contact_person', 'address')
        }),
        ('Additional Information', {
            'fields': ('description',),
            'classes': ('collapse',)
        }),
        ('System Information', {
            'fields': ('django_user', 'created_by', 'created_at', 'updated_at'),
            'classes': ('collapse',)
        })
    )
    
    readonly_fields = ('created_at', 'updated_at', 'hospital_code')
    
    def get_users_count(self, obj):
        return obj.get_users_count()
    get_users_count.short_description = 'Users Count'
    
    def save_model(self, request, obj, form, change):
        """Override save to auto-create promotion group and discount"""
        is_new = obj.pk is None
        super().save_model(request, obj, form, change)
        
        if is_new:
            # Create promotion group and discount for new hospital
            obj.create_promotion_group_and_discount()


admin.site.register(Hospital, HospitalAdmin)


class TimeSlotAdmin(admin.ModelAdmin):
    list_display = ('id',
                    'patient',
                    'therapist_django_user',
                    'doctor_django_user',
                    'created_at')
    search_fields = ['patient__first_name', 'patient__last_name', 'patient__email',
                     'therapist_django_user__first_name', 'therapist_django_user__last_name', 'therapist_django_user__email',
                     'doctor_django_user__first_name', 'doctor_django_user__last_name', 'doctor_django_user__email']
    date_hierarchy = 'created_at'
    ordering = ('-created_at',)

admin.site.register(TimeSlot, TimeSlotAdmin)