import requests
from APIs.models import User as AppUser
from ziluck_project.constants import ADMIN_PHONE_NUMBER, SMS_API_URL, SMS_VERIFY_LOOKUP_URL



class SMS:
    def __init__(self):
        self.__url = SMS_API_URL
        self.__admin = ADMIN_PHONE_NUMBER
        self.__verify_lookup_url = SMS_VERIFY_LOOKUP_URL

    # def notify_doctor(self, user):
    #     message = "پیام جدیدی از " + user.profile.first_name + " " + \
    #               user.profile.last_name + " دارید." + "\nآیدیا"
    #     therapist = user.profile.therapist
    #     doctor = Doctor.objects.filter(django_user=therapist)[0]
    #
    #     querystring = {
    #         "receptor": doctor.phone,
    #         "message": message,
    #     }
    #     response = requests.request("POST", self.url, params=querystring)
    #     return response

    def notify_user(self, user):
        message = "پیام جدیدی از سمت پزشک دارید." + "\nآیدیا"
        querystring = {
            "receptor": user.phone_number,
            "message": message,
        }
        response = requests.request("POST", self.__url, params=querystring, verify=False)
        return response

    def send_to_admin(self, message):
        querystring = {
            "receptor": self.__admin,
            "message": message,
        }
        response = requests.request("POST", self.__url, params=querystring, verify=False)
        return response

    def send_to_list(self, data):
        for item in data:
            querystring = {
                "receptor": item["phone"],
                # "receptor": self.admin,
                "message": item["message"],
            }
            requests.request("POST", self.__url, params=querystring, verify=False)

    def ziluck_welcome_sms(self, user: AppUser):
        message = 'درود، خرید پلن شما با موفقیت انجام شده است. به زودی ارتباط شما با متخصص مربوطه از طریق ' \
                  'اپلیکیشن برقرار خواهد شد. '
        querystring = {
            "receptor": user.phone_number,
            "message": message,
        }
        response = requests.request("POST", self.__url, params=querystring, verify=False)
        return response

    def send_lookup(self, code: str, phone:str):
        # querystring = {"receptor": phone, "template": "ziluck-verify", "token": code, "token2": "IDIA-bjM9gCO09A3"}
        querystring = {"receptor": phone, "template": "ziluck-verify", "token": code}
        response = requests.request("POST", self.__verify_lookup_url, params=querystring, verify=False)
        jresp = response.json()
        if jresp.get("return").get("status") == 200 or jresp.get("return").get("status") == 409:
            return True
        else:
            return False



