import os.path
from datetime import datetime

from pyfcm import FCMNotification
from APIs.models import Profile, User, NotificationLog
from panel.models import Doctor, Assistant, Message, FirebaseNotification
from ziluck_project.constants import FIREBASE_PROJECT_ID_ziluck, FIREBASE_PROJECT_ID_Lacto, \
    FIREBASE_SERVICE_ACCOUNT_FILE_ziluck, FIREBASE_SERVICE_ACCOUNT_FILE_Lacto
from ziluck_project.settings import BASE_DIR


class PushNotification:
    def __init__(self, user=None):
        if not user:
            print("USER IS NONE BUT PUSH NOTIFICATION WITH LACTO")
            self.push_service = FCMNotification(
                project_id=FIREBASE_PROJECT_ID_Lacto,
                service_account_file=FIREBASE_SERVICE_ACCOUNT_FILE_Lacto
            )
            return

        if not user.profile.version:
            print("PUSH NOTIFICATION WITH ZILUCK")
            self.push_service = FCMNotification(
                project_id=FIREBASE_PROJECT_ID_ziluck,
                service_account_file=FIREBASE_SERVICE_ACCOUNT_FILE_ziluck
            )
        else:
            print("PUSH NOTIFICATION WITH LACTO")
            self.push_service = FCMNotification(
                project_id=FIREBASE_PROJECT_ID_Lacto,
                service_account_file=FIREBASE_SERVICE_ACCOUNT_FILE_Lacto
            )
            
    def send_notification_to_user(self, user, title: str, message: str):
        try:
            firebase_token = user.profile.firebase_token
            if not firebase_token:
                print(f"No firebase token for {user.identifier}")
                NotificationLog.objects.create(
                    user=user,
                    title=title,
                    body=message,
                    status='failed',
                    error_message='No Firebase token'
                )
                return False

            result = self.push_service.notify(
                fcm_token=firebase_token,
                notification_title=title,
                notification_body=message
            )

            # Handle both pyfcm and firebase_admin response formats
            if 'success' in result:
                status = 'success' if result.get('success', 0) > 0 else 'failed'
            elif 'name' in result:
                status = 'success'  # firebase_admin v1 success returns a message ID
            else:
                status = 'failed'

            error_message = result['results'][0].get('error') if result.get('results') and result.get('failure', 0) > 0 else None

            # Create notification record
            notification = FirebaseNotification(
                title=title,
                body=message,
                datetime=datetime.now(),
                user=user
            )
            notification.save()

            # Log the notification attempt
            log = NotificationLog.objects.create(
                user=user,
                title=title,
                body=message,
                status=status,
                error_message=error_message
            )

            return status == 'success'

        except Exception as e:
            print(f"Exception during notification send: {e}")
            NotificationLog.objects.create(
                user=user,
                title=title,
                body=message,
                status='failed',
                error_message=str(e)
            )
            return False

    def send_message_to_my_patients(self, message: str, therapist, django_users: list):
        try:
            message_title = "زیلاک" + "!"
            patient_list = []
            profiles = Profile.objects.filter(therapist=therapist.django_user)
            user = User.objects.filter(profile__therapist=therapist.django_user, django_user__in=django_users)
            if user:
                for p in user:
                    patient_list.append(p.profile.firebase_token)
                    try:
                        user = User.objects.filter(profile=p.profile, django_user__in=django_users).first()
                        m = Message(sender=therapist.django_user, receiver=user.django_user, text=message)
                        m.save()
                        notification = FirebaseNotification(
                            title=message_title,
                            body=message,
                            datetime=datetime.now(),
                            user=user
                        )
                        notification.save()
                    except Exception as e:
                        print(e)
                        pass
                if len(patient_list) > 0:
                    result = self.push_service.notify(fcm_token=[patient_list],
                                                      notification_title=message_title,
                                                      notification_body=message)
            return True
        except Exception as e:
            print(e)
            return False

    def send_message_to_all_patients(self, message: str, therapist):
        try:
            message_title = "زیلاک" + "!"
            patient_list = []
            profiles = Profile.objects.filter(therapist=therapist.django_user)
            for p in profiles:
                patient_list.append(p.firebase_token)
                try:
                    user = User.objects.filter(profile=p).first()
                    m = Message(sender=therapist.django_user, receiver=user.django_user, text=message)
                    m.save()
                    notification = FirebaseNotification(
                        title=message_title,
                        body=message,
                        datetime=datetime.now(),
                        user=user
                    )
                    notification.save()
                except Exception as e:
                    print(e)
                    pass

            if len(patient_list) > 0:
                for p in patient_list:
                    result = self.push_service.notify(fcm_token=p,
                                                      notification_title=message_title,
                                                      notification_body=message)

            doctor = Doctor.objects.filter(django_user=therapist.django_user).first()
            assistants = Assistant.objects.filter(doctor=doctor)
            for assistant in assistants:
                message_title = "زیلاک" + "!"
                patient_list = []
                profiles = Profile.objects.filter(therapist=assistant.django_user)
                for p in profiles:
                    patient_list.append(p.firebase_token)
                    try:
                        user = User.objects.filter(profile=p).first()
                        m = Message(sender=assistant.django_user, receiver=user.django_user, text=message)
                        m.save()
                        notification = FirebaseNotification(
                            title=message_title,
                            body=message,
                            datetime=datetime.now(),
                            user=user
                        )
                        notification.save()
                    except Exception as e:
                        print(e)
                        pass
                if len(patient_list) > 0:
                    for p in patient_list:
                        result = self.push_service.notify(fcm_token=p,
                                                          notification_title=message_title,
                                                          notification_body=message)
            return True
        except Exception as e:
            print(e)
            return False

    def send_notification_to_my_patients(self, message: str, therapist, django_users: list):
        try:
            message_title = "زیلاک" + "!"
            patient_list = []
            # profiles = Profile.objects.filter(therapist=therapist.django_user)
            users = User.objects.filter(profile__therapist=therapist.django_user, django_user__in=django_users)
            if users.exists():
                for u in users:
                    patient_list.append(u.profile.firebase_token)
                    try:
                        user = User.objects.filter(profile=u.profile, django_user__in=django_users).first()
                        notification = FirebaseNotification(
                            title=message_title,
                            body=message,
                            datetime=datetime.now(),
                            user=user
                        )
                        notification.save()
                    except Exception as e:
                        print(e)
                        pass
                if len(patient_list) > 0:
                    for p in patient_list:
                        result = self.push_service.notify(fcm_token=p,
                                                          notification_title=message_title,
                                                          notification_body=message)
                        print("RESULT OF PUSH NOTIFICATION:", result)
            # else:
            #     for p in profiles:
            #         patient_list.append(p.firebase_token)
            #         try:
            #             user = User.objects.filter(profile=p).first()
            #             notification = FirebaseNotification(
            #                 title=message_title,
            #                 body=message,
            #                 datetime=datetime.now(),
            #                 user=user
            #             )
            #             notification.save()
            #         except Exception as e:
            #             print(e)
            #             pass
            #     if len(patient_list) > 0:
            #         result = self.push_service.notify_multiple_devices(registration_ids=patient_list,
            #                                                            message_title=message_title,
            #                                                            message_body=message)
            return True
        except Exception as e:
            print(e)
            return False

    def send_notification_to_all_patients(self, message: str, therapist):
        try:
            message_title = "زیلاک" + "!"
            patient_list = []
            profiles = Profile.objects.filter(therapist=therapist.django_user)
            for p in profiles:
                patient_list.append(p.firebase_token)
                try:
                    user = User.objects.filter(profile=p).first()
                    notification = FirebaseNotification(
                        title=message_title,
                        body=message,
                        datetime=datetime.now(),
                        user=user
                    )
                    notification.save()
                except Exception as e:
                    print(e)
                    pass

            if len(patient_list) > 0:
                for p in patient_list:
                    result = self.push_service.notify(fcm_token=p,
                                                      notification_title=message_title,
                                                      notification_body=message)

            doctor = Doctor.objects.filter(django_user=therapist.django_user).first()
            assistants = Assistant.objects.filter(doctor=doctor)
            for assistant in assistants:
                message_title = "زیلاک" + "!"
                patient_list = []
                profiles = Profile.objects.filter(therapist=assistant.django_user)
                for p in profiles:
                    patient_list.append(p.firebase_token)
                    try:
                        user = User.objects.filter(profile=p).first()
                        notification = FirebaseNotification(
                            title=message_title,
                            body=message,
                            datetime=datetime.now(),
                            user=user
                        )
                        notification.save()
                    except Exception as e:
                        print(e)
                        pass

                if len(patient_list) > 0:
                    for p in patient_list:
                        result = self.push_service.notify(fcm_token=p,
                                                          notification_title=message_title,
                                                          notification_body=message)
            return True
        except Exception as e:
            print(e)
            return False

    def send_notification_to(self, registration_id, message_title, message):
        result = self.push_service.notify(
            fcm_token=registration_id,
            notification_title=message_title,
            notification_body=message
        )
        return result

    def send_inactive_user_notification(self, app_user, message):
        try:
            message_title = "لاکتو!" if app_user.profile.version else "زیلاک!"
            firebase_token = app_user.profile.firebase_token
            print(f"Sending to token: {firebase_token}")

            if not firebase_token:
                print(f"No firebase token for {app_user.identifier}")
                NotificationLog.objects.create(
                    user=app_user,
                    title=message_title,
                    body=message,
                    status='failed',
                    error_message='No Firebase token'
                )
                return False

            print("Attempting to send notification...")
            result = self.push_service.notify(
                fcm_token=firebase_token,
                notification_title=message_title,
                notification_body=message
            )
            print(f"FCM Response: {result}")

            # Handle both pyfcm and firebase_admin response formats
            if 'success' in result:
                status = 'success' if result.get('success', 0) > 0 else 'failed'
            elif 'name' in result:
                status = 'success'  # firebase_admin v1 success returns a message ID
            else:
                status = 'failed'
            print(f"Determined status: {status}")

            error_message = result['results'][0].get('error') if result.get('results') and result.get('failure',
                                                                                                      0) > 0 else None

            log = NotificationLog.objects.create(
                user=app_user,
                title=message_title,
                body=message,
                status=status,
                error_message=error_message
            )
            print(f"Created log: {log.id}")
            return status == 'success'

        except Exception as e:
            print(f"Exception during notification send: {e}")
            NotificationLog.objects.create(
                user=app_user,
                title=message_title,
                body=message,
                status='failed',
                error_message=str(e)
            )
            return False