# Timeslot Payment System

## Overview

The Timeslot Payment System allows non-premium users to purchase consultation timeslots from doctors. The system supports both coin and money payments, with doctors managing the assignment of purchased timeslots to therapists.

## Features

### For Users (Non-Premium)
- Purchase timeslots with coins (2000 coins per timeslot)
- Purchase timeslots with money (200,000 toman per timeslot)
- View available timeslots from doctors
- Receive confirmation after successful purchase

### For Doctors
- Create timeslots available for purchase
- View purchased timeslots that need assignment
- Assign purchased timeslots to therapists
- Track statistics (total, available, purchased, assigned timeslots)

### For Therapists
- Receive assigned timeslots from doctors
- Conduct sessions with patients who purchased timeslots

## API Endpoints

### User Endpoints
- `POST /timeslot/available/for/purchase/` - Get available timeslots
- `POST /timeslot/purchase/with/coins/` - Purchase with coins
- `POST /timeslot/payment/link/` - Get payment link for money

### Doctor Endpoints
- `POST /doctor/timeslot/create/` - Create timeslot for purchase
- `POST /doctor/timeslot/purchased/` - Get purchased timeslots
- `POST /doctor/timeslot/assign/` - Assign to therapist
- `POST /doctor/therapists/available/` - Get available therapists

## Panel Interface

### Doctor Panel
1. **Timeslot Management** (`/panel/doctor/timeslot/management/`)
   - Dashboard with statistics
   - List of purchased timeslots needing assignment
   - Assignment modal for each timeslot

2. **Create Timeslots** (`/panel/doctor/timeslot/create/`)
   - Interactive calendar interface
   - Select days and time slots
   - View existing timeslots

### Navigation
- Added "مدیریت زمان‌ها" menu item in doctor panel
- Accessible via sidebar navigation

## Database Models

### TimeSlotPayment
```python
class TimeSlotPayment(models.Model):
    user = models.ForeignKey(AppUser)
    time_slot = models.ForeignKey(TimeSlot)
    payment_type = models.CharField(choices=['coin', 'money'])
    coin_amount = models.IntegerField(default=0)  # 2000 coins
    money_amount = models.IntegerField(default=0)  # 200,000 toman
    status = models.CharField(choices=['pending', 'assigned', 'completed', 'cancelled'])
    assigned_therapist = models.ForeignKey(Assistant, null=True)
    is_paid = models.BooleanField(default=False)
    created_at = models.DateTimeField(default=datetime.now)
    payment_date = models.DateTimeField(null=True)
    assigned_date = models.DateTimeField(null=True)
```

### Enhanced TimeSlot
```python
class TimeSlot(models.Model):
    # ... existing fields ...
    doctor_django_user = models.ForeignKey(DjangoUser)  # Doctor who created
    created_by_doctor = models.BooleanField(default=False)
    is_available = models.IntegerField(choices=[
        (0, 'Booked'),
        (1, 'Available'),
        (2, 'Purchased - Waiting Assignment'),
        (3, 'Cancelled')
    ])
```

## Workflow

1. **Doctor creates timeslots** → Available for purchase
2. **Non-premium user purchases** → With coins or money
3. **Payment processed** → Timeslot marked as "purchased - waiting assignment"
4. **Doctor assigns to therapist** → Timeslot becomes booked and assigned
5. **Therapist conducts session** → Normal appointment flow

## Pricing

- **Coin Payment**: 2000 coins per timeslot
- **Money Payment**: 200,000 toman per timeslot

## Installation

1. **Run migrations**:
   ```bash
   python manage.py makemigrations payment
   python manage.py makemigrations panel
   python manage.py migrate
   ```

2. **Access the panel**:
   - Doctor panel: `/panel/doctor/timeslot/management/`
   - Create timeslots: `/panel/doctor/timeslot/create/`

## Usage Examples

### Creating Timeslots (Doctor)
1. Navigate to "مدیریت زمان‌ها" in doctor panel
2. Click "ایجاد زمان جدید"
3. Select days and time slots
4. Submit to create available timeslots

### Managing Purchases (Doctor)
1. Navigate to "مدیریت زمان‌ها"
2. View purchased timeslots in the table
3. Click "تخصیص به درمانگر" for each timeslot
4. Select therapist and confirm assignment

### Purchasing Timeslots (User)
1. Call API to get available timeslots
2. Choose payment method (coins or money)
3. Complete payment
4. Wait for doctor assignment

## Security Features

- Token-based authentication for all API calls
- Doctor-only access to management interfaces
- Validation of therapist ownership by doctor
- Payment verification before assignment

## Mobile Responsiveness

- Responsive design for mobile devices
- Optimized grid layout for time slot selection
- Touch-friendly interface elements

## Future Enhancements

- Email/SMS notifications for assignments
- Bulk timeslot creation
- Cancellation and refund functionality
- Advanced reporting and analytics
- Integration with video conferencing platforms 