# Timeslot API Documentation

## Get Available Timeslots for Purchase (Modified)

**Endpoint:** `POST /timeslot/available/for/purchase/`

**Description:** Retrieves available timeslots that can be purchased by non-premium users within a specified date range.

### Request Parameters

| Parameter | Type | Required | Format | Description |
|-----------|------|----------|--------|-------------|
| token | string | Yes | `^(\S){30}$` | User authentication token (30 characters) |
| start_date | string | No | `^[\d]+$` | Start date as Unix timestamp. If not provided, defaults to current time |
| end_date | string | No | `^[\d]+$` | End date as Unix timestamp. If not provided, no upper limit is applied |

### Request Example

```http
POST /timeslot/available/for/purchase/
Content-Type: application/x-www-form-urlencoded

token=abc123def456ghi789jkl012mno345&start_date=1735689600&end_date=1736294400
```

### Response Format

#### Success Response (200 OK)

```json
{
  "status": "success",
  "message": "Available timeslots for purchase",
  "data": {
    "timeslots": [
      {
        "id": 123,
        "start_time": 1735689600,
        "duration": 15,
        "coin_price": 2000,
        "money_price": 200000
      },
      {
        "id": 124,
        "start_time": 1735693200,
        "duration": 30,
        "coin_price": 2000,
        "money_price": 200000
      }
    ],
    "user_coins": 5000,
    "date_range": {
      "start_date": 1735689600,
      "end_date": 1736294400
    }
  }
}
```

#### Error Response (400/401/500)

```json
{
  "status": "error",
  "message": "Error description",
  "code": "ERROR_CODE"
}
```

### Response Fields

#### Timeslot Object
| Field | Type | Description |
|-------|------|-------------|
| id | integer | Unique timeslot identifier |
| start_time | integer | Start time as Unix timestamp |
| duration | integer | Duration in minutes |
| coin_price | integer | Price in coins (always 2000) |
| money_price | integer | Price in currency units (always 200000) |

#### Data Object
| Field | Type | Description |
|-------|------|-------------|
| timeslots | array | Array of available timeslot objects |
| user_coins | integer | Current user's coin balance |
| date_range | object | Applied date range filters |

#### Date Range Object
| Field | Type | Description |
|-------|------|-------------|
| start_date | integer/null | Applied start date filter as Unix timestamp |
| end_date | integer/null | Applied end date filter as Unix timestamp |

### Usage Examples

#### 1. Get all future timeslots (no date filtering)
```bash
curl -X POST http://localhost:8000/timeslot/available/for/purchase/ \
  -H "Content-Type: application/x-www-form-urlencoded" \
  -d "token=your_token_here_30_characters_long"
```

#### 2. Get timeslots from tomorrow onwards
```bash
curl -X POST http://localhost:8000/timeslot/available/for/purchase/ \
  -H "Content-Type: application/x-www-form-urlencoded" \
  -d "token=your_token_here_30_characters_long&start_date=1735689600"
```

#### 3. Get timeslots within a specific date range
```bash
curl -X POST http://localhost:8000/timeslot/available/for/purchase/ \
  -H "Content-Type: application/x-www-form-urlencoded" \
  -d "token=your_token_here_30_characters_long&start_date=1735689600&end_date=1736294400"
```

#### 4. Get timeslots up to a specific end date
```bash
curl -X POST http://localhost:8000/timeslot/available/for/purchase/ \
  -H "Content-Type: application/x-www-form-urlencoded" \
  -d "token=your_token_here_30_characters_long&end_date=1736294400"
```

### Filtering Logic

1. **No date parameters**: Returns timeslots from current time onwards
2. **Only start_date**: Returns timeslots from start_date onwards
3. **Only end_date**: Returns timeslots from current time to end_date
4. **Both dates**: Returns timeslots within the specified range (start_date to end_date)

### Notes

- All timestamps are in Unix format (seconds since epoch)
- Timeslots are filtered to show only those:
  - Created by doctors (`created_by_doctor=True`)
  - Available for purchase (`is_available=1`)
  - Created by users in the 'Doctor' group
- Results are ordered by start_time in ascending order
- The API uses Django's `__gte` (greater than or equal) and `__lte` (less than or equal) filters

### Error Codes

| Code | Description |
|------|-------------|
| `INVALID_TOKEN` | Invalid or expired authentication token |
| `INVALID_ARGUMENT` | Invalid request parameters or server error |

### Changes Made

This endpoint has been modified to accept optional `start_date` and `end_date` parameters for date range filtering. The previous behavior (showing all future timeslots when no dates are provided) is maintained for backward compatibility. 