# Comment Creation Script

This script creates `Comment` instances in your Django database based on two lists: tokens and comments.

## What the Script Does

1. **Takes two lists**: A list of user tokens and a list of comment contents
2. **Finds users**: For each token, finds the corresponding `User` instance
3. **Creates comments**: Creates `Comment` instances with:
   - The found user as the comment author
   - The comment content from the comments list
   - A random date between August 2024 and July 2025
   - `is_active` set to `True`

## How to Use

### 1. Customize the Data Lists

Open `create_comments_script.py` and find the customization section:

```python
# ============================================================================
# CUSTOMIZE THIS SECTION WITH YOUR ACTUAL DATA
# ============================================================================

# Replace these example lists with your actual tokens and comments
tokens_list = [
    # Add your actual user tokens here
    "abc123def456",
    "xyz789uvw012",
    # Add more tokens...
]

comments_list = [
    # Add your actual comment contents here
    "This is a real comment from a user",
    "Another user's feedback comment",
    # Add more comments...
]
```

**Important**: 
- Both lists must have the same length
- The first comment will be assigned to the first token, second comment to second token, etc.
- Make sure the tokens exist in your database

### 2. Run the Script

```bash
# Activate your virtual environment
source /Users/mohammadamintebianian/PycharmProjects/ziluck/venv/bin/activate

# Run the script
python create_comments_script.py
```

### 3. Confirm Execution

The script will ask for confirmation before creating the comments:
```
About to create 5 comments...
Do you want to continue? (y/n): 
```

Type `y` to proceed or `n` to cancel.

## Script Features

- **Error Handling**: Continues processing even if some users aren't found
- **Random Dates**: Generates realistic random timestamps
- **Progress Tracking**: Shows which comments are being created
- **Summary Report**: Displays all created comments at the end
- **Safety Check**: Asks for confirmation before making database changes

## Output Example

```
Starting Comment creation script...
Tokens list length: 3
Comments list length: 3

About to create 3 comments...
Do you want to continue? (y/n): y
Created comment 1: User John Doe 123 - 'This is a real comment from a user...' at 2024-12-15 14:23:45
Created comment 2: User Jane Smith 456 - 'Another user's feedback comment...' at 2025-03-22 09:12:33
Created comment 3: User Bob Johnson 789 - 'Third comment content here...' at 2024-11-08 16:45:12

Script completed!
Successfully created 3 comments out of 3 attempts

Created comments summary:
1. User: John Doe 123
   Content: This is a real comment from a user...
   Created: 2024-12-15 14:23:45
   Active: True

2. User: Jane Smith 456
   Content: Another user's feedback comment...
   Created: 2025-03-22 09:12:33
   Active: True

3. User: Bob Johnson 789
   Content: Third comment content here...
   Created: 2024-11-08 16:45:12
   Active: True
```

## Database Models Used

- **User**: Found by token to assign as comment author
- **Comment**: Created with user, content, random date, and active status

## Notes

- The script uses Django ORM to create database records
- Random dates are generated between August 1, 2024 and July 31, 2025
- All comments are created with `is_active=True`
- The script handles errors gracefully and continues processing other items
- Make sure your Django environment is properly configured before running 