# PaymentPlans Feature Documentation

## Overview
The PaymentPlans feature provides a comprehensive system for managing subscription plans that users can purchase. This feature includes a data model, API endpoints, and a management interface for administrators.

## Features

### 1. Data Model (`PaymentPlans`)
The `PaymentPlans` model is located in `payment/models.py` and includes the following fields:

- **name**: Plan name (CharField, max 100 chars)
- **plan_database_id**: Database identifier for the plan (IntegerField)
- **price**: Base price (DecimalField, 10 digits, 2 decimal places)
- **items_included**: Features included in the plan (TextField, separated by &)
- **items_excluded**: Features excluded from the plan (TextField, separated by &)
- **promotion**: Promotion description (TextField, optional)
- **price_with_promotion**: Promotional price (DecimalField, optional)
- **subscription_period**: Subscription duration (CharField, e.g., Monthly, Yearly)
- **is_active**: Whether the plan is active (BooleanField, default True)
- **created_at**: Creation timestamp (DateTimeField, auto)
- **updated_at**: Last update timestamp (DateTimeField, auto)

### 2. API Endpoint
**URL**: `/api/v1/payment/plans/`
**Method**: POST
**Authentication**: Token required (sent in POST data)
**Description**: Returns all active payment plans with items included/excluded as lists

**Request Format**:
```json
{
    "token": "user_authentication_token_here"
}
```

**Response Format**:
```json
{
    "status": "success",
    "message": "Payment plans retrieved successfully",
    "data": [
        {
            "id": 1,
            "name": "Basic Plan",
            "plan_database_id": 1001,
            "price": 99.99,
            "items_included": ["Basic consultation", "Diet plan", "Weekly follow-up"],
            "items_excluded": ["Phone consultation", "In-person visit"],
            "promotion": "20% off for first month",
            "price_with_promotion": 79.99,
            "subscription_period": "Monthly",
            "created_at": "2024-01-01T00:00:00Z",
            "updated_at": "2024-01-01T00:00:00Z"
        }
    ],
    "user": {
        "id": 123,
        "username": "user123",
        "phone_number": "09123456789"
    }
}
```

**Error Responses**:
- **400 Bad Request**: Token not provided
- **401 Unauthorized**: Invalid token
- **403 Forbidden**: User account deactivated
- **405 Method Not Allowed**: GET request not supported
- **500 Internal Server Error**: Server error
