# Hospital Payment Simulation API

## Overview

This API allows hospital systems to simulate successful payment actions for users without requiring actual payment gateway verification. It performs the exact same actions that occur when a user's payment is successfully verified through ZarinPal or DigiPay.

## Quick Start

### Endpoint
```
POST /payment/hospital/successful-payment/
```

### Basic Usage
```bash
curl -X POST \
  https://api.ziluck.info/payment/hospital/successful-payment/ \
  -d 'hospital_api_key=Z9xd3NikanhospitalQ8zYpR7G5wK2uHvM1R&phone_number=09123456789&plan=1'
```

## What This API Does

When called successfully, this API performs **exactly the same actions** as successful payment verification:

1. **Therapist Assignment**: Creates/updates therapist selection and assigns to user profile
2. **Credit Addition**: Adds subscription credit based on plan type (30 or 90 days)
3. **Welcome Message**: Sends personalized welcome message to user
4. **Notifications**: Sends Telegram notifications and receipt emails

## Authentication

- **API Key**: `Z9xd3NikanhospitalQ8zYpR7G5wK2uHvM1R`
- **Method**: Passed in request parameters
- **Security**: Validates against hospital integration system

## Parameters

| Parameter | Required | Type | Description |
|-----------|----------|------|-------------|
| `hospital_api_key` | Yes | string | Hospital API key for authentication |
| `phone_number` | Yes | string | User's phone number (09XXXXXXXXX format) |
| `plan` | Yes | integer | Plan number (1-8) |

## Plan Types

| Plan | Credit Days | Type | Description |
|------|-------------|------|-------------|
| 1, 3, 5, 7 | 30 | Monthly | Standard monthly plans |
| 2, 4, 6, 8 | 90 | Quarterly | Standard quarterly plans |

## Response Examples

### Success
```json
{
    "status": "success",
    "message": "Payment simulation completed successfully",
    "data": {
        "user_id": 12345,
        "phone_number": "09123456789",
        "plan": 1,
        "credit_days_added": 30,
        "therapist_assigned": 67890,
        "hospital_name": "Hospital Integration",
        "actions_performed": [
            "therapist_selection_created",
            "credit_added",
            "welcome_message_sent",
            "notifications_sent"
        ]
    }
}
```

### Error
```json
{
    "error": "User not found with the provided phone number",
    "status": "error"
}
```

## Error Codes

| Status | Code | Description |
|--------|------|-------------|
| 200 | Success | Payment simulation completed |
| 400 | Bad Request | Missing/invalid parameters |
| 401 | Unauthorized | Invalid hospital API key |
| 404 | Not Found | User not found |
| 500 | Server Error | Internal processing error |

### Rate Limiting
- 60 requests per minute
- 1000 requests per hour
- 10000 requests per day
