# Background Diet Generation System

## Overview

This system automatically generates complete diets for bronze plan users (plans 7 and 8) when they purchase a subscription. The diet generation happens in the background to avoid blocking the payment verification process.

## How It Works

### 1. Payment Verification Trigger
When a user purchases a bronze plan (plan 7 or 8), the payment verification functions in `payment/views.py` trigger the background diet generation:

- **ZarinPal Payment**: `verify()` function
- **DigiPay Payment**: `verify_digipay()` function  
- **Free Payment**: `get_pay_link()` method in `ZarinPalPayment` model

### 2. Background Task Execution
The system calls `start_diet_generation_background(user_id)` which:
- Starts a background thread
- Calls `generate_complete_diet_for_user(user_id)`
- Generates diet for all 5 meals (breakfast, lunch, dinner, snack1, snack2)
- Creates a Diet object with start date 24 hours later

### 3. Diet Generation Process
For each meal type, the system:
1. Gets user's questionnaire data and health tags
2. Calls the existing `refresh_column_cards()` function
3. Converts the response to the expected diet JSON format
4. Creates 14 meal entries per meal type
5. Saves the complete diet to the database

## Files Created/Modified

### New Files:
- `panel/background_tasks.py` - Main background task logic
- `panel/management/commands/generate_diet.py` - Django management command
- `test_diet_generation.py` - Test script
- `check_user_diet.py` - Diet verification script
- `DIET_GENERATION_README.md` - This documentation

### Modified Files:
- `payment/views.py` - Added background task triggers
- `payment/models.py` - Added background task for free payments
- `panel/templates/assistant/diets2.html` - Fixed linter errors

## Usage

### Testing the System

1. **Test with Management Command**:
   ```bash
   python manage.py generate_diet <user_id>
   ```

2. **Test with Python Script**:
   ```bash
   python test_diet_generation.py
   ```

3. **Check User's Diet**:
   ```bash
   python check_user_diet.py
   ```

### Manual Testing

1. **Purchase a Bronze Plan**: Use the payment system to purchase plan 7 or 8
2. **Check Logs**: Look for background task messages in the server logs
3. **Verify Diet**: Use the check script to verify the diet was created

## Diet JSON Structure

The generated diet follows the existing template structure:

```json
{
  "week1": {
    "breakfast": [
      [{"title": "Food Name", "ingredient": [...]}],
      [{"title": "Food Name", "ingredient": [...]}],
      // ... 14 entries
    ],
    "lunch": [...],
    "dinner": [...],
    "snack1": [...],
    "snack2": [...]
  },
  "type": "Bronze Plan Diet"
}
```

## Error Handling

The system includes comprehensive error handling:
- **User not found**: Logs error and returns False
- **No therapist**: Logs error and returns False  
- **Questionnaire processing fails**: Uses default health tags
- **Card generation fails**: Creates empty meal entries
- **Background thread fails**: Logs error but doesn't block payment

## Monitoring

### Log Messages to Watch For:
- `"Starting background diet generation for user {user_id}"`
- `"Generated {count} cards for {meal_type}"`
- `"Successfully created diet for user {user_id}"`
- `"Diet generation completed successfully for user {user_id}"`

### Common Issues:
1. **User has no therapist**: Check TherapistSelection records
2. **No questionnaire data**: System uses default health tags
3. **Card generation fails**: Check FoodCard database and filters
4. **Background thread dies**: Check server logs for exceptions

## Configuration

### Plan Types:
- **Plan 7**: Monthly Bronze
- **Plan 8**: Three Month Bronze

### Start Date:
- Diets are created with start date = today + 1 day (24 hours later)

### Meal Types:
- breakfast, lunch, dinner, snack1, snack2

## Future Enhancements

1. **Queue System**: Replace threads with a proper task queue (Celery)
2. **Retry Logic**: Add retry mechanism for failed generations
3. **Progress Tracking**: Add progress indicators for long-running generations
4. **Email Notifications**: Notify users when diet is ready
5. **Admin Interface**: Add admin panel to monitor diet generation

## Troubleshooting

### Diet Not Generated:
1. Check if user has a therapist assigned
2. Verify user has questionnaire data
3. Check server logs for error messages
4. Test manual generation with management command

### Empty Diet Entries:
1. Check FoodCard database for available cards
2. Verify health tag filtering isn't too restrictive
3. Check calorie requirements and distribution

### Performance Issues:
1. Monitor server resources during generation
2. Consider implementing task queue for high load
3. Add caching for frequently accessed data 