# Comment API Documentation

## Overview
The Comment API allows users to post comments and authorized clients to retrieve all comments using a special API key.

## Authentication

### For Posting Comments
Users must provide their user token and phone number for authentication.

### For Retrieving Comments
Only authorized clients with the special Comment API key can retrieve all comments.

## API Endpoints

### 1. Post Comment
**Endpoint:** `POST /comments/post/`

**Required Fields:**
- `token`: User's 30-character authentication token
- `phone_number`: User's phone number (format: 09xxxxxxxxx)
- `content`: Comment content (must not be empty)

**Example Request:**
```http
POST /comments/post/
Content-Type: application/x-www-form-urlencoded

token=abcdefghijklmnopqrstuvwxyz1234
phone_number=09123456789
content=This is my comment
```

**Success Response:**
```json
{
    "success": true,
    "message": "کامنت با موفقیت ثبت شد",
    "data": {
        "comment_id": 1,
        "content": "This is my comment",
        "created_at": "2024-01-15 10:30:00",
        "user": "John Doe 123"
    }
}
```

### 2. Get All Comments (Protected)
**Endpoint:** `POST /comments/get/`

**Required Fields:**
- `comment_api_key`: Special API key for comment access

**API Key:** `CommentAPIKey_ZiLuck2024_AccessToken_9pQ7mN3X`

**Example Request:**
```http
POST /comments/get/
Content-Type: application/x-www-form-urlencoded

comment_api_key=CommentAPIKey_ZiLuck2024_AccessToken_9pQ7mN3X
```

**Success Response:**
```json
{
    "success": true,
    "message": "کامنت‌ها با موفقیت دریافت شد",
    "data": [
        {
            "id": 1,
            "content": "This is my comment",
            "created_at": "2024-01-15 10:30:00",
            "updated_at": "2024-01-15 10:30:00",
            "user": {
                "identifier": "John Doe 123",
                "first_name": "John",
                "last_name": "Doe"
            }
        }
    ]
}
```

### 3. Get User Comments
**Endpoint:** `POST /comments/user/`

**Required Fields:**
- `token`: User's 30-character authentication token
- `phone_number`: User's phone number (format: 09xxxxxxxxx)

**Example Request:**
```http
POST /comments/user/
Content-Type: application/x-www-form-urlencoded

token=abcdefghijklmnopqrstuvwxyz1234
phone_number=09123456789
```

**Success Response:**
```json
{
    "success": true,
    "message": "کامنت‌های کاربر با موفقیت دریافت شد",
    "data": [
        {
            "id": 1,
            "content": "This is my comment",
            "created_at": "2024-01-15 10:30:00",
            "updated_at": "2024-01-15 10:30:00"
        }
    ]
}
```

## Security Notes

1. **Comment API Key**: The special API key is required to retrieve all comments. This prevents unauthorized access to the comment system.

2. **User Authentication**: Individual users can only post comments and view their own comments using their personal tokens.

3. **Input Validation**: All inputs are validated for proper format and content.

## Error Responses

**Invalid Token:**
```json
{
    "success": false,
    "message": "توکن نامعتبر است",
    "code": 4001
}
```

**Invalid API Key:**
```json
{
    "success": false,
    "message": "Invalid comment API key",
    "code": 4002
}
```

**Empty Content:**
```json
{
    "success": false,
    "message": "محتوای کامنت نمی‌تواند خالی باشد",
    "code": 400
}
``` 