# Call Center Export - Questionnaire Data Update

## 📋 Update Summary

The call center export script has been enhanced with comprehensive questionnaire data from three questionnaire models. This provides call center operators with detailed nutritional and lifestyle information to have informed conversations with users from a nutritionist's perspective.

---

## 🎯 What Was Added

### Total Enhancement
- **Previous**: 36 data columns
- **New**: 70 data columns (+34 questionnaire fields)
- **File Size**: ~10KB → ~14KB

---

## 📊 New Data Fields (34 Fields)

### 1. UserQuestionnaire (Nutrition Profile) - 13 Fields

**Purpose**: Understanding user's dietary habits, preferences, and restrictions

| Column Name (Persian) | Key Information | Use for Call Center |
|----------------------|-----------------|---------------------|
| بیماری‌های مزمن (پرسشنامه) | Chronic illnesses from questionnaire | Cross-reference with profile diseases |
| محدودیت‌های غذایی | Dietary restrictions/avoidances | Critical for meal planning discussions |
| بارداری/شیردهی | Pregnancy/breastfeeding status | Important health context |
| وعده‌های غذایی روزانه | Main meals per day | Understand eating patterns |
| نوع ورزش | Exercise type | Activity level context |
| شدت ورزش | Exercise intensity | Fitness assessment |
| دفعات پخت | Cooking frequency | Meal preparation capability |
| میان‌وعده مورد علاقه | Snack preferences | Dietary preferences |
| دفعات مصرف گوشت | Meat consumption frequency | Protein intake patterns |
| صبحانه مورد علاقه | Breakfast preferences | Morning meal planning |
| ناهار ترجیحی | Lunch preferences | Midday meal planning |
| شام ترجیحی | Dinner preferences | Evening meal planning |
| تنوع غذایی | Meal variety | Diet diversity assessment |

**Example Data:**
```
محدودیت‌های غذایی: غیره, بادمجان
نوع ورزش: کاردیو
صبحانه مورد علاقه: تخم مرغ, املت, قهوه
```

---

### 2. MicrobiomeQuestionnaire (Digestive Health) - 13 Fields

**Purpose**: Understanding digestive health and gut-related lifestyle factors

| Column Name (Persian) | Key Information | Use for Call Center |
|----------------------|-----------------|---------------------|
| مصرف فیبر/غذای گیاهی | Fiber/plant food intake | Diet quality assessment |
| مصرف غذای فرآوری شده | Processed food frequency | Nutrition quality indicator |
| مصرف آب روزانه | Daily water intake | Hydration status |
| مصرف الکل | Alcohol consumption | Lifestyle factor |
| سیگار | Smoking/tobacco use | Health risk factor |
| سطح استرس | Stress level | Mental health context |
| نفخ شکم | Bloating frequency | Digestive issues |
| قوام مدفوع | Stool consistency | Gut health indicator |
| دفعات اجابت مزاج | Bowel movement frequency | Digestive regularity |
| علائم گوارشی | Other digestive symptoms | Health concerns |
| مصرف آنتی‌بیوتیک | Antibiotics/NSAIDs usage | Medication history |
| مصرف پروبیوتیک | Probiotics/prebiotics use | Supplement usage |
| نوشیدنی شیرین | Sugary drinks frequency | Diet quality factor |

**Example Data:**
```
مصرف آب روزانه: 7 لیوان
سطح استرس: متوسط
نفخ شکم: بله، گاهی اوقات
مصرف پروبیوتیک: هیچ کدام
```

---

### 3. LifestyleQuestionnaire (Lifestyle & Habits) - 8 Fields

**Purpose**: Understanding daily habits, sleep, and food relationship

| Column Name (Persian) | Key Information | Use for Call Center |
|----------------------|-----------------|---------------------|
| ساعات خواب | Sleep hours per night | Sleep quality |
| رابطه با غذا | Relationship with food | Eating behavior |
| مدیریت استرس | Stress coping methods | Mental health support |
| غذای خانگی (هفتگی) | Home-cooked meals per week | Cooking habits |
| مشکلات خواب | Sleep issues | Health concerns |
| الگوی خوردن | Eating patterns | Meal timing |
| روش پخت | Cooking methods | Food preparation |
| نوع نان صبحانه | Breakfast bread type | Dietary preferences |

**Example Data:**
```
ساعات خواب: 8 ساعت
رابطه با غذا: آگاهانه غذاخور
مدیریت استرس: هیچ‌کدام
غذای خانگی (هفتگی): 2 بار
```

---

## 🎯 How Call Center Should Use This Data

### 1. **Pre-Call Preparation**
Review questionnaire data before calling:
- Check dietary restrictions for personalized advice
- Note digestive issues for targeted support
- Understand lifestyle factors for context

### 2. **During the Call**

**Opening:**
```
"سلام [نام]، می‌بینم که شما [نوع ورزش] انجام می‌دهید، چطور پیش میره؟"
"می‌بینم که [محدودیت‌های غذایی] دارید، آیا برنامه غذایی‌تون با این محدودیت‌ها همخوانی داره؟"
```

**Dietary Discussion:**
```
"با توجه به اینکه [دفعات پخت] پخت می‌کنید، آیا دستورالعمل‌های ساده‌تری نیاز دارید؟"
"می‌بینم که [صبحانه مورد علاقه] دوست دارید، آیا صبحانه‌های جدید هم امتحان کردید؟"
```

**Health Concerns:**
```
"با توجه به [نفخ شکم]، آیا غذاهای خاصی رو شناسایی کردید که مشکل ایجاد می‌کنه؟"
"می‌بینم که [سطح استرس]، آیا این روی عادات غذایی‌تون تأثیر گذاشته؟"
```

**Lifestyle Support:**
```
"با [ساعات خواب] خواب، آیا احساس می‌کنید انرژی کافی دارید؟"
"می‌بینم [مصرف آب روزانه] لیوان آب می‌نوشید، بیایید ببینیم چطور می‌تونیم این رو افزایش بدیم."
```

### 3. **Personalized Recommendations**

Based on questionnaire data:

**Low Water Intake:**
```
"می‌بینم آب کمی می‌نوشید. بیایید هدف روزانه تعیین کنیم..."
```

**High Processed Food:**
```
"با توجه به مصرف غذای فرآوری شده، بیایید جایگزین‌های سالم‌تر پیدا کنیم..."
```

**Sleep Issues:**
```
"مشکلات خواب می‌تونه روی کاهش وزن تأثیر بذاره. بیایید درباره این صحبت کنیم..."
```

**Digestive Symptoms:**
```
"علائم گوارشی ممکنه نشان‌دهنده عدم تحمل غذایی باشه. بیایید رژیم رو بررسی کنیم..."
```

---

## 📈 Test Results

### File Successfully Created
```bash
✅ File: call_center_users_20251012_134258.xlsx
✅ Users exported: 22
✅ Total columns: 70 (was 36, added 34)
✅ File size: ~14KB
```

### Sample Data Verification
```
User 1:
  محدودیت‌های غذایی: غیره, بادمجان
  نوع ورزش: کاردیو
  مصرف آب روزانه: 4 لیوان
  ساعات خواب: 8 ساعت
```

---

## 🔍 Data Quality Notes

### Handling Missing Data
- All questionnaire fields default to **"ندارد"** (Not Available) if:
  - User hasn't filled the questionnaire
  - Specific field is empty
  - Data can't be retrieved

### Data Cleaning
- Brackets `[]` are automatically removed
- Comma-separated lists are properly formatted
- Extra quotes and whitespace are cleaned

### Multiple Questionnaires
- If a user has filled the questionnaire multiple times, the **latest** version is used

---

## 💡 Call Center Tips

### 1. **Cross-Reference Data**
Compare questionnaire diseases with profile diseases:
```
بیماری‌های مزمن (پرسشنامه) vs بیماری‌ها (Profile)
```

### 2. **Identify Inconsistencies**
Look for contradictions to clarify:
- Exercise type vs activity level
- Sleep hours vs sleep issues
- Cooking frequency vs home-cooked meals

### 3. **Spot Opportunities**
Identify areas for improvement:
- Low water intake → Hydration coaching
- No exercise → Activity recommendations  
- High stress → Stress management tips
- Poor sleep → Sleep hygiene advice

### 4. **Build Rapport**
Use their preferences to personalize:
```
"می‌بینم که [میان‌وعده مورد علاقه] دوست دارید..."
"با توجه به [روش پخت] که استفاده می‌کنید..."
```

---

## 📊 Column Organization in Excel

The 70 columns are organized as follows:

1. **Contact Info** (5 columns)
   - Phone, Name, Email

2. **Personal Details** (7 columns)
   - Gender, Age, Birth date, Weight, Height, BMI

3. **Health Info** (2 columns)
   - Diseases, Activity level

4. **Subscription** (7 columns)
   - Status, Plan, Dates, Days remaining

5. **Payment** (5 columns)
   - Total payments, Amount, Last payment, Discounts

6. **Engagement** (4 columns)
   - Registration, Coins, Codes, Churn risk

7. **Assignment** (2 columns)
   - Therapist, Hospital

8. **System** (4 columns)
   - Device, App version, Market, User ID

9. **🆕 UserQuestionnaire** (13 columns)
   - Nutrition profile and preferences

10. **🆕 MicrobiomeQuestionnaire** (13 columns)
    - Digestive health and habits

11. **🆕 LifestyleQuestionnaire** (8 columns)
    - Sleep, stress, and lifestyle

---

## ✅ Summary

### What Changed
- ✅ Added 34 new questionnaire fields
- ✅ Total columns: 36 → 70
- ✅ File size: ~10KB → ~14KB
- ✅ All filters work correctly
- ✅ Data cleaning implemented
- ✅ Missing data handled gracefully

### Benefits
- 📊 **More Context**: Understand user's complete nutritional profile
- 💬 **Better Conversations**: Personalized discussions based on actual data
- 🎯 **Targeted Advice**: Specific recommendations based on habits
- 🤝 **Build Rapport**: Reference their preferences and habits
- 📈 **Identify Issues**: Spot health concerns and opportunities

### Ready to Use
All export filters work with the new questionnaire data:
- `python export_users_for_call_center.py` (all users)
- `python export_users_for_call_center.py active_subscription`
- `python export_users_for_call_center.py expired_subscription`
- `python export_users_for_call_center.py no_subscription`
- And all other filters...

---

**Updated**: October 12, 2025  
**Status**: ✅ Production Ready with Enhanced Questionnaire Data  
**Total Fields**: 70 comprehensive data points per user

---

*Now your call center team has complete nutritional and lifestyle information to provide truly personalized support!* 🎉


