# Call Center User Export Script

## Overview

This script generates a comprehensive Excel file containing all necessary user information for call center operations. The exported file includes contact details, health metrics, subscription status, payment history, and engagement data.

## Features

### Exported Data Includes:

#### 📞 Contact Information
- Phone number
- Full name (first and last)
- Email address

#### 👤 Personal Details
- Gender
- Age
- Birth date
- Current weight
- Goal weight
- Height
- BMI (automatically calculated)
- Diseases/health conditions
- Activity level

#### 💳 Subscription Information
- Subscription status (Active/Expired/Free)
- Plan name (Silver, Gold, Platinum, Bronze)
- Plan number
- Subscription start date
- Subscription end date
- Days remaining in subscription

#### 💰 Payment Information
- Total number of payments made
- Total amount paid (in Rials)
- Last payment date
- Last payment amount
- Discount codes used

#### 📊 Engagement Metrics
- Registration date
- Coin balance
- Referral code (intro code)
- User code
- Churn risk score

#### 🏥 Assignment Information
- Assigned nutritionist/therapist
- Associated hospital (if any)

#### 📱 System Information
- Device type
- App version
- Market source
- User ID (for reference)

## Usage

### Basic Usage

Export all registered users:
```bash
python export_users_for_call_center.py
```

### Filter Options

#### 1. Export Active Subscribers Only
Users with currently active subscriptions:
```bash
python export_users_for_call_center.py active_subscription
```

#### 2. Export Expired Subscribers
Users whose subscriptions have expired:
```bash
python export_users_for_call_center.py expired_subscription
```

#### 3. Export Non-Subscribers
Users who have never purchased a subscription:
```bash
python export_users_for_call_center.py no_subscription
```

#### 4. Export High Churn Risk Users
Users with high churn risk scores (risk score > 60):
```bash
python export_users_for_call_center.py high_churn_risk
```

#### 5. Export Recent Signups
Users who signed up in the last N days:
```bash
python export_users_for_call_center.py recent_signup 30
```
Replace `30` with any number of days.

#### 6. Export Specific Phone Numbers
Export data for specific users by phone number:
```bash
python export_users_for_call_center.py phone_list 09123456789 09198765432 09301234567
```

## Output

### File Location
The script generates an Excel file and saves it to:
```
static/amin/call_center_users_[filter]_[timestamp].xlsx
```

### Download Link
After execution, the script provides a public URL:
```
https://ziluck.probiofit.net/static/amin/call_center_users_[filter]_[timestamp].xlsx
```

### File Format
- **Format**: Excel (.xlsx)
- **Sheet Name**: کاربران (Users)
- **Formatting**: 
  - Colored headers with white text
  - Auto-adjusted column widths
  - Sorted by subscription status and remaining days

## Output Statistics

The script provides a summary including:
- Total users exported
- Number of users with active subscriptions
- Number of users with expired subscriptions
- Number of users without subscriptions
- Total revenue from all users

## Example Output

```
======================================================================
📊 EXPORT COMPLETED SUCCESSFULLY
======================================================================
✅ Total users exported: 1,247
📁 File saved to: /path/to/static/amin/call_center_users_all_20251012_143022.xlsx
🔗 Download link: https://ziluck.probiofit.net/static/amin/call_center_users_all_20251012_143022.xlsx
📅 Generated on: 2025-10-12 14:30:22

📈 STATISTICS:
   - Users with active subscription: 342
   - Users with expired subscription: 189
   - Users without subscription: 716
   - Total revenue: 1,234,567,890 ریال
======================================================================
```

## Call Center Use Cases

### 1. Renewal Campaigns
Export expired subscribers to call them for renewal:
```bash
python export_users_for_call_center.py expired_subscription
```

### 2. Retention Campaigns
Export high churn risk users to prevent cancellations:
```bash
python export_users_for_call_center.py high_churn_risk
```

### 3. Onboarding Calls
Export recent signups (last 7 days) for welcome calls:
```bash
python export_users_for_call_center.py recent_signup 7
```

### 4. Non-Subscriber Conversion
Export free users to offer subscription benefits:
```bash
python export_users_for_call_center.py no_subscription
```

### 5. Check-in Calls
Export users whose subscriptions are ending soon (you can sort the exported file by "روزهای باقی‌مانده" column in Excel)

### 6. Follow-up Specific Users
Export specific users by phone number for targeted follow-ups:
```bash
python export_users_for_call_center.py phone_list 09123456789 09198765432
```

## Excel File Columns (Persian)

The exported Excel file contains the following columns:

| Column Name | Description |
|------------|-------------|
| شماره تلفن | Phone Number |
| نام | First Name |
| نام خانوادگی | Last Name |
| نام کامل | Full Name |
| ایمیل | Email |
| جنسیت | Gender |
| سن | Age |
| تاریخ تولد | Birth Date |
| وزن فعلی (کیلوگرم) | Current Weight |
| وزن هدف (کیلوگرم) | Goal Weight |
| قد (سانتی‌متر) | Height |
| BMI | BMI |
| بیماری‌ها | Diseases |
| سطح فعالیت | Activity Level |
| وضعیت اشتراک | Subscription Status |
| نام پلن | Plan Name |
| شماره پلن | Plan Number |
| تاریخ شروع اشتراک | Subscription Start Date |
| تاریخ پایان اشتراک | Subscription End Date |
| روزهای باقی‌مانده | Days Remaining |
| تعداد پرداخت‌ها | Number of Payments |
| مجموع مبلغ پرداختی (ریال) | Total Amount Paid |
| تاریخ آخرین پرداخت | Last Payment Date |
| مبلغ آخرین پرداخت (ریال) | Last Payment Amount |
| کدهای تخفیف استفاده شده | Discount Codes Used |
| تاریخ ثبت‌نام | Registration Date |
| تعداد کوین | Coin Balance |
| کد معرف | Referral Code |
| کد کاربری | User Code |
| متخصص تغذیه | Assigned Nutritionist |
| بیمارستان مرتبط | Associated Hospital |
| نوع دستگاه | Device Type |
| نسخه اپلیکیشن | App Version |
| بازار | Market |
| شناسه کاربر | User ID |
| امتیاز ریزش | Churn Risk Score |

## Technical Details

### Requirements
- Python 3.6+
- Django
- pandas
- openpyxl (automatically installed with pandas)

### Database Models Used
- `User` (APIs.models)
- `Profile` (APIs.models)
- `TherapistSelection` (panel.models)
- `ZarinPalPayment` (payment.models)
- `DigiPayPayment` (payment.models)
- `HospitalUserUpgrade` (payment.models)

### Performance
- Processes users in batches
- Shows progress every 100 users
- Optimized database queries with `select_related()`

## Troubleshooting

### Issue: Script fails to run
**Solution**: Make sure Django environment is properly initialized and all required models are imported.

### Issue: Empty output file
**Solution**: Check if there are any registered users in the database matching your filter criteria.

### Issue: Missing data in some columns
**Solution**: Some users may not have complete profile information. The script handles missing data gracefully by showing 'ندارد' (None) or 'نامشخص' (Unknown).

### Issue: Permission errors when saving file
**Solution**: Ensure the `static/amin/` directory exists and has write permissions.

## Notes

- Only registered users (`isRegistered=True`) are exported
- The script automatically creates the output directory if it doesn't exist
- All dates are formatted as YYYY-MM-DD or YYYY-MM-DD HH:MM
- Amounts are in Iranian Rials
- The file is sorted by subscription status and remaining days by default
- BMI is calculated automatically from weight and height
- Age is calculated from birth date

## Support

For issues or questions about this script, contact the development team.

## Version History

- **v1.0** (2025-10-12): Initial release with comprehensive user data export and multiple filter options

