# User Data Logging Scoring System Documentation

## Overview

The scoring system evaluates user health-related behaviors based on their daily data logs. It calculates a variety of scores for different health dimensions (hydration, diet, sleep, exercise, etc.) and aggregates them into a daily wellness score. The system is designed to encourage healthy habits and consistent data logging.

---

## 1. Scoring Dimensions

The system calculates scores for the following dimensions:
- **Hydration**: Water intake (glasses per day)
- **Diet**: Quality and completeness of meal logging, and nutritional analysis
- **Dietary Habits Consistency**: Frequency and regularity of meal logging
- **Sleep**: Duration and timing of sleep
- **Exercise**: Steps taken and activity minutes
- **Mental Wellbeing**: Defaulted to a baseline value unless otherwise inferred
- **Logging Completeness**: How many key fields are filled in the daily log
- **Wellness Score**: Weighted aggregate of the above

---

## 2. Score Calculation Logic

### A. Daily Score Calculation

The main function for daily score calculation is `calculate_daily_scores(daily_log)` (see `APIs/views/user.py`):

- **Hydration**:  
  - Score = min(100, (water_glasses / 8) * 100)  
  - 8 glasses is considered optimal.

- **Dietary Habits Consistency**:  
  - Based on the number of main meals logged:
    - 3+ meals: 0.8
    - 2 meals: 0.5
    - 1 meal: 0.3

- **Sleep**:  
  - Score = 100 if 7–9 hours; otherwise, penalized by 20 points per hour away from 8.

- **Exercise**:  
  - Steps: min(100, (steps / 10,000) * 100)
  - Activity: min(100, (activity_minutes / 30) * 100)
  - Exercise score = average of steps and activity scores.

- **Logging Completeness**:  
  - Fraction of key fields filled (meals, water, steps, sleep, activities).

- **Wellness Score**:  
  - Weighted sum:
    - Hydration: 15%
    - Diet: 25%
    - Dietary Habits Consistency: 10%
    - Sleep: 20%
    - Exercise: 20%
    - Mental Wellbeing: 10%
  - Formula:  
    ```
    wellness_score = hydration*0.15 + diet*0.25 + dietary_habits.consistency*100*0.1 + sleep*0.2 + exercise*0.2 + mental_wellbeing*0.1
    ```

---

### B. Nutritional Scoring (Diet Quality)

- The system uses a detailed nutritional scoring module (`APIs/modules/scoring_module.py`) to analyze the quality of meals based on:
  - Ratios like carb-to-fiber, protein-to-calories, glycemic load, saturated fat, sodium-to-potassium, etc.
  - Disease-specific and goal-specific scoring rules (e.g., for diabetes, obesity, cardiovascular health).
  - Each metric is categorized (very_bad, bad, average, good, very_good) and mapped to a numeric score.
  - Weighted sum of these metrics gives the meal or diet score.

---

### C. Engagement and Logging Points

- Points are awarded for each type of data entry (diet, activity, steps, water, sleep, messages).
- Each entry can increment a daily engagement score, up to a cap.
- The completeness and frequency of logging directly impact the engagement and overall wellness score.

---

### D. Specialized Scoring (e.g., Meal Matching)

- When users follow a recommended diet plan, their logged meals are compared to the plan:
  - Points are deducted for missing or extra ingredients, or for large discrepancies in portion sizes.
  - The final meal score is capped (e.g., 10 for main meals, 5 for snacks).

---

## 3. Score Aggregation and Storage

- All individual scores are stored in the user's daily record.
- The total daily score is capped at 100.
- The system prints a breakdown of each component for transparency and debugging.

---

## 4. Wellness Assistant and Feedback

- The system uses the calculated scores to generate personalized feedback, notifications, and suggestions for the user.
- The feedback includes reasoning for each score and actionable tips for improvement.

---

## 5. Key Functions and Files

- `APIs/views/user.py`: `calculate_daily_scores`, wellness report endpoints.
- `APIs/views/views.py`: `updateTotalPointDay`, `updateTotalPointDayV1` (legacy), logic for updating points on each log.
- `APIs/modules/scoring_module.py`: Nutritional scoring logic, disease/goal-specific rules.
- `APIs/modules/wellness_assistant.py`: Aggregates scores, generates feedback and notifications.
- `panel/api.py`: Handles meal logging and scoring against diet plans.

---

## 6. Extensibility

- The scoring system is modular and can be extended to include new health dimensions, diseases, or custom rules.
- Weights and thresholds can be adjusted in the configuration dictionaries.

---

## 7. Example: Daily Log Scoring Flow

1. **User logs data** (meals, water, steps, sleep, activities).
2. **System updates points** for each entry type.
3. **Nutritional analysis** is performed on meals.
4. **Scores for each dimension** are calculated.
5. **Wellness score** is computed as a weighted sum.
6. **Personalized feedback** is generated and sent to the user.

---

## 8. References in Codebase

- `APIs/views/user.py` (lines ~2343–2418): Daily score calculation.
- `APIs/views/views.py` (lines ~674–1244): Point update logic for each log type.
- `APIs/modules/scoring_module.py` (entire file): Nutritional scoring.
- `APIs/modules/wellness_assistant.py` (lines ~58–145): Feedback and notification generation.
- `panel/api.py` (lines ~702–871): Meal logging and plan adherence scoring.

---

**For more details on any specific scoring dimension or code implementation, refer to the mentioned files and line numbers, or contact the development team.** 