# راهنمای توسعه

## نمای کلی

این راهنما اطلاعات جامعی برای توسعه‌دهندگان کارکن روی پروژه uDiet ارائه می‌دهد. این راهنما شامل راه‌اندازی محیط، استانداردهای کدنویسی، شیوه‌های تست و روش‌های استقرار است.

## راه‌اندازی محیط

### پیش‌نیازها

1. پایتون 3.8 یا بالاتر
2. Node.js 14 یا بالاتر
3. Git
4. SQLite (توسعه) یا MySQL (تولید)
5. ابزار محیط مجازی (venv یا conda)

### راه‌اندازی توسعه محلی

1. کلون کردن مخزن:
```bash
git clone https://github.com/your-org/udiet.git
cd udiet
```

2. ایجاد و فعال‌سازی محیط مجازی:
```bash
python -m venv venv
source venv/bin/activate  # در ویندوز: venv\Scripts\activate
```

3. نصب وابستگی‌ها:
```bash
pip install -r requirements.txt
```

4. تنظیم متغیرهای محیطی:
```bash
cp .env.example .env
# ویرایش .env با پیکربندی محلی خود
```

5. راه‌اندازی پایگاه داده:
```bash
python manage.py migrate
python manage.py createsuperuser
```

6. اجرای سرور توسعه:
```bash
python manage.py runserver
```

### ابزارهای توسعه

1. ویرایشگر کد:
   - VS Code با افزونه پایتون
   - PyCharm Professional

2. ابزارهای پایگاه داده:
   - SQLite Browser (توسعه)
   - MySQL Workbench (تولید)

3. تست API:
   - Postman
   - Insomnia

4. کنترل نسخه:
   - Git
   - GitHub Desktop

## ساختار پروژه

```
udiet/
├── APIs/                    # نقاط پایانی API و منطق کسب و کار
│   ├── views/              # توابع و کلاس‌های نمایش
│   ├── models.py           # مدل‌های پایگاه داده
│   ├── urls.py             # مسیریابی URL
│   └── tests/              # تست‌های API
├── panel/                  # پنل مدیریت
├── static/                 # فایل‌های استاتیک
├── templates/              # قالب‌های HTML
├── media/                  # فایل‌های آپلود شده توسط کاربر
├── docs/                   # مستندات
├── scripts/                # اسکریپت‌های کمکی
├── manage.py              # اسکریپت مدیریت Django
└── requirements.txt       # وابستگی‌های پایتون
```

## استانداردهای کدنویسی

### پایتون

1. راهنمای سبک:
   - پیروی از PEP 8
   - استفاده از Black برای فرمت‌بندی کد
   - استفاده از isort برای مرتب‌سازی import‌ها
   - حداکثر طول خط: 88 کاراکتر

2. قراردادهای نام‌گذاری:
   - کلاس‌ها: PascalCase
   - توابع/متدها: snake_case
   - متغیرها: snake_case
   - ثابت‌ها: UPPER_CASE
   - اعضای خصوصی: پیشوند _

3. مستندسازی:
   - استفاده از docstring‌های سبک Google
   - شامل type hints
   - مستندسازی تمام API‌های عمومی
   - به‌روزرسانی نظرات

مثال:
```python
def calculate_bmi(weight: float, height: float) -> float:
    """محاسبه شاخص توده بدنی (BMI).

    Args:
        weight: وزن به کیلوگرم
        height: قد به متر

    Returns:
        float: مقدار BMI

    Raises:
        ValueError: اگر وزن یا قد منفی باشد
    """
    if weight <= 0 or height <= 0:
        raise ValueError("وزن و قد باید مثبت باشند")
    return weight / (height ** 2)
```

### JavaScript/TypeScript

1. راهنمای سبک:
   - استفاده از ESLint
   - استفاده از Prettier
   - پیروی از راهنمای سبک Airbnb

2. قراردادهای نام‌گذاری:
   - کلاس‌ها: PascalCase
   - توابع: camelCase
   - متغیرها: camelCase
   - ثابت‌ها: UPPER_CASE
   - اعضای خصوصی: پیشوند _

3. مستندسازی:
   - استفاده از JSDoc
   - شامل تعاریف نوع
   - مستندسازی تمام API‌های عمومی

## تست

### ساختار تست

1. تست‌های واحد:
   - تست توابع جداگانه
   - شبیه‌سازی وابستگی‌های خارجی
   - استفاده از fixtures پایتست

2. تست‌های یکپارچه‌سازی:
   - تست نقاط پایانی API
   - تست عملیات پایگاه داده
   - تست یکپارچه‌سازی سرویس‌های خارجی

3. تست‌های end-to-end:
   - تست گردش‌های کاری کاربر
   - تست اجزای رابط کاربری
   - استفاده از Selenium یا Cypress

### اجرای تست‌ها

```bash
# اجرای تمام تست‌ها
python manage.py test

# اجرای ماژول تست خاص
python manage.py test APIs.tests.test_user

# اجرا با پوشش
coverage run manage.py test
coverage report
```

### نیازمندی‌های پوشش تست

- حداقل پوشش: 80%
- مسیرهای بحرانی: 100%
- نقاط پایانی API: 90%
- عملیات پایگاه داده: 85%

## گردش کار Git

### استراتژی شاخه‌ها

1. شاخه‌های اصلی:
   - `main`: کد آماده تولید
   - `develop`: شاخه یکپارچه‌سازی
   - `feature/*`: ویژگی‌های جدید
   - `bugfix/*`: رفع اشکالات
   - `release/*`: آماده‌سازی انتشار

2. نام‌گذاری شاخه‌ها:
   - ویژگی‌ها: `feature/description`
   - اشکالات: `bugfix/description`
   - انتشارها: `release/version`

### دستورالعمل‌های commit

1. فرمت:
```
<type>(<scope>): <description>

[بدنه اختیاری]

[پاورقی اختیاری]
```

2. انواع:
   - feat: ویژگی جدید
   - fix: رفع اشکال
   - docs: مستندات
   - style: فرمت‌بندی
   - refactor: بازسازی کد
   - test: تست
   - chore: نگهداری

3. مثال‌ها:
```
feat(auth): اضافه کردن تأیید شماره تلفن
fix(api): مدیریت مقادیر null در پروفایل کاربر
docs(readme): به‌روزرسانی دستورالعمل‌های نصب
```

## فرآیند بررسی کد

1. نیازمندی‌های Pull Request:
   - عنوان توصیفی
   - توضیحات دقیق
   - ارجاع به issue مرتبط
   - گزارش پوشش تست
   - به‌روزرسانی‌های مستندات

2. چک‌لیست بررسی:
   - رعایت سبک کد
   - پوشش تست
   - مستندات
   - تأثیر عملکرد
   - ملاحظات امنیتی
   - مدیریت خطا

## استقرار

### محیط استقرار

1. مراحل استقرار:
```bash
# Pull latest changes
git pull origin develop

# نصب وابستگی‌ها
pip install -r requirements.txt

# اجرای مهاجرت‌ها
python manage.py migrate

# جمع آوری فایل‌های استاتیک
python manage.py collectstatic

# اجرای سرویس‌ها
sudo systemctl restart udiet
```

2. تأیید:
   - اجرای سری تست
   - بررسی لاگ‌ها
   - تأیید عملیات مهاجرت
   - تست مسیرهای بحرانی

### محیط تولید

1. مراحل استقرار:
```bash
# Pull latest changes
git pull origin main

# نصب وابستگی‌ها
pip install -r requirements.txt

# اجرای مهاجرت‌ها
python manage.py migrate

# جمع آوری فایل‌های استاتیک
python manage.py collectstatic

# اجرای سرویس‌ها
sudo systemctl restart udiet
```

2. پس از استقرار:
   - مشاهده لاگ اشکال
   - بررسی متریک های عملکرد
   - تأیید بک‌ها
   - به‌روزرسانی مستندات

## مانیتورینگ و ثبت لاگ

### ثبت لاگ

1. سطح لاگ:
   - DEBUG: اطلاعات دقیق
   - INFO: اطلاعات عمومی
   - WARNING: پیام‌های هشدار
   - ERROR: پیام‌های اشکال
   - CRITICAL: اشکال بحرانی

2. فرمت لاگ:
```python
LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'verbose': {
            'format': '{levelname} {asctime} {module} {process:d} {thread:d} {message}',
            'style': '{',
        },
    },
    'handlers': {
        'file': {
            'level': 'INFO',
            'class': 'logging.FileHandler',
            'filename': 'debug.log',
            'formatter': 'verbose',
        },
    },
    'loggers': {
        'django': {
            'handlers': ['file'],
            'level': 'INFO',
            'propagate': True,
        },
    },
}
```

### مانیتورینگ

1. متریک های مانیتورینگ:
   - زمان پاسخ API
   - نرخ اشکال
   - عملکرد پایگاه داده
   - استفاده از حافظه
   - استفاده از CPU
   - حجم دیسک
   - حجم سرویس

2. هشدارها:
   - حداکثر نرخ اشکال
   - حداکثر زمان پاسخ
   - حداکثر استفاده منابع
   - اتفاقات امنیتی

## اصول امنیتی

1. احراز هویت:
   - استفاده از توکن JWT
   - پیاده سازی سرعت بندی
   - ذخیره سریع رمز عبور
   - مدیریت جلسه

2. حفاظت از داده:
   - رمنتیزه داده حساس
   - صافی ورودی کاربر
   - تأیید همه درخواست‌ها
   - استفاده از HTTPS

3. امنیت کد:
   - به‌روزرسانی وابستگی‌های وابسته
   - بررسی امنیت
   - بررسی کد
   - آزمون ترافیک پرت

## بهینه سازی عملکرد

1. پایگاه داده:
   - استفاده از ایندکس مناسب
   - بهینه سازی انتخاب
   - پیاده سازی حافظه
   - نگهداری منظم

2. API:
   - پیاده سازی صفحه بندی
   - استفاده از کمپرسی
   - حافظه سازی پاسخ
   - بهینه سازی بارگذاری

3. Frontend:
   - کم کردن فایل‌های عملیات
   - استفاده از CDN
   - پیاده سازی بارگذاری فازی
   - بهینه سازی تصاویر

## رفع اشکال

### اشکالات متداول

1. پایگاه داده:
   - مشکلات ارتباط
   - عملیات مهاجرت
   - مشکلات عملکرد

2. API:
   - اشکالات احراز هویت
   - سرعت بندی
   - تأیید خطا

3. استقرار:
   - مشکلات محیط
   - عملیات خطا
   - مشکلات ساختار

### ابزارهای اسناد

1. Django Debug Toolbar
2. ثبت لاگ
3. انتخاب داده
4. مانیتورینگ API
5. بهینه سازی عملکرد 