# API مدیریت کاربر

## نمای کلی

API مدیریت کاربر نقاط پایانی برای ثبت‌نام کاربر، احراز هویت، مدیریت پروفایل و تنظیمات کاربر ارائه می‌دهد.

## نقاط پایانی

### ثبت‌نام کاربر

#### ثبت‌نام
```http
POST /api/v1/user/sign/
Content-Type: application/json

{
    "phone_number": "string",
    "password": "string",
    "name": "string",
    "email": "string" // اختیاری
}
```

پاسخ:
```json
{
    "status": "success",
    "data": {
        "user_id": "integer",
        "activation_code": "string",
        "message": "کد فعال‌سازی به شماره تلفن شما ارسال شد"
    }
}
```

#### فعال‌سازی حساب
```http
POST /api/v1/user/activation_code/
Content-Type: application/json

{
    "phone_number": "string",
    "activation_code": "string"
}
```

پاسخ:
```json
{
    "status": "success",
    "data": {
        "token": "string",
        "user": {
            "id": "integer",
            "phone_number": "string",
            "name": "string",
            "role": "string"
        }
    }
}
```

### مدیریت پروفایل

#### دریافت اطلاعات پروفایل
```http
GET /api/v1/user/profile_info
Authorization: Bearer <token>
```

پاسخ:
```json
{
    "status": "success",
    "data": {
        "id": "integer",
        "phone_number": "string",
        "name": "string",
        "email": "string",
        "profile_image": "string",
        "created_at": "datetime",
        "last_login": "datetime",
        "settings": {
            "notifications_enabled": "boolean",
            "language": "string",
            "timezone": "string"
        }
    }
}
```

#### به‌روزرسانی پروفایل
```http
POST /api/v1/user/profile_info/update/
Authorization: Bearer <token>
Content-Type: application/json

{
    "name": "string", // اختیاری
    "email": "string", // اختیاری
    "profile_image": "file" // اختیاری
}
```

#### به‌روزرسانی وزن
```http
POST /api/v1/user/profile_info/update/weight/
Authorization: Bearer <token>
Content-Type: application/json

{
    "weight": "float",
    "unit": "string" // "kg" یا "lb"
}
```

### تنظیمات کاربر

#### دریافت تنظیمات
```http
GET /api/v1/user/settings
Authorization: Bearer <token>
```

پاسخ:
```json
{
    "status": "success",
    "data": {
        "notifications_enabled": "boolean",
        "language": "string",
        "timezone": "string",
        "measurement_system": "string", // "metric" یا "imperial"
        "theme": "string" // "light" یا "dark"
    }
}
```

#### به‌روزرسانی تنظیمات
```http
POST /api/v1/user/settings
Authorization: Bearer <token>
Content-Type: application/json

{
    "notifications_enabled": "boolean", // اختیاری
    "language": "string", // اختیاری
    "timezone": "string", // اختیاری
    "measurement_system": "string", // اختیاری
    "theme": "string" // اختیاری
}
```

### پرسشنامه کاربر

#### دریافت پرسشنامه
```http
GET /api/v1/user/questionnaire
Authorization: Bearer <token>
```

پاسخ:
```json
{
    "status": "success",
    "data": {
        "questions": [
            {
                "id": "integer",
                "question": "string",
                "type": "string", // "multiple_choice"، "text"، "number"
                "options": ["string"] // برای سؤالات چند گزینه‌ای
            }
        ]
    }
}
```

#### ارسال پرسشنامه
```http
POST /api/v1/user/questionnaire
Authorization: Bearer <token>
Content-Type: application/json

{
    "answers": [
        {
            "question_id": "integer",
            "answer": "string"
        }
    ]
}
```

### مدیریت حساب

#### حذف حساب
```http
POST /api/v1/delete/user/
Authorization: Bearer <token>
Content-Type: application/json

{
    "password": "string" // برای تأیید
}
```

## کدهای خطا

| کد | توضیحات |
|------|-------------|
| 400  | پارامترهای ورودی نامعتبر |
| 401  | غیرمجاز - توکن نامعتبر یا مفقود |
| 403  | ممنوع - حساب فعال نشده است |
| 404  | کاربر یافت نشد |
| 409  | شماره تلفن قبلاً ثبت شده است |
| 429  | تلاش‌های بیش از حد برای فعال‌سازی |

## محدودیت‌های نرخ

- ثبت‌نام: 3 تلاش در ساعت برای هر IP
- فعال‌سازی: 5 تلاش در ساعت برای هر شماره تلفن
- ورود: 10 تلاش در ساعت برای هر IP
- به‌روزرسانی پروفایل: 60 درخواست در ساعت برای هر کاربر

## ملاحظات امنیتی

1. رمزهای عبور باید شرایط زیر را داشته باشند:
   - حداقل 8 کاراکتر
   - حداقل یک حرف بزرگ
   - حداقل یک حرف کوچک
   - حداقل یک عدد
   - حداقل یک کاراکتر خاص

2. شماره‌های تلفن باید از طریق فعال‌سازی پیامکی تأیید شوند

3. توکن‌های JWT پس از 24 ساعت منقضی می‌شوند

4. عملیات حساس نیاز به تأیید رمز عبور دارند

## حریم خصوصی داده

- داده‌های کاربر در حالت ذخیره‌سازی رمزنگاری می‌شوند
- اطلاعات شخصی فقط با رضایت صریح به اشتراک گذاشته می‌شوند
- کاربران می‌توانند درخواست صدور یا حذف داده کنند
- تمام ارتباطات API از طریق HTTPS انجام می‌شوند

## بهترین شیوه‌ها

1. همیشه شماره‌های تلفن را قبل از ارسال کدهای فعال‌سازی تأیید کنید 