# API گزارش‌دهی

## نمای کلی

API گزارش‌دهی نقاط پایانی برای تولید گزارش‌های مختلف سلامت، تحلیل‌ها و پیگیری پیشرفت ارائه می‌دهد. این API به کاربران و ارائه‌دهندگان خدمات بهداشتی کمک می‌کند تا داده‌های سلامت را تحلیل کنند و پیشرفت را در طول زمان پیگیری کنند.

## نقاط پایانی

### گزارش‌های عمومی

#### تولید گزارش
```http
POST /api/v1/report/generate/
Authorization: Bearer <token>
Content-Type: application/json

{
    "report_type": "string", // "روزانه"، "هفتگی"، "ماهانه"، "سفارشی"
    "start_date": "date",
    "end_date": "date",
    "metrics": ["string"], // مثال: ["قند_خون"، "وزن"، "فعالیت"]
    "format": "string" // "json"، "pdf"، "csv"
}
```

پاسخ:
```json
{
    "status": "success",
    "data": {
        "report_id": "string",
        "report_url": "string",
        "generated_at": "datetime",
        "metrics": {
            "blood_sugar": {
                "average": "float",
                "min": "float",
                "max": "float",
                "trend": "string" // "افزایشی"، "کاهشی"، "پایدار"
            },
            "weight": {
                "start": "float",
                "end": "float",
                "change": "float",
                "trend": "string"
            },
            "activity": {
                "total_minutes": "integer",
                "calories_burned": "float",
                "most_common": "string"
            }
        }
    }
}
```

#### دریافت خلاصه گزارش
```http
GET /api/v1/report/summary
Authorization: Bearer <token>
پارامترهای جستجو:
- start_date: "date" // اختیاری
- end_date: "date" // اختیاری
```

### گزارش‌های روزانه

#### دریافت گزارش امروز
```http
GET /api/v1/report/reports/toDay
Authorization: Bearer <token>
```

پاسخ:
```json
{
    "status": "success",
    "data": {
        "date": "date",
        "blood_sugar": {
            "readings": [
                {
                    "time": "datetime",
                    "value": "float",
                    "type": "string"
                }
            ],
            "average": "float"
        },
        "meals": [
            {
                "time": "datetime",
                "name": "string",
                "calories": "float",
                "foods": [
                    {
                        "name": "string",
                        "quantity": "float",
                        "unit": "string"
                    }
                ]
            }
        ],
        "activities": [
            {
                "time": "datetime",
                "type": "string",
                "duration": "integer",
                "calories_burned": "float"
            }
        ],
        "medications": [
            {
                "time": "datetime",
                "name": "string",
                "dosage": "float",
                "unit": "string"
            }
        ],
        "water_intake": "float",
        "steps": "integer"
    }
}
```

### گزارش‌های هفتگی

#### دریافت گزارش هفتگی
```http
GET /api/v1/report/reports/weekly
Authorization: Bearer <token>
پارامترهای جستجو:
- week_start: "date" // اختیاری، پیش‌فرض هفته جاری
```

### امتیازات و دستاوردها

#### دریافت امتیازات
```http
GET /api/v1/report/points
Authorization: Bearer <token>
پارامترهای جستجو:
- start_date: "date" // اختیاری
- end_date: "date" // اختیاری
```

پاسخ:
```json
{
    "status": "success",
    "data": {
        "total_points": "integer",
        "daily_points": [
            {
                "date": "date",
                "points": "integer",
                "activities": [
                    {
                        "type": "string",
                        "points": "integer"
                    }
                ]
            }
        ],
        "achievements": [
            {
                "id": "integer",
                "name": "string",
                "description": "string",
                "earned_at": "datetime",
                "points": "integer"
            }
        ]
    }
}
```

#### دریافت امتیازات 30 روز گذشته
```http
GET /api/v1/report/last/thirty/days/points/
Authorization: Bearer <token>
```

#### دریافت بالاترین امتیازات
```http
GET /api/v1/report/Top/scores/
Authorization: Bearer <token>
پارامترهای جستجو:
- period: "string" // "هفته"، "ماه"، "سال"
- limit: "integer" // اختیاری، پیش‌فرض 10
```

### معیارهای سلامت

#### دریافت گزارش BMI
```http
GET /api/v1/report/bmi
Authorization: Bearer <token>
پارامترهای جستجو:
- start_date: "date" // اختیاری
- end_date: "date" // اختیاری
```

پاسخ:
```json
{
    "status": "success",
    "data": {
        "current_bmi": "float",
        "bmi_category": "string",
        "history": [
            {
                "date": "date",
                "bmi": "float",
                "weight": "float",
                "height": "float"
            }
        ],
        "recommendations": {
            "target_bmi": "float",
            "weight_change": "float",
            "suggestions": ["string"]
        }
    }
}
```

#### دریافت گزارش قدم‌ها
```http
GET /api/v1/report/reports/steps
Authorization: Bearer <token>
پارامترهای جستجو:
- start_date: "date" // اختیاری
- end_date: "date" // اختیاری
```

### گزارش‌های خواب

#### دریافت گزارش خواب
```http
GET /api/v1/report/sleep/report
Authorization: Bearer <token>
پارامترهای جستجو:
- start_date: "date" // اختیاری
- end_date: "date" // اختیاری
```

پاسخ:
```json
{
    "status": "success",
    "data": {
        "average_sleep_duration": "float",
        "sleep_quality": {
            "poor": "integer",
            "fair": "integer",
            "good": "integer",
            "excellent": "integer"
        },
        "sleep_schedule": [
            {
                "date": "date",
                "start_time": "datetime",
                "end_time": "datetime",
                "duration": "float",
                "quality": "string"
            }
        ],
        "recommendations": {
            "target_duration": "float",
            "suggestions": ["string"]
        }
    }
}
```

## کدهای خطا

| کد | توضیحات |
|------|-------------|
| 400  | پارامترهای ورودی نامعتبر |
| 401  | غیرمجاز - توکن نامعتبر یا مفقود |
| 403  | ممنوع - دسترسی ناکافی |
| 404  | گزارش یافت نشد |
| 422  | محدوده تاریخ نامعتبر |
| 429  | درخواست‌های بیش از حد |

## محدودیت‌های نرخ

- تولید گزارش: 10 درخواست در ساعت برای هر کاربر
- گزارش‌های روزانه: 100 درخواست در ساعت برای هر کاربر
- گزارش‌های هفتگی: 50 درخواست در ساعت برای هر کاربر
- امتیازات و دستاوردها: 100 درخواست در ساعت برای هر کاربر
- معیارهای سلامت: 50 درخواست در ساعت برای هر کاربر

## تجمیع داده

1. تجمیع مبتنی بر زمان:
   - میانگین‌های روزانه
   - روندهای هفتگی
   - خلاصه‌های ماهانه
   - مقایسه‌های سالانه

2. تجمیع معیار:
   - روندهای قند خون
   - تغییرات وزن
   - الگوهای فعالیت
   - کیفیت خواب
   - مصرف تغذیه‌ای

## بهترین شیوه‌ها

1. استفاده از محدوده‌های تاریخ مناسب
2. پیاده‌سازی تجمیع داده مناسب
3. کش کردن گزارش‌های پرکاربرد
4. پیاده‌سازی مدیریت خطای مناسب
5. استفاده از عملیات دسته‌ای برای معیارهای متعدد
6. ارائه توصیه‌های واضح
7. گنجاندن تحلیل روند
8. پشتیبانی از فرمت‌های خروجی متعدد
9. پیاده‌سازی تجسم داده مناسب
10. در نظر گرفتن ترجیحات و اهداف کاربر