# User Profile API Documentation

## Endpoints

### 1. Retrieve Profile Information

**Endpoint:**
```
GET /api/v1/user/profile_info
POST /api/v1/user/profile_info
```

**Description:**
Returns the current user's profile information. Both GET and POST methods are supported with different response formats.

---

#### Method 1: GET Request

**Endpoint:**
```
GET /api/v1/user/profile_info?token=<your_jwt_token>
```

**Description:**
Use GET method with token as a query parameter for standard REST API calls.

**Request Parameters:**
| Name   | Type   | Required | Description                |
|--------|--------|----------|----------------------------|
| token  | string | Yes      | JWT token as query parameter |

**Request Example:**
```bash
curl -X GET "https://api.example.com/api/v1/user/profile_info?token=your_jwt_token_here"
```

**Response Example:**
```json
{
  "status": "success",
  "data": {
    "first_name": "string",
    "last_name": "string",
    "birth_date": 1546270161,
    "weight": 70.5,
    "goal_weight": 68.0,
    "height": 175,
    "diabetes_type": 1,
    "detection_year": 1390,
    "insulin_sensitivity": 200,
    "pills": ["Metformin"],
    "type_of_treatment": 2,
    "user_setting": "string",
    "weight_state": "overweight",
    "activity_level": 1.5,
    "gender": 1,
    "CR": 12.5,
    "BMR": 1600,
    "IBW": 68.0,
    "carb_rate": 1.8,
    "a1c": 7.2,
    "email": "user@example.com",
    "user_code": "abc123",
    "avatar": 1,
    "diseases_list": "&1&2&3&",
    "Carbohydrates_g": 200,
    "Protein_g": 80,
    "Fat_g": 60,
    "Carbohydrates_unit": 50,
    "Protein_unit": 20,
    "Fat_unit": 15,
    "Carbohydrates_distribution_list_g": [30, 40, 50, 30, 20, 30],
    "Protein_distribution_g": 80,
    "Fat_distribution_g": 60,
    "jalali_birth_date": "1370-01-01"
  }
}
```

**Error Codes:**
| Code | Description                                 |
|------|---------------------------------------------|
| 400  | Invalid parameter                           |
| 401  | Invalid or missing token                    |
| 404  | Profile not found                           |

---

#### Method 2: POST Request

**Endpoint:**
```
POST /api/v1/user/profile_info
```

**Headers:**
```
Content-Type: application/json
```

**Description:**
Use POST method to create a new user profile. All profile information must be provided in the request body.

**Request Body Fields:**
| Name                        | Type    | Required | Description |
|-----------------------------|---------|----------|-------------|
| token                       | string  | Yes      | JWT token for authentication |
| first_name                  | string  | Yes      | User's first name |
| last_name                   | string  | Yes      | User's last name |
| birth_date                  | string  | Yes      | User's birth date |
| weight                      | string  | Yes      | User's weight |
| height                      | string  | Yes      | User's height |
| activity_level              | string  | Yes      | User's activity level |
| gender                      | string  | Yes      | User's gender |
| email                       | string  | Yes      | User's email address |
| type_of_treatment           | string  | Yes      | Type of treatment (default: "0") |
| avatar                      | string  | Yes      | Avatar code (default: "0") |
| diabetes_type               | string  | Yes      | Type of diabetes (default: "0") |
| detection_year              | string  | Yes      | Year of diabetes detection |
| minimum_sugar               | string  | Yes      | Minimum blood sugar level |
| maximum_sugar               | string  | Yes      | Maximum blood sugar level |
| hypo                        | string  | Yes      | Hypoglycemia threshold |
| hyper                       | string  | Yes      | Hyperglycemia threshold |
| device_type                 | string  | Yes      | Device type (e.g., "android") |
| disease_list                | string  | Yes      | List of diseases |
| user_settings               | string  | Yes      | User settings |
| intro_code                  | string  | Yes      | Introduction code (can be empty) |

**Request Body Example:**
```json
{
  "token": "your_jwt_token_here",
  "first_name": "Ali",
  "last_name": "Rezaei",
  "birth_date": "1990-01-01",
  "weight": "75",
  "height": "180",
  "activity_level": "1.5",
  "gender": "1",
  "email": "ali.rezaei@example.com",
  "type_of_treatment": "0",
  "avatar": "0",
  "diabetes_type": "0",
  "detection_year": "2020",
  "minimum_sugar": "70",
  "maximum_sugar": "190",
  "hypo": "60",
  "hyper": "250",
  "device_type": "android",
  "disease_list": "1&2&3",
  "user_settings": "1&2&3",
  "intro_code": " "
}
```

**Request Example:**
```bash
curl -X POST "https://api.example.com/api/v1/user/profile_info" \
  -H "Content-Type: application/json" \
  -d '{
    "token": "your_jwt_token_here",
    "first_name": "Ali",
    "last_name": "Rezaei",
    "birth_date": "1990-01-01",
    "weight": "75",
    "height": "180",
    "activity_level": "1.5",
    "gender": "1",
    "email": "ali.rezaei@example.com",
    "type_of_treatment": "0",
    "avatar": "0",
    "diabetes_type": "0",
    "detection_year": "2020",
    "minimum_sugar": "70",
    "maximum_sugar": "190",
    "hypo": "60",
    "hyper": "250",
    "device_type": "android",
    "disease_list": "1&2&3",
    "user_settings": "1&2&3",
    "intro_code": " "
  }'
```

**Response Example:**
```json
{
  "status": "success",
  "message": "Profile created successfully",
  "data": {
    "profile_id": 12345,
    "user_id": 67890,
    "created_at": "2024-01-15T10:30:00Z",
    "profile_status": "active"
  }
}
```

**Error Codes:**
| Code | Description                                 |
|------|---------------------------------------------|
| 400  | Invalid parameter or missing required fields |
| 401  | Invalid or missing token                    |
| 409  | Profile already exists for this user        |
| 422  | Validation error (e.g., invalid email format) |

---

### 2. Update Profile Information

**Endpoint:**
```
POST /api/v1/user/profile_info/update/
Content-Type: application/json
```

**Description:**
Updates the user's profile information. Only provided fields will be updated.

#### Request Body Fields
| Name                        | Type    | Required | Description |
|-----------------------------|---------|----------|-------------|
| token                       | string  | Yes      | JWT token for authentication |
| first_name                  | string  | No       | User's first name (min 2 chars) |
| last_name                   | string  | No       | User's last name (min 2 chars)  |
| birth_date                  | int     | No       | Timestamp (seconds since epoch)  |
| weight                      | float   | No       | User's weight                    |
| height                      | int     | No       | User's height (cm)               |
| diabetes_type               | int     | No       | 0: Gestational, 1: Type 1, 2: Type 2 |
| detection_year              | int     | No       | Year of diabetes detection        |
| insulin_sensitivity         | int     | No       | Insulin sensitivity               |
| pills                       | string  | No       | Medication codes, separated by &  |
| type_of_treatment           | int     | No       | 0: Drug, 1: Insulin, 2: GLP1, ... |
| user_setting                | string  | No       | User settings                     |
| activity_level              | float   | No       | Activity level (1-2)              |
| gender                      | int     | No       | 0: Female, 1: Male                |
| carb_rate                   | float   | No       | Carbohydrate rate                 |
| a1c                         | float   | No       | HbA1c value                       |
| email                       | string  | No       | Email address                     |
| user_code                   | string  | No       | User code                         |
| avatar                      | int     | No       | Avatar code                       |
| diseases                    | string  | No       | Disease codes, separated by &     |
| device_type                 | string  | No       | Device type (e.g., android)       |
| version                     | string  | No       | App version                       |
| market                      | string  | No       | Market name                       |
| firebase_token              | string  | No       | Firebase token                    |
| latitude                    | float   | No       | Latitude                          |
| longitude                   | float   | No       | Longitude                         |
| address                     | string  | No       | Address                           |

**Note:** All fields are optional except for the `token`. Only the fields provided in the request will be updated. Some fields (e.g., first_name, last_name) have minimum length requirements. If key fields (weight, height, etc.) are updated, profile calculations will be refreshed.

#### Request Example
```json
{
  "token": "your_jwt_token_here",
  "first_name": "Ali",
  "last_name": "Rezaei",
  "weight": 75.0,
  "height": 180,
  "diabetes_type": 2
}
```

#### Success Response Example
```json
{
  "status": "success",
  "data": ["first_name", "weight", "height"]
}
```

#### Error Codes
| Code | Description                                 |
|------|---------------------------------------------|
| 400  | Invalid parameter                           |
| 401  | Invalid or missing token                    |
| 404  | User not found                              |
| 409  | Conflict (e.g., duplicate email)            |

---

## Field Details

- **Required fields:**
  - For GET: Only the `token` in request body is required.
  - For POST (update): Only the `token` is required; all other fields are optional.
- **Optional fields:**
  - All fields in the POST body are optional except `token`. If omitted, they will not be changed.

## Security Notes

- **Token Placement**: JWT tokens are passed in the request body rather than headers for enhanced security, especially in mobile applications.
- **HTTPS Required**: All API calls must be made over HTTPS to ensure token security.
- **Token Expiration**: JWT tokens expire after 24 hours and must be refreshed.

## Error Codes (All Endpoints)
| Code | Description                                 |
|------|---------------------------------------------|
| 400  | Invalid parameter (e.g., wrong type, missing required) |
| 401  | Unauthorized (invalid or missing token)      |
| 403  | Forbidden (account not activated)            |
| 404  | Not found (user or profile not found)        |
| 409  | Conflict (e.g., duplicate phone/email)       |
| 429  | Too many requests (rate limit exceeded)      |

## Notes
- All requests must be made over HTTPS.
- JWT tokens expire after 24 hours.
- Sensitive operations may require password confirmation.
- All user data is encrypted at rest.
- Authentication tokens are passed in the request body for enhanced security. 