# API اعلان‌ها

## نمای کلی

API اعلان‌ها نقاط پایانی برای مدیریت اعلان‌های فوری، پیام‌های درون برنامه‌ای و ارتباطات مربی ارائه می‌دهد. این API با Firebase Cloud Messaging (FCM) برای اعلان‌های فوری یکپارچه می‌شود و یک سیستم پیام‌رسانی قوی برای تعامل با کاربر فراهم می‌کند.

## نقاط پایانی

### اعلان‌های فوری

#### ارسال اعلان به کاربران غیرفعال
```http
POST /api/v1/firebase/lastweek/
Authorization: Bearer <token>
Content-Type: application/json

{
    "message": "string",
    "title": "string",
    "data": {
        "type": "string",
        "action": "string",
        "params": {} // داده‌های اضافی اختیاری
    }
}
```

#### ارسال اعلان با لینک
```http
POST /api/v1/firebase/send/link/to/all/
Authorization: Bearer <token>
Content-Type: application/json

{
    "message": "string",
    "title": "string",
    "link": "string",
    "data": {
        "type": "string",
        "action": "string",
        "params": {} // داده‌های اضافی اختیاری
    }
}
```

#### ارسال یادداشت اعلان
```http
POST /api/v1/firebase/send/note/
Authorization: Bearer <token>
Content-Type: application/json

{
    "message": "string",
    "title": "string",
    "user_ids": ["string"], // اختیاری، در صورت عدم ارائه به تمام کاربران ارسال می‌شود
    "data": {
        "type": "string",
        "action": "string",
        "params": {} // داده‌های اضافی اختیاری
    }
}
```

### پیام‌های درون برنامه‌ای

#### ارسال پیام
```http
POST /api/v1/message/send/
Authorization: Bearer <token>
Content-Type: application/json

{
    "recipient_id": "string",
    "message": "string",
    "type": "string", // "متن"، "تصویر"، "سیستم"
    "metadata": {
        "image_url": "string", // اختیاری، برای پیام‌های تصویری
        "action": "string", // اختیاری، برای پیام‌های سیستمی
        "params": {} // داده‌های اضافی اختیاری
    }
}
```

پاسخ:
```json
{
    "status": "success",
    "data": {
        "message_id": "string",
        "sent_at": "datetime",
        "status": "string" // "ارسال شده"، "تحویل داده شده"، "خوانده شده"
    }
}
```

#### دریافت پیام‌های اخیر
```http
GET /api/v1/message/recent/
Authorization: Bearer <token>
پارامترهای جستجو:
- limit: "integer" // اختیاری، پیش‌فرض 20
- before: "datetime" // اختیاری، برای صفحه‌بندی
```

پاسخ:
```json
{
    "status": "success",
    "data": {
        "messages": [
            {
                "id": "string",
                "sender_id": "string",
                "recipient_id": "string",
                "message": "string",
                "type": "string",
                "metadata": {},
                "sent_at": "datetime",
                "read_at": "datetime",
                "status": "string"
            }
        ],
        "pagination": {
            "has_more": "boolean",
            "next_cursor": "string"
        }
    }
}
```

### تنظیمات اعلان

#### دریافت تنظیمات اعلان
```http
GET /api/v1/user/settings
Authorization: Bearer <token>
```

پاسخ:
```json
{
    "status": "success",
    "data": {
        "notifications": {
            "push_enabled": "boolean",
            "email_enabled": "boolean",
            "in_app_enabled": "boolean",
            "categories": {
                "health_alerts": "boolean",
                "diet_reminders": "boolean",
                "activity_reminders": "boolean",
                "medication_reminders": "boolean",
                "coach_messages": "boolean",
                "system_updates": "boolean"
            },
            "quiet_hours": {
                "enabled": "boolean",
                "start": "time",
                "end": "time"
            }
        }
    }
}
```

#### به‌روزرسانی تنظیمات اعلان
```http
POST /api/v1/user/settings
Authorization: Bearer <token>
Content-Type: application/json

{
    "notifications": {
        "push_enabled": "boolean", // اختیاری
        "email_enabled": "boolean", // اختیاری
        "in_app_enabled": "boolean", // اختیاری
        "categories": {
            "health_alerts": "boolean", // اختیاری
            "diet_reminders": "boolean", // اختیاری
            "activity_reminders": "boolean", // اختیاری
            "medication_reminders": "boolean", // اختیاری
            "coach_messages": "boolean", // اختیاری
            "system_updates": "boolean" // اختیاری
        },
        "quiet_hours": {
            "enabled": "boolean", // اختیاری
            "start": "time", // اختیاری
            "end": "time" // اختیاری
        }
    }
}
```

### قالب‌های اعلان

سیستم از قالب‌های مختلف اعلان برای سناریوهای مختلف پشتیبانی می‌کند:

1. هشدارهای سلامت:
   - هشدارهای سطح قند خون
   - یادآوری‌های دارو
   - یادآوری‌های فعالیت
   - یادآوری‌های پیگیری رژیم غذایی

2. به‌روزرسانی‌های پیشرفت:
   - اعلان‌های دستاورد
   - هشدارهای تکمیل هدف
   - گزارش‌های پیشرفت
   - اعلان‌های رکورد

3. ارتباطات مربی:
   - اعلان‌های پیام
   - هشدارهای بازخورد
   - به‌روزرسانی‌های برنامه
   - پیام‌های سفارشی

4. اعلان‌های سیستم:
   - به‌روزرسانی‌های برنامه
   - اعلان‌های ویژگی
   - هشدارهای نگهداری
   - اعلان‌های امنیتی

## کدهای خطا

| کد | توضیحات |
|------|-------------|
| 400  | پارامترهای ورودی نامعتبر |
| 401  | غیرمجاز - توکن نامعتبر یا مفقود |
| 403  | ممنوع - دسترسی ناکافی |
| 404  | کاربر یافت نشد |
| 422  | تنظیمات اعلان نامعتبر |
| 429  | درخواست‌های بیش از حد |

## محدودیت‌های نرخ

- اعلان‌های فوری: 100 درخواست در ساعت برای هر کاربر
- پیام‌های درون برنامه‌ای: 200 درخواست در ساعت برای هر کاربر
- به‌روزرسانی‌های تنظیمات: 50 درخواست در ساعت برای هر کاربر
- بازیابی پیام: 100 درخواست در ساعت برای هر کاربر

## بهترین شیوه‌ها

1. استفاده از کانال‌های اعلان مناسب
2. احترام به ترجیحات کاربر
3. پیاده‌سازی ساعات سکوت
4. استفاده از قالب‌های اعلان مناسب
5. گنجاندن محتوای قابل اقدام
6. پیاده‌سازی مدیریت خطای مناسب
7. استفاده از عملیات دسته‌ای در صورت امکان
8. نظارت بر تحویل اعلان
9. پیاده‌سازی منطق تلاش مجدد مناسب
10. پیروی از دستورالعمل‌های پلتفرم

## ملاحظات امنیتی

1. اعتبارسنجی مجوزهای کاربر
2. پاکسازی محتوای پیام
3. پیاده‌سازی محدودیت نرخ
4. استفاده از کانال‌های امن
5. محافظت از حریم خصوصی کاربر
6. پیاده‌سازی احراز هویت مناسب
7. نظارت بر سوء استفاده
8. پیروی از مقررات حفاظت از داده