# API نظارت بر سلامت

## نمای کلی

API نظارت بر سلامت نقاط پایانی برای پیگیری معیارهای مختلف سلامت از جمله فعالیت‌ها، مصرف غذا، سطح قند خون، مصرف دارو، الگوهای خواب و مدیریت وزن ارائه می‌دهد.

## نقاط پایانی

### پیگیری فعالیت

#### ثبت فعالیت
```http
POST /api/v1/report/activities
Authorization: Bearer <token>
Content-Type: application/json

{
    "activity_type": "string",
    "duration": "integer", // به دقیقه
    "intensity": "string", // "کم"، "متوسط"، "زیاد"
    "calories_burned": "float",
    "date": "datetime",
    "notes": "string" // اختیاری
}
```

#### ویرایش فعالیت
```http
POST /api/v1/report/activities/edit/
Authorization: Bearer <token>
Content-Type: application/json

{
    "activity_id": "integer",
    "activity_type": "string", // اختیاری
    "duration": "integer", // اختیاری
    "intensity": "string", // اختیاری
    "calories_burned": "float", // اختیاری
    "date": "datetime", // اختیاری
    "notes": "string" // اختیاری
}
```

#### حذف فعالیت
```http
POST /api/v1/report/activities/delete/
Authorization: Bearer <token>
Content-Type: application/json

{
    "activity_id": "integer"
}
```

### ثبت غذا

#### ثبت مصرف غذا
```http
POST /api/v1/report/eating
Authorization: Bearer <token>
Content-Type: application/json

{
    "food_id": "integer",
    "quantity": "float",
    "unit": "string", // "گرم"، "میلی‌لیتر"، "وعده"
    "meal_type": "string", // "صبحانه"، "ناهار"، "شام"، "میان‌وعده"
    "date": "datetime",
    "notes": "string" // اختیاری
}
```

#### ثبت غذا با تصویر
```http
POST /api/v1/report/eating/with/pic/
Authorization: Bearer <token>
Content-Type: multipart/form-data

{
    "image": "file",
    "meal_type": "string",
    "date": "datetime",
    "notes": "string" // اختیاری
}
```

#### دریافت لیست غذاها
```http
GET /api/v1/report/Foodstuffs/
Authorization: Bearer <token>
```

پاسخ:
```json
{
    "status": "success",
    "data": {
        "foods": [
            {
                "id": "integer",
                "name": "string",
                "calories": "float",
                "protein": "float",
                "carbs": "float",
                "fat": "float",
                "serving_size": "float",
                "serving_unit": "string"
            }
        ]
    }
}
```

### نظارت بر قند خون

#### ثبت قند خون
```http
POST /api/v1/report/sugar
Authorization: Bearer <token>
Content-Type: application/json

{
    "value": "float",
    "unit": "string", // "mg/dl" یا "mmol/l"
    "measurement_type": "string", // "ناشتا"، "قبل از غذا"، "بعد از غذا"، "تصادفی"
    "date": "datetime",
    "notes": "string" // اختیاری
}
```

#### ثبت قند خون با تصویر
```http
POST /api/v1/report/sugar/glocometer/
Authorization: Bearer <token>
Content-Type: multipart/form-data

{
    "image": "file",
    "value": "float",
    "unit": "string",
    "measurement_type": "string",
    "date": "datetime",
    "notes": "string" // اختیاری
}
```

### پیگیری دارو

#### ثبت دارو
```http
POST /api/v1/report/drug
Authorization: Bearer <token>
Content-Type: application/json

{
    "drug_id": "integer",
    "dosage": "float",
    "unit": "string",
    "date": "datetime",
    "notes": "string" // اختیاری
}
```

#### ثبت مصرف انسولین
```http
POST /api/v1/report/insulin
Authorization: Bearer <token>
Content-Type: application/json

{
    "insulin_id": "integer",
    "dosage": "float",
    "unit": "string", // "واحد"
    "injection_site": "string", // اختیاری
    "date": "datetime",
    "notes": "string" // اختیاری
}
```

#### ثبت مصرف GLP-1
```http
POST /api/v1/report/glp1/
Authorization: Bearer <token>
Content-Type: application/json

{
    "glp1_id": "integer",
    "dosage": "float",
    "unit": "string",
    "date": "datetime",
    "notes": "string" // اختیاری
}
```

### پیگیری خواب

#### ثبت خواب
```http
POST /api/v1/report/sleep/report
Authorization: Bearer <token>
Content-Type: application/json

{
    "start_time": "datetime",
    "end_time": "datetime",
    "quality": "string", // "ضعیف"، "متوسط"، "خوب"، "عالی"
    "notes": "string" // اختیاری
}
```

### مدیریت وزن

#### ثبت وزن
```http
POST /api/v1/report/add/weight
Authorization: Bearer <token>
Content-Type: application/json

{
    "weight": "float",
    "unit": "string", // "kg" یا "lb"
    "date": "datetime",
    "notes": "string" // اختیاری
}
```

#### دریافت تاریخچه وزن
```http
GET /api/v1/report/get/weight
Authorization: Bearer <token>
پارامترهای جستجو:
- start_date: "date" // اختیاری
- end_date: "date" // اختیاری
```

### مصرف آب

#### ثبت مصرف آب
```http
POST /api/v1/report/add/water
Authorization: Bearer <token>
Content-Type: application/json

{
    "amount": "float",
    "unit": "string", // "ml" یا "oz"
    "date": "datetime"
}
```

## Error Codes

| Code | Description |
|------|-------------|
| 400  | Invalid input parameters |
| 401  | Unauthorized - Invalid or missing token |
| 403  | Forbidden - Insufficient permissions |
| 404  | Resource not found |
| 409  | Duplicate entry |
| 422  | Invalid measurement unit |
| 429  | Too many requests |

## Rate Limits

- Activity logging: 100 requests per hour per user
- Food logging: 100 requests per hour per user
- Blood sugar logging: 50 requests per hour per user
- Medication logging: 50 requests per hour per user
- Sleep logging: 10 requests per hour per user
- Weight logging: 10 requests per hour per user
- Water logging: 50 requests per hour per user

## Data Validation

1. Blood Sugar Values:
   - mg/dl: 20-600
   - mmol/l: 1.1-33.3

2. Weight Values:
   - kg: 20-300
   - lb: 44-661

3. Water Intake:
   - ml: 0-5000
   - oz: 0-169

4. Activity Duration:
   - Minimum: 1 minute
   - Maximum: 1440 minutes (24 hours)

## Best Practices

1. Use appropriate units based on user preferences
2. Validate all measurements before storage
3. Implement proper date/time handling
4. Cache frequently accessed data
5. Implement proper error handling
6. Use batch operations for multiple entries
7. Implement data aggregation for reports 