# Food Card Suggestion API

## Overview

The Food Card Suggestion API provides personalized food recommendations based on user profile, calorie requirements, and health conditions.

## Endpoint

```
POST /api/v1/user/suggest/food/card/
```

## Request Parameters

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| `token` | string | Yes | User authentication token (30 characters) |
| `meal_id` | integer | Yes | Meal type identifier (0-4) |

### Meal ID Values

- `0`: Breakfast (صبحانه)
- `1`: Lunch (نهار)  
- `2`: Dinner (شام)
- `3`: Snack 1 (میان وعده اول)
- `4`: Snack 2 (میان وعده دوم)

## Request Example

```json
{
    "token": "abc123def456ghi789jkl012mno345pqr",
    "meal_id": 1
}
```

## Response Format

### Success Response

```json
{
    "status": "OK",
    "message": "Food card suggested successfully",
    "data": {
        "food_card": {
            "id": 123,
            "fa_name": "ساندویچ مرغ و سبزیجات",
            "en_name": "Chicken and Vegetable Sandwich",
            "calories": 350,
            "carb_ratio": 45.0,
            "fat_ratio": 25.0,
            "protein_ratio": 30.0,
            "recipe_description": "ساندویچ سالم با مرغ کبابی و سبزیجات تازه",
            "recipe_image_link": "https://example.com/image.jpg",
            "foods": ["bread", "chicken", "vegetables"]
        },
        "user_info": {
            "user_cr": 2000,
            "meal_calories": 700,
            "meal_type": "lunch",
            "meal_id": 1
        },
        "health_tags": {
            "Allergens": {
                "AL_Dairy_Milk": 0,
                "AL_Grain_Wheat": 0
            },
            "DietaryPreferences": {
                "Diet_Low_Sugar": 1,
                "Diet_Low_Fat": 0
            },
            "Diseases": {
                "Disease_Diabetes": 1,
                "Disease_Hypertension": 0
            }
        }
    }
}
```

### Error Responses

#### Invalid Token
```json
{
    "status": "Error",
    "message": "Invalid token",
    "error_code": 1001
}
```

#### User Profile Not Found
```json
{
    "status": "Error", 
    "message": "User profile not found",
    "error_code": 1002
}
```

#### No Suitable Food Cards
```json
{
    "status": "Error",
    "message": "No suitable food cards found", 
    "error_code": 1002
}
```

## Algorithm Details

The API follows this process:

1. **User Identification**: Validates the token and retrieves user profile
2. **Calorie Calculation**: 
   - Gets user's daily calorie requirement (CR)
   - Calculates meal-specific calories based on meal type:
     - Breakfast: 20% of daily calories
     - Lunch: 35% of daily calories  
     - Dinner: 30% of daily calories
     - Snacks: 7.5% of daily calories each
3. **Health Tag Generation**: Uses `generate_health_tags()` function to analyze user questionnaire responses
4. **Food Card Filtering**:
   - Filters by meal type (breakfast/lunch/dinner/snack)
   - Filters by calorie range (±20% tolerance)
   - Excludes allergens based on user health tags
   - Applies dietary preferences (vegan, gluten-free, etc.)
   - Considers disease-specific requirements
5. **Fallback Strategy**: If no cards match strict criteria, relaxes constraints progressively
6. **Random Selection**: Randomly selects one suitable food card

## Health Conditions Supported

### Allergens
- Dairy products (لبنیات)
- Gluten (گلوتن) 
- Eggs (تخم مرغ)
- Soy (سویا)
- Nuts and seeds (آجیل و دانه‌های روغنی)
- Red meat (گوشت قرمز)
- Processed foods (غذاهای فرآوری‌شده)
- White meat (گوشت سفید)
- Seafood (غذاهای دریایی)
- Legumes (حبوبات)
- Eggplant (بادمجان)
- Mushrooms (قارچ)
- Dried fruits (میوه‌های خشک)

### Dietary Preferences
- Vegetarian (گیاهخوار)
- Vegan (وگان)
- Low sugar (قند)
- Low carb (کربوهیدرات کم)
- Low fat (کم چربی)
- Low sodium (کم سدیم)

### Diseases
- Diabetes (دیابت)
- Hypertension (فشار خون بالا)
- High cholesterol (کلسترول چربی و کمی دفع پروتئین)
- Heart disease (بیماری قلبی)
- IBS (سندروم روده تحریک پذیر)
- Gout (نقرس)

## Notes

- The API uses a ±20% calorie tolerance to provide more food options
- If no cards match the strict criteria, the API progressively relaxes constraints
- Health tags are generated from user questionnaire responses using the `generate_health_tags()` function
- The API returns comprehensive information including the selected food card, user context, and applied health filters 