# API مدیریت رژیم غذایی

## نمای کلی

API مدیریت رژیم غذایی نقاط پایانی برای مدیریت برنامه‌های رژیم غذایی، پایگاه داده غذا، تحلیل تغذیه‌ای و توصیه‌های رژیم غذایی ارائه می‌دهد. این API به کاربران کمک می‌کند تا مصرف تغذیه‌ای خود را پیگیری کنند و از برنامه‌های رژیم غذایی شخصی‌سازی شده پیروی کنند.

## نقاط پایانی

### برنامه‌های رژیم غذایی

#### دریافت لیست رژیم
```http
GET /api/v1/diet/list/
Authorization: Bearer <token>
پارامترهای جستجو:
- start_date: "date" // اختیاری
- end_date: "date" // اختیاری
- type: "string" // اختیاری، فیلتر بر اساس نوع رژیم
```

پاسخ:
```json
{
    "status": "success",
    "data": {
        "diets": [
            {
                "id": "integer",
                "name": "string",
                "type": "string",
                "description": "string",
                "start_date": "date",
                "end_date": "date",
                "meals": [
                    {
                        "id": "integer",
                        "name": "string",
                        "time": "time",
                        "foods": [
                            {
                                "food_id": "integer",
                                "name": "string",
                                "quantity": "float",
                                "unit": "string",
                                "calories": "float",
                                "protein": "float",
                                "carbs": "float",
                                "fat": "float"
                            }
                        ]
                    }
                ],
                "total_calories": "float",
                "total_protein": "float",
                "total_carbs": "float",
                "total_fat": "float"
            }
        ]
    }
}
```

#### تولید رژیم رایگان
```http
POST /api/v1/api/generate/
Authorization: Bearer <token>
Content-Type: application/json

{
    "preferences": {
        "calories": "float",
        "protein": "float", // درصد
        "carbs": "float", // درصد
        "fat": "float", // درصد
        "meals_per_day": "integer",
        "dietary_restrictions": ["string"], // مثال: "گیاهخواری"، "بدون گلوتن"
        "allergies": ["string"],
        "favorite_foods": ["integer"], // شناسه‌های غذا
        "disliked_foods": ["integer"] // شناسه‌های غذا
    },
    "duration": "integer", // تعداد روزها
    "start_date": "date"
}
```

### پایگاه داده غذا

#### دریافت لیست غذاها
```http
GET /api/v1/list/foods
Authorization: Bearer <token>
پارامترهای جستجو:
- search: "string" // اختیاری، جستجو بر اساس نام
- category: "string" // اختیاری، فیلتر بر اساس دسته‌بندی
- page: "integer" // اختیاری، برای صفحه‌بندی
- per_page: "integer" // اختیاری، تعداد آیتم در هر صفحه
```

پاسخ:
```json
{
    "status": "success",
    "data": {
        "foods": [
            {
                "id": "integer",
                "name": "string",
                "category": "string",
                "calories": "float",
                "protein": "float",
                "carbs": "float",
                "fat": "float",
                "fiber": "float",
                "sugar": "float",
                "serving_size": "float",
                "serving_unit": "string",
                "is_favorite": "boolean"
            }
        ],
        "pagination": {
            "total": "integer",
            "page": "integer",
            "per_page": "integer",
            "total_pages": "integer"
        }
    }
}
```

#### افزودن غذا به علاقه‌مندی‌ها
```http
POST /api/v1/list/add/to/favorite/foods/
Authorization: Bearer <token>
Content-Type: application/json

{
    "food_id": "integer"
}
```

#### حذف غذا از علاقه‌مندی‌ها
```http
POST /api/v1/list/delete/from/favorite/foods/
Authorization: Bearer <token>
Content-Type: application/json

{
    "food_id": "integer"
}
```

#### دریافت غذاهای مورد علاقه
```http
GET /api/v1/list/favorite/foods/
Authorization: Bearer <token>
```

### تحلیل تغذیه‌ای

#### دریافت توزیع درشت‌مغذی‌ها
```http
GET /api/v1/report/macro_nutrients_distribution
Authorization: Bearer <token>
پارامترهای جستجو:
- start_date: "date" // اختیاری
- end_date: "date" // اختیاری
```

پاسخ:
```json
{
    "status": "success",
    "data": {
        "daily_averages": {
            "calories": "float",
            "protein": {
                "grams": "float",
                "percentage": "float"
            },
            "carbs": {
                "grams": "float",
                "percentage": "float"
            },
            "fat": {
                "grams": "float",
                "percentage": "float"
            }
        },
        "trends": {
            "dates": ["date"],
            "calories": ["float"],
            "protein": ["float"],
            "carbs": ["float"],
            "fat": ["float"]
        }
    }
}
```

#### بررسی پارامترهای وعده غذایی
```http
GET /api/v1/check/meal/parameters/
Authorization: Bearer <token>
پارامترهای جستجو:
- meal_id: "integer"
```

پاسخ:
```json
{
    "status": "success",
    "data": {
        "meal": {
            "id": "integer",
            "name": "string",
            "time": "time",
            "total_calories": "float",
            "protein": "float",
            "carbs": "float",
            "fat": "float",
            "fiber": "float",
            "sugar": "float",
            "glycemic_index": "float",
            "glycemic_load": "float"
        },
        "recommendations": {
            "calorie_range": {
                "min": "float",
                "max": "float"
            },
            "protein_range": {
                "min": "float",
                "max": "float"
            },
            "carbs_range": {
                "min": "float",
                "max": "float"
            },
            "fat_range": {
                "min": "float",
                "max": "float"
            }
        }
    }
}
```

## کدهای خطا

| کد | توضیحات |
|------|-------------|
| 400  | پارامترهای ورودی نامعتبر |
| 401  | غیرمجاز - توکن نامعتبر یا مفقود |
| 403  | ممنوع - دسترسی ناکافی |
| 404  | منبع یافت نشد |
| 409  | ورودی تکراری |
| 422  | مقادیر تغذیه‌ای نامعتبر |
| 429  | درخواست‌های بیش از حد |

## محدودیت‌های نرخ

- تولید برنامه رژیم: 5 درخواست در روز برای هر کاربر
- پرس‌وجوهای پایگاه داده غذا: 100 درخواست در ساعت برای هر کاربر
- تحلیل تغذیه‌ای: 50 درخواست در ساعت برای هر کاربر
- مدیریت غذاهای مورد علاقه: 100 درخواست در ساعت برای هر کاربر

## اعتبارسنجی داده

1. مقادیر تغذیه‌ای:
   - کالری: 0-5000 کیلوکالری
   - پروتئین: 0-500 گرم
   - کربوهیدرات: 0-1000 گرم
   - چربی: 0-500 گرم
   - فیبر: 0-100 گرم
   - قند: 0-500 گرم

2. پارامترهای وعده غذایی:
   - وعده‌های غذایی در روز: 1-6
   - اندازه‌های وعده: 0-2000 گرم
   - شاخص گلیسمی: 0-100
   - بار گلیسمی: 0-100

## بهترین شیوه‌ها

1. استفاده از واحدهای مناسب بر اساس ترجیحات کاربر
2. اعتبارسنجی تمام مقادیر تغذیه‌ای قبل از ذخیره‌سازی
3. پیاده‌سازی مدیریت مناسب تاریخ/زمان
4. کش کردن داده‌های پرکاربرد
5. پیاده‌سازی مدیریت خطای مناسب
6. استفاده از عملیات دسته‌ای برای ورودی‌های متعدد
7. پیاده‌سازی تجمیع داده برای گزارش‌ها
8. در نظر گرفتن ترجیحات و محدودیت‌های کاربر
9. ارائه توصیه‌های تغذیه‌ای
10. پیگیری غذاهای مورد علاقه و تاریخچه 