# مستندات API

## نمای کلی

API برنامه uDiet یک سرویس RESTful است که نقاط پایانی برای نظارت بر سلامت، مدیریت رژیم غذایی، مدیریت کاربر و گزارش‌دهی ارائه می‌دهد. تمام نقاط پایانی API با پیشوند `/api/v1/` شروع می‌شوند.

## احراز هویت

API از JWT (توکن وب JSON) برای احراز هویت استفاده می‌کند. برای دسترسی به نقاط پایانی محافظت شده، توکن JWT را در هدر Authorization قرار دهید:

```
Authorization: Bearer <your_jwt_token>
```

### نقاط پایانی احراز هویت

#### ورود
```http
POST /api/v1/user/login/
Content-Type: application/json

{
    "phone_number": "string",
    "password": "string"
}
```

پاسخ:
```json
{
    "token": "string",
    "user": {
        "id": "integer",
        "phone_number": "string",
        "name": "string",
        "role": "string"
    }
}
```

#### خروج
```http
POST /api/v1/user/logout/
Authorization: Bearer <token>
```

## دسته‌بندی‌های API

1. [مدیریت کاربر](./user.md)
   - ثبت‌نام کاربر
   - مدیریت پروفایل
   - احراز هویت
   - تنظیمات

2. [نظارت بر سلامت](./health.md)
   - پیگیری فعالیت
   - ثبت غذا
   - نظارت بر قند خون
   - پیگیری دارو
   - پیگیری خواب
   - مدیریت وزن

3. [مدیریت رژیم غذایی](./diet.md)
   - برنامه‌ریزی وعده‌های غذایی
   - پایگاه داده غذا
   - تحلیل تغذیه‌ای
   - توصیه‌های رژیم غذایی

4. [گزارش‌دهی](./reporting.md)
   - گزارش‌های سلامت
   - تحلیل‌ها
   - پیگیری پیشرفت
   - گزارش‌های سفارشی

5. [اعلان‌ها](./notifications.md)
   - اعلان‌های فوری
   - پیام‌های درون برنامه‌ای
   - ارتباطات مربی

## فرمت‌های پاسخ متداول

### پاسخ موفقیت
```json
{
    "status": "success",
    "data": {
        // داده‌های پاسخ
    }
}
```

### پاسخ خطا
```json
{
    "status": "error",
    "error": {
        "code": "string",
        "message": "string",
        "details": {} // جزئیات اضافی خطا (اختیاری)
    }
}
```

## کدهای خطا

| کد | توضیحات |
|------|-------------|
| 400  | درخواست نامعتبر - پارامترهای ورودی نامعتبر |
| 401  | غیرمجاز - احراز هویت نامعتبر یا مفقود |
| 403  | ممنوع - دسترسی ناکافی |
| 404  | یافت نشد - منبع وجود ندارد |
| 429  | درخواست‌های بیش از حد - محدودیت نرخ تجاوز شده |
| 500  | خطای داخلی سرور |

## محدودیت نرخ

درخواست‌های API برای جلوگیری از سوء استفاده محدود شده‌اند. محدودیت‌های فعلی:
- 100 درخواست در دقیقه برای کاربران احراز هویت شده
- 20 درخواست در دقیقه برای کاربران احراز هویت نشده

هدرهای محدودیت نرخ در تمام پاسخ‌ها گنجانده شده‌اند:
```
X-RateLimit-Limit: 100
X-RateLimit-Remaining: 95
X-RateLimit-Reset: 1625097600
```

## نسخه‌گذاری

API از نسخه‌گذاری URL استفاده می‌کند (مثلاً `/api/v1/`). هنگامی که تغییرات شکست‌آور معرفی می‌شوند، یک نسخه جدید منتشر می‌شود در حالی که سازگاری معکوس برای یک دوره معقول حفظ می‌شود.

## بهترین شیوه‌ها

1. همیشه از HTTPS استفاده کنید
2. هدرهای مناسب را شامل کنید
3. محدودیت نرخ را مدیریت کنید
4. مدیریت خطای مناسب را پیاده‌سازی کنید
5. پاسخ‌ها را در صورت لزوم کش کنید
6. از صفحه‌بندی برای نقاط پایانی لیست استفاده کنید

## SDK‌ها و کتابخانه‌های کلاینت

- SDK پایتون (برنامه‌ریزی شده)
- SDK جاوااسکریپت/تایپ‌اسکریپت (برنامه‌ریزی شده)
- SDK‌های موبایل برای iOS و Android (برنامه‌ریزی شده)

## پشتیبانی

برای پشتیبانی API یا گزارش مشکلات:
- یک issue در مخزن ایجاد کنید
- با تیم توسعه تماس بگیرید
- برای وضعیت سیستم به [صفحه وضعیت API](./status.md) مراجعه کنید 