# مستندات پروژه uDiet

به مستندات پروژه uDiet خوش آمدید. این مستندات اطلاعات جامعی در مورد معماری سیستم، API‌ها و دستورالعمل‌های توسعه ارائه می‌دهد.

## فهرست مطالب

1. [معماری سیستم](./architecture.md)
   - نمای کلی سیستم
   - نمودارهای تعامل اجزا
   - جزئیات پشته فناوری

2. [مستندات API](./api/README.md)
   - احراز هویت و مجوزها
   - مرجع نقاط پایانی
   - ساختارهای درخواست/پاسخ
   - کدهای خطا

3. [مستندات پایگاه داده](./database.md)
   - نمودارهای ارتباط موجودیت‌ها
   - تعاریف ساختار
   - مهاجرت‌ها
   - مدل‌های داده

4. [راهنمای توسعه](./development.md)
   - راه‌اندازی محیط
   - استانداردهای کدنویسی
   - استراتژی تست
   - فرآیند استقرار

5. [امنیت](./security.md)
   - فرآیند احراز هویت
   - قوانین مجوزدهی
   - بهترین شیوه‌های امنیتی
   - دستورالعمل‌های OWASP

6. [مانیتورینگ و عملیات](./operations.md)
   - استراتژی ثبت رویدادها
   - راه‌اندازی مانیتورینگ
   - معیارهای عملکرد
   - راهنمای عیب‌یابی

7. [راهنمای یکپارچه‌سازی](./integration.md)
   - سرویس‌های شخص ثالث
   - API‌های خارجی
   - الگوهای یکپارچه‌سازی

## شروع سریع

1. کلون کردن مخزن
2. نصب وابستگی‌ها: `pip install -r requirements.txt`
3. راه‌اندازی پایگاه داده: `python manage.py migrate`
4. اجرای سرور توسعه: `python manage.py runserver`

## پشتیبانی

برای هرگونه سوال یا مشکل، لطفاً با تیم توسعه تماس بگیرید یا یک issue در مخزن ایجاد کنید. 