# Diet Management Dashboard Implementation

## Overview
A new diet management dashboard has been implemented for the Assistant user group to help them track and manage patient diets more effectively.

## Features Implemented

### 1. User Categorization
The system automatically categorizes patients into four groups based on their diet status:

#### **Recently Received Diets** (Within last 7 days)
- Shows patients who received their diet within the past 7 days
- Helps assistants track new diet assignments
- Background: Pink/Rose color for easy identification

#### **Active Diets** (8-23 days remaining)
- Displays patients with active diets that have more than 7 days remaining
- These are patients in the middle of their diet cycle
- Background: Light blue color

#### **Expiring Soon** (0-7 days remaining)
- ⚠️ Critical category showing patients whose diets will expire within the next 7 days
- Requires immediate attention for diet renewal
- Background: Light orange color for urgency

#### **No Diet**
- Lists patients who don't have any assigned diet
- Helps identify patients who need diet assignment
- Background: Light gray color

### 2. Dashboard Statistics
The page displays four colored statistic cards showing:
- Total number of patients
- Number of recently received diets
- Number of active diets
- Number of expiring diets

### 3. Tabbed Interface
Easy navigation between categories using tabs with badge counts for each category.

### 4. Patient Information Display
For each patient, the following information is shown:
- First name and last name
- Diet start date (in Jalali calendar format)
- Days since diet started
- Days remaining until expiration
- Action buttons to view patient profile or diet details

### 5. Quick Actions
- **View Patient**: Direct link to patient profile
- **View Diet**: Direct link to diet details
- **Add Diet**: For patients without diets

## Technical Implementation

### Files Created/Modified

#### 1. **View Function** (`panel/assistant.py`)
- Function: `diet_management()`
- Location: Lines 6674-6783
- Features:
  - Authentication and authorization checks
  - Automatic patient categorization based on diet dates
  - Calculation of days remaining for each diet
  - Sorted results within each category

#### 2. **Template** (`panel/templates/assistant/diet_management.html`)
- Modern, responsive design
- Bootstrap-based tabbed interface
- Gradient colored statistic cards
- Hover effects and animations
- Mobile-friendly layout

#### 3. **URL Routing** (`panel/urls.py`)
- Route: `/assistant/diet/management/`
- Name: `panel-assistant-diet-management`
- Location: Line 139

#### 4. **Sidebar Menu** (`panel/templates/assistant/base.html`)
- Added menu item with heartbeat icon
- Located between "Diet Templates" and "Requested Foods"
- Location: Lines 135-137

#### 5. **Translations**
Added translations for all UI text in three languages:

**English** (`locale/en/LC_MESSAGES/django.po`):
- Diet Management Dashboard
- Total Patients
- Recently Received
- Active Diets
- Expiring Soon
- No Diet
- And 14 more related strings

**Farsi/Persian** (`locale/fa/LC_MESSAGES/django.po`):
- داشبورد مدیریت رژیم های غذایی
- کل بیماران
- رژیم های اخیر
- رژیم های فعال
- نزدیک به اتمام
- بدون رژیم
- And 14 more related strings

**Arabic** (`locale/ar/LC_MESSAGES/django.po`):
- لوحة إدارة النظام الغذائي
- إجمالي المرضى
- الأنظمة الغذائية الحديثة
- الأنظمة النشطة
- قريبة من الانتهاء
- بدون نظام غذائي
- And 14 more related strings

## Business Logic

### Diet Validity Calculation
- Each diet is valid for **30 days** from the `from_date`
- Days remaining = 30 - (current_date - from_date).days
- Categories are based on both days since start and days remaining

### Categorization Logic
```python
if days_since_start <= 7:
    # Recently received (within first 7 days)
elif days_remaining <= 7 and days_remaining >= 0:
    # Expiring soon (last 7 days of validity)
elif days_remaining > 7:
    # Active diet (more than 7 days remaining)
else:
    # Diet expired (more than 30 days passed)
```

## Usage

### For Assistants
1. Navigate to the sidebar menu
2. Click on "مدیریت رژیم ها" (Diet Management)
3. View the statistics cards for a quick overview
4. Switch between tabs to see different patient categories
5. Use action buttons to view patient details or manage diets

### Benefits
- **Proactive Management**: Identify diets that need renewal before they expire
- **Better Organization**: Clear categorization of all patients
- **Time Savings**: Quick access to patient and diet information
- **Improved Patient Care**: Ensure continuous diet coverage for all patients

## Database Queries
The implementation uses optimized queries:
- Single query to fetch all patients assigned to the assistant
- Individual queries for latest diet per patient (can be optimized with select_related if needed)
- No N+1 query problems

## Access Control
- Only authenticated users can access the page
- User must belong to the 'Assistant' group
- Each assistant sees only their assigned patients

## Future Enhancements (Suggestions)
1. Add filtering and search capabilities
2. Export functionality for reports
3. Bulk actions for diet renewal
4. Email notifications for expiring diets
5. Historical diet tracking
6. Performance optimization with select_related/prefetch_related

## Testing
To test the implementation:
1. Log in as an Assistant user
2. Navigate to the Diet Management page
3. Verify that patients are correctly categorized
4. Test the action buttons
5. Switch between different language options to verify translations

## Notes
- The Jalali (Persian) calendar is used for date display to match the primary user base
- The 30-day validity period is hardcoded but can be made configurable if needed
- Patients can appear in the "Expiring Soon" category even if their diet has already expired

