# لیست کامل بیومارکرهای مورد استفاده در سیستم تحلیل آزمایش خون

این سند شامل تمام بیومارکرهایی است که در `analysisEngine.ts` و `riskEngine.ts` استفاده می‌شوند.

---

## 📊 بیومارکرهای تعریف شده در `_buildDynamicRanges()` (analysisEngine.ts)

### 1. هماتولوژی (Hematology)
| بیومارکر | نام کامل | استفاده در |
|---------|---------|-----------|
| **Hb** | Hemoglobin (هموگلوبین) | idxHematology |
| **HCT** | Hematocrit (هماتوکریت) | - |
| **RBC** | Red Blood Cell Count (شمارش گلبول قرمز) | - |
| **Ferritin** | Ferritin (فریتین) | idxHematology |
| **WBC** | White Blood Cell Count (شمارش گلبول سفید) | - |
| **Platelet** | Platelet Count (شمارش پلاکت) | - |
| **MCV** | Mean Corpuscular Volume (حجم متوسط گلبول قرمز) | idxHematology |

### 2. کلیه (Kidney Function)
| بیومارکر | نام کامل | استفاده در |
|---------|---------|-----------|
| **Creatinine** | Creatinine (کراتینین) | idxOrganFunction |
| **eGFR** | estimated Glomerular Filtration Rate (نرخ فیلتراسیون گلومرولی) | idxOrganFunction |
| **Urea** | Urea (اوره) | idxOrganFunction |

### 3. هورمونی (Hormonal)
| بیومارکر | نام کامل | استفاده در |
|---------|---------|-----------|
| **Estradiol** | Estradiol (استرادیول) | idxHormonal |
| **Testosterone** | Testosterone (تستوسترون) | idxHormonal |
| **FSH** | Follicle Stimulating Hormone (هورمون محرک فولیکول) | idxHormonal |
| **TSH** | Thyroid Stimulating Hormone (هورمون محرک تیروئید) | idxThyroid |
| **T3 Free** | Free Triiodothyronine (تری‌یدوتیرونین آزاد) | idxThyroid |
| **T4 Free** | Free Thyroxine (تیروکسین آزاد) | idxThyroid |
| **Cortisol** | Cortisol (کورتیزول) | idxHormonal |

### 4. متابولیک (Metabolic)
| بیومارکر | نام کامل | استفاده در |
|---------|---------|-----------|
| **Fasting Glucose** | Fasting Blood Sugar / FBS (قند خون ناشتا) | idxCardiometabolic, RiskEngine |
| **HbA1c** | Hemoglobin A1c (هموگلوبین گلیکوزیله) | idxCardiometabolic, RiskEngine |
| **Triglycerides** | Triglycerides (تری‌گلیسرید) | idxCardiometabolic, RiskEngine |
| **Total Cholesterol** | Total Cholesterol (کلسترول تام) | idxCardiometabolic, RiskEngine |
| **LDL** | Low-Density Lipoprotein (کلسترول بد) | idxCardiometabolic |
| **HDL** | High-Density Lipoprotein (کلسترول خوب) | idxCardiometabolic, RiskEngine |

### 5. کبد (Liver Function)
| بیومارکر | نام کامل | استفاده در |
|---------|---------|-----------|
| **ALT** | Alanine Aminotransferase (آلانین آمینوترانسفراز) | idxOrganFunction |
| **AST** | Aspartate Aminotransferase (آسپارتات آمینوترانسفراز) | idxOrganFunction |
| **GGT** | Gamma-Glutamyl Transferase (گاما گلوتامیل ترانسفراز) | idxOrganFunction, RiskEngine |
| **Bilirubin Total** | Total Bilirubin (بیلی‌روبین تام) | idxOrganFunction |

### 6. ویتامین‌ها و مواد معدنی (Vitamins & Minerals)
| بیومارکر | نام کامل | استفاده در |
|---------|---------|-----------|
| **Vitamin D3** | Vitamin D3 / 25-OH Vitamin D (ویتامین D3) | idxHematology |
| **Vitamin B12** | Vitamin B12 / Cobalamin (ویتامین B12) | idxHematology |
| **Iron** | Iron / Fe (آهن) | idxHematology |
| **Calcium** | Calcium (کلسیم) | idxHormonal |
| **Magnesium** | Magnesium (منیزیم) | idxHormonal |

### 7. التهاب (Inflammation)
| بیومارکر | نام کامل | استفاده در |
|---------|---------|-----------|
| **CRP** | C-Reactive Protein (پروتئین واکنش‌دهنده C) | idxCardiometabolic |

---

## 🔍 بیومارکرهای استفاده شده در Index Functions

### idxCardiometabolic (شاخص قلب و متابولیسم)
- HbA1c (وزن: 0.25)
- Fasting Glucose (وزن: 0.15)
- LDL (وزن: 0.15)
- CRP (وزن: 0.20)
- Total Cholesterol (وزن: 0.05)
- Triglycerides (وزن: 0.10)
- HDL (وزن: 0.10)
- **نسبت محاسبه شده**: Triglycerides / HDL

### idxHematology (شاخص خون و تغذیه)
- Hb (وزن: 0.20)
- MCV (وزن: 0.10)
- Ferritin (وزن: 0.20)
- Iron (وزن: 0.10)
- Vitamin D3 (وزن: 0.25)
- Vitamin B12 (وزن: 0.15)

### idxOrganFunction (شاخص عملکرد ارگان‌ها)
- ALT (وزن: 0.20)
- AST (وزن: 0.15)
- Bilirubin Total (وزن: 0.10)
- eGFR (وزن: 0.35)
- Creatinine (وزن: 0.15)
- Urea (وزن: 0.05)

### idxThyroid (شاخص تیروئید)
- TSH (وزن: 0.60)
- T4 Free (وزن: 0.20)
- T3 Free (وزن: 0.20)

### idxHormonal (شاخص تعادل هورمونی)
- Magnesium (وزن: 0.20)
- Calcium (وزن: 0.10)
- Cortisol (وزن: 0.30)
- Estradiol (وزن: 0.20)
- FSH (وزن: 0.20)
- Testosterone (وزن: 0.20)

---

## ⚠️ بیومارکرهای استفاده شده در RiskEngine

### calculateCvdRisk() - ریسک قلبی-عروقی
**بیومارکرهای مورد نیاز:**
- Total Cholesterol (کلسترول تام)
- Fasting Glucose (برای تشخیص دیابت)
- HbA1c (برای تشخیص دیابت)

**پارامترهای اضافی:**
- Age (سن)
- Gender (جنسیت)
- Smoker (سیگاری)
- SBP (فشار خون سیستولیک)
- Diabetes Status (وضعیت دیابت)

### calculateDiabetesRisk() - ریسک دیابت
**بیومارکرهای مورد نیاز:**
- HbA1c (اولویت اول - مدل Framingham)
- Fasting Glucose (اولویت دوم - مدل Stern)
- HDL (برای مدل Stern)

**پارامترهای اضافی:**
- Age (سن)
- Gender (جنسیت)
- BMI (شاخص توده بدنی)
- Family History (سابقه خانوادگی دیابت)
- SBP (برای مدل Stern)

### calculateLiverRisk() - ریسک کبد چرب (FLI)
**بیومارکرهای مورد نیاز:**
- Triglycerides (تری‌گلیسرید)
- GGT (گاما گلوتامیل ترانسفراز)

**پارامترهای اضافی:**
- BMI (شاخص توده بدنی)
- Waist (دور کمر)

---

## 📝 بیومارکرهای ذکر شده در Lifestyle Feedback

بیومارکرهای زیر دارای پیام‌های بازخورد سبک زندگی اختصاصی هستند:

1. **Vitamin D3** - بازخورد برای سطح پایین/عالی
2. **Vitamin B12** - بازخورد برای کمبود
3. **Ferritin** - بازخورد برای سطح پایین/بالا
4. **Hb, HCT, RBC** - بازخورد برای کم‌خونی/غلظت خون
5. **Fasting Glucose, HbA1c** - بازخورد برای قند خون بالا
6. **Triglycerides** - بازخورد برای سطح بالا
7. **HDL** - بازخورد برای سطح پایین
8. **LDL** - بازخورد برای سطح بالا
9. **ALT, AST, GGT** - بازخورد برای فشار کبد
10. **TSH** - بازخورد برای عملکرد تیروئید
11. **Magnesium** - بازخورد برای کمبود
12. **Cortisol** - بازخورد برای استرس مزمن
13. **CRP** - بازخورد برای التهاب
14. **Homocysteine** - بازخورد برای سطح بالا (ذکر شده اما در ranges تعریف نشده)
15. **eGFR, Creatinine** - بازخورد برای عملکرد کلیه

---

## 📊 خلاصه آماری

- **کل بیومارکرهای تعریف شده در ranges**: 33 بیومارکر
- **بیومارکرهای استفاده شده در Index Functions**: 25 بیومارکر
- **بیومارکرهای استفاده شده در RiskEngine**: 6 بیومارکر
- **بیومارکرهای دارای بازخورد سبک زندگی**: 15+ بیومارکر

---

## 🔄 نقشه‌برداری نام‌های آزمایش (Excel → Analyzer)

برای فایل Excel `novo_lab_test.xlsx`، نام‌های زیر باید به نام‌های انگلیسی مپ شوند:

| نام در Excel | نام در Analyzer |
|-------------|----------------|
| ALT | ALT |
| AST | AST |
| GGT | GGT |
| ALP | ALP |
| Bili-T | Bilirubin Total |
| Cr | Creatinine |
| Urea | Urea |
| eGFR | eGFR |
| FBS | Fasting Glucose |
| A1C-E | HbA1c |
| TG | Triglycerides |
| Chol | Total Cholesterol |
| LDL | LDL |
| HDL | HDL |
| Hgb | Hb |
| Hct / HCT | HCT |
| RBC | RBC |
| MCV | MCV |
| FTL | Ferritin |
| Fe | Iron |
| Vit D3 | Vitamin D3 |
| Vit B12 | Vitamin B12 |
| CRP | CRP |
| TSH | TSH |
| T3 Free | T3 Free |
| T4 Free | T4 Free |

---

**تاریخ ایجاد**: 2025-01-15  
**نسخه**: 1.0


