from PIL.ImagePalette import random
from numpy.ma.core import identity
from rest_framework.decorators import api_view
from rest_framework.response import Response
from rest_framework import status
from django.http import JsonResponse
import json
import string
import csv
import jdatetime
from django.shortcuts import render

from django.http import HttpResponse, HttpResponseRedirect
from django.template import loader
from django.core.files.storage import FileSystemStorage
from django.utils import timezone
# import secrets
from datetime import *
from datetime import time
from ziluck_project.settings import STATIC_ROOT
from wsgiref.util import FileWrapper
import os
import numpy as np
import requests
import warnings


warnings.filterwarnings("ignore")

import re
from APIs.models import *
from ziluck_project import settings

from APIs.forms import UploadFileForm
import pandas
from APIs.views.Errors import Errors

# from django.utils.timezone import utc
from ziluck_project.constants import SMS_API_URL
from panel.models import Message as co_message
from panel.models import Challenge
from django.db.models import Q

from APIs.modules.BIA_analysis_module import process_body_composition_image
from django.views.decorators.csrf import csrf_exempt

from rest_framework.decorators import api_view
from rest_framework.response import Response
# from APIs.scripts.missed_food_card_generator import generate_food_card_json
from APIs.models import FoodCard

LOGGING = True

MEAL = [5, 5, 5, 5, 0,  # 0 -> 4
        0, 0, 0, 0, 0,  # 5 -> 9
        1, 1, 2, 2, 2,  # 10 -> 14
        2, 3, 3, 3, 4,  # 15 -> 19
        4, 4, 4, 5,     # 20 -> 23
        ]

HEI_Table = {
    # CR: [cereal(grain), Protein, Dairy, Fruit, Vegetables, Fat]
    1100: [3, 5, 2, 3, 3, 3],
    1200: [4, 5, 2, 3, 3, 3],
    1300: [4, 4, 3, 3, 3, 3],
    1400: [5, 5, 2, 4, 3, 3],
    1500: [5.5, 5, 3, 3.5, 3, 4],
    1600: [7, 5, 2, 3.5, 3, 3],
    1700: [7, 5, 3, 4, 3, 4],
    1800: [8, 6, 3, 4, 4, 4],
    1900: [9, 6, 3, 4, 4, 5],
    2000: [8, 7, 3, 5, 4, 5],
    2100: [9, 8, 3, 4.5, 5, 5],
    2200: [11, 7, 4, 4, 5, 5],
    2300: [11, 8, 3, 4.5, 4, 7],
    2400: [12, 8, 4, 4, 5, 5],
    2500: [12, 9, 3.5, 4.5, 4, 7],
    2600: [13.5, 9, 3, 5, 4, 7],
    2700: [14.5, 9, 3, 5, 5, 7],
    2800: [16, 9, 3, 5, 5, 6.5],
    2900: [17, 9, 3, 5, 5, 7],
    3000: [18, 9, 3, 5, 5, 7],
    3100: [18, 10, 3, 5, 5, 6],
    3200: [19, 10, 4, 5, 5, 6],
    3300: [19, 10, 4, 5.5, 5, 7],
    3400: [19, 10, 4, 6.5, 5, 8],
    3500: [20, 11, 4, 6, 5, 8],
}


def generateRandomString(seq_set, size):
    """Choose a random element from a non-empty sequence."""
    ts = str(int(datetime.now().timestamp() * 1000000))
    if size == 6:
        try:
            ret = ""
            ret += ts[-4:]
            ret = ret[0] + ret[0] + ret
        except ValueError:
            raise IndexError('Cannot choose from an empty sequence') from None
    elif size == 4:
        try:
            ret = ts[-4:]
        except ValueError:
            raise IndexError('Cannot choose from an empty sequence') from None
    elif size == 15:
        try:
            ret = ts[-6:] + ts[-3] + ts[-6:]
        except ValueError:
            raise IndexError('Cannot choose from an empty sequence') from None
    else:
        try:
            ret = ""
            for i in range(size):
                j = np.random.randint(len(seq_set))
                ret += seq_set[j]
            now = str(datetime.now().timestamp())
            now = now.replace(".", "-")
            n = len(now)
            if len(ret) > n:
                ret = now + ret[n:]
        except ValueError:
            raise IndexError('Cannot choose from an empty sequence') from None
    return ret


def AddingData(request):
    username = 'Hossein Sojoodi'
    context = {
        'username': username,
    }
    return render(request, 'Support/update_foods_list.html', context)


def writeErrorToLog(error, request):
    if LOGGING is True:
        strreq = ""
        try:
            if request.method == "POST":
                strreq = str(request.POST)
            else:
                strreq = str(request.GET)
        except Exception as e:
            strreq = str(request)

        message = str(jdatetime.datetime.now()) + "\n" + str(
            error) + "\n" + "on request of:\n" + strreq + "\n========\n\n"
        print(message)
        path = STATIC_ROOT + "/logs/error.log"
        # f = open(path, "a+")
        f = open(path, "a+", encoding="utf-8")
        f.write(message)
        f.close()


class myResponse():
    @staticmethod
    def Error(message, error_code):
        return JsonResponse({
            "status": "Error",
            "message": message,
            "error_code": str(error_code),
            "data": []
        }, safe=False)

    @staticmethod
    def OK(message, data):
        return JsonResponse({
            "status": "OK",
            "message": message,
            "error_code": "1000",
            "data": [data]
        }, safe=False)


def CreateResponse(status, message, error_code, data):
    return JsonResponse({
        "status": status,
        "message": message,
        "error_code": str(error_code),
        "data": [data]
    }, safe=False)


def RequsetChecker(data, format, request=None):
    # Sampeleforamt=[
    #     {
    #         "name":"field name", # required
    #         "format":"regex",    # required
    #         "required": True,    # optional default is true
    #         "errorMessage":"field be required!" # optional
    #     }
    # ]
    information = "\n+--------------------- START OF LOG ----------------------+\nINFORMATION:\n"
    try:
        if request is not None:
            information += "  Method: {}\n".format(request.method)
            information += "  URL: {}\n".format(request.build_absolute_uri())
            if request.method == "POST":
                information += '  request["POST"]: {}\n'.format(request.POST)
            else:
                information += '  request["GET"]: {}\n'.format(request.GET)

        print(information)
    except Exception as e:
        print(information)
        print("  Exception in creating INFORMATION [ {} ]:".format(datetime.now()), e)

    try:
        temp = Transaction.objects.filter(date=date.today())
        if temp.exists():
            transaction = temp[0]
        else:
            transaction = Transaction(date=date.today())

        transaction.all_transactions += 1
        transaction.save()

    except Exception as e:
        print("  Exception in Transaction checking [ {} ]:".format(datetime.now()), e)

    for field in format:
        if field.get('required') is None or field.get('required') is True:
            if data.get(field['name']) is None:
                msg = 'the ' + field['name'] + ' is required'
                log = msg + "\n" + "  request =\n  " + str(data) + "\n===========\n\n"
                # writeErrorToLog(log, data)
                transaction.error_transactions += 1
                print("  error 1 in api call [ {} ]:".format(datetime.now()), ":", log)
                transaction.save()
                raise ValueError(msg)
            elif not re.compile(field['format']).match(data.get(field['name'])):
                msg = field.get('errorMessage') or 'invalid input format on ' + field['name']
                log = msg + "\n" + "  request =\n  " + str(data) + "\n===========\n\n"
                # writeErrorToLog(log, data)
                transaction.error_transactions += 1
                print("  error 2 in api call [ {} ]:".format(datetime.now()), ":", log)
                transaction.save()
                raise ValueError(msg)
        elif field.get('required') is False and not (data.get(field['name']) is None):
            if data.get(field['name']) is None:
                msg = 'the ' + field['name'] + ' is required'
                log = msg + "\n" + "  request =\n  " + str(data) + "\n===========\n\n"
                # writeErrorToLog(log, data)
                transaction.error_transactions += 1
                print("  error 3 in api call [ {} ]:".format(datetime.now()), ":", log)
                transaction.save()
                raise ValueError(msg)
            elif not re.compile(field['format']).match(data.get(field['name'])):
                msg = field.get('errorMessage') or 'invalid input format on ' + field['name']
                log = msg + "\n" + "  request =\n  " + str(data) + "\n===========\n\n"
                # writeErrorToLog(log, data)
                transaction.error_transactions += 1
                print("  error 4 in api call [ {} ]:".format(datetime.now()), ":", log)
                transaction.save()
                raise ValueError(msg)

    transaction.save()
    print("  true api call [ {} ]:\n  request data:{}\n===========\n\n".format(datetime.now(), str(data)))
    return


def extractPhone(packedPhone):
    phone = ""
    phone += packedPhone[10:13]
    phone += packedPhone[23:26]
    phone += packedPhone[36:39]
    phone += packedPhone[49:][:-10]
    return phone


def normalize(x):
    if x > 1.20:
        return -1
    if x > 1.15:
        return 0.2
    if x > 1.1:
        return 0.4
    if x > 1.05:
        return 0.6
    if x > 1:
        return 0.8
    if x > 0.95:
        return 1
    if x > 0.9:
        return 0.9
    if x > 0.85:
        return 0.8
    if x > 0.8:
        return 0.7
    if x > 0.75:
        return 0.5
    if x > 0.70:
        return 0.4
    return 0.1


def myListSum(list):
    s = 0
    for x in list:
        if not (x == -1):
            s += x
    return s


def Calculate_CR_Macro_Nutrients_Distribution(age, weight, height,
                                              gender, activityFactor, type_of_treatment):
    BMR = 0
    BMI = 20
    CR = 0
    metabolism_Energy = 1
    boy = [15, 15, 15,
           16, 16, 16,
           15, 15, 15, 15,
           14, 14, 14, 14,
           13.5, 13.5, 13.5, 13.5]
    girl = [15, 15, 15,
            16, 16, 16,
            17, 17, 17, 17,
            16, 16, 16, 16,
            17, 17, 17, 17]

    if age < 19 and (age > 1) and (gender == False):  # man
        CR = boy[age - 1] * height
        BMR = CR
        L = round(((height / 100) ** 2) * 18.5, 1)
        H = round(((height / 100) ** 2) * 25, 1)
        BMI = weight / ((height / 100) ** 2)
        if BMI > 25:
            IBW = H
        elif BMI < 18.5:
            IBW = L
        else:
            IBW = weight
        weight_state = "شما در سن رشد هستید و محدوده وزن حالت سلامت برای شما " + str(L) + " تا " + str(
            H) + " کیلوگرم میباشد"
    elif age < 19 and (age > 1) and (gender == True):  # woman
        CR = girl[age - 1] * height
        BMR = CR
        L = round(((height / 100) ** 2) * 18.5, 1)
        H = round(((height / 100) ** 2) * 25, 1)
        BMI = weight / ((height / 100) ** 2)
        if BMI > 25:
            IBW = H
        elif BMI < 18.5:
            IBW = L
        else:
            IBW = weight
        weight_state = "شما در سن رشد هستید و محدوده وزن حالت سلامت برای شما " + str(L) + " تا " + str(
            H) + " کیلوگرم میباشد"
    else:
        BMI = weight / ((height / 100) ** 2)
        if BMI < 18.5:
            CR = 500  # to adding weight
            IBW = ((height / 100) ** 2) * 22
            weight_state = "تلاش کنید به محدوده وزن ایده آل نزدیک شوید، وزن حالت سلامت برای شما " + str(
                int(IBW)) + " کیلوگرم میباشد"

        elif BMI < 25:
            CR = 0  # Normal range
            IBW = weight
            weight_state = "وزن شما در محدوده نرمال قرار دارد"
        elif BMI <= 30:
            CR = -500  # to reduce weight
            if gender is False:  # men
                IBW = ((height / 100) ** 2) * 24
            else:  # woman
                IBW = ((height / 100) ** 2) * 22
            weight_state = "شما اضافه وزن دارید، از وزن خود کاسته و تلاش کنید به وزن حالت سلامت برسید، وزن حالت سلامت برای شما " + str(
                int(IBW)) + " کیلوگرم میباشد"
        else:  # BMI upper than 30
            CR = -500  # to reduce weight
            IBW = ((height / 100) ** 2) * 24
            weight_state = "شما چاق محسوب میشوید و از وزن خود بکاهید و به وزن حالت سلامت خود یعنی " + str(
                int(IBW)) + " کیلو گرم نزدیک شوید"

        if gender is False:  # men
            BMR = (10 * weight) + (6.25 * height) - (5 * age) + 5
        else:  # woman
            BMR = (10 * weight) + (6.25 * height) - (5 * age) - 161

        if BMI < 18.5:
            metabolism_Energy = 1.1
        CR = CR + round(BMR * activityFactor * metabolism_Energy, 2)

        # if BMI > 24.9:
        #     temp = (height/100)**2
        #     if isMen is True:
        #         IBW = temp * 23
        #     else:
        #         IBW = temp * 21.5
        #     weight = IBW + (weight - IBW) / 4
        #
        # if isMen is True:
        #     BMR = (10 * weight) + (6.25 * height) - (5 * age) + 5
        # else:
        #     BMR = (10 * weight) + (6.25 * height) - (5 * age) - 161
        # CR = BMR * activityFactor * 1.1
        # if BMI < 18.5:
        #     CR = CR + 500
        # if BMI > 25:
        #     CR = CR - 500

    carbohydrates_g = round((CR * 0.53) / 4, 2)
    protein_g = round((CR * 0.2) / 4, 2)
    fat_g = round((CR * 0.27) / 9, 2)
    carbohydrates_coefficient = [[0.15, 0.13, 0.24, 0.13, 0.24, 0.11], [0.15, 0.13, 0.22, 0.13, 0.22, 0.15]]
    carbohydrate_distribution_g = []
    carbohydrate_distribution_unit = []
    if type_of_treatment == 0:
        set = carbohydrates_coefficient[0]  # for drug
    elif type_of_treatment == 1:
        set = carbohydrates_coefficient[1]  # for insulin
    else:
        set = carbohydrates_coefficient[0]  # for glp1 type and combination models ...

    for x in set:
        carbohydrate_distribution_g.append(round(x * carbohydrates_g, 2))
        carbohydrate_distribution_unit.append(round(x * carbohydrates_g / 15, 2))

    data = {
        "CR": CR,
        "BMR": BMR,
        "IBW": int(IBW),
        "weight_state": weight_state,
        "macro_nutrients": {
            "carbohydrates_g": round(carbohydrates_g, 2),
            "carbohydrates_unit": round(carbohydrates_g / 15, 2),
            "protein_g": round(protein_g, 2),
            "protein_unit": round(protein_g / 7, 2),
            "fat_g": round(fat_g, 2),
            "fat_unit": round(fat_g / 6, 2)
        },
        "carbohydrate_distribution_g": carbohydrate_distribution_g,
        "carbohydrate_distribution_unit": carbohydrate_distribution_unit,
        "protein_distribution_g": round(protein_g / 6, 2),
        "protein_distribution_unit": round((protein_g / 6) / 7, 2),
        "fat_distribution_g": round((fat_g / 6), 2),
        "fat_distribution_unit": round(((fat_g / 6) / 6), 2)
    }
    return data


def getSubUserList(strList):
    S = strList.split("&")
    last = len(S) - 1
    F = []
    for i in range(1, last):
        if not S[i] == "":
            F.append(str(S[i]))
    return F


def getList(strList):
    S = strList.split("&")
    last = len(S) - 1
    F = []
    for i in range(1, last):
        if not S[i] == "":
            F.append(float(S[i]))
    return F


def getIntegerList(strList):
    S = strList.split("&")
    last = len(S) - 1
    F = []
    for i in range(1, last):
        if not S[i] == "":
            F.append(int(float(S[i])))
    return F


def getFloatList(strList):
    S = strList.split("&")
    last = len(S) - 1
    F = []
    for i in range(1, last):
        if not S[i] == "":
            F.append(float(S[i]))
    return F


def getHomeUnitElements(strList):
    S = strList.split("&")
    last = len(S) - 1
    F = []
    for i in range(1, last):
        if not S[i] == "":
            F.append(S[i])
    return F


def listToStr(list):
    S = "&"
    for item in list:
        S += str(item) + "&"
    return S


def getPointDistributionList(profile):
    type_of_treatment = profile.type_of_treatment
    diabetes_type = profile.diabetes_type
    if diabetes_type == 0:
        index = 0
    elif diabetes_type == 2:
        index = 3
    elif diabetes_type == 1:
        index = 1
        if type_of_treatment == 0:
            index = 2
        elif type_of_treatment == 2:
            index = 1
    else:
        index = 0

    wt = profile.weight
    ht = profile.height / 100
    BMI = wt / (ht ** 2)
    bcf = BMI - 25
    if bcf < 0:
        bcf = 0
    elif bcf > 10:
        bcf = 10
    coefficients = [[
        30, 5, 25, 10, 5, 15, 10
    ], [
        25 - bcf, 5, 25 - (bcf / 2), 5, 10 + bcf, 20 + (bcf / 2), 10
    ], [
        20 - bcf, 0, 25 - (bcf / 2), 10, 15 + bcf, 20 + (bcf / 2), 10
    ], [
        35, 5, 25, 10, 5, 10, 10
    ]]
    return coefficients[index]


def myListAdder(A, B):
    temp = []
    for i in range(len(A)):
        temp.append(A[i] + B[i])
    return temp


def getHEI_List(food, amount):
    temp = []

    # food = Food()
    # Todo add PUFA, MUFA, Fat to [0 ... 2]
    temp.append(round(food.PUFA * (amount / 100), 4))
    temp.append(round(food.MUFA * (amount / 100), 4))
    temp.append(round(food.Fat_g * (amount / 100), 4))
    # Todo repair this amounts... [3 ... 12]
    temp.append(round(food.HEI_1_Fruit * (amount / 100), 4))  # kole miveh
    temp.append(round(food.HEI_2_Fruit * (amount / 100), 4))  # miveh kamel
    temp.append(round(food.HEI_1_Vegetables * (amount / 100), 4))  # kole sabzijat
    temp.append(round(food.HEI_2_Vegetables * (amount / 100), 4))  # sabzijat barg sabz
    temp.append(round(food.HEI_Whole_Grain_Grains * (amount / 100), 4))  # gallat daneh kamel
    temp.append(round(food.HEI_Dairy * (amount / 100), 4))  # labaniat
    temp.append(round(food.HEI_Protein_Foods * (amount / 100), 4))  # kol gaza haye proteini ...
    temp.append(round(food.HEI_Seafood_and_Plant_Proteins * (amount / 100), 4))  # gaza heye daryati
    temp.append(round(food.HEI_Sodium * (amount / 100), 4))  # sodiom
    temp.append(round(food.HEI_Sugar * (amount / 100), 4))  # gand
    temp.append(round(food.Saturated_Fat_g * (amount / 100), 4))  # SFA

    # HEI portions: [cereal(grain), Protein, Dairy, Fruit, Vegetables, Fat]
    temp.append(round(food.cereal_unit * (amount / 100), 5))  # cereal_unit     --> 14
    temp.append(round(food.meat_unit * (amount / 100), 5))  # meat_unit       --> 15
    temp.append(round(food.dairy_unit * (amount / 100), 5))  # dairy_unit      --> 16
    temp.append(round(food.fruit_unit * (amount / 100), 5))  # fruit_unit      --> 17
    temp.append(round(food.vegetables_unit * (amount / 100), 5))  # vegetables_unit --> 18
    temp.append(round(food.fat_unit * (amount / 100), 5))  # fat_unit        --> 19

    return temp


def HEI_Point_Calculator(list, allCalorie):
    temp = []
    PUFA = list[0]
    MUFA = list[1]
    SFA = list[13]

    if allCalorie == 0:
        allCalorie = 2 ** (-10)  # ~ zero

    # temp 0
    x = (list[3] * 1000) / allCalorie
    temp.append(min(5, round(5 * x, 2)))

    # temp 1
    x = (list[4] * 1000) / allCalorie
    if x < 0.5:
        temp.append(round(5 * x, 2))
    else:
        temp.append(5)

    # temp 2
    x = (list[5] * 1000) / (allCalorie * 1.1)
    if x < 1.1:
        temp.append(round(5 * x, 2))
    else:
        temp.append(5)

    # temp 3
    x = (list[6] * 1000) / (allCalorie * 1.1)
    if x < 1.1:
        temp.append(round(5 * x, 2))
    else:
        temp.append(5)

    # temp 4
    x = (list[7] * 1000) / (allCalorie * 1.5)
    if x < 1.5:
        temp.append(round(10 * x, 2))
    else:
        temp.append(10)

    # temp 5
    x = (list[8] * 1000) / (allCalorie * 1.3)
    if x < 1.3:
        temp.append(round(10 * x, 2))
    else:
        temp.append(10)

    # temp 6
    x = (list[9] * 1000) / (allCalorie * 2.5)
    if x < 2.5:
        temp.append(round(5 * x, 2))
    else:
        temp.append(5)

    # temp 7
    x = (list[10] * 1000) / (allCalorie * 0.8)
    if x < 0.8:
        temp.append(round(5 * x, 2))
    else:
        temp.append(5)

    # temp 8
    if not (SFA == 0):
        x = (PUFA + MUFA) / SFA
        if x < 1.2:
            temp.append(0)
        elif x > 2.5:
            temp.append(10)
        else:
            temp.append(round(4 * x, 2))
    else:
        temp.append(0)

    # temp 9
    x = (list[11] * 1000) / allCalorie
    if x < 1.1:
        temp.append(0)
    elif x > 2:
        temp.append(10)
    else:
        temp.append(round(5 * x, 2))

    # temp 10
    x = (list[12] * 267) / allCalorie
    if x > 0.26 * allCalorie:
        temp.append(0)
    elif x < 0.065 * allCalorie:
        temp.append(10)
    else:
        temp.append(round((10 * x) / (0.26 * allCalorie), 2))

    # temp 11
    x = (SFA * 900) / allCalorie
    if x > 0.16 * allCalorie:
        temp.append(0)
    elif x < 0.08 * allCalorie:
        temp.append(10)
    else:
        temp.append(round((10 * x) / (0.16 * allCalorie), 2))

    return sum(temp) / 100


def updateTotalPointDayV1(user, record):
    PointDistributionList = getPointDistributionList(user.profile)
    p = []
    cooperate = []
    d = record.date
    dt1 = datetime(d.year, d.month, d.day, 0, 0, 0)  # start of day
    dt2 = datetime(d.year, d.month, d.day, 23, 59, 59)  # end of day
    insulins = InsulinUsage.objects.filter(user=user, time__range=(dt1, dt2))
    if not insulins.exists():
        cooperate.append(0)
    else:
        cooperate.append(min((insulins.count() + 1) / 2, 2) / 10)

    d = DrugUsage.objects.filter(user=user, time__range=(dt1, dt2))
    g = GLP1Usage.objects.filter(user=user, time__range=(dt1, dt2))
    if (d.count() + g.count()) == 0:
        cooperate.append(0)
    else:
        cooperate.append(min((d.count() + g.count() + 1) / 2, 2) / 10)

    f = Feeling.objects.filter(user=user, time__range=(dt1, dt2))
    if not f.exists():
        cooperate.append(0)
    else:
        cooperate.append(min(f.count() / 2, 1.5) / 10)

    s = SugarMeasurement.objects.filter(user=user, time__range=(dt1, dt2))
    if not s.exists():
        cooperate.append(0)
    else:
        cooperate.append(min((s.count() + 1) / 2, 1.5) / 10)

    eating_items = Eating.objects.filter(user=user, date_time__range=(dt1, dt2))
    if not eating_items.exists():
        cooperate.append(0)
    else:
        cooperate.append(min((eating_items.count() + 1) / 2, 1.5) / 5)

    totalCooperate = sum(cooperate)

    calorie_used = 0
    sugar_used = 0
    saturated_fat = 0
    fiber = 0
    for item in eating_items:
        sugar_used += item.food.Sugar_g * (item.amount / 100)
        calorie_used += item.food.Calories * (item.amount / 100)
        saturated_fat += item.food.Saturated_Fat_g * (item.amount / 100)
        fiber += item.food.Fiber_g * (item.amount / 100)

    # sugar
    B1 = 0
    if calorie_used != 0:
        A1 = 400 * (sugar_used / calorie_used)
        if A1 < 6.5:
            B1 = 15
        elif A1 > 26:
            B1 = 0
        else:
            B1 = (-15 / 19.50) * A1 + 20

    # saturated fat
    B2 = 0
    if calorie_used != 0:
        A2 = 900 * (saturated_fat / calorie_used)
        if A2 < 7:
            B2 = 15
        elif A2 > 10:
            B2 = 0
        else:
            B2 = (-5 * A2) + 50

    # fiber
    if user.profile.gender == 1:  # women
        if fiber < 3:
            B3 = 0
        elif fiber > 25:
            B3 = 13
        else:
            B3 = (13 / 22) * (fiber - 3)
    else:
        if fiber < 3:
            B3 = 0
        elif fiber > 38:
            B3 = 13
        else:
            B3 = (13 / 35) * (fiber - 3)

    # todo: B4 skipped, (Vegetable, it is calculating in HEI ...)

    # sleeping
    sleeps = Sleep.objects.filter(user=user, time__range=(dt1 - timedelta(hours=3), dt2 - timedelta(hours=12)))
    if not sleeps.exists():
        B5 = 0
    else:
        sleep_duration = 0
        for s in sleeps:
            sleep_duration = ((s.end - s.start) / 3600)
        if sleep_duration < 4 or sleep_duration > 12:
            B5 = 0
        elif sleep_duration > 7:
            B5 = 4
        else:
            B5 = (4 / 3) * (sleep_duration - 4)

    # Physical activities
    B6 = record.total_Activity_Point * 15
    # todo: B7 is skipped (other sports)

    # Calorie
    if calorie_used + 500 > user.profile.CR:
        B8 = 0
    else:
        B8 = 10

    B_items_score = sum((B1, B2, B3, B5, B6, B8))

    p.append(record.totalSugarControlPoint * PointDistributionList[0])
    p.append(record.totalHypoHyperControlPoint * PointDistributionList[1])
    p.append(record.total_HEI_Point * PointDistributionList[2])
    p.append(record.totalCarboControlPoint * PointDistributionList[3])
    p.append(record.total_Calories_Point * PointDistributionList[4])
    p.append(record.total_Activity_Point * PointDistributionList[5])
    p.append(totalCooperate * PointDistributionList[6])
    DayPoint = max(0, min(round(sum(p) + B_items_score, 2), 100))
    record.total_points = DayPoint
    record.save()
    return {
        "DayPoint": DayPoint,
        "totalCooperate": totalCooperate
    }


# daily score v2.1.0

def get_user_info(user, profile):
    user_info = []
    wt = profile.weight
    ht = profile.height / 100
    BMI = wt / (ht ** 2)
    Age = int((datetime.now() - profile.birth_date).days / 365)
    gender = profile.gender
    HealthCondition = user.profile.diseases
    element_to_remove = 'Healthy'
    if element_to_remove in HealthCondition:
        HealthCondition.remove(element_to_remove)
    Activity_level = profile.activity_level
    user_info.append((wt, ht, BMI, Age, gender, HealthCondition, Activity_level))
    return user_info


def get_calory_per_day(wt, ht, gender, activity_level, BMI):
    adjusted_wt = 0

    # Determine adjusted weight
    if 18.5 <= BMI <= 24.9:  # Normal BMI range
        adjusted_wt = wt
    elif BMI < 18.5:  # Underweight
        adjusted_wt = 20.0 * (ht ** 2)
    elif BMI >= 25:  # Overweight or Obesity
        adjusted_wt = 23.0 * (ht ** 2)
        adjusted_wt = adjusted_wt + ((wt - adjusted_wt) * 0.25)
        # adjusted_wt = adjusted_wt_pre + adjusted_wt_pre

    # Calculate TEE based on gender and adjusted weight
    if gender == 0:
        TEE = (adjusted_wt * 24 * 1) * activity_level * 1.1
    elif gender == 1:
        TEE = (adjusted_wt * 24 * 0.95) * activity_level * 1.1
    else:
        return "Invalid gender"

    # Calculate calories per day based on BMI category
    if BMI < 18.5:  # Underweight
        calory_per_day = TEE + 500
    elif 18.5 <= BMI < 25:  # Normal weight
        calory_per_day = TEE
    elif BMI >= 25:  # Overweight or Obesity
        calory_per_day = TEE - 500
    else:
        return "Invalid BMI"

    return calory_per_day


def get_foodItemsDiet(user):
    diet = Diet.objects.filter(user=user).last()

    if not diet:
        print("No diet found for the user.")
        return {}

    score = 0
    try:
        # Parse the JSON data
        diet_data = diet.eaten_foods  # Assuming 'eaten_foods' is the JSON field
        if not diet_data:
            print("Diet data is empty or None.")
            return {}

        week_data = diet_data.get("week1", {})
        if not week_data:
            print("No week1 data found.")
            return {}

        scores = {}
        for meal, days in week_data.items():
            if not days or not isinstance(days, dict):
                print(f"No valid data found for meal: {meal}")
                continue

            scores[meal] = {}
            for day, day_data in days.items():
                if not day_data or not isinstance(day_data, dict):
                    print(f"No valid data found for {meal}, {day}.")
                    scores[meal][day] = 0
                    continue

                selected_mode = day_data.get("selected_mode") or {}
                eaten = day_data.get("eaten") or {}

                selected_ingredients = selected_mode.get("ingredient") or []
                eaten_ingredients = eaten.get("ingredient") or []

                # Extract food codes
                selected_food_codes = set(
                    ingredient.get("food_code") for ingredient in selected_ingredients
                )
                eaten_food_codes = set(
                    ingredient.get("food_code") for ingredient in eaten_ingredients
                )
                matches = selected_food_codes.intersection(eaten_food_codes)
                mismatches = selected_food_codes.symmetric_difference(eaten_food_codes)
                score = 10 - (len(mismatches))
    except Exception as e:
        print(f"Error processing diet data: {e}")
    return score


def compare_nutrition_facts(eating_NF_dict, meal_foods):
    tolerance = 30  # Tolerance level for comparison
    # Iterate over all foods in the meal_foods dictionary
    for food_name, food_nutrition_list in meal_foods.items():
        for nutrition in food_nutrition_list:
            # Compare nutrition facts field by field
            is_match = all(
                abs(eating_NF_dict.get(key, 0) - nutrition.get(key, 0)) <= tolerance
                for key in eating_NF_dict.keys()
            )
            if is_match:
                return True
    return False


def cal_diet_mistmatchScore(nutrition_facts, meal_percent, meal_id):
    score = 0
    tolerance = 30

    # Extract nutrition facts
    fat = nutrition_facts.get("Fat_g", 0)
    protein = nutrition_facts.get("protein_g", 0)
    carbohydrate = nutrition_facts.get("carbohydrates_g", 0)
    calory = nutrition_facts.get("calories", 0)
    meal = meal_id  # Use the provided meal_id

    meal_value = meal_percent.get(meal, 0)  # Get the planned calories for this meal

    # Calorie Score
    if meal_value - 50 < calory < meal_value + 50:
        caloScore = 5
    else:
        caloScore = 0

    # Ratio calculation
    if carbohydrate != 0:  # Avoid division by zero
        ratio = (fat + protein) / carbohydrate
        l = 1  # Target ratio
        mismatch_penalty = abs(l - ratio) * 5
        score = max(5 - mismatch_penalty, 0)  # Ensure score doesn't go negative
    else:
        ratio = 0
        score = 0  # Set score to 0 if carbohydrate is missing or 0

    # Cap the score based on meal type
    if meal in [0, 1, 2]:  # Breakfast, Lunch, Dinner
        score = min(score, 10)
    elif meal in [3, 4]:  # Snack1, Snack2
        score = min(score, 5)
    total_score = caloScore + score
    return total_score


def get_meal_values(calory_per_day):
    breakfast = int(calory_per_day * 0.2)
    lunch = int(calory_per_day * 0.35)
    dinner = int(calory_per_day * 0.3)
    snack1 = int(calory_per_day * 0.075)
    snack2 = int(calory_per_day * 0.075)
    meal_percent = {
        0: breakfast,
        1: lunch,
        2: dinner,
        3: snack1,
        4: snack2,
    }
    return meal_percent


def cal_eaten_nutritionFacts(eating_items):
    # Define meal names for clarity
    meal_names = {
        0: 'breakfast',
        1: 'lunch',
        2: 'dinner',
        3: 'snack1',
        4: 'snack2',
    }

    # Initialize the nutrition facts dictionary for each meal
    nutrition_facts_per_meal = {}

    # Iterate through each item to accumulate the values per meal
    for item in eating_items:
        meal_id = item.meal
        # Ensure the meal_id is valid
        if meal_id not in meal_names:
            continue  # Skip invalid meal IDs or handle as needed

        if meal_id not in nutrition_facts_per_meal:
            # Initialize nutrition facts for this meal
            nutrition_facts_per_meal[meal_id] = {
                "meal_name": meal_names[meal_id],
                "protein_g": 0,
                "calories": 0,
                "fat_g": 0,
                "carbohydrates_g": 0,
                "Fiber_g": 0,
            }

        # Accumulate nutrition facts
        nutrition_facts_per_meal[meal_id]["protein_g"] += item.food.Protein_g * (item.amount / 100)
        nutrition_facts_per_meal[meal_id]["calories"] += item.food.Calories * (item.amount / 100)
        nutrition_facts_per_meal[meal_id]["fat_g"] += item.food.Fat_g * (item.amount / 100)
        nutrition_facts_per_meal[meal_id]["carbohydrates_g"] += item.food.Carbohydrates_g * (item.amount / 100)
        nutrition_facts_per_meal[meal_id]["Fiber_g"] += item.food.Fiber_g * (item.amount / 100)

    return nutrition_facts_per_meal


def updateTotalPointDay(user, record, isCall=0, is_Diet=False, is_Activity=False, is_Step=False, is_Sleep=False,
                        is_Message=False, is_Water=False, is_Mid_Day_Sleep=False):
    wt, ht, BMI, Age, gender, HealthCondition, Activity_level = get_user_info(user, user.profile)[0]
    calory_per_day = get_calory_per_day(wt, ht, gender, Activity_level, BMI)
    meal_percent = get_meal_values(calory_per_day)

    d = record.date
    dt1 = datetime(d.year, d.month, d.day, 0, 0, 0)  # start of day
    dt2 = datetime(d.year, d.month, d.day, 23, 59, 59)  # end of day

    points_awarded = {
        'Diet_points_gained': 0,
        'Fiber_points_gained': 0,
        'Activity_points_gained': 0,
        'Step_points_gained': 0,
        'Water_points_gained': 0,
        'Sleep_points_gained': 0,
        'Engagement_points_gained': 0,
        'Message_points_gained': 0,
    }
    previous_DataEntry_score = record.this_day_DataEntry_score

    if is_Diet:
        eating_items = Eating.objects.filter(user=user, date_time__range=(dt1, dt2))
        previous_Diet_Point = record.this_day_total_diet_Point
        nutrition_facts_per_meal = cal_eaten_nutritionFacts(eating_items)

        global_meal_id = 5
        Diet_score = 0
        if isCall != -1:
            Diet_score = isCall
            # if previous_Diet_Point != 0:
            #     points_gained = Diet_score - previous_Diet_Point if Diet_score > previous_Diet_Point else -1
            # elif previous_Diet_Point == 0:
            #     points_gained = Diet_score
        else:
            for meal_id, nutrition_facts in nutrition_facts_per_meal.items():
                meal_score = cal_diet_mistmatchScore(nutrition_facts, meal_percent, meal_id)
                Diet_score += meal_score
                global_meal_id = meal_id
            points_gained = Diet_score if previous_Diet_Point < 40 else 0
            points_awarded['Water_points_gained'] = max(points_gained, 0)
            if global_meal_id == 0:
                record.this_day_breakfast_Point = min(max(Diet_score, record.this_day_breakfast_Point), 10)
            elif global_meal_id == 1:
                record.this_day_lunch_Point = min(max(Diet_score, record.this_day_lunch_Point), 10)
            elif global_meal_id == 2:
                record.this_day_dinner_Point = min(max(Diet_score, record.this_day_dinner_Point), 10)
            elif global_meal_id == 3:
                record.this_day_snack1_Point = min(max(Diet_score, record.this_day_snack1_Point), 10)
            elif global_meal_id == 4:
                record.this_day_snack2_Point = min(max(Diet_score, record.this_day_snack2_Point), 10)

            Fiber_intake = sum(nutrition['Fiber_g'] for nutrition in nutrition_facts_per_meal.values())
            if isCall == -1:
                record.total_Fiber_used = Fiber_intake
            if user.profile.gender == 1:
                based_fiber = 28
                record.total_Fiber_Point = (record.total_Fiber_used * 15) / based_fiber
                record.total_Fiber_Point = min(record.total_Fiber_Point, 15)
            else:
                based_fiber = 38
                record.total_Fiber_Point = (record.total_Fiber_used * 15) / based_fiber
                record.total_Fiber_Point = min(record.total_Fiber_Point, 15)

        if Diet_score == {}:
            Diet_score = 0
        record.this_day_DataEntry_score += 1
        record.this_day_DataEntry_score = min(record.this_day_DataEntry_score, 10)

    if is_Step:
        # Walking score calculation
        step_record = Walking.objects.filter(user=user, date__range=(dt1, dt2))
        previous_Step_Point = record.total_Steps_Point
        if step_record.exists():
            steps = step_record.last().steps
            steps_points = min(int(steps / 1000), 10)  # 1 point per 1000 steps, up to 10 points
            record.total_Steps_Point = min(steps_points, 10)
            if steps_points == previous_Step_Point and previous_Step_Point != 10:
                points_gained = -1
            elif previous_Step_Point == 0:
                points_gained = steps_points
                if record.total_Activity_Point != 0 and steps_points + 5 > 10:
                    points_gained = 10 - record.total_Exercise_Point
            elif previous_Step_Point != 0 and record.total_Exercise_Point != 10:
                points_gained = steps_points - previous_Step_Point
                if record.total_Activity_Point != 0 and steps_points + 5 > 10:
                    points_gained = 10 - record.total_Exercise_Point
            elif record.total_Exercise_Point == 10:
                points_gained = -2
            else:
                points_gained = 0
            points_awarded['Step_points_gained'] = points_gained
        else:
            record.total_Steps_Point = 0
        record.total_Exercise_Point = min(record.total_Steps_Point + record.total_Activity_Point, 10)

    if is_Activity:
        # Exercise score calculation
        activities = Activities_log.objects.filter(user=user, start_date_time__range=(dt1, dt2))
        previous_Activity_Point = record.total_Activity_Point
        if activities.exists():
            record.total_Activity_Point = 5
            points_gained = 5 if previous_Activity_Point == 0 else 0
            points_awarded['Activity_points_gained'] = max(points_gained, 0)
            previous_DataEntry_score = record.this_day_DataEntry_score
            record.this_day_DataEntry_score += 1
            record.this_day_DataEntry_score = min(record.this_day_DataEntry_score, 10)
            points_awarded['Engagement_points_gained'] = record.this_day_DataEntry_score - previous_DataEntry_score
        else:
            record.total_Activity_Point = 0

        # Update the record
        record.total_Exercise_Point = min(record.total_Steps_Point + record.total_Activity_Point, 10)

    if is_Water:
        water = Water.objects.filter(user=user, time__range=(dt1, dt2))
        previous_Water_Point = record.total_Water_Point
        if not water.exists():
            water_score = 0
        else:
            water_intake = water.last().amount
            water_score = min((water_intake / 8) * 10, 10)
            points_gained = water_score if previous_Water_Point < 10 else 0
            record.total_Water_Point = min(record.total_Water_Point + water_score, 10)
            points_awarded['Water_points_gained'] = max(points_gained, 0)

            previous_DataEntry_score = record.this_day_DataEntry_score
            record.this_day_DataEntry_score += 1
            record.this_day_DataEntry_score = min(record.this_day_DataEntry_score, 10)
            points_awarded['Engagement_points_gained'] = record.this_day_DataEntry_score - previous_DataEntry_score

    if is_Sleep and not is_Mid_Day_Sleep:
        sleeps = Sleep.objects.filter(user=user)
        previous_Sleep_Point = record.total_Sleep_Point
        sleep_duration_points = 0
        sleep_start_points = 0

        if sleeps.exists():
            sleep_record = sleeps.last()
            start_timestamp = sleep_record.start
            end_timestamp = sleep_record.end
            start_time = datetime.fromtimestamp(start_timestamp)
            end_time = datetime.fromtimestamp(end_timestamp)
            sleep_duration_hours = (end_time - start_time).total_seconds() / 3600

            # Define nap criteria
            nap_start_time = start_time.replace(hour=11, minute=0, second=0, microsecond=0)  # 1 PM
            nap_end_time = start_time.replace(hour=20, minute=0, second=0, microsecond=0)  # 9 PM
            is_nap = (
                    nap_start_time <= start_time <= nap_end_time and  # Sleep starts between 1 PM and 9 PM
                    sleep_duration_hours < 2  # Sleep duration is less than 2 hours
            )

            if is_nap:
                # Skip point calculation for naps
                total_sleep_points = previous_Sleep_Point
            else:
                # Calculate sleep duration points
                duration_difference = abs(sleep_duration_hours - 8)
                sleep_duration_points = max(5 - int(duration_difference), 0)

                # Calculate sleep start time points
                ideal_start_time = start_time.replace(hour=22, minute=0, second=0, microsecond=0)  # 10 PM
                if start_time.hour < 22:
                    ideal_start_time -= timedelta(days=1)
                hours_late = (start_time - ideal_start_time).total_seconds() / 3600

                if hours_late < 0:
                    hours_late = 0  # No penalty for sleeping before 10 PM
                sleep_start_points = max(5 - int(hours_late), 0)

                # Ensure points are within 0 and 5
                sleep_duration_points = min(sleep_duration_points, 5)
                sleep_start_points = min(sleep_start_points, 5)

                total_sleep_points = sleep_duration_points + sleep_start_points
                points_gained = total_sleep_points if previous_Sleep_Point == 0 else 0
                points_awarded['Sleep_points_gained'] = max(points_gained, 0)

        else:
            total_sleep_points = 0

        record.total_Sleep_Point = min(total_sleep_points, 10)
        previous_DataEntry_score = record.this_day_DataEntry_score
        record.this_day_DataEntry_score += 1
        record.this_day_DataEntry_score = min(record.this_day_DataEntry_score, 10)
        points_awarded['Engagement_points_gained'] = record.this_day_DataEntry_score - previous_DataEntry_score

    if is_Message:
        # messages = Message.objects.filter(time__range=(dt1 - timedelta(hours=3), dt2 - timedelta(hours=12)))
        Message_score = 0
        message = co_message.objects.filter(Q(sender=user.django_user) | Q(receiver=user.django_user),
                                            time__range=(dt1, dt2))

        if not message.exists():
            Message_score = 0
        else:
            Message_score += 1
        record.this_day_messages = min(record.this_day_messages + Message_score, 5)

    is_participating = Challenge.objects.filter(participants=user, end_deadline__gte=datetime.now()).exists()
    if is_participating:
        Challenge_score = 5
    else:
        Challenge_score = 0

    Engagement_score = min((record.this_day_DataEntry_score + Challenge_score), 10)
    record.total_Engage_Point = Engagement_score
    Diet_score = min(record.this_day_breakfast_Point + record.this_day_lunch_Point + record.this_day_dinner_Point + record.this_day_snack1_Point + record.this_day_snack2_Point, 40)
    record.this_day_total_diet_Point = Diet_score
    total_score = min((record.this_day_total_diet_Point + record.total_Fiber_Point + record.total_Exercise_Point + record.total_Water_Point + record.total_Sleep_Point + record.total_Engage_Point + record.this_day_messages), 100)
    print('--------------------------------')
    print('Diet_score', record.this_day_total_diet_Point)
    print('fiber_score', record.total_Fiber_Point)
    print('activity_score', record.total_Exercise_Point)
    print('water_score', record.total_Water_Point)
    print('sleep_score', record.total_Sleep_Point)
    print('Engagement_score', record.total_Engage_Point)
    print('Total score:', total_score)
    record.total_points = total_score
    record.save()
    return {
        "DayPoint": total_score,
        "totalCooperate": 0,
        'Diet_score': record.this_day_total_diet_Point,
        'Fiber_score': record.total_Fiber_Point,
        'Activity_score': record.total_Exercise_Point,
        'Water_score': record.total_Water_Point,
        'Sleep_score': record.total_Sleep_Point,
        'Engagement_score': record.total_Engage_Point,
        'Message_score': record.this_day_messages,
        'points_awarded': points_awarded,
    }


def notif_cal(difference, api_name):
    # Round the difference to 2 decimal places
    difference_rounded = round(difference, 2)

    if difference_rounded > 0:
        return f"شما {difference_rounded} امتیاز بابت ثبت میزان {api_name} خود به دست آوردید!"
    elif difference_rounded == -100:
        return f"شما حداکثر امتیاز مربوط به {api_name} خود را در این وعده گرفته‌اید."
    elif difference_rounded < 0:
        return f"امتیاز مربوط به {api_name} شما قبلا محاسبه شده است."
    else:
        return f"امتیاز مربوط به {api_name} شما قبلا محاسبه شده است."


def NaNtoInt(x):
    cc = str(x)
    if (cc == "nan") or (cc == "--") or (cc == "-") or (cc == "~"):
        return 0

    if cc.__contains__("\xa0"):
        cc = cc.replace("\xa0", "")  # \xa0
        if cc.__contains__("/"):
            parts = cc.split("/")
            num = parts[0] + "." + parts[1]
            cc = float(num)
        elif cc.__contains__("."):
            parts = cc.split(".")
            num = parts[0] + "." + parts[1]
            cc = float(num)
        else:
            raise ValueError("Why do not you erase these spaces around the number '" + str(x) + "' ?\n\n")
    else:
        return float(cc)


def getIntroCode():
    recent_profiles = Profile.objects.filter(register_time__gt=datetime.now() - timedelta(days=10)).order_by(
        '-user_code')

    code = None

    if not recent_profiles.exists():
        code = 'aaaaaa'  # for first user

    i = 0
    while (i < recent_profiles.count()) and (code == None):
        code = recent_profiles[i].user_code
        i += 1

    alphabet = '0123456789' + 'abcdefghijklmnopqrstuvwxyz'  # radix 36 ---> 0 ... 35
    arr = []

    if code == "zzzzz":
        code = "1" + "zzzzz"

    for i in range(len(code)):
        arr.append(alphabet.find(code[i]))
    arr[len(arr) - 1] += 1

    for i in range(len(arr)):
        if arr[len(arr) - i - 1] > 35:
            arr[len(arr) - i - 1] -= 36
            arr[len(arr) - i - 2] += 1

    result = ""
    for j in range(len(arr)):
        result += alphabet[arr[j]]
    return result


def limitString(s, limit):
    if len(s) < limit or limit < 0:
        return s
    else:
        return s[0: limit] + "..."


@api_view(["POST", "GET"])
def TestingApi3(request):
    if request.method == "POST":
        try:
            data = {
                "phone_number": request.POST["phone_number"],
                "token": request.POST["token"],
                "message": request.POST["message"],
            }
            return myResponse.OK("ok", data)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        try:
            return myResponse.OK("ok", [str(request.GET)])
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


# @api_view(["POST", "GET"])
# def pdf(request):
#     try:
#         # from jinja2 import Environment, FileSystemLoader
#         import pdfkit
#         from django.template.loader import get_template

#         # env = Environment(loader=FileSystemLoader('.'))
#         # template = env.get_template("main.html")

#         context = {
#             "name": str(datetime.now()),
#             "image_address": "file:///C:/Users/Hossein/Desktop/iDia/vm/iDia_project/APIs/template/pdf_report/images/robot.png",
#         }

#         # html_report = template.render(context)
#         html_report = get_template("pdf_report/main.html").render(context=context)

#         pdfkit.from_string(html_report, 'static/user_reports/GfG.pdf')
#         return HttpResponse(html_report)

#     except Exception as e:
#         return myResponse.Error(str(e), -1)


def sendCodeWithEmail(code, recip):
    from django.core.mail import send_mail
    html_message = '''
                <h4>
                    Ziluck Account
                </h4>
                <h4>
                    your Ziluck activation code:
                </h4>
                <br>
                <h1>
                    {code}
                </h1>
                <br>
                <h5>
                     This code will only be valid for 4 minutes.
                </h5>
                <br>
                <h5>
                    <a href="https://probiofit.net">Ziluck App</a>
                <h5>
            '''.format(code=code)
    result = send_mail(
        subject='your Ziluck activation code',
        from_email='activation@idia.app',
        message="",
        recipient_list=[recip],
        fail_silently=False,
        html_message=html_message
    )
    return result


def send_sms(phone, message):
    # send welcome message ...
    querystring = {
        "receptor": phone,
        "message": message
    }
    response = requests.request("POST", SMS_API_URL, params=querystring)


@csrf_exempt
@api_view(["POST"])
def process_body_composition_image_api(request):    
    """
    API endpoint to process a body composition analysis image and return the generated HTML report link.
    Accepts an image file via POST (multipart/form-data, key: 'image').
    Returns: JSON with the HTML report link.
    """
    try:
        if 'image' not in request.FILES:
            return myResponse.Error("No image file provided", -1)
        image_file = request.FILES['image']
        # Save the uploaded image to a temp location
        from django.conf import settings
        import uuid
        upload_dir = os.path.join(settings.BASE_DIR, 'static', 'bia_images')
        os.makedirs(upload_dir, exist_ok=True)
        filename = f"bia_{uuid.uuid4().hex}.jpg"
        image_path = os.path.join(upload_dir, filename)
        with open(image_path, 'wb+') as destination:
            for chunk in image_file.chunks():
                destination.write(chunk)
        # Process the image and get the HTML report path
        html_path = process_body_composition_image(image_path)
        print("1.", html_path)
        # Convert the absolute HTML path to a relative/static URL if possible
        static_root = getattr(settings, 'STATIC_ROOT', None)
        print("2.", static_root)
        static_url = getattr(settings, 'STATIC_URL', 'static')
        print("3.", static_url)
        # Replace static_root with static_url to get the relative static path
        html_url = html_path.replace(static_root, static_url)
        print("4.", html_url)
        # Ensure the URL uses forward slashes
        html_url = html_url.replace('\\', '')
        print("5.", html_url)
        html_url = html_url.replace('//', '/')
        print("6.", html_url)
        # Prepend the domain to make it a full URL
        full_url = f"https://ziluck.probiofit.net{html_url}"
        return myResponse.OK("HTML report generated", {"html_report_url": full_url})
    except Exception as e:
        return myResponse.Error(f"Error processing image: {str(e)}", -1)

@api_view(["POST"])
def test_delete_all_foodcards(request):
    """
    Test-only API: Delete all FoodCard objects from the database.
    """
    deleted_count, _ = FoodCard.objects.all().delete()
    return Response({'deleted_count': deleted_count, 'message': 'All FoodCard objects deleted.'})


@api_view(['GET', 'POST'])
def payment_plans_api(request):
    """
    API endpoint to get all active payment plans
    Returns payment plans with items included/excluded as lists
    Requires user authentication via token
    """
    if request.method == "POST":
        try:
            # Get token from POST data
            token = str(request.POST.get("token"))
            if not token:
                return Response({
                    'status': 'error',
                    'message': 'Token required',
                    'error': 'Token must be provided in POST data'
                }, status=status.HTTP_400_BAD_REQUEST)
            
            # Verify user token
            from APIs.models import User
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return Response({
                    'status': 'error',
                    'message': 'Invalid token',
                    'error': 'The provided token is not valid'
                }, status=status.HTTP_401_UNAUTHORIZED)
            
            user = temp[0]
        
            
            # Get all active payment plans
            from payment.models import PaymentPlans
            plans = PaymentPlans.objects.filter(is_active=True).order_by('price')
            
            plans_data = []
            for plan in plans:
                plan_data = {
                    'id': plan.id,
                    'name': plan.name,
                    'plan_database_id': plan.plan_database_id,
                    'price': float(plan.price),
                    'items_included': plan.get_items_included_list(),
                    'items_excluded': plan.get_items_excluded_list(),
                    'promotion': plan.promotion,
                    'price_with_promotion': float(plan.price_with_promotion) if plan.price_with_promotion else None,
                    'subscription_period': plan.subscription_period,
                    'created_at': plan.created_at.isoformat() if plan.created_at else None,
                    'updated_at': plan.updated_at.isoformat() if plan.updated_at else None
                }
                plans_data.append(plan_data)
            
            return Response({
                'status': 'success',
                'message': 'Payment plans retrieved successfully',
                'data': plans_data,
                'user': {
                    'id': user.id,
                    'username': user.username if hasattr(user, 'username') else None,
                    'phone_number': user.phone_number if hasattr(user, 'phone_number') else None
                }
            }, status=status.HTTP_200_OK)
            
        except Exception as e:
            print(f"Error in payment_plans_api: {str(e)}")
            return Response({
                'status': 'error',
                'message': 'Failed to retrieve payment plans',
                'error': str(e)
            }, status=status.HTTP_500_INTERNAL_SERVER_ERROR)
    
    else:
        # GET request - return error message
        return Response({
            'status': 'error',
            'message': 'POST method required',
            'error': 'This API endpoint requires POST method with token authentication'
        }, status=status.HTTP_405_METHOD_NOT_ALLOWED)
    