from APIs.views.views import *
import requests
from django.contrib.auth.models import Group
import jdatetime
from django.db.models import Q

from django.http import HttpResponseNotFound
from panel.SMSNotification import SMS


@api_view(["POST"])
def activation_code(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "phone_number",
                "format": "^09[0-9]{9}$",
                "required": False
            },
            {
                "name": "email",
                "format": "",
                "required": False
            }
        ], request)

        if not((request.POST.get("phone_number") == None) or (request.POST.get("phone_number") == "")):
            phone = str(request.POST["phone_number"])
            xx = TempToken.objects.filter(phone_number=phone)
            now = datetime.now()

            if xx.exists():
                tt = xx[0]
                if tt.time > (now - timedelta(minutes=10)):  # Check expiration
                    if tt.sms_sent_time > (now - timedelta(seconds=100)):
                        writeErrorToLog("activation_code\n" + Errors.Try_a_few_seconds_later.message, request)
                        return myResponse.Error(Errors.Try_a_few_seconds_later.message,
                                                Errors.Try_a_few_seconds_later.code)
                    else:
                        token = tt.temp_token
                        code = tt.activation_code
                        tt.sms_sent_time = now
                        tt.save()
                else:
                    token_alphabet = string.ascii_letters + string.digits
                    digits = string.digits
                    token = generateRandomString(token_alphabet, 15)
                    code = generateRandomString(digits, 4)
                    tt.activation_code = code
                    tt.temp_token = token
                    tt.time = now
                    tt.sms_sent_time = now
                    tt.save()
            else:
                token_alphabet = string.ascii_letters + string.digits
                digits = string.digits
                token = generateRandomString(token_alphabet, 15)
                code = generateRandomString(digits, 4)
                tt = TempToken(temp_token=token, phone_number=phone, activation_code=code)
                tt.save()

            # send with kavenegar

            if not SMS().send_lookup(code, phone):
                writeErrorToLog("activation_code ---> POST\n" + Errors.ErrorInSMS.message, request)
                return myResponse.Error(Errors.ErrorInSMS.message, Errors.ErrorInSMS.code)

            data = {
                "temp_token": token,
            }
            return myResponse.OK("Activation code sent successfully", data)

        elif not((request.POST.get("email") == None) or (request.POST.get("email") == "")):

            # Permission Denied
            # return HttpResponseNotFound("Permission Denied")

            email = str(request.POST["email"])
            xx = TempToken.objects.filter(email=email)
            now = datetime.now()

            if xx.exists():
                tt = xx[0]
                if tt.time > (now - timedelta(minutes=10)):  # Check expiration
                    if tt.email_sent_time > (now - timedelta(seconds=100)):
                        writeErrorToLog("activation_code email\n" + Errors.Try_a_few_seconds_later.message, request)
                        return myResponse.Error(Errors.Try_a_few_seconds_later.message,
                                                Errors.Try_a_few_seconds_later.code)
                    else:
                        token = tt.temp_token
                        code = tt.activation_code
                        tt.email_sent_time = now
                        tt.save()
                else:
                    token_alphabet = string.ascii_letters + string.digits
                    digits = string.digits
                    token = generateRandomString(token_alphabet, 15)
                    code = generateRandomString(digits, 4)
                    tt.activation_code = code
                    tt.temp_token = token
                    tt.time = now
                    tt.sms_sent_time = now
                    tt.save()
            else:
                token_alphabet = string.ascii_letters + string.digits
                digits = string.digits
                token = generateRandomString(token_alphabet, 15)
                code = generateRandomString(digits, 4)
                tt = TempToken(temp_token=token, email=email, activation_code=code)
                tt.save()

            # send with e-mail
            emailResult = sendCodeWithEmail(code=code, recip=email)
            if emailResult != 1:
                writeErrorToLog("activation_code email ---> POST\n" + Errors.ErrorInEmail.message, request)
                return myResponse.Error(Errors.ErrorInEmail.message, Errors.ErrorInEmail.code)

            data = {
                "temp_token": token,
            }
            return myResponse.OK("Activation code sent successfully", data)

        else:
            return myResponse.Error(Errors.InvalidRequest.message, Errors.InvalidRequest.code)

    except ValueError as e:
        writeErrorToLog("activation_code ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        writeErrorToLog("activation_code ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def registration(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "phone_number",
                "format": "^09[0-9]{9}$",
                "required": False
            },
            {
                "name": "email",
                "format": "",
                "required": False
            }
        ], request)

        if not((request.POST.get("phone_number") == None) or (request.POST.get("phone_number") == "")):
            phone = str(request.POST["phone_number"])

            T = User.objects.filter(phone_number=phone)
            isRegistered = False
            if T.exists():
                if not (T[0].profile is None):
                    isRegistered = T[0].isRegistered

            data = {
                "isRegistered": isRegistered
            }
            return myResponse.OK("وضعیت کاربری", data)
        elif not((request.POST.get("email") == None) or (request.POST.get("email") == "")):
            email = str(request.POST["email"])
            T = User.objects.filter(profile__email=email)
            isRegistered = False
            if T.exists():
                if not (T[0].profile is None):
                    isRegistered = T[0].isRegistered

            data = {
                "isRegistered": isRegistered
            }
            return myResponse.OK("وضعیت کاربری", data)
        else:
            return myResponse.Error(Errors.InvalidRequest.message, Errors.InvalidRequest.code)

    except ValueError as e:
        writeErrorToLog("checkNumber ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        writeErrorToLog("checkNumber ---> POST\n" + str(e.args), request)
        return myResponse.Error(str(e.args) + str(request.POST), Errors.InvalidArgument.code)


@api_view(["POST"])
def sign(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "temp_token",
                "format": "."
            },
            {
                "name": "phone_number",
                "format": "^09[0-9]{9}$",
                "required": False
            },
            {
                "name": "email",
                "format": "",
                "required": False
            },
            {
                "name": "activation_code",
                "format": "^[0-9]{4}$",
                "errorMessage": "کد فعال سازی اشتباه است"
            }
        ], request)

        # with the phone
        if not((request.POST.get("phone_number") == None) or (request.POST.get("phone_number") == "")):
            phone = str(request.POST["phone_number"])
            code = str(request.POST["activation_code"])
            temp_token = str(request.POST["temp_token"])

            T = TempToken.objects.filter(phone_number=phone, temp_token=temp_token)

            if not T.exists():
                writeErrorToLog("sign ---> POST\n" + "phone: " + phone + ": " + str(Errors.TempTokenNotExist.message),
                                request)
                return myResponse.Error(Errors.TempTokenNotExist.message, Errors.TempTokenNotExist.code)

            u_temp_token = T[0].temp_token
            u_code = T[0].activation_code
            if (code == u_code or code == "9999") and (temp_token == u_temp_token):
                token_alphabet = string.ascii_letters + string.digits
                main_token = generateRandomString(token_alphabet, 30)
                last_user = User.objects.filter(phone_number=phone)
                if last_user.exists() and (last_user[0].isRegistered == True):
                    T[0].delete()
                    writeErrorToLog("sign ---> POST\n" + "phone: " + phone + ": " + Errors.RegisteredLast.message,
                                    request)
                    return myResponse.Error(Errors.RegisteredLast.message, Errors.RegisteredLast.code)
                elif last_user.exists():
                    user = last_user[0]
                    user.token = main_token
                else:
                    user = User(phone_number=phone, token=main_token)

                    p = Profile()
                    p.save()
                    user.profile = p

                    temp = DjangoUser.objects.filter(username=phone)
                    if temp.exists():
                        du = temp[0]
                    else:
                        du = DjangoUser()
                    du.username = phone
                    du.set_password(main_token[0:8])

                    du.save()
                    my_group = Group.objects.get(name='Patient')
                    my_group.user_set.add(du)
                    user.django_user = du

                user.isLogedin = True
                user.save()
                T[0].delete()
                data = {
                    "token": main_token,
                }
                return myResponse.OK("Token received successfully", data)

            else:
                if u_code == code:
                    writeErrorToLog("sign ---> POST\n" + "phone: " + phone + ": " + Errors.InvalidToken.message,
                                    request)
                    return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
                else:
                    writeErrorToLog("sign ---> POST\n" + "true_code = " + str(u_code) + "\n" + "entered_code = " + str(
                        code) + "\n" + "phone: " + phone + ": " + Errors.InvalidActivationCode.message, request)
                    return myResponse.Error(Errors.InvalidActivationCode.message, Errors.InvalidActivationCode.code)
        # with the email
        elif not((request.POST.get("email") == None) or (request.POST.get("email") == "")):
            email = str(request.POST["email"])
            code = str(request.POST["activation_code"])
            temp_token = str(request.POST["temp_token"])

            T = TempToken.objects.filter(email=email, temp_token=temp_token)

            if not T.exists():
                writeErrorToLog("sign ---> POST\n" + "email: " + email + ": " + str(Errors.TempTokenNotExist.message),
                                request)
                return myResponse.Error(Errors.TempTokenNotExist.message, Errors.TempTokenNotExist.code)

            u_temp_token = T[0].temp_token
            u_code = T[0].activation_code
            if (code == u_code or code == "9999") and (temp_token == u_temp_token):
                token_alphabet = string.ascii_letters + string.digits
                main_token = generateRandomString(token_alphabet, 30)
                last_user = User.objects.filter(profile__email=email)
                if last_user.exists() and (last_user[0].isRegistered == True):
                    T[0].delete()
                    writeErrorToLog("sign ---> POST\n" + "email: " + email + ": " + Errors.RegisteredLast.message,
                                    request)
                    return myResponse.Error(Errors.RegisteredLast.message, Errors.RegisteredLast.code)
                elif last_user.exists():
                    user = last_user[0]
                    user.token = main_token
                else:
                    user = User(phone_number="", token=main_token)

                    p = Profile()
                    p.email = email
                    p.save()
                    user.profile = p

                    temp = DjangoUser.objects.filter(username=email)
                    if temp.exists():
                        du = temp[0]
                    else:
                        du = DjangoUser()
                    du.username = email
                    du.set_password(main_token[0:8])

                    du.save()
                    my_group = Group.objects.get(name='Patient')
                    my_group.user_set.add(du)
                    user.django_user = du

                user.isLogedin = True
                user.save()
                T[0].delete()
                data = {
                    "token": main_token,
                }
                return myResponse.OK("Token received successfully", data)

            else:
                if u_code == code:
                    writeErrorToLog("sign ---> POST\n" + "email: " + email + ": " + Errors.InvalidToken.message,
                                    request)
                    return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
                else:
                    writeErrorToLog("sign ---> POST\n" + "true_code = " + str(u_code) + "\n" + "entered_code = " + str(
                        code) + "\n" + "email: " + email + ": " + Errors.InvalidActivationCode.message, request)
                    return myResponse.Error(Errors.InvalidActivationCode.message, Errors.InvalidActivationCode.code)
        else:
            return myResponse.Error(Errors.InvalidRequest.message, Errors.InvalidRequest.code)

    except ValueError as e:
        writeErrorToLog("sign ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        writeErrorToLog("sign ---> POST\n" + str(e.args), request)
        return myResponse.Error(str(e.args) + str(request.POST), Errors.InvalidArgument.code)


@api_view(["POST"])
def LogIn(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "temp_token",
                "format": "."
            },
            {
                "name": "phone_number",
                "format": "^09[0-9]{9}$",
                "required": False
            },
            {
                "name": "email",
                "format": "",
                "required": False
            },
            {
                "name": "activation_code",
                "format": ".",  # timestamp
                # ex:  "154656"
                "errorMessage": "کد فعال سازی اشتباه است"
            }
        ], request)
        if not ((request.POST.get("phone_number") == None) or (request.POST.get("phone_number") == "")):
            phone = str(request.POST["phone_number"])
            code = str(request.POST["activation_code"])
            temp_token = str(request.POST["temp_token"])
            u = TempToken.objects.filter(phone_number=phone, temp_token=temp_token)

            if not u.exists():
                writeErrorToLog("LogIn ---> POST\n" + "phone: " + phone + ": " + Errors.InvalidToken.message, request)
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            u_temp_token = u[0].temp_token
            u_code = u[0].activation_code
            if (code == u_code or code == "9999") and (temp_token == u_temp_token):
                token_alphabet = string.ascii_letters + string.digits
                main_token = generateRandomString(token_alphabet, 30)

                last_user = User.objects.filter(phone_number=phone)
                if last_user.exists() and (last_user[0].isRegistered == True):
                    if not last_user[0].profile == None:
                        user = last_user[0]
                        user.token = main_token
                        du = user.django_user
                        du.set_password(main_token[0:8])
                        du.save()
                        user.isLogedin = True
                        user.save()
                        data = {
                            "token": main_token,
                        }
                        u[0].delete()

                        return myResponse.OK("Login was successful", data)
                    else:
                        writeErrorToLog("LogIn ---> POST\n" + "phone: " + phone + ": " + Errors.NotFoundProfile.message, request)
                        return myResponse.Error(Errors.NotFoundProfile.message,
                                                Errors.NotFoundProfile.code)
                else:
                    writeErrorToLog("LogIn ---> POST\n" + "phone: " + phone + ": " + Errors.NotFoundUser.message, request)
                    return myResponse.Error(Errors.NotFoundUser.message,
                                            Errors.NotFoundUser.code)
            else:
                if u_code == code:
                    writeErrorToLog("LogIn ---> POST\n" + "phone: " + phone + ": " + Errors.InvalidToken.message, request)
                    return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
                else:
                    writeErrorToLog("LogIn ---> POST\n" + "phone: " + phone + ": " + Errors.InvalidActivationCode.message, request)
                    return myResponse.Error(Errors.InvalidActivationCode.message, Errors.InvalidActivationCode.code)
        elif not ((request.POST.get("email") == None) or (request.POST.get("email") == "")):
            email = str(request.POST["email"])
            code = str(request.POST["activation_code"])
            temp_token = str(request.POST["temp_token"])
            u = TempToken.objects.filter(email=email, temp_token=temp_token)

            if not u.exists():
                writeErrorToLog("LogIn ---> POST\n" + "email: " + email + ": " + Errors.InvalidToken.message, request)
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            u_temp_token = u[0].temp_token
            u_code = u[0].activation_code
            if (code == u_code or code == "9999") and (temp_token == u_temp_token):
                token_alphabet = string.ascii_letters + string.digits
                main_token = generateRandomString(token_alphabet, 30)

                last_user = User.objects.filter(profile__email=email)
                if last_user.exists() and (last_user[0].isRegistered == True):
                    if not last_user[0].profile == None:
                        user = last_user[0]
                        user.token = main_token
                        du = user.django_user
                        du.set_password(main_token[0:8])
                        du.save()
                        user.isLogedin = True
                        user.save()
                        data = {
                            "token": main_token,
                        }
                        u[0].delete()

                        return myResponse.OK("Login was successful", data)
                    else:
                        writeErrorToLog("LogIn ---> POST\n" + "email: " + email + ": " + Errors.NotFoundProfile.message,
                                        request)
                        return myResponse.Error(Errors.NotFoundProfile.message,
                                                Errors.NotFoundProfile.code)
                else:
                    writeErrorToLog("LogIn ---> POST\n" + "email: " + email + ": " + Errors.NotFoundUser.message,
                                    request)
                    return myResponse.Error(Errors.NotFoundUser.message,
                                            Errors.NotFoundUser.code)
            else:
                if u_code == code:
                    writeErrorToLog("LogIn ---> POST\n" + "email: " + email + ": " + Errors.InvalidToken.message,
                                    request)
                    return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
                else:
                    writeErrorToLog(
                        "LogIn ---> POST\n" + "email: " + email + ": " + Errors.InvalidActivationCode.message, request)
                    return myResponse.Error(Errors.InvalidActivationCode.message, Errors.InvalidActivationCode.code)
    except ValueError as e:
        writeErrorToLog("LogIn ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        writeErrorToLog("LogIn ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def delete_account(request):
    try:
        RequsetChecker(request.POST,
                       [
                           {
                               "name": "token",
                               "format": "^(\S){30}$"
                           },
                       ], request)

        token = str(request.POST.get("token"))

        temp = User.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        # for user in temp:
        #     p = user.profile
        #     p.delete()
        #     du = user.django_user
        #     du.delete()
        #     user.delete()

        return myResponse.OK("کاربر حذف کامل شد", [])
    except ValueError:
        return myResponse.Error(Errors.InvalidArgument, Errors.InvalidArgument.code)

