from APIs.views.views import *


@api_view(["POST"])
def get_gifts(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "errorMessage": "توکن نامعتبر است"
            },
        ], request)

        temp = User.objects.filter(token=request.POST.get("token"))
        if not temp.exists():
            return myResponse.Error(Errors.NotFoundUser.message, Errors.NotFoundUser.code)
        user = temp[0]

        gifts = Gift.objects.filter(user=user).order_by("-created_at")
        data = []
        for gift in gifts:
            data.append({
                "name": gift.name,
                "created_at": gift.created_at,
                "code": gift.code,
                "description": gift.description,
                "link": gift.link,
            })
        return myResponse.OK("gifts list", data)
    except Exception as e:
        return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
