import django.db.models
from networkx import to_dict_of_dicts
import logging

logger = logging.getLogger(__name__)

from panel.telegram_notification import TelegramNotification

from .views import *
from APIs.views.firebase import send_notification
import requests
from django.contrib.auth.models import Group
import jdatetime
from ziluck_project.hospital_config import HOSPITAL_INFO
from django.contrib.auth import authenticate, login
from django.db.models import Q
from panel.SMSNotification import SMS
from panel.utility import generate_file_name
from ziluck_project.settings import MEDIA_ROOT
from panel.models import Hospital
from panel.models import Message as PanelMessage
from django.utils.timezone import now
from APIs.modules.recommendation_engine import get_food_recommendations
from neo4j import GraphDatabase
from datetime import datetime, timedelta
from ziluck_project.settings import STATIC_ROOT
from APIs.modules.wellness_assistant import call_health_wellness_assistant
import json
import re
from APIs.models import Mood
from APIs.models import BreathWork
from ziluck_project.hospital_config import validate_hospital_api_key, get_hospital_name
from panel.services.diet_generation import start_diet_generation_background
from APIs.models import Diet
from panel.models import TimeSlot, Assistant, Doctor
from panel.models import TimeSlot
from payment.models import TimeSlotPayment, ZarinPalPayment
from ziluck_project.constants import MERCHANT, ZP_API_REQUEST, ZP_API_STARTPAY, TIMESLOT_PAYMENT
import json
import requests
import random
import string
from panel.tagging import generate_health_tags, calorie_distributions, cr_list, all_alergic_tags

@api_view(["POST"])
def activation_code(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "phone_number",
                "format": "^09[0-9]{9}$"
            }
        ], request)

        phone = str(request.POST["phone_number"])

        xx = TempToken.objects.filter(phone_number=phone)
        now = datetime.now()

        # return myResponse.Error(Errors.ErrorInSMS.message, Errors.ErrorInSMS.code)

        if xx.exists():
            tt = xx[0]
            if tt.time > (now - timedelta(minutes=10)):  # Check expiration
                if tt.sms_sent_time > (now - timedelta(seconds=100)):
                    writeErrorToLog("activation_code\n" + Errors.Try_a_few_seconds_later.message, request)
                    return myResponse.Error(Errors.Try_a_few_seconds_later.message, Errors.Try_a_few_seconds_later.code)
                else:
                    token = tt.temp_token
                    code = tt.activation_code
                    tt.sms_sent_time = now
                    tt.save()
            else:
                token_alphabet = string.ascii_letters + string.digits
                digits = string.digits
                token = generateRandomString(token_alphabet, 15)
                code = generateRandomString(digits, 4)
                tt.activation_code = code
                tt.temp_token = token
                tt.time = now
                tt.sms_sent_time = now
                tt.save()
        else:
            token_alphabet = string.ascii_letters + string.digits
            digits = string.digits
            token = generateRandomString(token_alphabet, 15)
            code = generateRandomString(digits, 4)
            tt = TempToken(temp_token=token, phone_number=phone, activation_code=code)
            tt.save()

        # # send with kavenegar
        if not SMS().send_lookup(code, phone):
            writeErrorToLog("activation_code ---> POST\n" + Errors.ErrorInSMS.message, request)
            return myResponse.Error(Errors.ErrorInSMS.message, Errors.ErrorInSMS.code)

        data = {
            # "activation_code": code,
            "temp_token": token,
            # "response": str(response)
        }
        return myResponse.OK("کد فعال سازی با موفقیت ارسال شد", data)
    except ValueError as e:
        writeErrorToLog("activation_code ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        writeErrorToLog("activation_code ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def checkNumber(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "phone_number",
                "format": "^09[0-9]{9}$"
            },
        ], request)

        phone = str(request.POST["phone_number"])

        T = User.objects.filter(phone_number=phone)
        isRegistered = False
        if T.exists():
            if not (T[0].profile is None):
                isRegistered = T[0].isRegistered

        data = {
            "isRegistered": isRegistered
        }
        return myResponse.OK("وضعیت کاربری", data)


    except ValueError as e:
        writeErrorToLog("checkNumber ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        writeErrorToLog("checkNumber ---> POST\n" + str(e.args), request)
        return myResponse.Error(str(e.args) + str(request.POST), Errors.InvalidArgument.code)


@api_view(["POST"])
def activation_code_debuging(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "phone_number",
                "format": "^09[0-9]{9}$"
            }
        ], request)

        phone = str(request.POST["phone_number"])

        xx = TempToken.objects.filter(phone_number=phone)
        if xx.exists():
            xx[0].delete()

        token_alphabet = string.ascii_letters + string.digits
        digits = string.digits
        token = generateRandomString(token_alphabet, 15)
        code = generateRandomString(digits, 4)
        # send activationCode AS SMS to phone number

        tt = TempToken(temp_token=token, phone_number=phone, activation_code=code)
        tt.save()

        data = {
            "activation_code": code,
            "temp_token": token,
        }
        return myResponse.OK("کد فعال سازی با موفقیت ارسال شد [حالت دیباگ]", data)
    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        writeErrorToLog(e.args, request)
        return myResponse.Error(e.args, Errors.InvalidArgument.code)


@api_view(["POST"])
def sign(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "temp_token",
                "format": "^(\S){15}$"
            },
            {
                "name": "phone_number",
                "format": "^09[0-9]{9}$"
            },
            {
                "name": "activation_code",
                "format": "^[0-9]{4}$",
                "errorMessage": "کد فعال سازی اشتباه است"
            }
        ], request)

        phone = str(request.POST["phone_number"])
        code = str(request.POST["activation_code"])
        temp_token = str(request.POST["temp_token"])

        T = TempToken.objects.filter(phone_number=phone, temp_token=temp_token)

        if not T.exists():
            writeErrorToLog("sign ---> POST\n" + "phone: " + phone + ": " + str(Errors.TempTokenNotExist.message),
                            request)
            return myResponse.Error(Errors.TempTokenNotExist.message, Errors.TempTokenNotExist.code)

        u_temp_token = T[0].temp_token
        u_code = T[0].activation_code
        if (code == u_code or code == "9999") and (temp_token == u_temp_token):
            token_alphabet = string.ascii_letters + string.digits
            main_token = generateRandomString(token_alphabet, 30)
            last_user = User.objects.filter(phone_number=phone)
            if last_user.exists() and (last_user[0].isRegistered == True):
                T[0].delete()
                writeErrorToLog("sign ---> POST\n" + "phone: " + phone + ": " + Errors.RegisteredLast.message, request)
                return myResponse.Error(Errors.RegisteredLast.message, Errors.RegisteredLast.code)
            elif last_user.exists():
                user = last_user[0]
                user.token = main_token
            else:
                user = User(phone_number=phone, token=main_token)

                p = Profile()
                address = Address()
                address.save()
                p.address = address
                p.save()
                user.profile = p

                temp = DjangoUser.objects.filter(username=phone)
                if temp.exists():
                    du = temp[0]
                else:
                    du = DjangoUser()
                du.username = phone
                du.set_password(main_token[0:8])

                du.save()
                my_group = Group.objects.get(name='Patient')
                my_group.user_set.add(du)
                user.django_user = du

            user.isLogedin = True
            user.save()
            T[0].delete()
            data = {
                "token": main_token,
            }
            return myResponse.OK("دریافت توکن با موفقیت انجام شد", data)

        else:
            if u_code == code:
                writeErrorToLog("sign ---> POST\n" + "phone: " + phone + ": " + Errors.InvalidToken.message, request)
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            else:
                writeErrorToLog("sign ---> POST\n" + "true_code = " + str(u_code) + "\n" + "entered_code = " + str(
                    code) + "\n" + "phone: " + phone + ": " + Errors.InvalidActivationCode.message, request)
                return myResponse.Error(Errors.InvalidActivationCode.message, Errors.InvalidActivationCode.code)
    except ValueError as e:
        writeErrorToLog("sign ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        writeErrorToLog("sign ---> POST\n" + str(e.args), request)
        return myResponse.Error(str(e.args) + str(request.POST), Errors.InvalidArgument.code)


@api_view(["POST"])
def LogIn(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "temp_token",
                "format": "^(\S){15}$"
            },
            {
                "name": "phone_number",
                "format": "^09[0-9]{9}$"
            },
            {
                "name": "activation_code",
                "format": ".",  # timestamp
                # ex:  "154656"
                "errorMessage": "کد فعال سازی اشتباه است"
            }
        ], request)

        phone = str(request.POST["phone_number"])
        code = str(request.POST["activation_code"])
        temp_token = str(request.POST["temp_token"])
        u = TempToken.objects.filter(phone_number=phone, temp_token=temp_token)

        if not u.exists():
            writeErrorToLog("LogIn ---> POST\n" + "phone: " + phone + ": " + Errors.InvalidToken.message, request)
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        u_temp_token = u[0].temp_token
        u_code = u[0].activation_code
        if (code == u_code or code == "9999") and (temp_token == u_temp_token):
            token_alphabet = string.ascii_letters + string.digits
            main_token = generateRandomString(token_alphabet, 30)

            last_user = User.objects.filter(phone_number=phone)
            if last_user.exists() and (last_user[0].isRegistered == True):
                if not last_user[0].profile == None:
                    user = last_user[0]
                    user.token = main_token
                    du = user.django_user
                    du.set_password(main_token[0:8])
                    du.save()
                    user.isLogedin = True
                    user.save()
                    data = {
                        "token": main_token,
                    }
                    u[0].delete()

                    return myResponse.OK("ورود با موفقیت انجام شد", data)
                else:
                    writeErrorToLog("LogIn ---> POST\n" + "phone: " + phone + ": " + Errors.NotFoundProfile.message,
                                    request)
                    return myResponse.Error(Errors.NotFoundProfile.message,
                                            Errors.NotFoundProfile.code)
            else:
                writeErrorToLog("LogIn ---> POST\n" + "phone: " + phone + ": " + Errors.NotFoundUser.message, request)
                return myResponse.Error(Errors.NotFoundUser.message,
                                        Errors.NotFoundUser.code)
        else:
            if u_code == code:
                writeErrorToLog("LogIn ---> POST\n" + "phone: " + phone + ": " + Errors.InvalidToken.message, request)
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            else:
                writeErrorToLog("LogIn ---> POST\n" + "phone: " + phone + ": " + Errors.InvalidActivationCode.message,
                                request)
                return myResponse.Error(Errors.InvalidActivationCode.message, Errors.InvalidActivationCode.code)
    except ValueError as e:
        writeErrorToLog("LogIn ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        writeErrorToLog("LogIn ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def LogOut(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$"
            },
            {
                "name": "phone_number",
                "format": "^09[0-9]{9}$"
            }
            # todo: change for v2
        ], request)
        phone = str(request.POST["phone_number"])
        token = str(request.POST["token"])
        u = User.objects.filter(phone_number=phone, token=token)
        if u.exists():
            user = u[0]
            token_alphabet = string.ascii_letters + string.digits
            new_token = generateRandomString(token_alphabet, 30)
            user.token = new_token
            user.isLogedin = False
            user.save()
            return myResponse.OK("خروج با موفقیت انجام شد", [])
        else:
            return myResponse.Error(Errors.NotFoundUser.message, Errors.NotFoundUser.code)
    except ValueError as e:
        writeErrorToLog(e.args, request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["GET", "POST"])
def profile_info(request):
    if request.method == "POST":
        # try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$"
            },
            # {
            #     "name": "phone_number",
            #     "format": "^09[0-9]{9}$"
            # },
            {
                "name": "first_name",
                "format": ".",
                "errorMessage": "insert string for first name",
                # "required": False
            },
            {
                "name": "last_name",
                "format": ".",
                "errorMessage": "insert string for last name",
                # "required": False
            },
            {
                "name": "birth_date",
                "format": "^[-+]?[0-9]+$",  # timestamp
                # ex:  "1546270161"
                "errorMessage": "تاریخ تولد اشتباه وارد شده است"
            },
            {
                "name": "weight",
                "format": "^[0-9]+\.?[0-9]+$",
                "errorMessage": "وزن را به صورت یک عدد فلوت وارد کنید"

            },
            {
                "name": "height",
                "format": "^[\d]+$",
            },
            {
                "name": "diabetes_type",
                "format": "^[0123]+$",
                "errorMessage": "نوع دیابت را به صورت یک عدد صحیح وارد کنید. 0 برای دیابت بارداری، 1 و 2 به ترتیب برای دیابت های نوع 1 و 2 میباشد"
            },
            {
                "name": "detection_year",
                "format": "^[\d]+$",

            },
            {
                "name": "minimum_sugar",
                "format": "^[\d]+$",
                "required": False,
            },
            {
                "name": "maximum_sugar",
                "format": "^[\d]+$",
                "required": False,
            },
            {
                "name": "hypo",
                "format": "^[\d]+$",
                "required": False,

            },
            {
                "name": "hyper",
                "format": "^[\d]+$",
                "required": False,
            },
            {
                "name": "insulin_short_effect_code",
                "format": "^[-+]?[\d]+$",
                "errorMessage": "کد انسولین کوتاه اثر را به صورت یک عدد صحیح وارد کنید",
                "required": False,
            },
            {
                "name": "insulin_long_effect_code",
                "format": "^[-+]?[\d]+$",
                "errorMessage": "کد انسولین بلند اثر را به صورت یک عدد صحیح وارد کنید",
                "required": False,
            },
            {
                "name": "insulin_mixed_effect_code",
                "format": "^[-+]?[\d]+$",
                "errorMessage": "کد انسولین از پیش ترکیب را به صورت یک عدد صحیح وارد کنید",
                "required": False
            },
            {
                "name": "glp1_code",
                "format": "^[-+]?[\d]+$",
                "errorMessage": "کد glp1 را به صورت یک عدد صحیح وارد کنید",
                "required": False
            },
            {
                "name": "insulin_sensitivity",
                "format": "^[\d]+$",
                "errorMessage": "حساسیت به انسولین را به صورت یک عدد صحیح وارد کنید",
                "required": False,
            },
            {
                "name": "type_of_treatment",
                "format": "^[0123]+$",
                "errorMessage": "نوع درمان را به صورت یک عدد صحیح 0 , 1 , 2  و یا ترکیب این ارقام وارد کنید"
            },
            {
                "name": "pills",
                "format": "^(\S)+$",
                "errorMessage": "قرص ها را به صورت یک رشته از کد ها که مابین آن ها & است، وارد کنید",
                "required": False,

            },
            {
                "name": "activity_level",
                "format": "^[0-9]+\.?[0-9]+$",
                "errorMessage": "سطح فعالیت را به صورت یک عدد اعشاری بین 1 تا 2 وارد کنید"
            },
            {
                "name": "gender",
                "format": "^[01]+$",
                "errorMessage": "جنسیت را به صورت یک عدد صحیح وارد کنید برای مرد ها 1 و برای زن ها 0"
            },
            {
                "name": "carb_rate",
                "format": "^[0-9]+\.?[0-9]+$",
                "errorMessage": "carb_rate میتواند یک عدد اعشاری یا صحیح باشد",
                "required": False,
            },
            {
                "name": "a1c",
                "format": ".",
                "errorMessage": "a1c میتواند یک عدد اعشاری یا صحیح باشد",
                "required": False,
            },
            {
                "name": "user_setting",
                "format": ".",
                "errorMessage": "user_setting",
                "required": False,
            },
            {
                "name": "device_type",
                "format": ".",
                "errorMessage": "insert string for device_type",
                "required": False
            },
            {
                "name": "avatar",
                "format": "^[\d]+$",
                "required": False
            },
            {
                "name": "email",
                "format": "",
                "required": False,
            },
            {
                "name": "market",
                "format": "",
                "required": False,
            },
            {
                "name": "intro_code",
                "format": ".",
                "required": False
            },
            {
                "name": "latitude ",
                "format": ".",
                "errorMessage": "insert string for latitude",
                "required": False
            },
            {
                "name": "longitude",
                "format": ".",
                "required": False
            },
            {
                "name": "address",
                "format": ".",
                "required": False
            },
            {
                "name": "hospital_api_key",
                "format": ".",
                "errorMessage": "insert hospital API key for tracking user origin",
                "required": False,
            },
            {
                "name": "disease_list",
                "format": "^(\S)+$",
                "errorMessage": "بیماری ها را به صورت یک رشته از کد ها که مابین آن ها & است، وارد کنید",
                "required": False,
            },

        ], request)

        token = request.POST["token"]
        # phone = request.POST["phone_number"]
        # u = User.objects.filter(token=token, phone_number=phone)
        u = User.objects.filter(token=token)
        if not u.exists():
            writeErrorToLog("profile_info ---> POST\n" + "Token: " + token + ": " + Errors.InvalidToken.message,
                            request)
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
        user = u[0]

        if user.profile is None:
            p = Profile()
            # set default value
            p.minimum_sugar = 70
            p.maximum_sugar = 180
            p.hyper = 240
            p.hypo = 70

            p.save()
            user.profile = p
            user.profile.save()
            user.save()

        if not (request.POST.get("first_name") is None):
            first_name = str(request.POST.get("first_name"))
            if len(first_name) < 1:
                writeErrorToLog(
                    "profile_info ---> POST\n" + "Token: " + token + ": " + Errors.InvalidFirstName.message,
                    request)
                return myResponse.Error(Errors.InvalidFirstName.message, Errors.InvalidFirstName.code)
            user.profile.first_name = first_name
            user.django_user.first_name = first_name

        if not (request.POST.get("last_name") is None):
            last_name = str(request.POST.get("last_name"))
            if len(last_name) < 1:
                writeErrorToLog(
                    "profile_info ---> POST\n" + "Token: " + token + ": " + Errors.InvalidLastName.message, request)
                return myResponse.Error(Errors.InvalidLastName.message, Errors.InvalidLastName.code)
            user.profile.last_name = last_name
            user.django_user.last_name = last_name

        if not (request.POST.get("hypo") is None):
            hypo = int(request.POST["hypo"])
            user.profile.hypo = hypo

        if not (request.POST.get("hyper") is None):
            hyper = int(request.POST["hyper"])
            user.profile.hyper = hyper

        if not (request.POST.get("minimum_sugar") is None):
            minimum_sugar = int(request.POST["minimum_sugar"])
            user.profile.minimum_sugar = minimum_sugar

        if not (request.POST.get("maximum_sugar") is None):
            maximum_sugar = int(request.POST["maximum_sugar"])
            user.profile.maximum_sugar = maximum_sugar

        if not (request.POST.get("user_setting") is None):
            user_setting = str(request.POST["user_setting"])
            user.profile.user_setting = user_setting

        gender = bool(int(request.POST["gender"]))
        birth_date = int(request.POST.get("birth_date"))
        bd = datetime.fromtimestamp(birth_date)
        weight = float(request.POST["weight"])
        height = int(request.POST["height"])
        diabetes_type = int(request.POST["diabetes_type"])
        detection_year = int(request.POST["detection_year"])

        if not (request.POST.get("insulin_short_effect_code") is None):
            insulin_short_effect_code = int(request.POST["insulin_short_effect_code"])
            if insulin_short_effect_code == -1:
                insulin_short_effect = None
            else:
                i1 = Insulin.objects.filter(Data_Base_Number=insulin_short_effect_code)
                if not i1.exists():
                    writeErrorToLog(
                        "profile_info ---> POST\n" + "Token: " + token + ": " + Errors.InvalidInsulinId.message,
                        request)
                    return myResponse.Error(Errors.InvalidInsulinId.message, Errors.InvalidInsulinId.code)
                else:
                    insulin_short_effect = i1[0]
                if user.profile.insulin_short_effect is not None:
                    selections = InsulinTypeSelection.objects.filter(user=user, end=None, insulin__EffectType=1)
                    if selections.exists():
                        last_type_selection = selections[0]
                        last_type_selection.finish()
                    insulin_type_selection = InsulinTypeSelection(insulin=insulin_short_effect, user=user)
                    insulin_type_selection.save()
            user.profile.insulin_short_effect = insulin_short_effect

        if not (request.POST.get("insulin_long_effect_code") is None):
            insulin_long_effect_code = int(request.POST["insulin_long_effect_code"])
            if insulin_long_effect_code == -1:
                insulin_long_effect = None
            else:
                i2 = Insulin.objects.filter(Data_Base_Number=insulin_long_effect_code)
                if not i2.exists():
                    writeErrorToLog(
                        "profile_info ---> POST\n" + "Token: " + token + ": " + Errors.InvalidInsulinId.message,
                        request)
                    return myResponse.Error(Errors.InvalidInsulinId.message, Errors.InvalidInsulinId.code)
                else:
                    insulin_long_effect = i2[0]
                if user.profile.insulin_long_effect is not None:
                    selections = InsulinTypeSelection.objects.filter(user=user, end=None, insulin__EffectType=2)
                    if selections.exists():
                        last_type_selection = selections[0]
                        last_type_selection.finish()
                    insulin_type_selection = InsulinTypeSelection(insulin=insulin_long_effect, user=user)
                    insulin_type_selection.save()
            user.profile.insulin_long_effect = insulin_long_effect

        if not (request.POST.get("insulin_sensitivity") is None):
            insulin_sensitivity = int(request.POST["insulin_sensitivity"])
            user.profile.insulin_sensitivity = insulin_sensitivity

        if not (request.POST.get("pills") is None):
            pills = str(request.POST["pills"])
            user.profile.pills = pills

        if not (request.POST.get("disease_list") is None):
            disease_list = str(request.POST["disease_list"])
            user.profile._diseases = disease_list

        if not (request.POST.get("activity_level") is None):
            try:
                activity_level = float(request.POST["activity_level"])
                user.profile.activity_level = activity_level
            except Exception as e:
                print(e)
                user.profile.activity_level = 1.25
        else:
            user.profile.activity_level = 1.25

        if not (request.POST.get("carb_rate") is None):
            carb_rate = float(request.POST["carb_rate"])
            user.profile.Carb_rate = carb_rate

        if not (request.POST.get("a1c") is None):
            user.profile.a1c = float(request.POST["a1c"])

        if not (request.POST.get("glp1_code") == None):
            glp1_code = int(request.POST["glp1_code"])
            if glp1_code == -1:
                user.profile.glp1_id = None
            else:
                temp = GLP1.objects.filter(DataBaseNumber=glp1_code)
                if not temp.exists():
                    writeErrorToLog(
                        "profile_info ---> POST\n" + "Token: " + token + ": " + Errors.InvalidGLP1Id.message,
                        request)
                    return myResponse.Error(Errors.InvalidGLP1Id.message, Errors.InvalidGLP1Id.code)
                else:
                    glp1 = temp[0]
                    user.profile.glp1_id = glp1.id

        if not (request.POST.get("insulin_mixed_effect_code") == None):
            insulin_mixed_effect_code = int(request.POST["insulin_mixed_effect_code"])
            if insulin_mixed_effect_code == -1:
                user.profile.insulin_mixed_effect = None
            else:
                temp = Insulin.objects.filter(Data_Base_Number=insulin_mixed_effect_code)
                if not temp.exists():
                    writeErrorToLog(
                        "profile_info ---> POST\n" + "Token: " + token + ": " + Errors.InvalidInsulinId.message,
                        request)
                    return myResponse.Error(Errors.InvalidInsulinId.message, Errors.InvalidInsulinId.code)
                else:
                    insilin = temp[0]
                    user.profile.insulin_mixed_effect = insilin

        if not (request.POST.get("device_type") is None):
            device_type = str(request.POST.get("device_type"))
            if len(device_type) < 2:
                writeErrorToLog(
                    "profile_info ---> POST\n" + "Token: " + token + ": " + Errors.InvalidLastName.message, request)
                return myResponse.Error(Errors.InvalidLastName.message, Errors.InvalidLastName.code)
            user.profile.device_type = device_type

        if not (request.POST.get("email") is None):
            email = str(request.POST.get("email"))
            if not (email == ""):
                user.profile.email = email

        if not (request.POST.get("market") is None):
            market = str(request.POST.get("market"))
            if not (market == ""):
                user.profile.market = market

        if not (request.POST.get("hospital_api_key") is None):
            hospital_api_key = str(request.POST.get("hospital_api_key"))
            if not (hospital_api_key == ""):
                # Lookup hospital code from the API key using the Hospital model
                try:
                    hospital = Hospital.objects.get(api_key=hospital_api_key, is_active=True)
                    user.profile.hospital_code = hospital.hospital_code
                    print(f"User {user.phone_number} assigned to hospital: {hospital.name} ({hospital.hospital_code})")
                except Hospital.DoesNotExist:
                    # Fallback to old hardcoded HOSPITAL_INFO for backward compatibility
                    if hospital_api_key in HOSPITAL_INFO:
                        hospital_code = HOSPITAL_INFO[hospital_api_key]["code"]
                        user.profile.hospital_code = hospital_code
                        print(f"User {user.phone_number} assigned to hospital using legacy config: {hospital_code}")
                    else:
                        # If API key not found in either database or configuration, log error but don't fail the request
                        writeErrorToLog(
                            f"profile_info ---> POST\n" + "Token: " + token + ": Invalid hospital API key: " + hospital_api_key, 
                            request)
                        print(f"Invalid hospital API key: {hospital_api_key}")
                except Exception as e:
                    # Log any other errors but don't fail the request
                    writeErrorToLog(
                        f"profile_info ---> POST\n" + "Token: " + token + ": Error looking up hospital: " + str(e), 
                        request)
                    print(f"Error looking up hospital: {str(e)}")

        if not (request.POST.get("avatar") is None):
            avatar = int(request.POST.get("avatar"))
            user.profile.avatar = avatar

        if not (request.POST.get("intro_code") is None):
            if (user.profile.user_code == None) and (
            not (user.phone_number == "09999999999")):  # dont set for test user "09999999999"
                user_code = getIntroCode()
                user.profile.register_time = datetime.now()
                user.profile.user_code = user_code
                user.profile.save()
            elif (not (user.profile.user_code is None)) and (not (user.phone_number == "09999999999")):
                user_code = getIntroCode()
                user.profile.register_time = datetime.now()
                user.profile.user_code = user_code
                user.profile.save()

            if (user.profile.intro_code is None) or (user.profile.intro_code is ""):
                intro_code = str(request.POST.get("intro_code")).lower()
                intro_profs = Profile.objects.filter(user_code=intro_code)
                if intro_profs.exists():
                    intro_prof = intro_profs[0]
                    sub_users = intro_prof.sub_users
                    if sub_users is None:
                        sub_users = "&"
                    if sub_users.count("&" + user.profile.user_code + "&") > 0:
                        pass
                        # return myResponse.Error(Errors.Already_Selected.message, Errors.Already_Selected.code)
                    else:
                        sub_users_list = getSubUserList(sub_users)
                        sub_users_list.append(user.profile.user_code)
                        intro_prof.sub_users = listToStr(sub_users_list)
                        intro_prof.save()
                        user.profile.intro_code = intro_code

        if (not (request.POST.get("latitude") is None)) and \
                (not (request.POST.get("longitude") is None)):
            if user.profile.address is None:
                address = Address()
                user.profile.address = address
                user.profile.address.save()
            user.profile.address.latitude = float(request.POST.get('latitude'))
            user.profile.address.longitude = float(request.POST.get('longitude'))
            user.profile.address.save()

        if not (request.POST.get("address") is None):
            if user.profile.address is None:
                address = Address()
                user.profile.address = address
                user.profile.address.save()
            user.profile.address.address = float(request.POST.get('address'))
            user.profile.address.save()

        # if intro_code not set
        if (user.profile.user_code == None) and (
        not (user.phone_number == "09999999999")):  # dont set for test user "09999999999"
            user_code = getIntroCode()
            user.profile.register_time = datetime.now()
            user.profile.user_code = user_code
        elif (not (user.profile.user_code is None)) and (not (user.phone_number == "09999999999")):
            user_code = getIntroCode()
            user.profile.register_time = datetime.now()
            user.profile.user_code = user_code

        send_message = False
        if (user.profile.weight == 0 or user.profile.weight == 1) and (
        not (user.phone_number == "09999999999")):  # test user --> 0999..
            send_message = True

        type_of_treatment = int(request.POST["type_of_treatment"])

        user.profile.birth_date = bd
        user.profile.weight = weight
        user.profile.height = height
        if diabetes_type == 3:
            user.profile.diabetes_type = 0
        else:
            user.profile.diabetes_type = diabetes_type
        user.profile.detection_year = detection_year

        user.profile.activity_level = activity_level

        user.profile.type_of_treatment = int(type_of_treatment)
        user.profile.gender = gender

        data = user.calculate_cr_macro_nutrients_distribution()

        user.profile.CR = data["CR"]
        user.profile.BMR = data["BMR"]
        user.profile.Carbohydrates_g = data["macro_nutrients"]["carbohydrates_g"]
        user.profile.Carbohydrates_unit = data["macro_nutrients"]["carbohydrates_unit"]
        user.profile.Protein_g = data["macro_nutrients"]["protein_g"]
        user.profile.Protein_unit = data["macro_nutrients"]["protein_unit"]
        user.profile.Fat_g = data["macro_nutrients"]["fat_g"]
        user.profile.Fat_unit = data["macro_nutrients"]["fat_unit"]
        Carbohydrates_distribution_list_g = listToStr(data["carbohydrate_distribution_g"])
        user.profile.Carbohydrates_distribution_list_g = Carbohydrates_distribution_list_g

        user.profile.Protein_distribution_g = data["protein_distribution_g"]
        user.profile.Fat_distribution_g = data["fat_distribution_g"]
        user.profile.weight_state = data["weight_state"]
        user.profile.goal_weight = data["IBW"]
        user.isRegistered = 1

        user.profile.save()

        user.isRegistered = True
        user.save()

        result = {}
        result["weight_state"] = data["weight_state"]
        result["IBW"] = data["IBW"]


        data = {'from': '50002710089184', 'to': user.phone_number, 'text': f'{first_name} عزیز به لاکتو خوش آمدی! 🎉 \n\nاولین جلسه مشاوره با متخصص تغذیه، هدیه ما به شماست. بدون نیاز به پرداخت، اولین قدم برای سلامتی‌ات رو بردار. \n\nهمین الان وارد اپ شو و زمان جلسه رایگان خودت رو رزرو کن!'}
        response = requests.post('https://console.melipayamak.com/api/send/simple/7b4e26f2301d405f925498b37bd09ef5', json=data)

        return myResponse.OK("پروفایل ساخته شد", result)
        # except ValueError as e:
        #     writeErrorToLog("profile_info ---> POST\n" + str(e.args), request)
        #     return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        # except Exception as e:
        #     writeErrorToLog("profile_info ---> POST\n" + str(e.args), request)
        #     return myResponse.Error(str(e), Errors.InvalidArgument.code)
    else:
        try:
            RequsetChecker(request.GET, [
                {
                    "name": "token",
                    "format": "^(\S){30}$"
                },
                # {
                #     "name": "phone_number",
                #     "format": "^09[0-9]{9}$"
                # }
            ], request)
            token = request.GET["token"]
            # phone = request.POST["phone_number"]
            # u = User.objects.filter(token=token, phone_number=phone)
            u = User.objects.filter(token=token)
            if not u.exists():
                writeErrorToLog("profile_info ---> GET\n" + "Token: " + token + ": " + Errors.InvalidToken.message,
                                request)
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            profile = u[0].profile
            if profile is None:
                writeErrorToLog(
                    "profile_info ---> GET\n" + "Token: " + token + ": " + "اطلاعات کاربری هنوز ثبت نشده اند.", request)
                return myResponse.Error("اطلاعات کاربری هنوز ثبت نشده اند.", Errors.LogicalError.code)
            # first_name = profile.first_name
            # last_name = profile.last_name
            birth_date = int(profile.birth_date.timestamp())
            weight = profile.weight
            goal_weight = profile.goal_weight
            diabetes_type = profile.diabetes_type
            detection_year = profile.detection_year
            minimum_sugar = profile.minimum_sugar
            maximum_sugar = profile.maximum_sugar
            hypo = profile.hypo
            hyper = profile.hyper
            height = profile.height
            email = profile.email
            user_code = profile.user_code
            avatar = profile.avatar
            diseases_list = profile.diseases
            hospital_code = profile.hospital_code

            insulin_short_effect_code = -1
            insulin_long_effect_code = -1
            insulin_mixed_effect_code = -1

            if profile.insulin_short_effect is None:
                insulin_short_effect = "نا مشخص"
            else:
                insulin_short_effect = profile.insulin_short_effect.name
                insulin_short_effect_code = profile.insulin_short_effect.Data_Base_Number

            if profile.insulin_long_effect is None:
                insulin_long_effect = "نا مشخص"
            else:
                insulin_long_effect = profile.insulin_long_effect.name
                insulin_long_effect_code = profile.insulin_long_effect.Data_Base_Number

            if profile.insulin_mixed_effect is None:
                insulin_mixed_effect = "نا مشخص"
            else:
                insulin_mixed_effect = profile.insulin_mixed_effect.name
                insulin_mixed_effect_code = profile.insulin_mixed_effect.Data_Base_Number

            if profile.glp1 is None:
                glp1 = "نا مشخص"
                glp1_code = -1
            else:
                glp1 = profile.glp1.name
                glp1_code = profile.glp1.DataBaseNumber

            pills_code = profile.pills.split("&")
            pills = []
            for i in range(len(pills_code)):
                if not (pills_code[i] is ''):
                    dd = Drug.objects.filter(id=int(pills_code[i]))
                    if dd.exists():
                        pills.append(dd[0].name)
            insulin_sensitivity = profile.insulin_sensitivity
            type_of_treatment = profile.type_of_treatment
            user_setting = profile.user_setting
            weight_state = profile.weight_state
            activity_level = profile.activity_level
            gender = int(profile.gender)
            carb_rate = float(profile.Carb_rate)
            CR = profile.CR
            BMR = profile.BMR
            IBW = profile.goal_weight

            Carbohydrates_g = profile.Carbohydrates_g
            Protein_g = profile.Protein_g
            Fat_g = profile.Fat_g
            Carbohydrates_unit = profile.Carbohydrates_unit
            Protein_unit = profile.Protein_unit
            Fat_unit = profile.Fat_unit
            Carbohydrates_distribution_list_g = profile.Carbohydrates_distribution_list_g
            Protein_distribution_g = profile.Protein_distribution_g
            Fat_distribution_g = profile.Fat_distribution_g
            a1c = profile.a1c
            if (profile.image is None) or (profile.image == ''):
                image_url = ""
            else:
                image_url = profile.image.url

            data = {
                "first_name": profile.first_name,
                "last_name": profile.last_name,
                "birth_date": birth_date,
                "weight": weight,
                "goal_weight": goal_weight,
                "height": height,
                "diabetes_type": diabetes_type,
                "detection_year": detection_year,
                "minimum_sugar": minimum_sugar,
                "maximum_sugar": maximum_sugar,
                "hypo": hypo,
                "hyper": hyper,
                "insulin_short_effect": insulin_short_effect,
                "insulin_long_effect": insulin_long_effect,
                "insulin_mixed_effect": insulin_mixed_effect,
                "insulin_short_effect_code": insulin_short_effect_code,
                "insulin_long_effect_code": insulin_long_effect_code,
                "insulin_mixed_effect_code": insulin_mixed_effect_code,
                "glp1": glp1,
                "glp1_code": glp1_code,
                "insulin_sensitivity": insulin_sensitivity,
                "pills": pills,
                "type_of_treatment": type_of_treatment,
                "user_setting": user_setting,
                "weight_state": weight_state,
                "activity_level": activity_level,
                "gender": gender,
                "CR": CR,
                "BMR": BMR,
                "IBW": IBW,
                "carb_rate": carb_rate,
                "a1c": a1c,
                "email": email,
                "user_code": user_code,
                "avatar": avatar,
                "diseases_list": diseases_list,
                "hospital_code": hospital_code,
                "image": image_url,

                "Carbohydrates_g": Carbohydrates_g,
                "Protein_g": Protein_g,
                "Fat_g": Fat_g,
                "Carbohydrates_unit": Carbohydrates_unit,
                "Protein_unit": Protein_unit,
                "Fat_unit": Fat_unit,
                "Carbohydrates_distribution_list_g": getList(Carbohydrates_distribution_list_g),
                "Protein_distribution_g": Protein_distribution_g,
                "Fat_distribution_g": Fat_distribution_g,
                "jalali_birth_date": str(jdatetime.date.fromgregorian(date=profile.birth_date.date()))

            }

            return myResponse.OK("اطلاعات کاربری", data)
        except ValueError as e:
            writeErrorToLog("profile_info ---> GET\n" + str(e.args), request)
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            writeErrorToLog("profile_info ---> GET\n" + str(e.args), request)
            return myResponse.Error(str(e.args), Errors.InvalidArgument.code)


@api_view(["POST"])
def profile_info_update(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$"
            },
            # {
            #     "name": "phone_number",
            #     "format": "^09[0-9]{9}$"
            # },
            {
                "name": "insulin_short_effect_code",
                "format": "^[-+]?[\d]+$",
                "errorMessage": "کد انسولین کوتاه اثر را به صورت یک عدد صحیح وارد کنید",
                "required": False
            },
            {
                "name": "insulin_long_effect_code",
                "format": "^[-+]?[\d]+$",
                "errorMessage": "کد انسولین بلند اثر را به صورت یک عدد صحیح وارد کنید",
                "required": False
            },
            {
                "name": "insulin_mixed_effect_code",
                "format": "^[-+]?[\d]+$",
                "errorMessage": "کد انسولین از پیش ترکیب را به صورت یک عدد صحیح وارد کنید",
                "required": False
            },
            {
                "name": "insulin_sensitivity",
                "format": "^[\d]+$",
                "errorMessage": "حساسیت به انسولین را به صورت یک عدد صحیح وارد کنید",
                "required": False
            },
            {
                "name": "pills",
                "format": "^(\S)+$",
                "errorMessage": "قرص ها را به صورت یک رشته از کد ها که مابین آن ها & است، وارد کنید",
                "required": False
            },
            {
                "name": "carb_rate",
                "format": "^[0-9]+\.?[0-9]+$",
                "errorMessage": "carb_rate میتواند یک عدد اعشاری یا صحیح باشد",
                "required": False
            },
            {
                "name": "a1c",
                "format": ".",
                "errorMessage": "a1c میتواند یک عدد اعشاری یا صحیح باشد",
                "required": False,
            },
            {
                "name": "glp1_code",
                "format": "^[-+]?[\d]+$",
                "errorMessage": "carb_rate میتواند یک عدد اعشاری یا صحیح باشد",
                "required": False
            },
            {
                "name": "doctor_id",
                "format": "^[\d]+$",
                "errorMessage": "کد دکتر را به صورت یک عدد صحیح وارد  کنید",
                "required": False
            },
            {
                "name": "first_name",
                "format": ".",
                "errorMessage": "insert string first_name",
                "required": False
            },
            {
                "name": "last_name",
                "format": ".",
                "errorMessage": "insert string last_name",
                "required": False
            },
            {
                "name": "device_type",
                "format": ".",
                "errorMessage": "insert string for device_type",
                "required": False
            },
            {
                "name": "version",
                "format": ".",
                "errorMessage": "insert string for version",
                "required": False
            },
            {
                "name": "email",
                "format": "",
                "required": False
            },
            {
                "name": "intro_code",
                "format": "^(\S){5}$",
                "required": False
            },
            {
                "name": "detection_year",
                "format": "^[\d]+$",
                "required": False
            },
            {
                "name": "avatar",
                "format": "^[\d]+$",
                "required": False
            },
            {
                "name": "birth_date",
                "format": "^[-+]?[0-9]+$",  # timestamp
                "required": False,
                "errorMessage": "تاریخ تولد اشتباه وارد شده است"
            },
            {
                "name": "weight",
                "format": "^[0-9]+\.?[0-9]+$",
                "errorMessage": "وزن را به صورت یک عدد فلوت وارد کنید",
                "required": False

            },
            {
                "name": "height",
                "format": "^[\d]+$",
                "required": False
            },
            {
                "name": "hypo",
                "format": "^[\d]+$",
                "required": False
            },
            {
                "name": "hyper",
                "format": "^[\d]+$",
                "required": False
            },
            {
                "name": "minimum_sugar",
                "format": "^[\d]+$",
                "required": False
            },
            {
                "name": "maximum_sugar",
                "format": "^[\d]+$",
                "required": False
            },
            {
                "name": "activity_level",
                "format": "^[0-9]+\.?[0-9]+$",
                "required": False
            },
            {
                "name": "diabetes_type",
                "format": "^[\d]+$",
                "required": False
            },
            {
                "name": "type_of_treatment",
                "format": "^[0123]+$",
                "errorMessage": "نوع درمان را به صورت یک عدد صحیح 0 , 1 , 2  و یا ترکیب این ارقام وارد کنید",
                "required": False
            },
            {
                "name": "market",
                "format": "",
                "required": False,
            },
            {
                "name": "firebase_token",
                "format": ".",
                "required": False
            },
            {
                "name": "latitude ",
                "format": ".",
                "required": False
            },
            {
                "name": "longitude",
                "format": ".",
                "required": False
            },
            {
                "name": "address",
                "format": ".",
                "required": False
            },
            {
                "name": "diseases",
                "format": "^(\S)+$",
                "errorMessage": "کد بیماری بین 0 تا 8 باشد و بین هر عدد & قرار بگیرد.",
                "required": False
            },

        ], request)

        token = request.POST["token"]
        # phone = request.POST["phone_number"]
        # u = User.objects.filter(token=token, phone_number=phone)
        u = User.objects.filter(token=token)
        if not u.exists():
            writeErrorToLog("profile_info_update ---> POST\n" + "Token: " + token + ": " + Errors.InvalidToken.message,
                            request)
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
        user = u[0]
        if user.profile is None:
            p = Profile()
            p.save()
            user.profile = p
            user.profile.save()
            user.save()

        updated_params = []
        essential_flag = False

        if not (request.POST.get("insulin_short_effect_code") is None):
            insulin_short_effect_code = int(request.POST["insulin_short_effect_code"])
            if insulin_short_effect_code == -1:
                insulin_short_effect = None
            else:
                i1 = Insulin.objects.filter(Data_Base_Number=insulin_short_effect_code)
                if not i1.exists():
                    writeErrorToLog(
                        "profile_info_update ---> POST\n" + "Token: " + token + ": " + Errors.InvalidInsulinId.message,
                        request)
                    return myResponse.Error(Errors.InvalidInsulinId.message, Errors.InvalidInsulinId.code)
                else:
                    insulin_short_effect = i1[0]
                if user.profile.insulin_short_effect is not None:
                    selections = InsulinTypeSelection.objects.filter(user=user, end=None, insulin__EffectType=1)
                    if selections.exists():
                        last_type_selection = selections[0]
                        last_type_selection.finish()
                    insulin_type_selection = InsulinTypeSelection(insulin=insulin_short_effect, user=user)
                    insulin_type_selection.save()
            updated_params.append("insulin_short_effect_code")
            user.profile.insulin_short_effect = insulin_short_effect

        if not (request.POST.get("insulin_long_effect_code") is None):
            insulin_long_effect_code = request.POST.get("insulin_long_effect_code")
            if insulin_long_effect_code == -1:
                insulin_long_effect = None
            else:
                i2 = Insulin.objects.filter(Data_Base_Number=insulin_long_effect_code)
                if not i2.exists():
                    writeErrorToLog(
                        "profile_info_update ---> POST\n" + "Token: " + token + ": " + Errors.InvalidInsulinId.message,
                        request)
                    return myResponse.Error(Errors.InvalidInsulinId.message, Errors.InvalidInsulinId.code)
                else:
                    insulin_long_effect = i2[0]
                if user.profile.insulin_long_effect is not None:
                    selections = InsulinTypeSelection.objects.filter(user=user, end=None, insulin__EffectType=2)
                    if selections.exists():
                        last_type_selection = selections[0]
                        last_type_selection.finish()
                    insulin_type_selection = InsulinTypeSelection(insulin=insulin_long_effect, user=user)
                    insulin_type_selection.save()
            updated_params.append("insulin_long_effect")
            user.profile.insulin_long_effect = insulin_long_effect

        if not (request.POST.get("insulin_mixed_effect_code") is None):
            insulin_mixed_effect_code = request.POST.get("insulin_mixed_effect_code")
            if insulin_mixed_effect_code == -1:
                insulin_mixed_effect = None
            else:
                i3 = Insulin.objects.filter(Data_Base_Number=insulin_mixed_effect_code)
                if not i3.exists():
                    writeErrorToLog(
                        "profile_info_update ---> POST\n" + "Token: " + token + ": " + Errors.InvalidInsulinId.message,
                        request)
                    return myResponse.Error(Errors.InvalidInsulinId.message, Errors.InvalidInsulinId.code)
                else:
                    insulin_long_effect = i3[0]
            updated_params.append("insulin_mixed_effect")
            user.profile.insulin_mixed_effect = insulin_long_effect

        if not (request.POST.get("insulin_sensitivity") is None):
            updated_params.append("insulin_sensitivity")
            user.profile.insulin_sensitivity = int(request.POST["insulin_sensitivity"])

        if not (request.POST.get("pills") is None):
            updated_params.append("pills")
            user.profile.pills = str(request.POST["pills"])

        if not (request.POST.get("detection_year") is None):
            updated_params.append("detection_year")
            user.profile.detection_year = int(request.POST["detection_year"])

        if not (request.POST.get("carb_rate") is None):
            updated_params.append("carb_rate")
            user.profile.Carb_rate = float(request.POST["carb_rate"])

        if not (request.POST.get("a1c") is None):
            updated_params.append("a1c")
            user.profile.a1c = float(request.POST["a1c"])

        if not (request.POST.get("glp1_code") is None):
            updated_params.append("glp1")
            temp = GLP1.objects.filter(DataBaseNumber=int(request.POST.get("glp1_code")))
            if temp.exists():
                glp1 = temp[0]
                user.profile.glp1_id = glp1.id
            else:
                writeErrorToLog(
                    "profile_info_update ---> POST\n" + "Token: " + token + ": " + Errors.InvalidGLP1Id.message,
                    request)
                return myResponse.Error(Errors.InvalidGLP1Id.message, Errors.InvalidGLP1Id.code)

        if not (request.POST.get("doctor_id") is None):
            if not (user.profile.doctor == None):
                updated_params.append("doctor_id")
                temp = Doctor.objects.filter(id=int(request.POST.get("doctor_id")))
                if temp.exists():
                    doctor = temp[0]
                    user.profile.doctor = doctor
                else:
                    writeErrorToLog(
                        "profile_info_update ---> POST\n" + "Token: " + token + ": " + Errors.NotFoundDoctor.message,
                        request)
                    return myResponse.Error(Errors.NotFoundDoctor.message, Errors.NotFoundDoctor.code)

        if not (request.POST.get("first_name") is None):
            first_name = str(request.POST.get("first_name"))
            if len(first_name) < 2:
                writeErrorToLog(
                    "profile_info_update ---> POST\n" + "Token: " + token + ": " + Errors.InvalidFirstName.message,
                    request)
                return myResponse.Error(Errors.InvalidFirstName.message, Errors.InvalidFirstName.code)
            user.profile.first_name = first_name
            user.django_user.first_name = first_name
            updated_params.append("first_name")

        if not (request.POST.get("last_name") is None):
            last_name = str(request.POST.get("last_name"))
            if len(last_name) < 2:
                writeErrorToLog(
                    "profile_info_update ---> POST\n" + "Token: " + token + ": " + Errors.InvalidLastName.message,
                    request)
                return myResponse.Error(Errors.InvalidLastName.message, Errors.InvalidLastName.code)
            user.profile.last_name = last_name
            user.django_user.last_name = last_name
            updated_params.append("last_name")

        if not (request.POST.get("device_type") is None):
            device_type = str(request.POST.get("device_type"))
            if len(device_type) < 2:
                writeErrorToLog(
                    "profile_info_update ---> POST\n" + "Token: " + token + ": " + Errors.InvalidDevice_type.message,
                    request)
                return myResponse.Error(Errors.InvalidDevice_type.message, Errors.InvalidDevice_type.code)
            user.profile.device_type = device_type
            updated_params.append("device_type")

        if not (request.POST.get("version") is None):
            version = str(request.POST.get("version"))
            if len(version) < 2:
                writeErrorToLog(
                    "profile_info_update ---> POST\n" + "Token: " + token + ": " + Errors.InvalidVersion.message,
                    request)
                return myResponse.Error(Errors.InvalidVersion.message, Errors.InvalidVersion.code)
            user.profile.version = version
            updated_params.append("version")

        if not (request.POST.get("market") is None):
            market = str(request.POST.get("market"))
            if not (market == ""):
                user.profile.market = market
                updated_params.append("market")

        if not (request.POST.get("email") is None):
            email = str(request.POST.get("email"))
            if not (email == ""):
                user.profile.email = email
                updated_params.append("email")

        if not (request.POST.get("avatar") is None):
            avatar = int(request.POST.get("avatar"))
            user.profile.avatar = avatar
            updated_params.append("avatar")

        if not (request.POST.get("hypo") is None):
            hypo = int(request.POST.get("hypo"))
            user.profile.hypo = hypo
            updated_params.append("hypo")

        if not (request.POST.get("hyper") is None):
            hyper = int(request.POST.get("hyper"))
            user.profile.hyper = hyper
            updated_params.append("hyper")

        if not (request.POST.get("maximum_sugar") is None):
            maximum_sugar = int(request.POST.get("maximum_sugar"))
            user.profile.maximum_sugar = maximum_sugar
            updated_params.append("maximum_sugar")

        if not (request.POST.get("minimum_sugar") is None):
            minimum_sugar = int(request.POST.get("minimum_sugar"))
            user.profile.minimum_sugar = minimum_sugar
            updated_params.append("minimum_sugar")

        if not (request.POST.get("diabetes_type") is None):
            diabetes_type = int(request.POST.get("diabetes_type"))
            user.profile.diabetes_type = diabetes_type
            updated_params.append("diabetes_type")

        if not (request.POST.get("activity_level") is None):
            activity_level = float(request.POST.get("activity_level"))
            user.profile.activity_level = activity_level
            updated_params.append("activity_level")
            essential_flag = True

        if not (request.POST.get("birth_date") is None):
            birth_date = int(request.POST.get("birth_date"))
            bd = datetime.fromtimestamp(birth_date)
            user.profile.birth_date = bd
            updated_params.append("birth_date")
            essential_flag = True

        if not (request.POST.get("weight") is None):
            weight = float(request.POST["weight"])
            user.profile.weight = weight
            updated_params.append("weight")
            essential_flag = True

        if not (request.POST.get("height") is None):
            height = int(request.POST["height"])
            user.profile.height = height
            updated_params.append("height")
            essential_flag = True

        if not (request.POST.get("type_of_treatment") is None):
            type_of_treatment = int(request.POST["type_of_treatment"])
            user.profile.type_of_treatment = type_of_treatment
            updated_params.append("type_of_treatment")
            essential_flag = True

        if not (request.POST.get("firebase_token") is None):
            firebase_token = str(request.POST["firebase_token"])
            user.profile.firebase_token = firebase_token
            updated_params.append("firebase_token")

        if (not (request.POST.get("latitude") is None)) and \
                (not (request.POST.get("longitude") is None)):
            if user.profile.address is None:
                address = Address()
                user.profile.address = address
                user.profile.address.save()
            user.profile.address.latitude = float(request.POST.get('latitude'))
            user.profile.address.longitude = float(request.POST.get('longitude'))
            user.profile.address.save()
            updated_params.append("latitude")
            updated_params.append("longitude")

        if not (request.POST.get("address") is None):
            if user.profile.address is None:
                address = Address()
                user.profile.address = address
                user.profile.address.save()
            user.profile.address.address = float(request.POST.get('address'))
            user.profile.address.save()
            updated_params.append("address")

        if not (request.POST.get("diseases") is None):
            diseases = str(request.POST["diseases"])
            user.profile._diseases = diseases
            updated_params.append("diseases")

        user.profile.save()

        if essential_flag is True:
            data = user.calculate_cr_macro_nutrients_distribution()
            user.profile.CR = data["CR"]
            user.profile.BMR = data["BMR"]
            user.profile.Carbohydrates_g = data["macro_nutrients"]["carbohydrates_g"]
            user.profile.Carbohydrates_unit = data["macro_nutrients"]["carbohydrates_unit"]
            user.profile.Protein_g = data["macro_nutrients"]["protein_g"]
            user.profile.Protein_unit = data["macro_nutrients"]["protein_unit"]
            user.profile.Fat_g = data["macro_nutrients"]["fat_g"]
            user.profile.Fat_unit = data["macro_nutrients"]["fat_unit"]
            Carbohydrates_distribution_list_g = listToStr(data["carbohydrate_distribution_g"])
            user.profile.Carbohydrates_distribution_list_g = Carbohydrates_distribution_list_g

            user.profile.Protein_distribution_g = data["protein_distribution_g"]
            user.profile.Fat_distribution_g = data["fat_distribution_g"]
            user.profile.weight_state = data["weight_state"]
            user.profile.goal_weight = data["IBW"]

        user.profile.save()

        return myResponse.OK("بروزرسانی ها انجام شد", updated_params)
    except ValueError as e:
        writeErrorToLog("profile_info_update ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        writeErrorToLog("profile_info_update ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def send_profile_image(request):
    token = request.POST["token"]
    u = User.objects.filter(token=token)
    if not u.exists():
        writeErrorToLog("profile_info ---> POST\n" + "Token: " + token + ": " + Errors.InvalidToken.message, request)
        return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
    user = u[0]

    file = request.FILES["file"]
    extension = file.name.split(".")[-1]
    if extension == "blob":
        extension = 'mp3'
    hashed_name = generate_file_name(extension)
    path_from_media_root = "panel/profiles/patients/" + hashed_name
    try:
        with open(MEDIA_ROOT + "/" + path_from_media_root, 'wb+') as destination:
            for chunk in file.chunks():
                destination.write(chunk)
            destination.close()

        # file_size = os.path.getsize(MEDIA_ROOT + "/" + path_from_media_root)
        user.profile.image = "panel/profiles/patients/" + hashed_name
        user.profile.save()
        data = {
            "image": user.profile.image.url
        }
        return myResponse.OK("updated", data)
    except Exception as e:
        return myResponse.Error("error on saving the profile image")


@api_view(["POST"])
def update_weight(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$"
            },
            # {
            #     "name": "phone_number",
            #     "format": "^09[0-9]{9}$"
            # },
            {
                "name": "weight",
                "format": "^[0-9]+\.?[0-9]+$",
                "errorMessage": "وزن میتواند یک عدد اعشاری یا صحیح باشد",
                "required": True
            }
        ], request)

        token = request.POST["token"]
        # phone = request.POST["phone_number"]
        # u = User.objects.filter(token=token, phone_number=phone)
        u = User.objects.filter(token=token)
        if not u.exists():
            writeErrorToLog("update_weight ---> POST\n" + Errors.InvalidToken.message, request)
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
        user = u[0]
        if user.profile is None:
            writeErrorToLog("update_weight ---> POST\n" + Errors.NotFoundProfile.message, request)
            return myResponse.Error(Errors.NotFoundProfile.message, Errors.NotFoundProfile.code)

        new_Weight = float(request.POST.get("weight"))
        user.profile.weight = new_Weight
        user.profile.save()

        data = user.calculate_cr_macro_nutrients_distribution()

        user.profile.CR = data["CR"]
        user.profile.BMR = data["BMR"]
        user.profile.Carbohydrates_g = data["macro_nutrients"]["carbohydrates_g"]
        user.profile.Carbohydrates_unit = data["macro_nutrients"]["carbohydrates_unit"]
        user.profile.Protein_g = data["macro_nutrients"]["protein_g"]
        user.profile.Protein_unit = data["macro_nutrients"]["protein_unit"]
        user.profile.Fat_g = data["macro_nutrients"]["fat_g"]
        user.profile.Fat_unit = data["macro_nutrients"]["fat_unit"]
        Carbohydrates_distribution_list_g = listToStr(data["carbohydrate_distribution_g"])
        user.profile.Carbohydrates_distribution_list_g = Carbohydrates_distribution_list_g

        user.profile.Protein_distribution_g = data["protein_distribution_g"]
        user.profile.Fat_distribution_g = data["fat_distribution_g"]
        user.profile.weight_state = data["weight_state"]
        user.profile.goal_weight = data["IBW"]
        user.profile.weight = new_Weight
        user.profile.save()
        user.save()

        BMI = new_Weight / ((user.profile.height / 100) ** 2)
        w = Weights(user=user, weight=new_Weight, time=datetime.now(), BMI=BMI)
        w.save()
        # send_notification(user, data["weight_state"])
        # send_sms(user.phone_number, data["weight_state"])

        result = {}
        result["weight_state"] = data["weight_state"]
        result["new_Weight"] = user.profile.weight
        result["IBW"] = data["IBW"]

        return myResponse.OK("وزن با موفقیت به روز رسانی شد. محاسبات مربوط به شما متناسب با آن تغییر یافت", result)
    except ValueError as e:
        writeErrorToLog("update_weight ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        writeErrorToLog("update_weight ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST", "GET"])
def user_questionnaire(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$"
                },
                {
                    "name": "question",
                    "format": "^.+&",
                    "errorMessage": "Incorrect question format. Please use correct format."
                },
                {
                    "name": "answer",
                    "format": "^.+&",
                    "errorMessage": "Incorrect answer format. Please use correct format."
                },
            ], request)

            token = str(request.POST["token"])
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            user = temp[0]

            questions = str(request.POST.get("question")).split("&")
            while '' in questions:
                questions.remove('')

            answers = str(request.POST.get("answer")).split("&")
            while '' in answers:
                answers.remove('')

            QandA = {
                "questions": questions,
                "answers": answers,
            }

            questionnaire = UserQuestionnaire(user=user, QandA=QandA)
            questionnaire.save()

            return myResponse.OK("Questionnaire was recorded", {})
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST", "GET"])
def questionnaire(request):
    if request.method == "POST":
        try:
            # Check if token is provided
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$"
                },
                {
                    "name": "is_from_app",
                    "format": "^[0-1]$",
                    "errorMessage": "This value is for checking if the user is from the app or not, and its value could be either 0 or 1.",
                    "required": False
                }
            ], request)
            
            
            questionnaire_type = request.POST.get("questionnaire_type")

            token = str(request.POST["token"])
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            user = temp[0]

            # Create a dictionary to store questions and answers
            QandA = {}

            # Loop through the POST data to collect questions and answers
            for key, value in request.POST.items():
                if key == "token":
                    continue  # Skip the token key

                # If there is a value for the question
                if value:
                    QandA[key] = value

            # Check if any data was collected
            if not QandA:
                return myResponse.Error("No questions or answers were provided.", Errors.InvalidArgument.code)

            if questionnaire_type == "MicrobiomeQuestionnaire":
                questionnaire = MicrobiomeQuestionnaire(user=user, QandA=QandA)
                questionnaire.save()
            elif questionnaire_type == "LifestyleQuestionnaire":
                questionnaire = LifestyleQuestionnaire(user=user, QandA=QandA)
                questionnaire.save()
            else:
                # Save the user questionnaire with the question-answer dictionary
                questionnaire = UserQuestionnaire(user=user, QandA=QandA)
                questionnaire.save()


            
            # Start background diet generation for LifestyleQuestionnaire from app
            if questionnaire_type == "LifestyleQuestionnaire":
                # Check if request is from app (default to False if not provided)
                is_from_app = request.POST.get("is_from_app", "0") == "1"
                logger.info(f"LifestyleQuestionnaire submitted - User: {user.id}, is_from_app: {is_from_app}")
                
                # Initialize Telegram notifier for debugging
                telegram_notifier = TelegramNotification()
                
                if is_from_app:
                    try:
                        telegram_notifier.send_debug_log(
                            f"🔍 Diet Gen Check\nUser ID: {user.id}\nQuestionnaire submitted from app"
                        )
                        
                        # Check if user has any existing diets and their timing
                        from datetime import date, timedelta
                        existing_diets = Diet.objects.filter(user=user).order_by('-from_date')
                        
                        should_generate_diet = False
                        
                        if not existing_diets.exists():
                            should_generate_diet = True
                            logger.info(f"User {user.id}: No existing diets found, will generate diet")
                            telegram_notifier.send_debug_log(
                                f"✅ User {user.id}: No existing diets\nWill generate new diet"
                            )
                        else:
                            # Get the most recent diet
                            latest_diet = existing_diets.first()
                            latest_diet_date = latest_diet.from_date
                            today = date.today()
                            days_since_latest = (today - latest_diet_date).days
                            logger.info(f"User {user.id}: Latest diet from {latest_diet_date}, {days_since_latest} days ago")
                            
                            if days_since_latest >= 14:
                                should_generate_diet = True
                                logger.info(f"User {user.id}: 14+ days since last diet, will generate new diet")
                                telegram_notifier.send_debug_log(
                                    f"✅ User {user.id}: {days_since_latest} days since last diet\nWill generate new diet"
                                )
                            else:
                                logger.info(f"User {user.id}: Only {days_since_latest} days since last diet, skipping generation")
                                telegram_notifier.send_debug_log(
                                    f"⏭️ User {user.id}: Only {days_since_latest} days since last diet\nSkipping (need 14+ days)"
                                )
                        
                        if should_generate_diet:
                            from panel.services.diet_generation import start_diet_generation_background
                            # Create a unique questionnaire event ID for idempotency
                            import uuid
                            questionnaire_event_id = f"lifestyle_questionnaire_{user.id}_{questionnaire.id}_{uuid.uuid4().hex[:8]}"
                            
                            logger.info(f"User {user.id}: Starting background diet generation with event_id: {questionnaire_event_id}")
                            telegram_notifier.send_debug_log(
                                f"🚀 Starting Diet Generation\nUser ID: {user.id}\nEvent ID: {questionnaire_event_id[:20]}..."
                            )
                            
                            result = start_diet_generation_background(user.id, questionnaire_event_id)
                            logger.info(f"User {user.id}: Background diet generation started, result: {result}")
                            
                            telegram_notifier.send_debug_log(
                                f"{'✅' if result else '❌'} Background thread started\nUser ID: {user.id}\nResult: {result}"
                            )
                    except Exception as e:
                        error_msg = f"❌ ERROR in Diet Generation\nUser ID: {user.id}\nError: {str(e)}"
                        logger.error(f"User {user.id}: Error in diet generation: {str(e)}", exc_info=True)
                        telegram_notifier.send_debug_log(error_msg)

            return myResponse.OK("Questionnaire was recorded", {})

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST", "GET"])
def settings(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$"
                },
                # {
                #     "name": "phone_number",
                #     "format": "^09[0-9]{9}$"
                # },
                {
                    "name": "user_setting",
                    "format": "^(\S)+$",
                    "errorMessage": "تنظیمات نا معتبر"
                }
            ], request)

            token = request.POST["token"]
            user_setting = request.POST["user_setting"]
            # phone = request.POST["phone_number"]
            # u = User.objects.filter(token=token, phone_number=phone)
            u = User.objects.filter(token=token)
            if not u.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            if len(request.POST["user_setting"]) > 500:
                return myResponse.Error("اندازه تنظیمات باید کمتر از 500 کاراکتر باشد", Errors.InvalidArgument.code)

            user = u[0]
            user.profile.user_setting = user_setting
            user.profile.save()
            return myResponse.OK("تغیرات اعمال شد", {})
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        try:
            RequsetChecker(request.GET, [
                {
                    "name": "token",
                    "format": "^(\S){30}$"
                },
                # {
                #     "name": "phone_number",
                #     "format": "^09[0-9]{9}$"
                # }
            ], request)
            token = request.GET["token"]
            # phone = request.POST["phone_number"]
            # u = User.objects.filter(token=token, phone_number=phone)
            u = User.objects.filter(token=token)
            if not u.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            profile = u[0].profile
            user_setting = profile.user_setting
            data = {
                "user_setting": user_setting,
            }
            return myResponse.OK("تنظیمات کاربر", data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def check(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$"
            },
        ], request)

        token = request.POST["token"]

        u = User.objects.filter(token=token)
        if not u.exists():
            writeErrorToLog("check ---> POST\n" + Errors.InvalidToken.message, request)
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
        user = u[0]
        new_message = PanelMessage.objects.filter(has_been_seen=False, receiver=user.django_user)

        data = {
            "number_of_new_message": new_message.count(),
        }

        return myResponse.OK("لیست آپدیت ها، پیام  ها و ...", data)
    except ValueError as e:
        writeErrorToLog("check ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        writeErrorToLog("check ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST", "GET"])
def registerToSite(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$"
                },
                {
                    "name": "phone_number",
                    "format": "^09[0-9]{9}$"
                },
                {
                    "name": "NewPassWord",
                    "format": "^(\S)+$",
                    "errorMessage": "رمزعبور نا معتبر است"
                },
                {
                    "name": "LastPassWord",
                    "format": "^(\S)+$",
                    "errorMessage": "رمز قبلی نا معتبر است"
                },
                {
                    "name": "first_name",
                    "format": ".",
                    "errorMessage": "نام نا معتبر است"
                },
                {
                    "name": "last_name",
                    "format": ".",
                    "errorMessage": "نام خانوادگی نا معتبر است"
                },
                {
                    "name": "doctor_id",
                    "format": "^[\d]+$",
                    "errorMessage": "کد پزشک نا معتبر است"
                }
            ], request)

            token = request.POST["token"]
            phone = request.POST["phone_number"]
            u = User.objects.filter(token=token, phone_number=phone)
            if not u.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            user = u[0]
            LastPassWord = str(request.POST.get("LastPassWord"))
            NewPassWord = str(request.POST.get("NewPassWord"))
            first_name = str(request.POST.get("first_name"))
            last_name = str(request.POST.get("last_name"))
            doctor_id = int(request.POST.get("doctor_id"))

            django_user = authenticate(request, username=phone, password=LastPassWord)
            if django_user is not None:
                try:
                    login(request, django_user)
                    django_user.set_password(NewPassWord)
                    django_user.save()
                except Exception as e:
                    return myResponse.Error(e.args, -1)

            else:
                django_user = authenticate(request, username=phone, password=token[0:8])
                if django_user is not None:
                    try:
                        login(request, django_user)
                        django_user.set_password(NewPassWord)
                        django_user.save()
                    except Exception as e:
                        return myResponse.Error(e.args, -1)
                return myResponse.Error(Errors.NotFoundUser.message, Errors.NotFoundUser.code)

            return myResponse.OK("تغیرات اعمال شد", {})
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        try:
            RequsetChecker(request.GET, [
                {
                    "name": "token",
                    "format": "^(\S){30}$"
                },
                {
                    "name": "phone_number",
                    "format": "^09[0-9]{9}$"
                }
            ], request)
            token = request.GET["token"]
            phone = request.GET["phone_number"]
            u = User.objects.filter(token=token, phone_number=phone)
            if not u.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            profile = u[0].profile
            user_setting = profile.user_setting
            data = {
                "user_setting": user_setting,
            }
            return myResponse.OK("تنظیمات کاربر", data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def update_last_login(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$"
            },
        ], request)

        token = request.POST["token"]

        u = User.objects.filter(token=token)
        if not u.exists():
            writeErrorToLog("update_last_login ---> POST\n" + Errors.InvalidToken.message, request)
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        user = u[0]

        # Ensure the user has a profile and update the last_login field
        profile = Profile.objects.filter(user=user).first()
        if profile:
            profile.last_login = now()
            profile.save()

        data = {
            "message": "Last login updated successfully",
            "last_login": profile.last_login.strftime("%Y-%m-%d %H:%M:%S") if profile else None
        }

        return myResponse.OK("آخرین ورود کاربر بروزرسانی شد", data)

    except ValueError as e:
        writeErrorToLog("update_last_login ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        writeErrorToLog("update_last_login ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    
    
    
    

@api_view(["POST", "GET"])
def test_recommendation_engine(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$"
                },
                {
                    "name": "meal_type",
                    "format": "^(BREAKFAST|LUNCH|DINNER|SNACK)$",
                    "errorMessage": "نوع غذا نا معتبر است" 
                },
                {
                    "name": "model",
                    "format": "^(0|1|2)$",
                    "errorMessage": "مدل نا معتبر است"
                },
                # {
                #     "name": "eaten_list",
                #     "format": "^(\S)+$",
                #     "errorMessage": "خوراکی‌های مورد استفاده معتبر نمی‌باشد",
                #     "required": False
                # }
            ], request)

            token = request.POST["token"]
            model = int(request.POST["model"])
            meal_type = request.POST["meal_type"]
            eaten_list = request.POST.get("eaten_list", [])
            input_food_dicts = request.POST.get("input_food_dicts", [])
            
            
            try:
                if input_food_dicts and input_food_dicts != []:  # Only run validation if input_food_dicts is not empty
                    # First ensure we have a string to work with
                    if not isinstance(input_food_dicts, str):
                        input_food_dicts = str(input_food_dicts)
                    
                    # Clean up potential formatting issues
                    input_food_dicts = input_food_dicts.strip()
                    
                    # Handle potential single quotes
                    input_food_dicts = input_food_dicts.replace("'", '"')
                    
                    # Fix potential trailing commas
                    input_food_dicts = re.sub(r',\s*}', '}', input_food_dicts)
                    input_food_dicts = re.sub(r',\s*]', ']', input_food_dicts)
                    
                    # Parse the JSON
                    try:
                        food_data = json.loads(input_food_dicts)
                        # Ensure food_data is a list
                        if not isinstance(food_data, list):
                            food_data = [food_data]
                    except json.JSONDecodeError as e:
                        # If first attempt fails, try to fix common issues
                        # Remove any non-printable characters
                        input_food_dicts = ''.join(char for char in input_food_dicts if char.isprintable())
                        # Try parsing again
                        food_data = json.loads(input_food_dicts)
                        # Ensure food_data is a list
                        if not isinstance(food_data, list):
                            food_data = [food_data]
                    
                    # Validate each food item in the list
                    validated_foods = []
                    for food_item in food_data:
                        if not isinstance(food_item, dict):
                            raise ValueError("Invalid food dictionary format")
                            
                        # Validate required fields
                        required_fields = ['FoodCode', 'FoodNamePersian', 'Calories', 'Carbohydrates_g', 'Protein_g', 'Fat_g']
                        missing_fields = [field for field in required_fields if field not in food_item]
                        if missing_fields:
                            raise ValueError(f"Missing required fields: {', '.join(missing_fields)}")
                        
                        # Ensure numeric fields are actually numbers
                        numeric_fields = ['Calories', 'Carbohydrates_g', 'Protein_g', 'Fat_g', 'serving_g', 'serving_size']
                        for field in numeric_fields:
                            if field in food_item:
                                try:
                                    food_item[field] = float(food_item[field])
                                except (ValueError, TypeError):
                                    food_item[field] = 0.0
                        
                        # Parse nested DiseaseJson if it exists
                        if 'DiseaseJson' in food_item and isinstance(food_item['DiseaseJson'], str):
                            try:
                                food_item['DiseaseJson'] = json.loads(food_item['DiseaseJson'])
                            except json.JSONDecodeError:
                                food_item['DiseaseJson'] = {}
                        
                        validated_foods.append(food_item)
                    
                    # Store the cleaned and validated data
                    input_food_dicts = validated_foods
                    
                else:
                    # If input_food_dicts is empty, set it to empty list
                    input_food_dicts = []
                
            except json.JSONDecodeError as e:
                writeErrorToLog(f"test_recommendation_engine ---> POST\nInvalid JSON format: {str(e)}", request)
                return myResponse.Error("Invalid food data format", Errors.InvalidArgument.code)
            except ValueError as e:
                writeErrorToLog(f"test_recommendation_engine ---> POST\nValidation error: {str(e)}", request)
                return myResponse.Error(str(e), Errors.InvalidArgument.code)
            except Exception as e:
                writeErrorToLog(f"test_recommendation_engine ---> POST\nError processing food data: {str(e)}", request)
                return myResponse.Error("Error processing food data", Errors.InvalidArgument.code)
                
            print("This is the input_food_dicts: ", input_food_dicts)

            # Get AppUser and validate token
            try:
                user = User.objects.get(token=token)
                if user.token != token:
                    return myResponse.Error("Invalid token", Errors.InvalidToken.code)
            except User.DoesNotExist:
                return myResponse.Error("User not found", Errors.UserNotFound.code)

            # Get profile and check CR values
            profile = Profile.objects.get(user=user)
            calorie_requirement = profile.CR_coach if profile.CR_coach else profile.CR

            # Map disease codes to scoring conditions
            disease_to_condition = {
                0: "Diabetes",  # Diabetes & Pre-diabetes
                1: "Weight Loss",
                2: "NAFLD",    # Fatty Liver
                3: "Hypertension", 
                4: "Hyperlipidemia",
                5: "PCOS",
                6: "IBS",
                7: "Migraine",
                8: "Sedentary Healthy Adults"  # Healthy
            }
            

            # Get scoring condition based on diseases
            try:
                # Split diseases string into list of disease codes
                disease_codes = profile._diseases.split('&')
                
                print(f"1 disease_codes: {disease_codes}")
                # Remove any empty strings
                disease_codes = [code for code in disease_codes if code]
                print(f"2 disease_codes: {disease_codes}")
                if disease_codes:
                    # Convert first disease code to int and use for scoring
                    disease_code = int(disease_codes[0])
                    score_condition = disease_to_condition.get(disease_code, "Sedentary Healthy Adults")
                else:
                    # No valid disease codes found
                    score_condition = "Sedentary Healthy Adults"
            except (ValueError, TypeError, AttributeError):
                # Default to healthy if diseases field is invalid
                score_condition = "Sedentary Healthy Adults"

            data = {}

            data["calorie_requirement"] = calorie_requirement
            data["score_condition"] = score_condition
            data["meal_type"] = meal_type
            # driver = GraphDatabase.driver("bolt://172.164.240.161:7687", auth=("neo4j", "@MahilaMoghadami@"))
            
            print(f"calorie_requirement: {calorie_requirement}")
            print(f"score_condition: {score_condition}")
            print(f"meal_type: {meal_type}")
            
            print("This is the eaten list: ", eaten_list)
            print("This is the input_food_dicts: ", input_food_dicts)
            
            # result = get_food_recommendations(
            #     driver=driver,
            #     flag=model,
            #     calorie_requirement=calorie_requirement,
            #     score_condition=score_condition,
            #     meal_type=meal_type,
            #     required_conditions=None, # list<string>: ["Diabetes"]
            #     required_allergens=None, # list<string>
            #     excluded_conditions=None, #√
            #     excluded_allergens=None, #√
            #     eaten_list=eaten_list,
            #     input_food_dicts=input_food_dicts
            # )
            
            # return myResponse.OK("ok", result)
            return myResponse.Error("Neo4j connection disabled", -1)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


# from APIs.bia_analyzer import generate_report, save_html_report

@api_view(['POST'])
def analyze_bia_image(request):
    try:
        # Check if image file is in request
        if 'image' not in request.FILES:
            return myResponse.Error("No image file provided", Errors.InvalidArgument.code)

        image_file = request.FILES['image']

        # Create bia_images directory if it doesn't exist
        image_dir = os.path.join(STATIC_ROOT, 'bia_images')
        os.makedirs(image_dir, exist_ok=True)

        # Generate unique filename with timestamp
        timestamp = datetime.now().strftime("%Y%m%d_%H%M%S")
        filename = f"bia_image_{timestamp}.jpg"
        image_path = os.path.join(image_dir, filename)

        # Save uploaded image
        with open(image_path, 'wb+') as destination:
            for chunk in image_file.chunks():
                destination.write(chunk)

        # Generate report from image
        report_content = generate_report(image_path)

        # Save report as HTML
        html_file_path = save_html_report(report_content, image_path)

        # Convert file path to URL
        html_url = f"/static/reports/{os.path.basename(html_file_path)}"

        return myResponse.OK("Report generated successfully", {
            "report_url": html_url
        })

    except Exception as e:
        return myResponse.Error(f"Error processing BIA image: {str(e)}", 12)


@api_view(['POST'])
def count_orange_cards(request):
    try:
        # Query food cards containing "پرتقال" in title
        orange_count = FoodCard.objects.filter(FA_Name__contains='پرتقال')
        card_names = []
        
        for card in orange_count:
            card_names.append(
                {
                    "FA_Name": card.FA_Name,
                    "calories": card.Calories,
                }
            )
        
        return myResponse.OK("ok", {
            "count": orange_count.count(),
            "card_names": card_names
        })

    except Exception as e:
        return myResponse.Error(f"Error counting orange cards: {str(e)}", 99)




@api_view(['POST'])
def add_summer_food_cards(request):
    
    try:        
        replacment_foods = [{"food_code": "9990426", "food_name": "هلو", "amount": 156, "home_unit_name": "عدد بزرگ", "home_unit_amount": 1, "Protein_g": 0.91, "Fat_g": 0.25, "Carbohydrates_g": 9.54, "Calories": 44.0, "Protein": 1.42, "Fat": 0.39, "Carbohydrates": 14.88, "Energy": 68.64}, {"food_code": "9190", "food_name": "شلیل", "amount": 156, "home_unit_name": "عدد بزرگ", "home_unit_amount": 1, "Protein_g": 1.06, "Fat_g": 0.32, "Carbohydrates_g": 10.55, "Calories": 44.0, "Protein": 1.65, "Fat": 0.5, "Carbohydrates": 16.46, "Energy": 68.64}, {"food_code": "9003", "food_name": "زردآلو", "amount": 40, "home_unit_name": "عدد بزرگ", "home_unit_amount": 1, "Protein_g": 1.4, "Fat_g": 0.4, "Carbohydrates_g": 11.12, "Calories": 48.0, "Protein": 0.56, "Fat": 0.16, "Carbohydrates": 4.45, "Energy": 19.2}, {"food_code": "9003", "food_name": "زردآلو", "amount": 80, "home_unit_name": "عدد بزرگ", "home_unit_amount": 2, "Protein_g": 1.4, "Fat_g": 0.39, "Carbohydrates_g": 11.12, "Calories": 48.0, "Protein": 1.12, "Fat": 0.31, "Carbohydrates": 8.9, "Energy": 38.4}, {"food_code": "9990420", "food_name": "آلو شابلون ", "amount": 156, "home_unit_name": "عدد بزرگ", "home_unit_amount": 1, "Protein_g": 1.06, "Fat_g": 0.32, "Carbohydrates_g": 10.55, "Calories": 44.0, "Protein": 1.65, "Fat": 0.5, "Carbohydrates": 16.46, "Energy": 68.64}, {"food_code": "9990425", "food_name": "هلو انجیری", "amount": 156, "home_unit_name": "عدد بزرگ", "home_unit_amount": 1, "Protein_g": 0.91, "Fat_g": 0.25, "Carbohydrates_g": 9.54, "Calories": 44.0, "Protein": 1.42, "Fat": 0.39, "Carbohydrates": 14.88, "Energy": 68.64}, {"food_code": "9990423", "food_name": "توت سیاه ", "amount": 32.5, "home_unit_name": "عدد", "home_unit_amount": 5, "Protein_g": 1.45, "Fat_g": 0.4, "Carbohydrates_g": 9.82, "Calories": 43.02, "Protein": 0.47, "Fat": 0.13, "Carbohydrates": 3.19, "Energy": 13.98}, {"food_code": "9990423", "food_name": "توت سیاه ", "amount": 65, "home_unit_name": "عدد", "home_unit_amount": 10, "Protein_g": 1.45, "Fat_g": 0.38, "Carbohydrates_g": 9.8, "Calories": 43.0, "Protein": 0.94, "Fat": 0.25, "Carbohydrates": 6.37, "Energy": 27.95}, {"food_code": "9990423", "food_name": "توت سیاه ", "amount": 97.5, "home_unit_name": "عدد", "home_unit_amount": 15, "Protein_g": 1.44, "Fat_g": 0.39, "Carbohydrates_g": 9.81, "Calories": 43.01, "Protein": 1.4, "Fat": 0.38, "Carbohydrates": 9.56, "Energy": 41.93}, {"food_code": "9990422", "food_name": "توت سفید ", "amount": 32.5, "home_unit_name": "عدد", "home_unit_amount": 5, "Protein_g": 1.05, "Fat_g": 0.31, "Carbohydrates_g": 10.55, "Calories": 43.02, "Protein": 0.34, "Fat": 0.1, "Carbohydrates": 3.43, "Energy": 13.98}, {"food_code": "9990422", "food_name": "توت سفید ", "amount": 65, "home_unit_name": "عدد", "home_unit_amount": 10, "Protein_g": 1.06, "Fat_g": 0.32, "Carbohydrates_g": 10.55, "Calories": 43.0, "Protein": 0.69, "Fat": 0.21, "Carbohydrates": 6.86, "Energy": 27.95}, {"food_code": "9990422", "food_name": "توت سفید ", "amount": 97.5, "home_unit_name": "عدد", "home_unit_amount": 15, "Protein_g": 1.06, "Fat_g": 0.32, "Carbohydrates_g": 10.55, "Calories": 43.01, "Protein": 1.03, "Fat": 0.31, "Carbohydrates": 10.29, "Energy": 41.93}, {"food_code": "9302", "food_name": "توت فرنگی", "amount": 90, "home_unit_name": "عدد", "home_unit_amount": 5, "Protein_g": 0.67, "Fat_g": 0.3, "Carbohydrates_g": 7.68, "Calories": 32.0, "Protein": 0.6, "Fat": 0.27, "Carbohydrates": 6.91, "Energy": 28.8}, {"food_code": "9302", "food_name": "توت فرنگی", "amount": 126, "home_unit_name": "عدد", "home_unit_amount": 7, "Protein_g": 0.67, "Fat_g": 0.3, "Carbohydrates_g": 7.68, "Calories": 32.0, "Protein": 0.84, "Fat": 0.38, "Carbohydrates": 9.68, "Energy": 40.32}, {"food_code": "9302", "food_name": "توت فرنگی", "amount": 180, "home_unit_name": "عدد", "home_unit_amount": 10, "Protein_g": 0.67, "Fat_g": 0.3, "Carbohydrates_g": 7.68, "Calories": 32.0, "Protein": 1.21, "Fat": 0.54, "Carbohydrates": 13.82, "Energy": 57.6}, {"food_code": "9990411", "food_name": "گوجه سبز", "amount": 47.5, "home_unit_name": "عدد", "home_unit_amount": 5, "Protein_g": 0.69, "Fat_g": 0.27, "Carbohydrates_g": 11.41, "Calories": 46.0, "Protein": 0.33, "Fat": 0.13, "Carbohydrates": 5.42, "Energy": 21.85}, {"food_code": "9990411", "food_name": "گوجه سبز", "amount": 66.5, "home_unit_name": "عدد", "home_unit_amount": 7, "Protein_g": 0.71, "Fat_g": 0.29, "Carbohydrates_g": 11.41, "Calories": 46.0, "Protein": 0.47, "Fat": 0.19, "Carbohydrates": 7.59, "Energy": 30.59}, {"food_code": "9990411", "food_name": "گوجه سبز", "amount": 95, "home_unit_name": "عدد", "home_unit_amount": 10, "Protein_g": 0.71, "Fat_g": 0.28, "Carbohydrates_g": 11.42, "Calories": 46.0, "Protein": 0.67, "Fat": 0.27, "Carbohydrates": 10.85, "Energy": 43.7}, {"food_code": "9990418", "food_name": "چغاله بادام ", "amount": 15, "home_unit_name": "عدد", "home_unit_amount": 5, "Protein_g": 20.0, "Fat_g": 50.0, "Carbohydrates_g": 20.0, "Calories": 566.67, "Protein": 3, "Fat": 7.5, "Carbohydrates": 3, "Energy": 85}, {"food_code": "9990418", "food_name": "چغاله بادام ", "amount": 21, "home_unit_name": "عدد", "home_unit_amount": 7, "Protein_g": 20.0, "Fat_g": 50.0, "Carbohydrates_g": 20.0, "Calories": 566.67, "Protein": 4.2, "Fat": 10.5, "Carbohydrates": 4.2, "Energy": 119}, {"food_code": "9990418", "food_name": "چغاله بادام ", "amount": 30, "home_unit_name": "عدد", "home_unit_amount": 10, "Protein_g": 20.0, "Fat_g": 50.0, "Carbohydrates_g": 20.0, "Calories": 566.67, "Protein": 6, "Fat": 15, "Carbohydrates": 6, "Energy": 170}, {"food_code": "9040", "food_name": "آلبالو", "amount": 57.39999999999999, "home_unit_name": "عدد", "home_unit_amount": 7, "Protein_g": 0.19, "Fat_g": 1.1, "Carbohydrates_g": 15.99, "Calories": 63.0, "Protein": 0.11, "Fat": 0.63, "Carbohydrates": 9.18, "Energy": 36.16}, {"food_code": "9040", "food_name": "آلبالو", "amount": 82, "home_unit_name": "عدد", "home_unit_amount": 10, "Protein_g": 0.2, "Fat_g": 1.1, "Carbohydrates_g": 16.0, "Calories": 63.0, "Protein": 0.16, "Fat": 0.9, "Carbohydrates": 13.12, "Energy": 51.66}, {"food_code": "9040", "food_name": "آلبالو", "amount": 122.99999999999999, "home_unit_name": "عدد", "home_unit_amount": 15, "Protein_g": 0.2, "Fat_g": 1.1, "Carbohydrates_g": 16.0, "Calories": 63.0, "Protein": 0.25, "Fat": 1.35, "Carbohydrates": 19.68, "Energy": 77.49}, {"food_code": "9070", "food_name": "گیلاس ", "amount": 57.39999999999999, "home_unit_name": "عدد متوسط", "home_unit_amount": 7, "Protein_g": 1.06, "Fat_g": 0.19, "Carbohydrates_g": 16.01, "Calories": 63.0, "Protein": 0.61, "Fat": 0.11, "Carbohydrates": 9.19, "Energy": 36.16}, {"food_code": "9070", "food_name": "گیلاس ", "amount": 82, "home_unit_name": "عدد متوسط", "home_unit_amount": 10, "Protein_g": 1.06, "Fat_g": 0.2, "Carbohydrates_g": 16.01, "Calories": 63.0, "Protein": 0.87, "Fat": 0.16, "Carbohydrates": 13.13, "Energy": 51.66}, {"food_code": "9070", "food_name": "گیلاس ", "amount": 98.39999999999999, "home_unit_name": "عدد متوسط", "home_unit_amount": 12, "Protein_g": 1.06, "Fat_g": 0.2, "Carbohydrates_g": 16.01, "Calories": 63.0, "Protein": 1.04, "Fat": 0.2, "Carbohydrates": 15.75, "Energy": 61.99}, {"food_code": "9070", "food_name": "گیلاس ", "amount": 122.99999999999999, "home_unit_name": "عدد متوسط", "home_unit_amount": 15, "Protein_g": 1.06, "Fat_g": 0.2, "Carbohydrates_g": 16.01, "Calories": 63.0, "Protein": 1.3, "Fat": 0.25, "Carbohydrates": 19.69, "Energy": 77.49}, {"food_code": "9159", "food_name": "طالبی", "amount": 125, "home_unit_name": "قاچ متوسط", "home_unit_amount": 1, "Protein_g": 0.8, "Fat_g": 0.2, "Carbohydrates_g": 8.2, "Calories": 34.0, "Protein": 1, "Fat": 0.25, "Carbohydrates": 10.25, "Energy": 42.5}, {"food_code": "9159", "food_name": "طالبی", "amount": 250, "home_unit_name": "قاچ متوسط", "home_unit_amount": 2, "Protein_g": 0.8, "Fat_g": 0.2, "Carbohydrates_g": 8.2, "Calories": 34.0, "Protein": 2, "Fat": 0.5, "Carbohydrates": 20.5, "Energy": 85}, {"food_code": "9159", "food_name": "طالبی", "amount": 375, "home_unit_name": "قاچ متوسط", "home_unit_amount": 3, "Protein_g": 0.8, "Fat_g": 0.2, "Carbohydrates_g": 8.2, "Calories": 34.0, "Protein": 3, "Fat": 0.75, "Carbohydrates": 30.75, "Energy": 127.5}, {"food_code": "9191", "food_name": "خربزه - قندک", "amount": 20, "home_unit_name": "قاچ کوچک", "home_unit_amount": 1, "Protein_g": 0.55, "Fat_g": 0.15, "Carbohydrates_g": 9.1, "Calories": 36.0, "Protein": 0.11, "Fat": 0.03, "Carbohydrates": 1.82, "Energy": 7.2}, {"food_code": "9191", "food_name": "خربزه - قندک", "amount": 40, "home_unit_name": "قاچ کوچک", "home_unit_amount": 2, "Protein_g": 0.55, "Fat_g": 0.15, "Carbohydrates_g": 9.1, "Calories": 36.0, "Protein": 0.22, "Fat": 0.06, "Carbohydrates": 3.64, "Energy": 14.4}, {"food_code": "9191", "food_name": "خربزه - قندک", "amount": 60, "home_unit_name": "قاچ کوچک", "home_unit_amount": 3, "Protein_g": 0.53, "Fat_g": 0.13, "Carbohydrates_g": 9.08, "Calories": 36.0, "Protein": 0.32, "Fat": 0.08, "Carbohydrates": 5.45, "Energy": 21.6}, {"food_code": "9146", "food_name": "هندوانه", "amount": 286, "home_unit_name": "قاچ بزرگ", "home_unit_amount": 1, "Protein_g": 0.61, "Fat_g": 0.15, "Carbohydrates_g": 7.55, "Calories": 30.0, "Protein": 1.74, "Fat": 0.43, "Carbohydrates": 21.59, "Energy": 85.8}, {"food_code": "9146", "food_name": "هندوانه", "amount": 572, "home_unit_name": "قاچ بزرگ", "home_unit_amount": 2, "Protein_g": 0.61, "Fat_g": 0.15, "Carbohydrates_g": 7.55, "Calories": 30.0, "Protein": 3.49, "Fat": 0.86, "Carbohydrates": 43.19, "Energy": 171.6}, {"food_code": "9146", "food_name": "هندوانه", "amount": 858, "home_unit_name": "قاچ بزرگ", "home_unit_amount": 3, "Protein_g": 0.61, "Fat_g": 0.15, "Carbohydrates_g": 7.55, "Calories": 30.0, "Protein": 5.23, "Fat": 1.29, "Carbohydrates": 64.78, "Energy": 257.4}, {"food_code": "9078", "food_name": "انگور سبز", "amount": 83.30000000000001, "home_unit_name": "عدد", "home_unit_amount": 17, "Protein_g": 0.88, "Fat_g": 0.58, "Carbohydrates_g": 10.18, "Calories": 44.0, "Protein": 0.73, "Fat": 0.48, "Carbohydrates": 8.48, "Energy": 36.65}, {"food_code": "9990413", "food_name": "انگور عسگری", "amount": 83.30000000000001, "home_unit_name": "عدد", "home_unit_amount": 17, "Protein_g": 0.88, "Fat_g": 0.58, "Carbohydrates_g": 10.18, "Calories": 44.0, "Protein": 0.73, "Fat": 0.48, "Carbohydrates": 8.48, "Energy": 36.65}, {"food_code": "9990414", "food_name": "انگور یاقوتی ", "amount": 102, "home_unit_name": "حبه", "home_unit_amount": 17, "Protein_g": 1.4, "Fat_g": 0.41, "Carbohydrates_g": 15.38, "Calories": 63.0, "Protein": 1.43, "Fat": 0.42, "Carbohydrates": 15.69, "Energy": 64.26}, {"food_code": "9990416", "food_name": "انگور ریش بابا ", "amount": 83.30000000000001, "home_unit_name": "عدد", "home_unit_amount": 17, "Protein_g": 0.88, "Fat_g": 0.58, "Carbohydrates_g": 10.18, "Calories": 44.0, "Protein": 0.73, "Fat": 0.48, "Carbohydrates": 8.48, "Energy": 36.65}, {"food_code": "9107", "food_name": "انگور سیاه", "amount": 102, "home_unit_name": "عدد", "home_unit_amount": 17, "Protein_g": 1.4, "Fat_g": 0.41, "Carbohydrates_g": 15.38, "Calories": 63.0, "Protein": 1.43, "Fat": 0.42, "Carbohydrates": 15.69, "Energy": 64.26}, {"food_code": "9231", "food_name": "گلابی", "amount": 89, "home_unit_name": "عدد متوسط", "home_unit_amount": 0.5, "Protein_g": 0.36, "Fat_g": 0.13, "Carbohydrates_g": 15.22, "Calories": 57.0, "Protein": 0.32, "Fat": 0.12, "Carbohydrates": 13.55, "Energy": 50.73}, {"food_code": "9231", "food_name": "گلابی", "amount": 178, "home_unit_name": "عدد متوسط", "home_unit_amount": 1, "Protein_g": 0.36, "Fat_g": 0.14, "Carbohydrates_g": 15.23, "Calories": 57.0, "Protein": 0.64, "Fat": 0.25, "Carbohydrates": 27.11, "Energy": 101.46}]
        
        # Find FoodCard instances with FA_Name "چای و خرما - میوه (پرتقال)"
        existing_food_cards = FoodCard.objects.filter(FA_Name="چای و خرما - میوه (پرتقال)")
        
        # List to store all new food cards data
        new_food_cards_data = []

        for existing_card in existing_food_cards:
            # Get the foods array from the existing FoodCard
            base_foods = existing_card.foods
            
            print("Original foods:", base_foods)
            
            # Remove items with food_code 9087 (orange)
            filtered_foods = []
            for food in base_foods:
                if str(food.get('food_code')) != '9087':  # Convert both to strings for comparison
                    filtered_foods.append(food)
                else:
                    print("Removing food with code 9087:", food)
            
            base_foods = filtered_foods
            print("Foods after removing orange:", base_foods)

            # Create a new FoodCard for each replacement food
            for replacement_food in replacment_foods:
                # Create a copy of base foods and add the current replacement food
                foods = base_foods.copy()
                foods.append(replacement_food)

                # Calculate new nutrition totals
                total_calories = 0
                total_protein = 0 
                total_fat = 0
                total_carbs = 0

                for food in foods:
                    total_calories += food.get('Energy', 0)
                    total_protein += food.get('Protein', 0)
                    total_fat += food.get('Fat', 0) 
                    total_carbs += food.get('Carbohydrate', 0)

                # Calculate ratios
                total_macros = total_protein + total_fat + total_carbs
                protein_ratio = (total_protein / total_calories) * 100 if total_calories > 0 else 0
                fat_ratio = (total_fat / total_calories) * 100 if total_calories > 0 else 0
                carb_ratio = (total_carbs / total_calories) * 100 if total_calories > 0 else 0

                # Create new food name using the replacement food's name
                new_food_name = f"چای و خرما - میوه ({replacement_food['food_name']})"
                
                print("generating card with name: ", new_food_name)
                print("foods in new card:", foods)
                
                # Create new FoodCard instance
                new_food_card = FoodCard(
                    FA_Name=new_food_name,
                    foods=foods,
                    Calories=total_calories,
                    protein_ratio=protein_ratio,
                    fat_ratio=fat_ratio,
                    carb_ratio=carb_ratio,
                    is_snack=True
                )
                new_food_card.save()
                
                # Add card data to our list
                new_food_cards_data.append({
                    'FA_Name': new_food_name,
                    'Calories': total_calories,
                    'Protein_Ratio': protein_ratio,
                    'Fat_Ratio': fat_ratio,
                    'Carb_Ratio': carb_ratio,
                    'Is_Snack': True,
                    'Foods': str(foods)  # Convert foods list to string for Excel
                })

        
        return Response({
            'message': 'New food cards created successfully',
            'excel_file': excel_path
        }, status=200)

    except Exception as e:
        print("Error:", str(e))
        return Response({'error': str(e)}, status=400)



# Function to calculate daily scores (excluding meal data)
def calculate_daily_scores(daily_log):
    scores = {
        "hydration": 0,
        "diet": 0,
        "dietary_habits.consistency": 0,
        "sleep": 0,
        "exercise": 0,
        "mental_wellbeing": 70,  # Default value
        "logging_completeness": 0,
        "wellness_score": 0
    }
    
    # Calculate hydration score (max 100)
    water_glasses = daily_log.get("water_glasses", 0)
    scores["hydration"] = min(100, (water_glasses / 8) * 100)  # Assuming 8 glasses is optimal
    
    # Calculate dietary habits consistency (0-1) based on number of meals logged
    meals = daily_log.get("meals", {})
    meal_count = len(meals.get("breakfast", [])) + len(meals.get("lunch", [])) + len(meals.get("dinner", []))
    if meal_count >= 3:  # If at least 3 main meals logged
        scores["dietary_habits.consistency"] = 0.8
    elif meal_count >= 2:
        scores["dietary_habits.consistency"] = 0.5
    elif meal_count >= 1:
        scores["dietary_habits.consistency"] = 0.3
    
    # Calculate sleep score (max 100)
    sleep_hours = daily_log.get("sleep", {}).get("duration_hours", 0)
    if 7 <= sleep_hours <= 9:  # Optimal sleep range
        scores["sleep"] = 100
    else:
        scores["sleep"] = max(0, 100 - abs(sleep_hours - 8) * 20)
    
    # Calculate exercise score (max 100)
    steps = daily_log.get("walking_steps", 0)
    activity_minutes = sum(activity.get("duration_minutes", 0) for activity in daily_log.get("activities", []))
    steps_score = min(100, (steps / 10000) * 100)  # Assuming 10000 steps is optimal
    activity_score = min(100, (activity_minutes / 30) * 100)  # Assuming 30 minutes is optimal
    scores["exercise"] = (steps_score + activity_score) / 2
    
    # Calculate logging completeness (0-1)
    meals = daily_log.get("meals", {})
    logged_items = [
        bool(meals.get("breakfast") or meals.get("lunch") or meals.get("dinner") or meals.get("snacks")),
        bool(daily_log.get("water_glasses")),
        bool(daily_log.get("walking_steps")),
        bool(daily_log.get("sleep", {}).get("duration_hours")),
        bool(daily_log.get("activities"))
    ]
    scores["logging_completeness"] = sum(logged_items) / len(logged_items)
    
    # Calculate overall wellness score
    weights = {
        "hydration": 0.15,
        "diet": 0.25,
        "dietary_habits.consistency": 0.1,
        "sleep": 0.2,
        "exercise": 0.2,
        "mental_wellbeing": 0.1
    }
            
    scores["wellness_score"] = int(
        scores["hydration"] * weights["hydration"] +
        scores["diet"] * weights["diet"] +
        scores["dietary_habits.consistency"] * 100 * weights["dietary_habits.consistency"] +
        scores["sleep"] * weights["sleep"] +
        scores["exercise"] * weights["exercise"] +
        scores["mental_wellbeing"] * weights["mental_wellbeing"]
    )
    
    return scores

@api_view(['POST'])
def wellness_report(request):
    # try:
        token = request.POST.get('token')
        user = User.objects.get(token=token)
        profile = user.profile
        
        # Get date range for past 30 days
        today = datetime.now().date()
        thirty_days_ago = today - timedelta(days=30)
        date_range_start = datetime.combine(thirty_days_ago, datetime.min.time())
        date_range_end = datetime.combine(today, datetime.max.time())
        
        # Initialize historical data list
        historical_data = []
        
        # Function to determine meal type based on time
        def get_meal_type(time):
            hour = time.hour
            if 5 <= hour < 11:  # 5 AM to 10:59 AM
                return "breakfast"
            elif 11 <= hour < 16:  # 11 AM to 3:59 PM
                return "lunch"
            elif 16 <= hour < 21:  # 4 PM to 8:59 PM
                return "dinner"
            else:  # 9 PM to 4:59 AM
                return "snacks"
        
        
        # Get all records for the past 30 days
        eating_records = Eating.objects.filter(
            user=user,
            date_time__range=(date_range_start, date_range_end)
        ).order_by('date_time')
        
        water_records = Water.objects.filter(
            user=user,
            time__range=(date_range_start, date_range_end)
        ).order_by('time')
        
        walking_records = Walking.objects.filter(
            user=user,
            date__range=(thirty_days_ago, today)
        ).order_by('date')
        
        sleep_records = Sleep.objects.filter(
            user=user,
            time__range=(date_range_start, date_range_end)
        ).order_by('time')
        
        activity_records = Activities_log.objects.filter(
            user=user,
            start_date_time__range=(date_range_start, date_range_end)
        ).order_by('start_date_time')
        
        # Group records by date
        current_date = None
        daily_log = None
        
        # Process all records chronologically
        all_records = []
        for record in eating_records:
            all_records.append(("eating", record))
        for record in water_records:
            all_records.append(("water", record))
        for record in walking_records:
            all_records.append(("walking", record))
        for record in sleep_records:
            all_records.append(("sleep", record))
        for record in activity_records:
            all_records.append(("activity", record))
            
        # Function to get datetime from record based on its type
        def get_record_datetime(record):
            if hasattr(record, 'date_time'):
                return record.date_time
            elif hasattr(record, 'start_date_time'):
                return record.start_date_time
            elif hasattr(record, 'time'):
                return record.time
            elif hasattr(record, 'date'):
                return datetime.combine(record.date, datetime.min.time())
            elif hasattr(record, 'created_at'):
                return record.created_at
            else:
                print(f"Warning: Record has no date field: {record}")
                return datetime.min  # Return minimum datetime as fallback
        
        # Sort records by their datetime
        all_records.sort(key=lambda x: get_record_datetime(x[1]))
        
        for record_type, record in all_records:
            # Get record date using the same function
            record_datetime = get_record_datetime(record)
            record_date = record_datetime.date()
                
            if record_date != current_date:
                if daily_log is not None:
                    # Calculate scores for the previous day
                    scores = calculate_daily_scores(daily_log)
                    historical_data.append({
                        "date": current_date.strftime("%Y-%m-%d"),
                        "daily_log": daily_log,
                        "scores": scores
                    })
                
                # Initialize new daily log with meal categories
                current_date = record_date
                daily_log = {
                    "meals": {
                        "breakfast": [],
                        "lunch": [],
                        "dinner": [],
                        "snacks": []
                    },
                    "water_glasses": 0,
                    "activities": [],
                    "walking_steps": 0,
                    "sleep": {"duration_hours": 0}
                }
            
            # Add record to daily log
            if record_type == "eating":
                print(f"Eating report: {record.meal}")
                
                # Create meal data with original structure
                meal_data = {
                    "name": record.food.FA_Name,
                    "quantity": record.amount,
                    "calories": record.food.Calories * record.amount,
                    "description": ""
                }
                # Determine meal type based on time and add to appropriate category
                meal_type = get_meal_type(record_datetime)
                daily_log["meals"][meal_type].append(meal_data)
            elif record_type == "water":
                daily_log["water_glasses"] += record.amount
            elif record_type == "walking":
                daily_log["walking_steps"] += record.steps
            elif record_type == "sleep":
                if hasattr(record, 'end') and record.end:
                    # Handle both datetime and float values for sleep duration
                    if isinstance(record.start, (int, float)) and isinstance(record.end, (int, float)):
                        # If start and end are floats (hours), calculate duration directly
                        sleep_duration = record.end - record.start
                    else:
                        # If start and end are datetime objects, calculate duration in hours
                        sleep_duration = (record.end - record.start).total_seconds() / 3600
                    daily_log["sleep"]["duration_hours"] = round(sleep_duration, 1)
            elif record_type == "activity":
                if record.activity:
                    duration = 0
                    if hasattr(record, 'start_date_time') and hasattr(record, 'end_date_time'):
                        duration = int((record.end_date_time - record.start_date_time).total_seconds() / 60)
                    activity_data = {
                        "name": record.activity.name,
                        "duration_minutes": duration
                    }
                    daily_log["activities"].append(activity_data)
        
        # Add the last day's data
        if daily_log is not None:
            scores = calculate_daily_scores(daily_log)
            historical_data.append({
                "date": current_date.strftime("%Y-%m-%d"),
                "daily_log": daily_log,
                "scores": scores
            })
        
        # Get today's data
        today_start = datetime.combine(today, datetime.min.time())
        today_end = datetime.combine(today, datetime.max.time())
        
        daily_log = {
            "date": f"{today.year}-{today.month}-{today.day}",
            "meals": {
                "breakfast": [],
                "lunch": [],
                "dinner": [],
                "snacks": []
            },
            "water_glasses": 0,
            "activities": [],
            "walking_steps": 0,
            "sleep": {"duration_hours": 0}
        }

        # Get today's records
        today_eating_records = Eating.objects.filter(
            user=user,
            date_time__range=(today_start, today_end)
        )

        for record in today_eating_records:
            # Create meal data with original structure
            meal_data = {
                "name": record.food.FA_Name,
                "quantity": record.amount,
                "calories": record.food.Calories * record.amount,
                "description": ""
            }
            # Determine meal type based on time and add to appropriate category
            meal_type = get_meal_type(record.date_time)
            daily_log["meals"][meal_type].append(meal_data)

        water_records = Water.objects.filter(
            user=user,
            time__range=(today_start, today_end)
        )
        daily_log["water_glasses"] = sum(record.amount for record in water_records)

        walking_records = Walking.objects.filter(
            user=user,
            date=today_start.date()
        )
        daily_log["walking_steps"] = sum(record.steps for record in walking_records)

        sleep_records = Sleep.objects.filter(
            user=user,
            time__range=(today_start, today_end)
        ).last()

        if sleep_records:
            try:
                sleep_duration = (sleep_records.end - sleep_records.start).total_seconds() / 3600
                if sleep_duration > 0:
                    daily_log["sleep"]["duration_hours"] = round(sleep_duration, 1)
            except Exception as e:
                print(f"Error calculating sleep duration: {e}")

        activity_records = Activities_log.objects.filter(
            user=user,
            start_date_time__range=(today_start, today_end)
        )

        for record in activity_records:
            if record.activity:
                duration = 0
                if record.start_date_time and record.end_date_time:
                    duration = int((record.end_date_time - record.start_date_time).total_seconds() / 60)
                activity_data = {
                    "name": record.activity.name,
                    "duration_minutes": duration
                }
                daily_log["activities"].append(activity_data)

        # Get wellness reports and user questionnaire
        wellness_reports = WellnessProfile.objects.filter(user=user).order_by('-created_at').last()
        user_questionnaire = UserQuestionnaire.objects.filter(user=user).last()
        
        user_data = {
            "user_id": user.id,
            "profile": {
                "first_name": profile.first_name,
                "gender": "male" if profile.gender == 1 else "female",
                "age": profile.age,
                "weight_kg": profile.weight,
                "height_cm": profile.height,
                "goal_weight_kg": user_questionnaire.QandA.get("IDEAL_WEIGHT") if user_questionnaire else None,
                "diseases": user_questionnaire.QandA.get("CHRONIC_ILLNESSES") if user_questionnaire else None
            },
            "daily_log": daily_log,
            "historical_data": historical_data
        }
        
        if wellness_reports is not None:
            user_data["wellness_report"] = wellness_reports
        else:
            user_data["wellness_report"] = {}
        
        # Initialize wellness_profile
        user_data["wellness_profile"] = {
            "history_summary": {
                "last_cleared": user_data["daily_log"]["date"],
                "daily_summaries": [],
                "weekly_summaries": [],
                "monthly_summaries": []
            },
            "recommendations": [],
            "goals": [],
            "achievements": []
        }
        
        # Convert WellnessProfile to dict if it exists
        if "wellness_report" in user_data and isinstance(user_data["wellness_report"], WellnessProfile):
            user_data["wellness_report"] = {
                "created_at": user_data["wellness_report"].created_at.isoformat() if user_data["wellness_report"].created_at else None
            }
            
        print(f"Historical data: {historical_data}")
        
        # Call wellness assistant
        wellness_assistant_response = call_health_wellness_assistant(user_data, [])
        user_data["wellness_assistant_response"] = wellness_assistant_response
        
        hydration = wellness_assistant_response["wellness_profile"]["hydration"]["score"]
        diet = wellness_assistant_response["wellness_profile"]["diet"]["score"]
        dietary_habits = wellness_assistant_response["wellness_profile"]["dietary_habits"]["consistency_score"]
        sleep = wellness_assistant_response["wellness_profile"]["sleep"]["score"]
        exercise = wellness_assistant_response["wellness_profile"]["exercise"]["score"]
        mental_wellbeing = wellness_assistant_response["wellness_profile"]["mental_wellbeing"]["score"]
        logging_completeness = wellness_assistant_response["wellness_profile"]["logging_behavior"]["completeness"]
        wellness_score = wellness_assistant_response["wellness_profile"]["wellness_score"]["value"]
        notification_title = wellness_assistant_response["notification_title"]
        notification_body = wellness_assistant_response["notification_body"]
        recommendation = wellness_assistant_response["text"]
        
        # Save the wellness profile
        WellnessProfile(user=user, profile=wellness_assistant_response, notification_title=notification_title, notification_body=notification_body, recommendation=recommendation, hydration=hydration, diet=diet, dietary_habits=dietary_habits, sleep=sleep, exercise=exercise, mental_wellbeing=mental_wellbeing, logging_completeness=logging_completeness, wellness_score=wellness_score).save()
        
        return myResponse.OK("Data generated successfully", user_data)
            
    # except Exception as e:
        # print("Error:", str(e))
        # return myResponse.Error(str(e))


# TODO: the last_cleared should be modified later

@api_view(["POST"])
def store_mood(request):
    try:
        RequsetChecker(request.POST, [
            {"name": "token", "format": "^(\\S){30}$"},
            {"name": "mood", "format": "^[1-9]$"},
            {"name": "note", "format": ".*", "required": False},
            {"name": "datetime", "format": "^[0-9]+$", "required": False},
        ], request)

        token = request.POST["token"]
        mood_value = int(request.POST["mood"])
        note = request.POST.get("note", "")
        created_at_timestamp = request.POST.get("datetime")

        user_qs = User.objects.filter(token=token)
        if not user_qs.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
        user = user_qs[0]

        mood_data = {
            "user": user,
            "mood": mood_value,
            "note": note
        }

        if created_at_timestamp:
            mood_data["created_at"] = datetime.fromtimestamp(int(created_at_timestamp))

        mood_obj = Mood.objects.create(**mood_data)
        return myResponse.OK("Mood stored successfully", {"mood": mood_obj.get_mood_display(), "created_at": mood_obj.created_at})
    except Exception as e:
        return myResponse.Error(str(e), -1)

@api_view(["POST"])
def log_breath_work(request):
    try:
        RequsetChecker(request.POST, [
            {"name": "token", "format": "^(\\S){30}$"},
            {"name": "breath_work_type", "format": "^[1-4]$"},
        ], request)

        token = request.POST["token"]
        breath_work_type = int(request.POST["breath_work_type"])

        user_qs = User.objects.filter(token=token)
        if not user_qs.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
        user = user_qs[0]

        bw_obj = BreathWork.objects.create(user=user, breath_work_type=breath_work_type)
        return myResponse.OK("Breath work logged successfully", {"breath_work_type": bw_obj.get_breath_work_type_display(), "created_at": bw_obj.created_at})
    except Exception as e:
        return myResponse.Error(str(e), -1)

@api_view(["POST"])
def mindfulness(request):
    try:
        RequsetChecker(request.POST, [
            {"name": "token", "format": "^(\\S){30}$"},
            {"name": "starttime", "format": "^\\d+$"},
            {"name": "endtime", "format": "^\\d+$"},
        ], request)

        token = request.POST["token"]
        starttime = int(request.POST["starttime"])
        endtime = int(request.POST["endtime"])

        user_qs = User.objects.filter(token=token)
        if not user_qs.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
        user = user_qs[0]

        from datetime import datetime
        start_dt = datetime.fromtimestamp(starttime)
        end_dt = datetime.fromtimestamp(endtime)

        moods = Mood.objects.filter(user=user, created_at__gte=start_dt, created_at__lte=end_dt).order_by('created_at')
        mood_list = [
            {
                "mood": m.get_mood_display(),
                "mood_number": m.mood,
                "note": m.note,
                "created_at": m.created_at.isoformat()
            }
            for m in moods
        ]
        return myResponse.OK("User moods fetched successfully", {"moods": mood_list})
    except Exception as e:
        return myResponse.Error(str(e), -1)
    

@api_view(["POST"])
def create_hospital_user(request):
    """
    Create a user instance for hospital patients without SMS verification.
    This API is called by the hospital's application to create user instances
    for patients who are already registered in the hospital system.
    Only creates the basic user instance without profile information.
    """
    try:
        # Validate required fields from hospital system
        RequsetChecker(request.POST, [
            {
                "name": "phone_number",
                "format": "^09[0-9]{9}$"
            },
            {
                "name": "hospital_api_key",
                "format": "^[a-zA-Z0-9_]{20,64}$"
            }
        ], request)

        # Extract data from request
        phone = str(request.POST["phone_number"])
        hospital_api_key = str(request.POST["hospital_api_key"])
        
        # Validate hospital API key
        hospital_info = validate_hospital_api_key(hospital_api_key)
        if not hospital_info:
            writeErrorToLog("create_hospital_user ---> POST\n" + "Invalid hospital API key: " + hospital_api_key, request)
            return myResponse.Error("Invalid hospital API key", Errors.InvalidArgument.code)
        
        hospital_name = hospital_info.get("name", "Unknown Hospital")
        hospital_code = hospital_info.get("code", "UNKNOWN")
        print(f"Hospital user creation request from: {hospital_name} ({hospital_code}) for phone: {phone}")

        # Check if user already exists
        existing_user = User.objects.filter(phone_number=phone)
        if existing_user.exists():
            user = existing_user[0]
            if user.isRegistered:
                # User already exists and is registered
                data = {
                    "user_id": user.id,
                    "token": user.token,
                    "message": "User already exists and is registered"
                }
                print(f"✅ Hospital user already exists: {hospital_name} -> User ID: {user.id}")
                return myResponse.OK("کاربر قبلاً ثبت شده است", data)
            else:
                # User exists but not registered, mark as registered and generate new token
                user.isRegistered = True
                user.isLogedin = True
                
                # Generate new token using the same algorithm as sign API
                token_alphabet = string.ascii_letters + string.digits
                new_token = generateRandomString(token_alphabet, 30)
                user.token = new_token
                user.save()
                
                data = {
                    "user_id": user.id,
                    "token": new_token,
                    "message": "User marked as registered"
                }
                print(f"✅ Hospital user updated: {hospital_name} -> User ID: {user.id}")
                return myResponse.OK("کاربر با موفقیت به‌روزرسانی شد", data)
        else:
            # Create new user instance only (no profile creation)
            token_alphabet = string.ascii_letters + string.digits
            main_token = generateRandomString(token_alphabet, 30)
            
            # Create Django user
            temp = DjangoUser.objects.filter(username=phone)
            if temp.exists():
                du = temp[0]
            else:
                du = DjangoUser()
            du.username = phone
            du.set_password(main_token[0:8])
            du.save()
            
            # Add to Patient group
            my_group = Group.objects.get(name='Patient')
            my_group.user_set.add(du)
            
            # Create main user instance only (no profile)
            user = User(
                phone_number=phone,
                token=main_token,
                django_user=du,
                isRegistered=True,
                isLogedin=True
            )
            user.save()
            
            data = {
                "user_id": user.id,
                "token": main_token,
                "message": "User created successfully"
            }
            print(f"✅ Hospital user created successfully: {hospital_name} ({hospital_code}) -> User ID: {user.id}")
            return myResponse.OK("کاربر با موفقیت ایجاد شد", data)
            
    except ValueError as e:
        writeErrorToLog("create_hospital_user ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        writeErrorToLog("create_hospital_user ---> POST\n" + str(e.args), request)
        return myResponse.Error(str(e.args), Errors.InvalidArgument.code)

    
    
    

@api_view(["POST"])
def purchase_timeslot_with_coins(request):
    """Purchase a timeslot using coins (2000 coins per timeslot)"""
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "required": True
            },
            {
                "name": "timeslot_id",
                "format": "^[\d]+$",
                "required": True
            }
        ], request)

        token = str(request.POST["token"])
        timeslot_id = int(request.POST["timeslot_id"])

        # Validate user
        user = User.objects.filter(token=token).first()
        if not user:
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        # Get timeslot
        timeslot = TimeSlot.objects.filter(
            id=timeslot_id,
            is_available=1
        ).first()
        
        if not timeslot:
            return myResponse.Error("Timeslot not found or not available", Errors.DataNotFound.code)

        # Check if user has enough coins (2000 coins per timeslot)
        required_coins = 2000
        if user.profile.coins < required_coins:
            return myResponse.Error("Insufficient coins. Required: 2000 coins", Errors.InsufficientCoins.code)

        # Create payment record
        from payment.models import TimeSlotPayment
        payment = TimeSlotPayment.objects.create(
            user=user,
            time_slot=timeslot,
            payment_type='coin',
            coin_amount=required_coins
        )

        # Process the payment
        if payment.process_coin_payment():
            
            try:
                TelegramNotification().send_timeslot_purchase_notif(f"یک کاربر به نام {user.profile.first_name} {user.profile.last_name} زمان مکالمه  {timeslot.start_time.strftime('%Y/%m/%d ساعت %H:%M')} را خریداری کرد")
            except Exception as e:
                print("This is the telegram exception: ", e)
                
            return myResponse.OK("Timeslot purchased successfully with coins", {
                "timeslot_id": timeslot.id,
                "start_time": int(timeslot.start_time.timestamp()),
                "remaining_coins": user.profile.coins
            })
        else:
            return myResponse.Error("Payment processing failed", Errors.InvalidArgument.code)

    except Exception as e:
        return myResponse.Error(str(e), Errors.InvalidArgument.code)


@api_view(["POST"])
def get_timeslot_payment_link(request):
    """Get payment link for timeslot purchase with money (200,000 toman)"""
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "required": True
            },
            {
                "name": "timeslot_id",
                "format": "^[\d]+$",
                "required": True
            }
        ], request)

        token = str(request.POST["token"])
        timeslot_id = int(request.POST["timeslot_id"])

        # Validate user
        user = User.objects.filter(token=token).first()
        if not user:
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        # Get timeslot
        timeslot = TimeSlot.objects.filter(
            id=timeslot_id,
            is_available=1
        ).first()
        
        if not timeslot:
            return myResponse.Error("Timeslot not found or not available", Errors.DataNotFound.code)

        # Create payment record
        from payment.models import TimeSlotPayment
        payment = TimeSlotPayment.objects.create(
            user=user,
            time_slot=timeslot,
            payment_type='money',
            money_amount=TIMESLOT_PAYMENT  # 450000 toman
        )

        
        # Create ZarinPal payment with timeslot verification callback
        req_header = {"accept": "application/json",
                      "content-type": "application/json'"}
        
        data = {
            'amount': TIMESLOT_PAYMENT,
            'callback_url': 'https://api.ziluck.info/payment/verify/timeslot/zarinpal/',
            'merchant_id': MERCHANT,
            'description': f'خرید زمان مشاوره - کاربر {user.profile.first_name} {user.profile.last_name}',
        }
        
        response = requests.post(url=ZP_API_REQUEST, data=json.dumps(data), headers=req_header).json()
        
        if response['data']['message'] == 'Success':
            authority = response['data']['authority']
            
            # Update payment record with authority
            payment.authority = authority
            payment.save()
            
            # Return payment link
            payment_link = ZP_API_STARTPAY.format(authority=authority)
            return myResponse.OK("لینک پرداخت", {
                "payment_link": payment_link,
                "authority": authority
            })
        else:
            return myResponse.Error("خطا در ایجاد لینک پرداخت", Errors.InvalidArgument.code)

    except Exception as e:
        return myResponse.Error(str(e), Errors.InvalidArgument.code)


@api_view(["POST"])
def get_available_timeslots_for_purchase(request):
    """Get available timeslots that can be purchased by non-premium users within a date range"""
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "required": True
            },
            {
                "name": "start_date",
                "format": "^[\d]+$",
                "required": False
            },
            {
                "name": "end_date",
                "format": "^[\d]+$",
                "required": False
            }
        ], request)

        token = str(request.POST["token"])
        user = User.objects.filter(token=token).first()
        if not user:
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        # Parse date parameters
        start_date = None
        end_date = None
        
        if "start_date" in request.POST:
            start_date = datetime.fromtimestamp(int(request.POST["start_date"]))
        else:
            # Default to current time if no start date provided
            start_date = datetime.now()
            
        if "end_date" in request.POST:
            end_date = datetime.fromtimestamp(int(request.POST["end_date"]))

        # Get available timeslots created by doctors for purchase
        from django.contrib.auth.models import Group
        doctor_group = Group.objects.get(name='Doctor')
        doctors = doctor_group.user_set.all()
        
        # Build the query with date filtering
        query_filters = {
            'doctor_django_user__in': doctors,
            'created_by_doctor': True,
            'is_available': 1,
            'start_time__gte': start_date
        }
        
        # Add end date filter if provided
        if end_date:
            query_filters['start_time__lte'] = end_date
        
        available_timeslots = TimeSlot.objects.filter(**query_filters).order_by('start_time')

        timeslots_data = []
        for timeslot in available_timeslots:
            doctor = Doctor.objects.filter(django_user=timeslot.doctor_django_user).first()
            timeslots_data.append({
                "id": timeslot.id,
                "start_time": int(timeslot.start_time.timestamp()),
                "duration": timeslot.duration,
                "coin_price": 2000,
                "money_price": 200000
            })

        return myResponse.OK("Available timeslots for purchase", {
            "timeslots": timeslots_data,
            "user_coins": user.profile.coins,
            "date_range": {
                "start_date": int(start_date.timestamp()) if start_date else None,
                "end_date": int(end_date.timestamp()) if end_date else None
            }
        })

    except Exception as e:
        return myResponse.Error(str(e), Errors.InvalidArgument.code)

    
    
    

@api_view(["POST"])
def doctor_create_timeslot_for_purchase(request):
    """Doctor creates a timeslot that can be purchased by non-premium users"""
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "required": True
            },
            {
                "name": "start_time",
                "format": "^[\d]+$",
                "required": True
            },
            {
                "name": "duration",
                "format": "^[\d]+$",
                "required": False
            }
        ], request)

        token = str(request.POST["token"])
        start_time_timestamp = int(request.POST["start_time"])
        duration = int(request.POST.get("duration", 15))

        # Validate user is a doctor
        user = User.objects.filter(token=token).first()
        if not user:
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        # Check if user is a doctor
        if not user.django_user.groups.filter(name='Doctor').exists():
            return myResponse.Error("Only doctors can create timeslots for purchase", Errors.InvalidArgument.code)

        start_time = datetime.fromtimestamp(start_time_timestamp)
        
        # Create timeslot
        timeslot = TimeSlot.objects.create(
            doctor_django_user=user.django_user,
            start_time=start_time,
            duration=duration,
            is_available=1,
            created_by_doctor=True
        )

        return myResponse.OK("Timeslot created successfully", {
            "timeslot_id": timeslot.id,
            "start_time": int(timeslot.start_time.timestamp()),
            "duration": timeslot.duration
        })

    except Exception as e:
        return myResponse.Error(str(e), Errors.InvalidArgument.code)


@api_view(["POST"])
def doctor_get_purchased_timeslots(request):
    """Get purchased timeslots that need to be assigned to therapists"""
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "required": True
            }
        ], request)

        token = str(request.POST["token"])
        user = User.objects.filter(token=token).first()
        if not user:
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        # Check if user is a doctor
        if not user.django_user.groups.filter(name='Doctor').exists():
            return myResponse.Error("Only doctors can view purchased timeslots", Errors.InvalidArgument.code)

        # Get purchased timeslots created by this doctor
        from payment.models import TimeSlotPayment
        purchased_timeslots = TimeSlotPayment.objects.filter(
            time_slot__doctor_django_user=user.django_user,
            is_paid=True,
            status='pending'
        ).order_by('time_slot__start_time')

        timeslots_data = []
        for payment in purchased_timeslots:
            timeslot = payment.time_slot
            timeslots_data.append({
                "payment_id": payment.id,
                "timeslot_id": timeslot.id,
                "start_time": int(timeslot.start_time.timestamp()),
                "duration": timeslot.duration,
                "patient_name": f"{payment.user.profile.first_name} {payment.user.profile.last_name}",
                "patient_phone": payment.user.phone_number,
                "payment_type": payment.payment_type,
                "payment_date": int(payment.payment_date.timestamp()) if payment.payment_date else None,
                "status": payment.status
            })

        return myResponse.OK("Purchased timeslots", {
            "timeslots": timeslots_data
        })

    except Exception as e:
        return myResponse.Error(str(e), Errors.InvalidArgument.code)


@api_view(["POST"])
def doctor_assign_timeslot_to_therapist(request):
    """Doctor assigns a purchased timeslot to a therapist"""
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "required": True
            },
            {
                "name": "payment_id",
                "format": "^[\d]+$",
                "required": True
            },
            {
                "name": "therapist_id",
                "format": "^[\d]+$",
                "required": True
            }
        ], request)

        token = str(request.POST["token"])
        payment_id = int(request.POST["payment_id"])
        therapist_id = int(request.POST["therapist_id"])

        # Validate user is a doctor
        user = User.objects.filter(token=token).first()
        if not user:
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        if not user.django_user.groups.filter(name='Doctor').exists():
            return myResponse.Error("Only doctors can assign timeslots", Errors.InvalidArgument.code)

        # Get the payment and therapist
        from payment.models import TimeSlotPayment
        payment = TimeSlotPayment.objects.filter(
            id=payment_id,
            time_slot__doctor_django_user=user.django_user,
            is_paid=True,
            status='pending'
        ).first()

        if not payment:
            return myResponse.Error("Payment not found or not eligible for assignment", Errors.DataNotFound.code)

        therapist = Assistant.objects.filter(id=therapist_id).first()
        if not therapist:
            return myResponse.Error("Therapist not found", Errors.DataNotFound.code)

        # Check if therapist belongs to this doctor
        if therapist.doctor.django_user != user.django_user:
            return myResponse.Error("Therapist does not belong to this doctor", Errors.InvalidArgument.code)

        # Assign the timeslot to the therapist
        if payment.assign_to_therapist(therapist):
            return myResponse.OK("Timeslot assigned successfully", {
                "payment_id": payment.id,
                "therapist_name": f"{therapist.first_name} {therapist.last_name}",
                "status": payment.status
            })
        else:
            return myResponse.Error("Failed to assign timeslot", Errors.InvalidArgument.code)

    except Exception as e:
        return myResponse.Error(str(e), Errors.InvalidArgument.code)


@api_view(["POST"])
def doctor_get_available_therapists(request):
    """Get available therapists for a doctor to assign timeslots"""
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "required": True
            }
        ], request)

        token = str(request.POST["token"])
        user = User.objects.filter(token=token).first()
        if not user:
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        if not user.django_user.groups.filter(name='Doctor').exists():
            return myResponse.Error("Only doctors can view therapists", Errors.InvalidArgument.code)

        # Get therapists assigned to this doctor
        therapists = Assistant.objects.filter(doctor__django_user=user.django_user)

        therapists_data = []
        for therapist in therapists:
            therapists_data.append({
                "id": therapist.id,
                "name": f"{therapist.first_name} {therapist.last_name}",
                "phone": therapist.phone if hasattr(therapist, 'phone') else None
            })

        return myResponse.OK("Available therapists", {
            "therapists": therapists_data
        })

    except Exception as e:
        return myResponse.Error(str(e), Errors.InvalidArgument.code)

    
    
    

@api_view(["GET"])
def user_timeslot_interface(request):
    """Simple user interface for viewing and purchasing timeslots"""
    try:
        # This is a demo view - in real implementation, you'd get user token from session/cookie
        # For demo purposes, we'll show the interface without requiring authentication
        
        context = {
            'user_token': 'demo_token_123456789012345678901234567890',  # Demo token
        }
        
        return render(request, template_name='doctor/user_timeslot_interface.html', context=context)
        
    except Exception as e:
        return myResponse.Error(str(e), Errors.InvalidArgument.code)

@api_view(["GET"])
def debug_timeslot_purchases(request):
    """Debug view to check timeslot purchases in database"""
    try:
        from payment.models import TimeSlotPayment
        from panel.models import TimeSlot
        
        # Get all timeslot payments
        all_payments = TimeSlotPayment.objects.all().order_by('-created_at')
        
        # Get all timeslots
        all_timeslots = TimeSlot.objects.all().order_by('-start_time')
        
        # Get purchased timeslots (is_available = 2)
        purchased_timeslots = TimeSlot.objects.filter(is_available=2)
        
        debug_data = {
            'total_payments': all_payments.count(),
            'total_timeslots': all_timeslots.count(),
            'purchased_timeslots_count': purchased_timeslots.count(),
            'recent_payments': [
                {
                    'id': p.id,
                    'user': f"{p.user.profile.first_name} {p.user.profile.last_name}" if p.user else "No user",
                    'timeslot_id': p.time_slot.id,
                    'payment_type': p.payment_type,
                    'is_paid': p.is_paid,
                    'status': p.status,
                    'created_at': p.created_at.strftime('%Y-%m-%d %H:%M:%S'),
                    'payment_date': p.payment_date.strftime('%Y-%m-%d %H:%M:%S') if p.payment_date else None
                }
                for p in all_payments[:10]  # Last 10 payments
            ],
            'recent_timeslots': [
                {
                    'id': t.id,
                    'start_time': t.start_time.strftime('%Y-%m-%d %H:%M:%S') if t.start_time else None,
                    'is_available': t.is_available,
                    'created_by_doctor': t.created_by_doctor,
                    'doctor': f"{t.doctor_django_user.first_name} {t.doctor_django_user.last_name}" if t.doctor_django_user else "No doctor"
                }
                for t in all_timeslots[:10]  # Last 10 timeslots
            ],
            'purchased_timeslots': [
                {
                    'id': t.id,
                    'start_time': t.start_time.strftime('%Y-%m-%d %H:%M:%S') if t.start_time else None,
                    'doctor': f"{t.doctor_django_user.first_name} {t.doctor_django_user.last_name}" if t.doctor_django_user else "No doctor"
                }
                for t in purchased_timeslots
            ]
        }
        
        return myResponse.OK("Debug data for timeslot purchases", debug_data)
        
    except Exception as e:
        return myResponse.Error(str(e), Errors.InvalidArgument.code)

@api_view(["POST"])
def get_user_purchased_timeslots(request):
    """Get user's purchased timeslots with links and descriptions"""
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "required": True
            }
        ], request)

        token = str(request.POST["token"])
        user = User.objects.filter(token=token).first()
        if not user:
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        # Get user's purchased timeslots
        from payment.models import TimeSlotPayment
        purchased_timeslots = TimeSlotPayment.objects.filter(
            user=user,
            is_paid=True
        ).order_by('-created_at')

        timeslots_data = []
        for payment in purchased_timeslots:
            timeslot = payment.time_slot
            
            # Use the appointment link set in the panel
            appointment_link = timeslot.appointment_link
            
            # Get therapist information if assigned
            therapist_info = None
            if payment.assigned_therapist:
                therapist_info = {
                    "name": f"{payment.assigned_therapist.first_name} {payment.assigned_therapist.last_name}",
                    "id": payment.assigned_therapist.id
                }
            
            # Create description based on status
            status_description = {
                'pending': 'Waiting for therapist assignment',
                'assigned': 'Assigned to therapist - ready for appointment',
                'completed': 'Appointment completed',
                'cancelled': 'Appointment cancelled'
            }.get(payment.status, 'Unknown status')
            
            timeslots_data.append({
                "payment_id": payment.id,
                "timeslot_id": timeslot.id,
                "start_time": int(timeslot.start_time.timestamp()),
                "duration": timeslot.duration,
                "payment_type": payment.payment_type,
                "payment_amount": payment.coin_amount if payment.payment_type == 'coin' else payment.money_amount,
                "status": payment.status,
                "status_description": status_description,
                "appointment_link": appointment_link,
                "therapist": therapist_info,
                "payment_date": int(payment.payment_date.timestamp()) if payment.payment_date else None,
                "assigned_date": int(payment.assigned_date.timestamp()) if payment.assigned_date else None,
                "created_at": int(payment.created_at.timestamp())
            })

        return myResponse.OK("User's purchased timeslots", {
            "timeslots": timeslots_data,
            "total_count": len(timeslots_data)
        })

    except Exception as e:
        return myResponse.Error(str(e), Errors.InvalidArgument.code)

@api_view(["POST"])
def check_phone_exists(request):
    """Check if a phone number has a profile in the database"""
    try:
        RequsetChecker(request.POST, [
            {
                "name": "phone_number",
                "format": "^09[0-9]{9}$",
                "errorMessage": "شماره تلفن باید با 09 شروع شود و 11 رقم باشد"
            }
        ], request)

        phone = str(request.POST["phone_number"])
        
        # Check if user exists with this phone number and has a profile
        user = User.objects.filter(phone_number=phone).first()
        user_exists = user is not None
        profile_exists = user_exists and user.profile is not None
        
        data = {
            "phone_number": phone,
            "user_exists": user_exists,
            "profile_exists": profile_exists,
            "message": "کاربر با این شماره تلفن یافت شد و پروفایل دارد" if profile_exists else (
                "کاربر با این شماره تلفن یافت شد اما پروفایل ندارد" if user_exists else "کاربری با این شماره تلفن یافت نشد"
            )
        }
        
        return myResponse.OK("بررسی وجود پروفایل", data)

    except ValueError as e:
        writeErrorToLog("check_phone_exists ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        writeErrorToLog("check_phone_exists ---> POST\n" + str(e.args), request)
        return myResponse.Error(str(e.args), Errors.InvalidArgument.code)

@api_view(["POST"])
def verify_meeting_session_access(request):
    """Verify if user has access to a specific meeting session"""
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "required": True
            },
            {
                "name": "meeting_id",
                "format": "^[\d]+$",
                "required": True
            }
        ], request)

        token = str(request.POST["token"])
        meeting_id = int(request.POST["meeting_id"])

        # Validate user
        user = User.objects.filter(token=token).first()
        if not user:
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        # Get the timeslot (meeting session)
        timeslot = TimeSlot.objects.filter(id=meeting_id).first()
        
        if not timeslot:
            return myResponse.Error("Meeting session not found", Errors.DataNotFound.code)

        # Check if user has purchased this session
        payment = TimeSlotPayment.objects.filter(
            user=user,
            time_slot=timeslot,
            is_paid=True
        ).first()

        if payment:
            # User has purchased this session
            return myResponse.OK("User has access to this meeting session", {
                "has_access": True,
                "meeting_id": meeting_id,
                "start_time": int(timeslot.start_time.timestamp()) if timeslot.start_time else None,
                "duration": timeslot.duration,
                "payment_type": payment.payment_type,
                "payment_date": int(payment.payment_date.timestamp()) if payment.payment_date else None,
                "status": payment.status
            })
        else:
            # User has not purchased this session
            return myResponse.OK("User does not have access to this meeting session", {
                "has_access": False,
                "meeting_id": meeting_id,
                "message": "Session not purchased"
            })

    except Exception as e:
        return myResponse.Error(str(e), Errors.InvalidArgument.code)


@api_view(["POST"])
def verify_meeting_session_by_token(request):
    """Verify meeting session access using token and meeting_id - alternative endpoint"""
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "required": True
            },
            {
                "name": "meeting_id",
                "format": "^[\d]+$",
                "required": True
            }
        ], request)

        token = str(request.POST["token"])
        meeting_id = int(request.POST["meeting_id"])

        # Validate user
        user = User.objects.filter(token=token).first()
        if not user:
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        # Get the timeslot (meeting session)
        timeslot = TimeSlot.objects.filter(id=meeting_id).first()
        
        if not timeslot:
            return myResponse.Error("Meeting session not found", Errors.DataNotFound.code)

        # Check if user has purchased this session
        payment = TimeSlotPayment.objects.filter(
            user=user,
            time_slot=timeslot,
            is_paid=True
        ).first()

        if payment:
            # User has purchased this session
            return myResponse.OK("Session access verified", {
                "verified": True,
                "meeting_id": meeting_id,
                "user_id": user.id,
                "start_time": int(timeslot.start_time.timestamp()) if timeslot.start_time else None,
                "duration": timeslot.duration,
                "payment_type": payment.payment_type,
                "payment_date": int(payment.payment_date.timestamp()) if payment.payment_date else None,
                "status": payment.status,
                "assigned_therapist": payment.assigned_therapist.id if payment.assigned_therapist else None
            })
        else:
            # User has not purchased this session
            return myResponse.OK("Session access denied", {
                "verified": False,
                "meeting_id": meeting_id,
                "user_id": user.id,
                "message": "Session not purchased or payment not completed"
            })

    except Exception as e:
        return myResponse.Error(str(e), Errors.InvalidArgument.code)

@api_view(["POST"])
def suggest_food_card(request):
    """
    API endpoint to suggest food cards based on user profile, calorie requirements, and health conditions.
    
    Input:
    - token: User authentication token
    - meal_id: Meal type (0=breakfast, 1=lunch, 2=dinner, 3=snack1, 4=snack2)
    
    Output:
    - Suggested food card with nutritional information
    """
    # try:
    # Validate request parameters
    RequsetChecker(request.POST, [
        {
            "name": "token",
            "format": "^(\S){30}$"
        },
        {
            "name": "meal_id",
            "format": "^[0-4]$"
        }
    ], request)

    token = str(request.POST["token"])
    meal_id = int(request.POST["meal_id"])

    # Identify user by token
    user_query = User.objects.filter(token=token)
    if not user_query.exists():
        return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

    user = user_query[0]
    profile = user.profile

    if profile is None:
        return myResponse.Error("User profile not found", Errors.LogicalError.code)

    # Get user's calorie requirement (CR)
    user_cr = profile.CR
    if user_cr <= 0:
        return myResponse.Error("User calorie requirement not calculated", Errors.LogicalError.code)

    questionnaire = UserQuestionnaire.objects.filter(user=user).order_by('-id').first()
    if not questionnaire:
        user_health_tags = generate_health_tags({}, profile=profile)
    else:
        qanda = questionnaire.QandA
        user_health_tags = generate_health_tags(qanda, profile=profile)

    if user_health_tags is None:
        return myResponse.Error("Failed to process questionnaire", Errors.LogicalError.code)

    # Normalize meal type
    meal_types = {
        0: "breakfast",
        1: "lunch", 
        2: "dinner",
        3: "snack-1",
        4: "snack-2"
    }
    meal_normalized = meal_types[meal_id]

    # Find the closest CR in cr_list for calorie distribution
    coach_cr = profile.CR_coach
    if coach_cr is not None:
        selected_cr = min(cr_list, key=lambda cr: (abs(coach_cr - cr), cr))
    else:
        selected_cr = min(cr_list, key=lambda cr: (abs(user_cr - cr), cr))

    distribution = calorie_distributions[selected_cr]

    # Calculate calorie target for the specific meal
    calorie_target_key = {
        'breakfast': 'B',
        'lunch': 'L',
        'dinner': 'D',
        'snack-1': 'S1',
        'snack-2': 'S2'
    }.get(meal_normalized, 'B')
    calorie_target = distribution.get(calorie_target_key, 0)

    # Create allergen filters (when tag is True in profile, select cards where tag is False)
    exclude_allergen_filters = {}
    for tag in all_alergic_tags:
        if user_health_tags.get('Allergens', {}).get(tag, 0) == 1:
            exclude_allergen_filters[tag] = False  # Exclude cards where allergen is present

    # Create exclude filters for diseases
    exclude_filters = {}
    tag_mapping = {
        'Disease_High_Cholesterol': 'Disease_High_cholesterol',
        'Disease_Hypertension': 'Disease_High_blood_pressure',
        'Disease_Thyroid': 'Disease_Hypothyroidism',
        'Allergens_Crustaceans': 'Allergens_Shrimp',
        'Allergens_TreeNuts': 'Allergens_Nuts',
    }
    for tag, value in user_health_tags.get('Diseases', {}).items():
        if value == 1:
            normalized_tag = tag_mapping.get(tag, tag)
            exclude_filters[normalized_tag] = False

    # Meal filters
    meal_filters = {}
    
    if meal_normalized == 'breakfast':
        meal_filters['is_breakfast'] = True
    elif meal_normalized == 'lunch':
        meal_filters['is_lunch'] = True
    elif meal_normalized == 'dinner':
        meal_filters['is_dinner'] = True
    
    if meal_normalized in ['snack-1', 'snack-2']:
        meal_filters['is_snack'] = True

    # Build filter criteria for FoodCard
    from APIs.models import FoodCard
    from django.db.models import Q
    import random

    # Start with the meal filters
    food_cards = FoodCard.objects.filter(**meal_filters)

    # Chain the exclusions to remove cards with any unsafe allergen
    for field, value in exclude_allergen_filters.items():
        food_cards = food_cards.exclude(**{field: value})

    # Chain the exclusions to remove cards with any unsafe disease
    for field, value in exclude_filters.items():
        food_cards = food_cards.exclude(**{field: value})

    # Filter by calorie range (same tolerance as refresh_column_cards: ±10%)
    min_calories = calorie_target * 0.9
    max_calories = calorie_target * 1.1
    food_cards = food_cards.filter(Calories__gte=min_calories, Calories__lte=max_calories)

    # If no cards found with strict filtering, relax constraints
    if not food_cards.exists():
        # Try without disease filters
        if exclude_filters:
            food_cards = FoodCard.objects.filter(**meal_filters)
            for field, value in exclude_allergen_filters.items():
                food_cards = food_cards.exclude(**{field: value})
            food_cards = food_cards.filter(Calories__gte=min_calories, Calories__lte=max_calories)

    # If still no cards, get any card for the meal type
    if not food_cards.exists():
        food_cards = FoodCard.objects.filter(**meal_filters)

    # Randomly select one food card
    if food_cards.exists():
        selected_card = random.choice(list(food_cards))
        
        # Prepare response data
        response_data = {
            "food_card": {
                "id": selected_card.id,
                "fa_name": selected_card.FA_Name,
                "en_name": selected_card.EN_Name,
                "calories": selected_card.Calories,
                "carb_ratio": selected_card.carb_ratio,
                "fat_ratio": selected_card.fat_ratio,
                "protein_ratio": selected_card.protein_ratio,
                "recipe_description": selected_card.recipe_description,
                "recipe_image_link": selected_card.recipe_image_link,
                "foods": selected_card.foods
            },
            "user_info": {
                "user_cr": user_cr,
                "meal_calories": calorie_target,
                "meal_type": meal_normalized,
                "meal_id": meal_id
            },
            "health_tags": user_health_tags
        }
        
        return myResponse.OK("Food card suggested successfully", response_data)
    else:
        return myResponse.Error("No suitable food cards found", Errors.LogicalError.code)

    # except ValueError as e:
    #     return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    # except Exception as e:
    #     return myResponse.Error(str(e), Errors.InternalError.code)


@api_view(["POST"])
def check_upcoming_meeting(request):
    """Check if user has an upcoming meeting and return meeting information"""
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "required": True
            }
        ], request)

        token = str(request.POST["token"])

        # Validate user
        user = User.objects.filter(token=token).first()
        if not user:
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        # Get current time
        now = datetime.now()
        
        # Find upcoming meetings for this user
        # Look for timeslots where user is the patient and start_time is in the future
        upcoming_meetings = TimeSlot.objects.filter(
            patient=user,
            start_time__gt=now,
            is_available=0  # 0 = booked
        ).order_by('start_time')

        if upcoming_meetings.exists():
            # Get the next upcoming meeting
            next_meeting = upcoming_meetings.first()
            
            # Get payment information for this meeting
            payment = TimeSlotPayment.objects.filter(
                user=user,
                time_slot=next_meeting,
                is_paid=True
            ).first()
            
            # Get therapist information if assigned
            therapist_info = None
            if payment and payment.assigned_therapist:
                therapist_info = {
                    "id": payment.assigned_therapist.id,
                    "name": payment.assigned_therapist.name if hasattr(payment.assigned_therapist, 'name') else "Unknown",
                    "phone": payment.assigned_therapist.phone if hasattr(payment.assigned_therapist, 'phone') else None,
                }
            
            # Get doctor information if available
            doctor_info = None
            if next_meeting.doctor_django_user:
                doctor_info = {
                    "id": next_meeting.doctor_django_user.id,
                    "username": next_meeting.doctor_django_user.username,
                }
            
            meeting_data = {
                "has_upcoming_meeting": True,
                "meeting_id": next_meeting.id,
                "start_time": int(next_meeting.start_time.timestamp()) if next_meeting.start_time else None,
                "duration": next_meeting.duration,
                "appointment_link": next_meeting.appointment_link,
                "payment_info": {
                    "payment_type": payment.payment_type if payment else None,
                    "status": payment.status if payment else None,
                    "payment_date": int(payment.payment_date.timestamp()) if payment and payment.payment_date else None,
                },
                "therapist": therapist_info,
                "doctor": doctor_info,
                "days_until_meeting": (next_meeting.start_time - now).days if next_meeting.start_time else None,
                "hours_until_meeting": int((next_meeting.start_time - now).total_seconds() / 3600) if next_meeting.start_time else None,
            }
            
            return myResponse.OK("User has an upcoming meeting", meeting_data)
        else:
            # No upcoming meetings found
            return myResponse.OK("No upcoming meetings found", {
                "has_upcoming_meeting": False,
                "message": "There is no upcoming meeting"
            })

    except Exception as e:
        print(f"Error in check_upcoming_meeting: {str(e)}")
        return myResponse.Error(str(e), Errors.InvalidArgument.code)


@api_view(["POST"])
def update_acquisition_source(request):
    """
    Update user's acquisition source (where they heard about us)
    Required parameters:
    - token: User's authentication token
    - acquisition_source: Where they heard about us (instagram, telegram, google, friend_referral, doctor, podcast, tv_radio, website, other)
    - acquisition_details: REQUIRED when acquisition_source is 'other'. Optional for other sources to provide additional context
    """
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$"
            },
            {
                "name": "acquisition_source",
                "format": ".*"
            },
            {
                "name": "acquisition_details",
                "format": ".*",
                "required": False
            }
        ])

        token = request.POST.get("token")
        acquisition_source = request.POST.get("acquisition_source")
        acquisition_details = request.POST.get("acquisition_details", "").strip()

        # Validate token and get user
        user = User.objects.filter(token=token).first()
        if user is None:
            return myResponse.TokenError()

        # Validate profile exists
        if user.profile is None:
            return myResponse.Error("پروفایل کاربر یافت نشد", Errors.InvalidArgument.code)

        # Validate acquisition source
        valid_sources = [choice[0] for choice in Profile.ACQUISITION_CHOICES]
        if acquisition_source not in valid_sources:
            return myResponse.Error(
                f"منبع آشنایی نامعتبر است. باید یکی از موارد زیر باشد: {', '.join(valid_sources)}", 
                Errors.InvalidArgument.code
            )

        # If 'other' is selected, acquisition_details is REQUIRED
        if acquisition_source == "other" and not acquisition_details:
            return myResponse.Error(
                "زمانی که گزینه 'سایر' را انتخاب می‌کنید، وارد کردن جزئیات الزامی است. لطفاً مشخص کنید از کجا با ما آشنا شدید.",
                Errors.InvalidArgument.code
            )

        # Update profile
        profile = user.profile
        
        # Only set acquisition_date if this is the first time setting acquisition_source
        if profile.acquisition_source is None:
            profile.acquisition_date = datetime.now()
        
        profile.acquisition_source = acquisition_source
        profile.acquisition_details = acquisition_details
        profile.save()

        # Get the Persian name for the source
        source_name = dict(Profile.ACQUISITION_CHOICES).get(acquisition_source, acquisition_source)

        return myResponse.OK("منبع آشنایی با موفقیت ثبت شد", {
            "acquisition_source": acquisition_source,
            "acquisition_source_name": source_name,
            "acquisition_details": acquisition_details,
            "acquisition_date": int(profile.acquisition_date.timestamp()) if profile.acquisition_date else None
        })

    except Exception as e:
        print(f"Error in update_acquisition_source: {str(e)}")
        return myResponse.Error(str(e), Errors.InvalidArgument.code)


@api_view(["GET"])
def get_acquisition_sources(request):
    """
    Get list of available acquisition sources
    No parameters required
    """
    try:
        sources = [
            {
                "code": choice[0],
                "name": choice[1]
            }
            for choice in Profile.ACQUISITION_CHOICES
        ]
        
        return myResponse.OK("لیست منابع آشنایی موجود", {
            "sources": sources
        })

    except Exception as e:
        print(f"Error in get_acquisition_sources: {str(e)}")
        return myResponse.Error(str(e), Errors.InvalidArgument.code)
