from .views import *


@api_view(["POST"])
def checkForUpdate(request):
    try:

        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$"
            },
            # {
            #     "name": "phone_number",
            #     "format": "^09[0-9]{9}$"
            # },
            {
                "name": "version",
                "format": ".",
                "errorMessage": "ورژن را به صورت تاریخ شمسی، جدا شده با نقطه وارد کنید مثلا 1398.06.06"
            },
        ], request)

        token = str(request.POST.get("token"))
        # phone = str(request.POST["phone_number"])
        temp = User.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        version = request.POST.get("version")
        v = AppVersion.objects.all().order_by("-time")[0]
        last_version = v.version

        version_to_list = version.split(".")
        last_version_to_list = last_version.split(".")

        version_numner = 10000 * int(version_to_list[0]) + 100 * int(version_to_list[1]) + int(version_to_list[2])
        last_version_numner = 10000 * int(last_version_to_list[0]) + 100 * int(last_version_to_list[1]) + int(last_version_to_list[2])

        result = {}

        if (last_version_numner > version_numner):
            result["need_for_update"] = True
            result["google_play_link"] = v.google_play_link
            result["bazar_link"] = v.bazar_link
            result["idia_site_link"] = v.site_link
            result["description"] = v.description
        else:
            result["need_for_update"] = False
        return myResponse.OK("بررسی برای آپدیت", result)

    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
