import os.path
from APIs.models import UserQuestionnaire
from datetime import datetime

if __name__ == '__main__':
    qus = UserQuestionnaire.objects.all()
    file_name = f"get_questionary_in_csv_{datetime.now().strftime('%Y_%m_%d_%H_%M_%S')}.csv"
    file_path = os.path.dirname(__file__) + f"/{file_name}"
    file = open(file_path, 'w')
    for item in qus:
        line = f"{item.user},"
        for key in item.QandA:
            line += f"{key},{item.QandA[key]}"
        line += "\n"
        file.write(line)
    file.close()
    print(f"successfully done! file path: {file_path}")